import numpy as np
from pandas._libs.indexing import _NDFrameIndexerBase

from pandas.core.dtypes.generic import ABCDataFrame as ABCDataFrame, ABCMultiIndex as ABCMultiIndex, ABCSeries as ABCSeries
from pandas.core.indexes.api import Index as Index, InvalidIndexError as InvalidIndexError
from pandas.errors import AbstractMethodError as AbstractMethodError
from pandas.util._decorators import Appender as Appender
from typing import Any, Optional

class _IndexSlice:
    def __getitem__(self, arg: Any) -> Any: ...

IndexSlice: Any

class IndexingError(Exception): ...

class IndexingMixin:
    @property
    def iloc(self) -> _iLocIndexer: ...
    @property
    def loc(self) -> _LocIndexer: ...
    @property
    def at(self) -> _AtIndexer: ...
    @property
    def iat(self) -> _iAtIndexer: ...

class _NDFrameIndexer(_NDFrameIndexerBase):
    axis: Any = ...
    def __call__(self, axis: Optional[Any] = ...) -> Any: ...
    def __getitem__(self, key: Any) -> Any: ...
    def __setitem__(self, key: Any, value: Any) -> None: ...

class _LocationIndexer(_NDFrameIndexer):
    def __getitem__(self, key: Any) -> Any: ...

class _LocIndexer(_LocationIndexer): ...
class _iLocIndexer(_LocationIndexer): ...

class _ScalarAccessIndexer(_NDFrameIndexerBase):
    def __getitem__(self, key: Any) -> Any: ...
    def __setitem__(self, key: Any, value: Any) -> None: ...

class _AtIndexer(_ScalarAccessIndexer): ...
class _iAtIndexer(_ScalarAccessIndexer): ...

def convert_to_index_sliceable(obj: Any, key: Any) -> Any: ...
def check_bool_indexer(index: Index, key: Any) -> np.ndarray: ...
def convert_missing_indexer(indexer: Any) -> Any: ...
def convert_from_missing_indexer_tuple(indexer: Any, axes: Any) -> Any: ...
def maybe_convert_ix(*args: Any) -> Any: ...
def is_nested_tuple(tup: Any, labels: Any) -> bool: ...
def is_label_like(key: Any) -> bool: ...
def need_slice(obj: Any) -> bool: ...
