import datetime
from collections import abc
from pandas import Categorical as Categorical, DatetimeIndex as DatetimeIndex,  Timestamp as Timestamp, concat as concat, isna as isna, to_datetime as to_datetime, to_timedelta as to_timedelta
from pandas._typing import FilePathOrBuffer as FilePathOrBuffer
from pandas.core.frame import DataFrame as DataFrame
from pandas.core.series import Series as Series
from pandas.util._decorators import Appender as Appender
from typing import Any, Dict, Hashable, Optional, Sequence, AnyStr


def read_stata(filepath_or_buffer: Any, convert_dates: bool = ..., convert_categoricals: bool = ..., index_col: Optional[Any] = ..., convert_missing: bool = ..., preserve_dtypes: bool = ..., columns: Optional[Any] = ..., order_categoricals: bool = ..., chunksize: Optional[Any] = ..., iterator: bool = ...) -> Any: ...

stata_epoch: Any
excessive_string_length_error: str

class PossiblePrecisionLoss(Warning): ...

precision_loss_doc: str

class ValueLabelTypeMismatch(Warning): ...

value_label_mismatch_doc: str

class InvalidColumnName(Warning): ...

invalid_name_doc: str

class StataValueLabel:
    labname: Any = ...
    value_labels: Any = ...
    text_len: Any = ...
    off: Any = ...
    val: Any = ...
    txt: Any = ...
    n: int = ...
    len: Any = ...
    def __init__(self, catarray: Any, encoding: str = ...) -> None: ...
    def generate_value_label(self, byteorder: Any) -> Any: ...

class StataMissingValue:
    MISSING_VALUES: Any = ...
    bases: Any = ...
    float32_base: bytes = ...
    increment: Any = ...
    value: Any = ...
    int_value: Any = ...
    float64_base: bytes = ...
    BASE_MISSING_VALUES: Any = ...
    def __init__(self, value: Any) -> None: ...
    string: Any = ...
    def __eq__(self, other: Any) -> bool: ...
    @classmethod
    def get_base_missing_value(cls, dtype: Any) -> Any: ...

class StataParser:
    DTYPE_MAP: Any = ...
    DTYPE_MAP_XML: Any = ...
    TYPE_MAP: Any = ...
    TYPE_MAP_XML: Any = ...
    VALID_RANGE: Any = ...
    OLD_TYPE_MAPPING: Any = ...
    MISSING_VALUES: Any = ...
    NUMPY_TYPE_MAP: Any = ...
    RESERVED_WORDS: Any = ...
    def __init__(self) -> None: ...

class StataReader(StataParser, abc.Iterator[Any]):
    __doc__: Any = ...
    col_sizes: Any = ...
    path_or_buf: Any = ...
    def __init__(self, path_or_buf: Any, convert_dates: bool = ..., convert_categoricals: bool = ..., index_col: Optional[Any] = ..., convert_missing: bool = ..., preserve_dtypes: bool = ..., columns: Optional[Any] = ..., order_categoricals: bool = ..., chunksize: Optional[Any] = ...) -> None: ...
    def __enter__(self) -> Any: ...
    def __exit__(self, exc_type: Any, exc_value: Any, traceback: Any) -> None: ...
    def close(self) -> None: ...
    def __next__(self) -> Any: ...
    def get_chunk(self, size: Optional[Any] = ...) -> Any: ...
    def read(self, nrows: Optional[Any] = ..., convert_dates: Optional[Any] = ..., convert_categoricals: Optional[Any] = ..., index_col: Optional[Any] = ..., convert_missing: Optional[Any] = ..., preserve_dtypes: Optional[Any] = ..., columns: Optional[Any] = ..., order_categoricals: Optional[Any] = ...) -> Any: ...
    @property
    def data_label(self) -> Any: ...
    def variable_labels(self) -> Any: ...
    def value_labels(self) -> Any: ...

class StataWriter(StataParser):
    type_converters: Any = ...
    def __init__(self, fname: Any, data: Any, convert_dates: Optional[Any] = ..., write_index: bool = ..., byteorder: Optional[Any] = ..., time_stamp: Optional[Any] = ..., data_label: Optional[Any] = ..., variable_labels: Optional[Any] = ...) -> None: ...
    def write_file(self) -> None: ...

class StataStrLWriter:
    df: Any = ...
    columns: Any = ...
    def __init__(self, df: Any, columns: Any, version: int = ..., byteorder: Optional[Any] = ...) -> None: ...
    def generate_table(self) -> Any: ...
    def generate_blob(self, gso_table: Any) -> Any: ...

class StataWriter117(StataWriter):
    def __init__(self, fname: Any, data: Any, convert_dates: Optional[Any] = ..., write_index: bool = ..., byteorder: Optional[Any] = ..., time_stamp: Optional[Any] = ..., data_label: Optional[Any] = ..., variable_labels: Optional[Any] = ..., convert_strl: Optional[Any] = ...) -> None: ...

class StataWriterUTF8(StataWriter117):
    def __init__(self, fname: FilePathOrBuffer[AnyStr], data: DataFrame, convert_dates: Optional[Dict[Hashable, str]]=..., write_index: bool=..., byteorder: Optional[str]=..., time_stamp: Optional[datetime.datetime]=..., data_label: Optional[str]=..., variable_labels: Optional[Dict[Hashable, str]]=..., convert_strl: Optional[Sequence[Hashable]]=..., version: Optional[int]=...) -> None: ...
