# Generated by Django 4.1 on 2022-08-08 15:06

import authentication_service.managers
from django.db import migrations, models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [("auth", "0012_alter_user_first_name_max_length")]

    operations = [
        migrations.CreateModel(
            name="AccountUser",
            fields=[
                ("password", models.CharField(max_length=128, verbose_name="password")),
                (
                    "last_login",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="last login"
                    ),
                ),
                (
                    "is_superuser",
                    models.BooleanField(
                        default=False,
                        help_text="Designates that this user has all permissions without explicitly assigning them.",
                        verbose_name="superuser status",
                    ),
                ),
                (
                    "id",
                    models.BigAutoField(primary_key=True, serialize=False, unique=True),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4, unique=True)),
                (
                    "firstname",
                    models.CharField(
                        blank=True,
                        help_text="What's your firstname?",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "lastname",
                    models.CharField(
                        blank=True,
                        help_text="What's your lastname?",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "username",
                    models.CharField(
                        help_text="What's your preferred username?",
                        max_length=255,
                        unique=True,
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        help_text="What's your email address?",
                        max_length=255,
                        unique=True,
                    ),
                ),
                (
                    "phone_number",
                    models.CharField(
                        blank=True,
                        help_text="What's your phone number?",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "profile_picture",
                    models.ImageField(blank=True, null=True, upload_to="user_images/"),
                ),
                ("is_active", models.BooleanField(default=False)),
                ("is_staff", models.BooleanField(default=False)),
                ("is_admin", models.BooleanField(default=False)),
                ("is_suspended", models.BooleanField(default=False)),
                ("is_email_active", models.BooleanField(default=False)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                (
                    "groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text="The groups this user belongs to. A user will get all permissions granted to each of their groups.",
                        related_name="user_set",
                        related_query_name="user",
                        to="auth.group",
                        verbose_name="groups",
                    ),
                ),
                (
                    "user_permissions",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Specific permissions for this user.",
                        related_name="user_set",
                        related_query_name="user",
                        to="auth.permission",
                        verbose_name="user permissions",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "users",
                "db_table": "users",
                "permissions": [("can_suspend_user", "Can suspend user")],
            },
            managers=[("objects", authentication_service.managers.UserManager())],
        ),
        migrations.AddIndex(
            model_name="accountuser",
            index=models.Index(
                fields=[
                    "username",
                    "email",
                    "is_active",
                    "date_created",
                    "date_modified",
                ],
                name="users_usernam_3053c0_idx",
            ),
        ),
    ]
