"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApi = exports.CorsHttpMethod = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const base_1 = require("../common/base");
const integration_1 = require("./integration");
const route_1 = require("./route");
const stage_1 = require("./stage");
const vpc_link_1 = require("./vpc-link");
/**
 * (experimental) Supported CORS HTTP methods.
 *
 * @experimental
 */
var CorsHttpMethod;
(function (CorsHttpMethod) {
    CorsHttpMethod["ANY"] = "*";
    CorsHttpMethod["DELETE"] = "DELETE";
    CorsHttpMethod["GET"] = "GET";
    CorsHttpMethod["HEAD"] = "HEAD";
    CorsHttpMethod["OPTIONS"] = "OPTIONS";
    CorsHttpMethod["PATCH"] = "PATCH";
    CorsHttpMethod["POST"] = "POST";
    CorsHttpMethod["PUT"] = "PUT";
})(CorsHttpMethod = exports.CorsHttpMethod || (exports.CorsHttpMethod = {}));
class HttpApiBase extends base_1.ApiBase {
    constructor() {
        super(...arguments);
        this.vpcLinks = {};
    }
    /**
     * (experimental) Metric for the number of client-side errors captured in a given period.
     *
     * @experimental
     */
    metricClientError(props) {
        return this.metric('4xx', { statistic: 'Sum', ...props });
    }
    /**
     * (experimental) Metric for the number of server-side errors captured in a given period.
     *
     * @experimental
     */
    metricServerError(props) {
        return this.metric('5xx', { statistic: 'Sum', ...props });
    }
    /**
     * (experimental) Metric for the amount of data processed in bytes.
     *
     * @experimental
     */
    metricDataProcessed(props) {
        return this.metric('DataProcessed', { statistic: 'Sum', ...props });
    }
    /**
     * (experimental) Metric for the total number API requests in a given period.
     *
     * @experimental
     */
    metricCount(props) {
        return this.metric('Count', { statistic: 'SampleCount', ...props });
    }
    /**
     * (experimental) Metric for the time between when API Gateway relays a request to the backend and when it receives a response from the backend.
     *
     * @experimental
     */
    metricIntegrationLatency(props) {
        return this.metric('IntegrationLatency', props);
    }
    /**
     * (experimental) The time between when API Gateway receives a request from a client and when it returns a response to the client.
     *
     * The latency includes the integration latency and other API Gateway overhead.
     *
     * @experimental
     */
    metricLatency(props) {
        return this.metric('Latency', props);
    }
    /**
     * (experimental) Add a new VpcLink.
     *
     * @experimental
     */
    addVpcLink(options) {
        const { vpcId } = options.vpc;
        if (vpcId in this.vpcLinks) {
            return this.vpcLinks[vpcId];
        }
        const count = Object.keys(this.vpcLinks).length + 1;
        const vpcLink = new vpc_link_1.VpcLink(this, `VpcLink-${count}`, options);
        this.vpcLinks[vpcId] = vpcLink;
        return vpcLink;
    }
    /**
     * @internal
     */
    _addIntegration(scope, config) {
        const { configHash, integration: existingIntegration } = this._integrationCache.getIntegration(scope, config);
        if (existingIntegration) {
            return existingIntegration;
        }
        const integration = new integration_1.HttpIntegration(scope, `HttpIntegration-${configHash}`, {
            httpApi: this,
            integrationType: config.type,
            integrationUri: config.uri,
            method: config.method,
            connectionId: config.connectionId,
            connectionType: config.connectionType,
            payloadFormatVersion: config.payloadFormatVersion,
            secureServerName: config.secureServerName,
        });
        this._integrationCache.saveIntegration(scope, config, integration);
        return integration;
    }
}
/**
 * (experimental) Create a new API Gateway HTTP API endpoint.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Api
 */
class HttpApi extends HttpApiBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.httpApiName = (_b = props === null || props === void 0 ? void 0 : props.apiName) !== null && _b !== void 0 ? _b : id;
        this.disableExecuteApiEndpoint = props === null || props === void 0 ? void 0 : props.disableExecuteApiEndpoint;
        let corsConfiguration;
        if (props === null || props === void 0 ? void 0 : props.corsPreflight) {
            const cors = props.corsPreflight;
            if (cors.allowOrigins && cors.allowOrigins.includes('*') && cors.allowCredentials) {
                throw new Error("CORS preflight - allowCredentials is not supported when allowOrigin is '*'");
            }
            const { allowCredentials, allowHeaders, allowMethods, allowOrigins, exposeHeaders, maxAge, } = props.corsPreflight;
            corsConfiguration = {
                allowCredentials,
                allowHeaders,
                allowMethods,
                allowOrigins,
                exposeHeaders,
                maxAge: maxAge === null || maxAge === void 0 ? void 0 : maxAge.toSeconds(),
            };
        }
        const apiProps = {
            name: this.httpApiName,
            protocolType: 'HTTP',
            corsConfiguration,
            description: props === null || props === void 0 ? void 0 : props.description,
            disableExecuteApiEndpoint: this.disableExecuteApiEndpoint,
        };
        const resource = new apigatewayv2_generated_1.CfnApi(this, 'Resource', apiProps);
        this.apiId = resource.ref;
        this.httpApiId = resource.ref;
        this._apiEndpoint = resource.attrApiEndpoint;
        this.defaultAuthorizer = props === null || props === void 0 ? void 0 : props.defaultAuthorizer;
        this.defaultAuthorizationScopes = props === null || props === void 0 ? void 0 : props.defaultAuthorizationScopes;
        if (props === null || props === void 0 ? void 0 : props.defaultIntegration) {
            new route_1.HttpRoute(this, 'DefaultRoute', {
                httpApi: this,
                routeKey: route_1.HttpRouteKey.DEFAULT,
                integration: props.defaultIntegration,
                authorizer: props.defaultAuthorizer,
                authorizationScopes: props.defaultAuthorizationScopes,
            });
        }
        if ((props === null || props === void 0 ? void 0 : props.createDefaultStage) === undefined || props.createDefaultStage === true) {
            this.defaultStage = new stage_1.HttpStage(this, 'DefaultStage', {
                httpApi: this,
                autoDeploy: true,
                domainMapping: props === null || props === void 0 ? void 0 : props.defaultDomainMapping,
            });
            // to ensure the domain is ready before creating the default stage
            if (props === null || props === void 0 ? void 0 : props.defaultDomainMapping) {
                this.defaultStage.node.addDependency(props.defaultDomainMapping.domainName);
            }
        }
        if ((props === null || props === void 0 ? void 0 : props.createDefaultStage) === false && props.defaultDomainMapping) {
            throw new Error('defaultDomainMapping not supported with createDefaultStage disabled');
        }
    }
    /**
     * (experimental) Import an existing HTTP API into this CDK app.
     *
     * @experimental
     */
    static fromHttpApiAttributes(scope, id, attrs) {
        class Import extends HttpApiBase {
            constructor() {
                super(...arguments);
                this.apiId = attrs.httpApiId;
                this.httpApiId = attrs.httpApiId;
                this._apiEndpoint = attrs.apiEndpoint;
            }
            get apiEndpoint() {
                if (!this._apiEndpoint) {
                    throw new Error('apiEndpoint is not configured on the imported HttpApi.');
                }
                return this._apiEndpoint;
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Get the default endpoint for this API.
     *
     * @experimental
     */
    get apiEndpoint() {
        if (this.disableExecuteApiEndpoint) {
            throw new Error('apiEndpoint is not accessible when disableExecuteApiEndpoint is set to true.');
        }
        return this._apiEndpoint;
    }
    /**
     * (experimental) Get the URL to the default stage of this API.
     *
     * Returns `undefined` if `createDefaultStage` is unset.
     *
     * @experimental
     */
    get url() {
        return this.defaultStage ? this.defaultStage.url : undefined;
    }
    /**
     * (experimental) Add a new stage.
     *
     * @experimental
     */
    addStage(id, options) {
        const stage = new stage_1.HttpStage(this, id, {
            httpApi: this,
            ...options,
        });
        return stage;
    }
    /**
     * (experimental) Add multiple routes that uses the same configuration.
     *
     * The routes all go to the same path, but for different
     * methods.
     *
     * @experimental
     */
    addRoutes(options) {
        var _b;
        const methods = (_b = options.methods) !== null && _b !== void 0 ? _b : [route_1.HttpMethod.ANY];
        return methods.map((method) => {
            var _b, _c;
            const authorizationScopes = (_b = options.authorizationScopes) !== null && _b !== void 0 ? _b : this.defaultAuthorizationScopes;
            return new route_1.HttpRoute(this, `${method}${options.path}`, {
                httpApi: this,
                routeKey: route_1.HttpRouteKey.with(options.path, method),
                integration: options.integration,
                authorizer: (_c = options.authorizer) !== null && _c !== void 0 ? _c : this.defaultAuthorizer,
                authorizationScopes,
            });
        });
    }
}
exports.HttpApi = HttpApi;
_a = JSII_RTTI_SYMBOL_1;
HttpApi[_a] = { fqn: "@aws-cdk/aws-apigatewayv2.HttpApi", version: "1.117.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXBpLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBR0Esc0VBQWdFO0FBRWhFLHlDQUF5QztBQUd6QywrQ0FBbUc7QUFDbkcsbUNBQXFGO0FBQ3JGLG1DQUFzRDtBQUN0RCx5Q0FBbUQ7Ozs7OztBQWtFbkQsSUFBWSxjQWlCWDtBQWpCRCxXQUFZLGNBQWM7SUFFeEIsMkJBQVMsQ0FBQTtJQUVULG1DQUFpQixDQUFBO0lBRWpCLDZCQUFXLENBQUE7SUFFWCwrQkFBYSxDQUFBO0lBRWIscUNBQW1CLENBQUE7SUFFbkIsaUNBQWUsQ0FBQTtJQUVmLCtCQUFhLENBQUE7SUFFYiw2QkFBVyxDQUFBO0FBQ2IsQ0FBQyxFQWpCVyxjQUFjLEdBQWQsc0JBQWMsS0FBZCxzQkFBYyxRQWlCekI7QUFzQ0QsTUFBZSxXQUFZLFNBQVEsY0FBTztJQUExQzs7UUFLVSxhQUFRLEdBQTRCLEVBQUUsQ0FBQztJQThEakQsQ0FBQzs7Ozs7O0lBNURRLGlCQUFpQixDQUFDLEtBQXFCO1FBQzVDLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFFLEdBQUcsS0FBSyxFQUFFLENBQUMsQ0FBQztJQUM1RCxDQUFDOzs7Ozs7SUFFTSxpQkFBaUIsQ0FBQyxLQUFxQjtRQUM1QyxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsU0FBUyxFQUFFLEtBQUssRUFBRSxHQUFHLEtBQUssRUFBRSxDQUFDLENBQUM7SUFDNUQsQ0FBQzs7Ozs7O0lBRU0sbUJBQW1CLENBQUMsS0FBcUI7UUFDOUMsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLGVBQWUsRUFBRSxFQUFFLFNBQVMsRUFBRSxLQUFLLEVBQUUsR0FBRyxLQUFLLEVBQUUsQ0FBQyxDQUFDO0lBQ3RFLENBQUM7Ozs7OztJQUVNLFdBQVcsQ0FBQyxLQUFxQjtRQUN0QyxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBTyxFQUFFLEVBQUUsU0FBUyxFQUFFLGFBQWEsRUFBRSxHQUFHLEtBQUssRUFBRSxDQUFDLENBQUM7SUFDdEUsQ0FBQzs7Ozs7O0lBRU0sd0JBQXdCLENBQUMsS0FBcUI7UUFDbkQsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLG9CQUFvQixFQUFFLEtBQUssQ0FBQyxDQUFDO0lBQ2xELENBQUM7Ozs7Ozs7O0lBRU0sYUFBYSxDQUFDLEtBQXFCO1FBQ3hDLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDdkMsQ0FBQzs7Ozs7O0lBRU0sVUFBVSxDQUFDLE9BQXFCO1FBQ3JDLE1BQU0sRUFBRSxLQUFLLEVBQUUsR0FBRyxPQUFPLENBQUMsR0FBRyxDQUFDO1FBQzlCLElBQUksS0FBSyxJQUFJLElBQUksQ0FBQyxRQUFRLEVBQUU7WUFDMUIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO1NBQzdCO1FBRUQsTUFBTSxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQztRQUNwRCxNQUFNLE9BQU8sR0FBRyxJQUFJLGtCQUFPLENBQUMsSUFBSSxFQUFFLFdBQVcsS0FBSyxFQUFFLEVBQUUsT0FBTyxDQUFDLENBQUM7UUFDL0QsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsR0FBRyxPQUFPLENBQUM7UUFFL0IsT0FBTyxPQUFPLENBQUM7SUFDakIsQ0FBQztJQUVEOztPQUVHO0lBQ0ksZUFBZSxDQUFDLEtBQWdCLEVBQUUsTUFBa0M7UUFDekUsTUFBTSxFQUFFLFVBQVUsRUFBRSxXQUFXLEVBQUUsbUJBQW1CLEVBQUUsR0FBRyxJQUFJLENBQUMsaUJBQWlCLENBQUMsY0FBYyxDQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsQ0FBQztRQUM5RyxJQUFJLG1CQUFtQixFQUFFO1lBQ3ZCLE9BQU8sbUJBQXNDLENBQUM7U0FDL0M7UUFFRCxNQUFNLFdBQVcsR0FBRyxJQUFJLDZCQUFlLENBQUMsS0FBSyxFQUFFLG1CQUFtQixVQUFVLEVBQUUsRUFBRTtZQUM5RSxPQUFPLEVBQUUsSUFBSTtZQUNiLGVBQWUsRUFBRSxNQUFNLENBQUMsSUFBSTtZQUM1QixjQUFjLEVBQUUsTUFBTSxDQUFDLEdBQUc7WUFDMUIsTUFBTSxFQUFFLE1BQU0sQ0FBQyxNQUFNO1lBQ3JCLFlBQVksRUFBRSxNQUFNLENBQUMsWUFBWTtZQUNqQyxjQUFjLEVBQUUsTUFBTSxDQUFDLGNBQWM7WUFDckMsb0JBQW9CLEVBQUUsTUFBTSxDQUFDLG9CQUFvQjtZQUNqRCxnQkFBZ0IsRUFBRSxNQUFNLENBQUMsZ0JBQWdCO1NBQzFDLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxXQUFXLENBQUMsQ0FBQztRQUVuRSxPQUFPLFdBQVcsQ0FBQztJQUNyQixDQUFDO0NBQ0Y7Ozs7Ozs7QUFXRCxNQUFhLE9BQVEsU0FBUSxXQUFXOzs7O0lBa0N0QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQW9COztRQUM1RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksQ0FBQyxXQUFXLFNBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLE9BQU8sbUNBQUksRUFBRSxDQUFDO1FBQ3hDLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUseUJBQXlCLENBQUM7UUFFbEUsSUFBSSxpQkFBa0QsQ0FBQztRQUN2RCxJQUFJLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxhQUFhLEVBQUU7WUFDeEIsTUFBTSxJQUFJLEdBQUcsS0FBSyxDQUFDLGFBQWEsQ0FBQztZQUNqQyxJQUFJLElBQUksQ0FBQyxZQUFZLElBQUksSUFBSSxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLElBQUksSUFBSSxDQUFDLGdCQUFnQixFQUFFO2dCQUNqRixNQUFNLElBQUksS0FBSyxDQUFDLDRFQUE0RSxDQUFDLENBQUM7YUFDL0Y7WUFDRCxNQUFNLEVBQ0osZ0JBQWdCLEVBQ2hCLFlBQVksRUFDWixZQUFZLEVBQ1osWUFBWSxFQUNaLGFBQWEsRUFDYixNQUFNLEdBQ1AsR0FBRyxLQUFLLENBQUMsYUFBYSxDQUFDO1lBQ3hCLGlCQUFpQixHQUFHO2dCQUNsQixnQkFBZ0I7Z0JBQ2hCLFlBQVk7Z0JBQ1osWUFBWTtnQkFDWixZQUFZO2dCQUNaLGFBQWE7Z0JBQ2IsTUFBTSxFQUFFLE1BQU0sYUFBTixNQUFNLHVCQUFOLE1BQU0sQ0FBRSxTQUFTLEVBQUU7YUFDNUIsQ0FBQztTQUNIO1FBRUQsTUFBTSxRQUFRLEdBQWdCO1lBQzVCLElBQUksRUFBRSxJQUFJLENBQUMsV0FBVztZQUN0QixZQUFZLEVBQUUsTUFBTTtZQUNwQixpQkFBaUI7WUFDakIsV0FBVyxFQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxXQUFXO1lBQy9CLHlCQUF5QixFQUFFLElBQUksQ0FBQyx5QkFBeUI7U0FDMUQsQ0FBQztRQUVGLE1BQU0sUUFBUSxHQUFHLElBQUksK0JBQU0sQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBQ3hELElBQUksQ0FBQyxLQUFLLEdBQUcsUUFBUSxDQUFDLEdBQUcsQ0FBQztRQUMxQixJQUFJLENBQUMsU0FBUyxHQUFHLFFBQVEsQ0FBQyxHQUFHLENBQUM7UUFDOUIsSUFBSSxDQUFDLFlBQVksR0FBRyxRQUFRLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsaUJBQWlCLENBQUM7UUFDbEQsSUFBSSxDQUFDLDBCQUEwQixHQUFHLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSwwQkFBMEIsQ0FBQztRQUVwRSxJQUFJLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxrQkFBa0IsRUFBRTtZQUM3QixJQUFJLGlCQUFTLENBQUMsSUFBSSxFQUFFLGNBQWMsRUFBRTtnQkFDbEMsT0FBTyxFQUFFLElBQUk7Z0JBQ2IsUUFBUSxFQUFFLG9CQUFZLENBQUMsT0FBTztnQkFDOUIsV0FBVyxFQUFFLEtBQUssQ0FBQyxrQkFBa0I7Z0JBQ3JDLFVBQVUsRUFBRSxLQUFLLENBQUMsaUJBQWlCO2dCQUNuQyxtQkFBbUIsRUFBRSxLQUFLLENBQUMsMEJBQTBCO2FBQ3RELENBQUMsQ0FBQztTQUNKO1FBRUQsSUFBSSxDQUFBLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxrQkFBa0IsTUFBSyxTQUFTLElBQUksS0FBSyxDQUFDLGtCQUFrQixLQUFLLElBQUksRUFBRTtZQUNoRixJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksaUJBQVMsQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFO2dCQUN0RCxPQUFPLEVBQUUsSUFBSTtnQkFDYixVQUFVLEVBQUUsSUFBSTtnQkFDaEIsYUFBYSxFQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxvQkFBb0I7YUFDM0MsQ0FBQyxDQUFDO1lBRUgsa0VBQWtFO1lBQ2xFLElBQUksS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLG9CQUFvQixFQUFFO2dCQUMvQixJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLG9CQUFvQixDQUFDLFVBQVUsQ0FBQyxDQUFDO2FBQzdFO1NBQ0Y7UUFFRCxJQUFJLENBQUEsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLGtCQUFrQixNQUFLLEtBQUssSUFBSSxLQUFLLENBQUMsb0JBQW9CLEVBQUU7WUFDckUsTUFBTSxJQUFJLEtBQUssQ0FBQyxxRUFBcUUsQ0FDcEYsQ0FBQztTQUNIO0lBQ0gsQ0FBQzs7Ozs7O0lBeEdNLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUF3QjtRQUN4RixNQUFNLE1BQU8sU0FBUSxXQUFXO1lBQWhDOztnQkFDa0IsVUFBSyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7Z0JBQ3hCLGNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO2dCQUMzQixpQkFBWSxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7WUFRcEQsQ0FBQztZQU5DLElBQVcsV0FBVztnQkFDcEIsSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLEVBQUU7b0JBQ3RCLE1BQU0sSUFBSSxLQUFLLENBQUMsd0RBQXdELENBQUMsQ0FBQztpQkFDM0U7Z0JBQ0QsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO1lBQzNCLENBQUM7U0FDRjtRQUNELE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBQy9CLENBQUM7Ozs7OztJQTZGRCxJQUFXLFdBQVc7UUFDcEIsSUFBSSxJQUFJLENBQUMseUJBQXlCLEVBQUU7WUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyw4RUFBOEUsQ0FBQyxDQUFDO1NBQ2pHO1FBQ0QsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7Ozs7Ozs7O0lBR0QsSUFBVyxHQUFHO1FBQ1osT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQy9ELENBQUM7Ozs7OztJQUdNLFFBQVEsQ0FBQyxFQUFVLEVBQUUsT0FBeUI7UUFDbkQsTUFBTSxLQUFLLEdBQUcsSUFBSSxpQkFBUyxDQUFDLElBQUksRUFBRSxFQUFFLEVBQUU7WUFDcEMsT0FBTyxFQUFFLElBQUk7WUFDYixHQUFHLE9BQU87U0FDWCxDQUFDLENBQUM7UUFDSCxPQUFPLEtBQUssQ0FBQztJQUNmLENBQUM7Ozs7Ozs7OztJQUdNLFNBQVMsQ0FBQyxPQUF5Qjs7UUFDeEMsTUFBTSxPQUFPLFNBQUcsT0FBTyxDQUFDLE9BQU8sbUNBQUksQ0FBQyxrQkFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ3BELE9BQU8sT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLE1BQU0sRUFBRSxFQUFFOztZQUM1QixNQUFNLG1CQUFtQixTQUFHLE9BQU8sQ0FBQyxtQkFBbUIsbUNBQUksSUFBSSxDQUFDLDBCQUEwQixDQUFDO1lBRTNGLE9BQU8sSUFBSSxpQkFBUyxDQUFDLElBQUksRUFBRSxHQUFHLE1BQU0sR0FBRyxPQUFPLENBQUMsSUFBSSxFQUFFLEVBQUU7Z0JBQ3JELE9BQU8sRUFBRSxJQUFJO2dCQUNiLFFBQVEsRUFBRSxvQkFBWSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLE1BQU0sQ0FBQztnQkFDakQsV0FBVyxFQUFFLE9BQU8sQ0FBQyxXQUFXO2dCQUNoQyxVQUFVLFFBQUUsT0FBTyxDQUFDLFVBQVUsbUNBQUksSUFBSSxDQUFDLGlCQUFpQjtnQkFDeEQsbUJBQW1CO2FBQ3BCLENBQUMsQ0FBQztRQUNMLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUFoSkgsMEJBaUpDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgTWV0cmljLCBNZXRyaWNPcHRpb25zIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWNsb3Vkd2F0Y2gnO1xuaW1wb3J0IHsgRHVyYXRpb24gfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2ZuQXBpLCBDZm5BcGlQcm9wcyB9IGZyb20gJy4uL2FwaWdhdGV3YXl2Mi5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgSUFwaSB9IGZyb20gJy4uL2NvbW1vbi9hcGknO1xuaW1wb3J0IHsgQXBpQmFzZSB9IGZyb20gJy4uL2NvbW1vbi9iYXNlJztcbmltcG9ydCB7IERvbWFpbk1hcHBpbmdPcHRpb25zLCBJU3RhZ2UgfSBmcm9tICcuLi9jb21tb24vc3RhZ2UnO1xuaW1wb3J0IHsgSUh0dHBSb3V0ZUF1dGhvcml6ZXIgfSBmcm9tICcuL2F1dGhvcml6ZXInO1xuaW1wb3J0IHsgSUh0dHBSb3V0ZUludGVncmF0aW9uLCBIdHRwSW50ZWdyYXRpb24sIEh0dHBSb3V0ZUludGVncmF0aW9uQ29uZmlnIH0gZnJvbSAnLi9pbnRlZ3JhdGlvbic7XG5pbXBvcnQgeyBCYXRjaEh0dHBSb3V0ZU9wdGlvbnMsIEh0dHBNZXRob2QsIEh0dHBSb3V0ZSwgSHR0cFJvdXRlS2V5IH0gZnJvbSAnLi9yb3V0ZSc7XG5pbXBvcnQgeyBIdHRwU3RhZ2UsIEh0dHBTdGFnZU9wdGlvbnMgfSBmcm9tICcuL3N0YWdlJztcbmltcG9ydCB7IFZwY0xpbmssIFZwY0xpbmtQcm9wcyB9IGZyb20gJy4vdnBjLWxpbmsnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSUh0dHBBcGkgZXh0ZW5kcyBJQXBpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBodHRwQXBpSWQ6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgbWV0cmljQ2xpZW50RXJyb3IocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBtZXRyaWNTZXJ2ZXJFcnJvcihwcm9wcz86IE1ldHJpY09wdGlvbnMpOiBNZXRyaWM7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgbWV0cmljRGF0YVByb2Nlc3NlZChwcm9wcz86IE1ldHJpY09wdGlvbnMpOiBNZXRyaWM7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgbWV0cmljQ291bnQocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBtZXRyaWNJbnRlZ3JhdGlvbkxhdGVuY3kocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIG1ldHJpY0xhdGVuY3kocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIGFkZFZwY0xpbmsob3B0aW9uczogVnBjTGlua1Byb3BzKTogVnBjTGlua1xuXG4gIC8qKlxuICAgKiBBZGQgYSBodHRwIGludGVncmF0aW9uXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgX2FkZEludGVncmF0aW9uKHNjb3BlOiBDb25zdHJ1Y3QsIGNvbmZpZzogSHR0cFJvdXRlSW50ZWdyYXRpb25Db25maWcpOiBIdHRwSW50ZWdyYXRpb247XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSHR0cEFwaVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGFwaU5hbWU/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGVmYXVsdEludGVncmF0aW9uPzogSUh0dHBSb3V0ZUludGVncmF0aW9uO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjcmVhdGVEZWZhdWx0U3RhZ2U/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY29yc1ByZWZsaWdodD86IENvcnNQcmVmbGlnaHRPcHRpb25zO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGVmYXVsdERvbWFpbk1hcHBpbmc/OiBEb21haW5NYXBwaW5nT3B0aW9ucztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkaXNhYmxlRXhlY3V0ZUFwaUVuZHBvaW50PzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGVmYXVsdEF1dGhvcml6ZXI/OiBJSHR0cFJvdXRlQXV0aG9yaXplcjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRlZmF1bHRBdXRob3JpemF0aW9uU2NvcGVzPzogc3RyaW5nW107XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgZW51bSBDb3JzSHR0cE1ldGhvZHtcbiAgICAgICAgICAgICAgICAgXG4gIEFOWSA9ICcqJyxcbiAgICAgICAgICAgICAgICAgICAgXG4gIERFTEVURSA9ICdERUxFVEUnLFxuICAgICAgICAgICAgICAgICBcbiAgR0VUID0gJ0dFVCcsXG4gICAgICAgICAgICAgICAgICBcbiAgSEVBRCA9ICdIRUFEJyxcbiAgICAgICAgICAgICAgICAgICAgIFxuICBPUFRJT05TID0gJ09QVElPTlMnLFxuICAgICAgICAgICAgICAgICAgIFxuICBQQVRDSCA9ICdQQVRDSCcsXG4gICAgICAgICAgICAgICAgICBcbiAgUE9TVCA9ICdQT1NUJyxcbiAgICAgICAgICAgICAgICAgXG4gIFBVVCA9ICdQVVQnLFxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgQ29yc1ByZWZsaWdodE9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhbGxvd0NyZWRlbnRpYWxzPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhbGxvd0hlYWRlcnM/OiBzdHJpbmdbXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGFsbG93TWV0aG9kcz86IENvcnNIdHRwTWV0aG9kW107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYWxsb3dPcmlnaW5zPzogc3RyaW5nW107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGV4cG9zZUhlYWRlcnM/OiBzdHJpbmdbXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1heEFnZT86IER1cmF0aW9uO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEFkZFJvdXRlc09wdGlvbnMgZXh0ZW5kcyBCYXRjaEh0dHBSb3V0ZU9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwYXRoOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWV0aG9kcz86IEh0dHBNZXRob2RbXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGF1dGhvcml6ZXI/OiBJSHR0cFJvdXRlQXV0aG9yaXplcjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGF1dGhvcml6YXRpb25TY29wZXM/OiBzdHJpbmdbXTtcbn1cblxuYWJzdHJhY3QgY2xhc3MgSHR0cEFwaUJhc2UgZXh0ZW5kcyBBcGlCYXNlIGltcGxlbWVudHMgSUh0dHBBcGkgeyAvLyBub3RlIHRoYXQgdGhpcyBpcyBub3QgZXhwb3J0ZWRcblxuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgYXBpSWQ6IHN0cmluZztcbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IGh0dHBBcGlJZDogc3RyaW5nO1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgYXBpRW5kcG9pbnQ6IHN0cmluZztcbiAgcHJpdmF0ZSB2cGNMaW5rczogUmVjb3JkPHN0cmluZywgVnBjTGluaz4gPSB7fTtcblxuICBwdWJsaWMgbWV0cmljQ2xpZW50RXJyb3IocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWMoJzR4eCcsIHsgc3RhdGlzdGljOiAnU3VtJywgLi4ucHJvcHMgfSk7XG4gIH1cblxuICBwdWJsaWMgbWV0cmljU2VydmVyRXJyb3IocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWMoJzV4eCcsIHsgc3RhdGlzdGljOiAnU3VtJywgLi4ucHJvcHMgfSk7XG4gIH1cblxuICBwdWJsaWMgbWV0cmljRGF0YVByb2Nlc3NlZChwcm9wcz86IE1ldHJpY09wdGlvbnMpOiBNZXRyaWMge1xuICAgIHJldHVybiB0aGlzLm1ldHJpYygnRGF0YVByb2Nlc3NlZCcsIHsgc3RhdGlzdGljOiAnU3VtJywgLi4ucHJvcHMgfSk7XG4gIH1cblxuICBwdWJsaWMgbWV0cmljQ291bnQocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWMoJ0NvdW50JywgeyBzdGF0aXN0aWM6ICdTYW1wbGVDb3VudCcsIC4uLnByb3BzIH0pO1xuICB9XG5cbiAgcHVibGljIG1ldHJpY0ludGVncmF0aW9uTGF0ZW5jeShwcm9wcz86IE1ldHJpY09wdGlvbnMpOiBNZXRyaWMge1xuICAgIHJldHVybiB0aGlzLm1ldHJpYygnSW50ZWdyYXRpb25MYXRlbmN5JywgcHJvcHMpO1xuICB9XG5cbiAgcHVibGljIG1ldHJpY0xhdGVuY3kocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWMoJ0xhdGVuY3knLCBwcm9wcyk7XG4gIH1cblxuICBwdWJsaWMgYWRkVnBjTGluayhvcHRpb25zOiBWcGNMaW5rUHJvcHMpOiBWcGNMaW5rIHtcbiAgICBjb25zdCB7IHZwY0lkIH0gPSBvcHRpb25zLnZwYztcbiAgICBpZiAodnBjSWQgaW4gdGhpcy52cGNMaW5rcykge1xuICAgICAgcmV0dXJuIHRoaXMudnBjTGlua3NbdnBjSWRdO1xuICAgIH1cblxuICAgIGNvbnN0IGNvdW50ID0gT2JqZWN0LmtleXModGhpcy52cGNMaW5rcykubGVuZ3RoICsgMTtcbiAgICBjb25zdCB2cGNMaW5rID0gbmV3IFZwY0xpbmsodGhpcywgYFZwY0xpbmstJHtjb3VudH1gLCBvcHRpb25zKTtcbiAgICB0aGlzLnZwY0xpbmtzW3ZwY0lkXSA9IHZwY0xpbms7XG5cbiAgICByZXR1cm4gdnBjTGluaztcbiAgfVxuXG4gIC8qKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHB1YmxpYyBfYWRkSW50ZWdyYXRpb24oc2NvcGU6IENvbnN0cnVjdCwgY29uZmlnOiBIdHRwUm91dGVJbnRlZ3JhdGlvbkNvbmZpZyk6IEh0dHBJbnRlZ3JhdGlvbiB7XG4gICAgY29uc3QgeyBjb25maWdIYXNoLCBpbnRlZ3JhdGlvbjogZXhpc3RpbmdJbnRlZ3JhdGlvbiB9ID0gdGhpcy5faW50ZWdyYXRpb25DYWNoZS5nZXRJbnRlZ3JhdGlvbihzY29wZSwgY29uZmlnKTtcbiAgICBpZiAoZXhpc3RpbmdJbnRlZ3JhdGlvbikge1xuICAgICAgcmV0dXJuIGV4aXN0aW5nSW50ZWdyYXRpb24gYXMgSHR0cEludGVncmF0aW9uO1xuICAgIH1cblxuICAgIGNvbnN0IGludGVncmF0aW9uID0gbmV3IEh0dHBJbnRlZ3JhdGlvbihzY29wZSwgYEh0dHBJbnRlZ3JhdGlvbi0ke2NvbmZpZ0hhc2h9YCwge1xuICAgICAgaHR0cEFwaTogdGhpcyxcbiAgICAgIGludGVncmF0aW9uVHlwZTogY29uZmlnLnR5cGUsXG4gICAgICBpbnRlZ3JhdGlvblVyaTogY29uZmlnLnVyaSxcbiAgICAgIG1ldGhvZDogY29uZmlnLm1ldGhvZCxcbiAgICAgIGNvbm5lY3Rpb25JZDogY29uZmlnLmNvbm5lY3Rpb25JZCxcbiAgICAgIGNvbm5lY3Rpb25UeXBlOiBjb25maWcuY29ubmVjdGlvblR5cGUsXG4gICAgICBwYXlsb2FkRm9ybWF0VmVyc2lvbjogY29uZmlnLnBheWxvYWRGb3JtYXRWZXJzaW9uLFxuICAgICAgc2VjdXJlU2VydmVyTmFtZTogY29uZmlnLnNlY3VyZVNlcnZlck5hbWUsXG4gICAgfSk7XG4gICAgdGhpcy5faW50ZWdyYXRpb25DYWNoZS5zYXZlSW50ZWdyYXRpb24oc2NvcGUsIGNvbmZpZywgaW50ZWdyYXRpb24pO1xuXG4gICAgcmV0dXJuIGludGVncmF0aW9uO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEh0dHBBcGlBdHRyaWJ1dGVzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaHR0cEFwaUlkOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYXBpRW5kcG9pbnQ/OiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEh0dHBBcGkgZXh0ZW5kcyBIdHRwQXBpQmFzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBmcm9tSHR0cEFwaUF0dHJpYnV0ZXMoc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgYXR0cnM6IEh0dHBBcGlBdHRyaWJ1dGVzKTogSUh0dHBBcGkge1xuICAgIGNsYXNzIEltcG9ydCBleHRlbmRzIEh0dHBBcGlCYXNlIHtcbiAgICAgIHB1YmxpYyByZWFkb25seSBhcGlJZCA9IGF0dHJzLmh0dHBBcGlJZDtcbiAgICAgIHB1YmxpYyByZWFkb25seSBodHRwQXBpSWQgPSBhdHRycy5odHRwQXBpSWQ7XG4gICAgICBwcml2YXRlIHJlYWRvbmx5IF9hcGlFbmRwb2ludCA9IGF0dHJzLmFwaUVuZHBvaW50O1xuXG4gICAgICBwdWJsaWMgZ2V0IGFwaUVuZHBvaW50KCk6IHN0cmluZyB7XG4gICAgICAgIGlmICghdGhpcy5fYXBpRW5kcG9pbnQpIHtcbiAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ2FwaUVuZHBvaW50IGlzIG5vdCBjb25maWd1cmVkIG9uIHRoZSBpbXBvcnRlZCBIdHRwQXBpLicpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiB0aGlzLl9hcGlFbmRwb2ludDtcbiAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBodHRwQXBpTmFtZT86IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGFwaUlkOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBodHRwQXBpSWQ6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGRpc2FibGVFeGVjdXRlQXBpRW5kcG9pbnQ/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBkZWZhdWx0U3RhZ2U6IElTdGFnZSB8IHVuZGVmaW5lZDtcblxuICBwcml2YXRlIHJlYWRvbmx5IF9hcGlFbmRwb2ludDogc3RyaW5nO1xuXG4gIHByaXZhdGUgcmVhZG9ubHkgZGVmYXVsdEF1dGhvcml6ZXI/OiBJSHR0cFJvdXRlQXV0aG9yaXplcjtcbiAgcHJpdmF0ZSByZWFkb25seSBkZWZhdWx0QXV0aG9yaXphdGlvblNjb3Blcz86IHN0cmluZ1tdO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzPzogSHR0cEFwaVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMuaHR0cEFwaU5hbWUgPSBwcm9wcz8uYXBpTmFtZSA/PyBpZDtcbiAgICB0aGlzLmRpc2FibGVFeGVjdXRlQXBpRW5kcG9pbnQgPSBwcm9wcz8uZGlzYWJsZUV4ZWN1dGVBcGlFbmRwb2ludDtcblxuICAgIGxldCBjb3JzQ29uZmlndXJhdGlvbjogQ2ZuQXBpLkNvcnNQcm9wZXJ0eSB8IHVuZGVmaW5lZDtcbiAgICBpZiAocHJvcHM/LmNvcnNQcmVmbGlnaHQpIHtcbiAgICAgIGNvbnN0IGNvcnMgPSBwcm9wcy5jb3JzUHJlZmxpZ2h0O1xuICAgICAgaWYgKGNvcnMuYWxsb3dPcmlnaW5zICYmIGNvcnMuYWxsb3dPcmlnaW5zLmluY2x1ZGVzKCcqJykgJiYgY29ycy5hbGxvd0NyZWRlbnRpYWxzKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcihcIkNPUlMgcHJlZmxpZ2h0IC0gYWxsb3dDcmVkZW50aWFscyBpcyBub3Qgc3VwcG9ydGVkIHdoZW4gYWxsb3dPcmlnaW4gaXMgJyonXCIpO1xuICAgICAgfVxuICAgICAgY29uc3Qge1xuICAgICAgICBhbGxvd0NyZWRlbnRpYWxzLFxuICAgICAgICBhbGxvd0hlYWRlcnMsXG4gICAgICAgIGFsbG93TWV0aG9kcyxcbiAgICAgICAgYWxsb3dPcmlnaW5zLFxuICAgICAgICBleHBvc2VIZWFkZXJzLFxuICAgICAgICBtYXhBZ2UsXG4gICAgICB9ID0gcHJvcHMuY29yc1ByZWZsaWdodDtcbiAgICAgIGNvcnNDb25maWd1cmF0aW9uID0ge1xuICAgICAgICBhbGxvd0NyZWRlbnRpYWxzLFxuICAgICAgICBhbGxvd0hlYWRlcnMsXG4gICAgICAgIGFsbG93TWV0aG9kcyxcbiAgICAgICAgYWxsb3dPcmlnaW5zLFxuICAgICAgICBleHBvc2VIZWFkZXJzLFxuICAgICAgICBtYXhBZ2U6IG1heEFnZT8udG9TZWNvbmRzKCksXG4gICAgICB9O1xuICAgIH1cblxuICAgIGNvbnN0IGFwaVByb3BzOiBDZm5BcGlQcm9wcyA9IHtcbiAgICAgIG5hbWU6IHRoaXMuaHR0cEFwaU5hbWUsXG4gICAgICBwcm90b2NvbFR5cGU6ICdIVFRQJyxcbiAgICAgIGNvcnNDb25maWd1cmF0aW9uLFxuICAgICAgZGVzY3JpcHRpb246IHByb3BzPy5kZXNjcmlwdGlvbixcbiAgICAgIGRpc2FibGVFeGVjdXRlQXBpRW5kcG9pbnQ6IHRoaXMuZGlzYWJsZUV4ZWN1dGVBcGlFbmRwb2ludCxcbiAgICB9O1xuXG4gICAgY29uc3QgcmVzb3VyY2UgPSBuZXcgQ2ZuQXBpKHRoaXMsICdSZXNvdXJjZScsIGFwaVByb3BzKTtcbiAgICB0aGlzLmFwaUlkID0gcmVzb3VyY2UucmVmO1xuICAgIHRoaXMuaHR0cEFwaUlkID0gcmVzb3VyY2UucmVmO1xuICAgIHRoaXMuX2FwaUVuZHBvaW50ID0gcmVzb3VyY2UuYXR0ckFwaUVuZHBvaW50O1xuICAgIHRoaXMuZGVmYXVsdEF1dGhvcml6ZXIgPSBwcm9wcz8uZGVmYXVsdEF1dGhvcml6ZXI7XG4gICAgdGhpcy5kZWZhdWx0QXV0aG9yaXphdGlvblNjb3BlcyA9IHByb3BzPy5kZWZhdWx0QXV0aG9yaXphdGlvblNjb3BlcztcblxuICAgIGlmIChwcm9wcz8uZGVmYXVsdEludGVncmF0aW9uKSB7XG4gICAgICBuZXcgSHR0cFJvdXRlKHRoaXMsICdEZWZhdWx0Um91dGUnLCB7XG4gICAgICAgIGh0dHBBcGk6IHRoaXMsXG4gICAgICAgIHJvdXRlS2V5OiBIdHRwUm91dGVLZXkuREVGQVVMVCxcbiAgICAgICAgaW50ZWdyYXRpb246IHByb3BzLmRlZmF1bHRJbnRlZ3JhdGlvbixcbiAgICAgICAgYXV0aG9yaXplcjogcHJvcHMuZGVmYXVsdEF1dGhvcml6ZXIsXG4gICAgICAgIGF1dGhvcml6YXRpb25TY29wZXM6IHByb3BzLmRlZmF1bHRBdXRob3JpemF0aW9uU2NvcGVzLFxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgaWYgKHByb3BzPy5jcmVhdGVEZWZhdWx0U3RhZ2UgPT09IHVuZGVmaW5lZCB8fCBwcm9wcy5jcmVhdGVEZWZhdWx0U3RhZ2UgPT09IHRydWUpIHtcbiAgICAgIHRoaXMuZGVmYXVsdFN0YWdlID0gbmV3IEh0dHBTdGFnZSh0aGlzLCAnRGVmYXVsdFN0YWdlJywge1xuICAgICAgICBodHRwQXBpOiB0aGlzLFxuICAgICAgICBhdXRvRGVwbG95OiB0cnVlLFxuICAgICAgICBkb21haW5NYXBwaW5nOiBwcm9wcz8uZGVmYXVsdERvbWFpbk1hcHBpbmcsXG4gICAgICB9KTtcblxuICAgICAgLy8gdG8gZW5zdXJlIHRoZSBkb21haW4gaXMgcmVhZHkgYmVmb3JlIGNyZWF0aW5nIHRoZSBkZWZhdWx0IHN0YWdlXG4gICAgICBpZiAocHJvcHM/LmRlZmF1bHREb21haW5NYXBwaW5nKSB7XG4gICAgICAgIHRoaXMuZGVmYXVsdFN0YWdlLm5vZGUuYWRkRGVwZW5kZW5jeShwcm9wcy5kZWZhdWx0RG9tYWluTWFwcGluZy5kb21haW5OYW1lKTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICBpZiAocHJvcHM/LmNyZWF0ZURlZmF1bHRTdGFnZSA9PT0gZmFsc2UgJiYgcHJvcHMuZGVmYXVsdERvbWFpbk1hcHBpbmcpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignZGVmYXVsdERvbWFpbk1hcHBpbmcgbm90IHN1cHBvcnRlZCB3aXRoIGNyZWF0ZURlZmF1bHRTdGFnZSBkaXNhYmxlZCcsXG4gICAgICApO1xuICAgIH1cbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBnZXQgYXBpRW5kcG9pbnQoKTogc3RyaW5nIHtcbiAgICBpZiAodGhpcy5kaXNhYmxlRXhlY3V0ZUFwaUVuZHBvaW50KSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ2FwaUVuZHBvaW50IGlzIG5vdCBhY2Nlc3NpYmxlIHdoZW4gZGlzYWJsZUV4ZWN1dGVBcGlFbmRwb2ludCBpcyBzZXQgdG8gdHJ1ZS4nKTtcbiAgICB9XG4gICAgcmV0dXJuIHRoaXMuX2FwaUVuZHBvaW50O1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGdldCB1cmwoKTogc3RyaW5nIHwgdW5kZWZpbmVkIHtcbiAgICByZXR1cm4gdGhpcy5kZWZhdWx0U3RhZ2UgPyB0aGlzLmRlZmF1bHRTdGFnZS51cmwgOiB1bmRlZmluZWQ7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBhZGRTdGFnZShpZDogc3RyaW5nLCBvcHRpb25zOiBIdHRwU3RhZ2VPcHRpb25zKTogSHR0cFN0YWdlIHtcbiAgICBjb25zdCBzdGFnZSA9IG5ldyBIdHRwU3RhZ2UodGhpcywgaWQsIHtcbiAgICAgIGh0dHBBcGk6IHRoaXMsXG4gICAgICAuLi5vcHRpb25zLFxuICAgIH0pO1xuICAgIHJldHVybiBzdGFnZTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGFkZFJvdXRlcyhvcHRpb25zOiBBZGRSb3V0ZXNPcHRpb25zKTogSHR0cFJvdXRlW10ge1xuICAgIGNvbnN0IG1ldGhvZHMgPSBvcHRpb25zLm1ldGhvZHMgPz8gW0h0dHBNZXRob2QuQU5ZXTtcbiAgICByZXR1cm4gbWV0aG9kcy5tYXAoKG1ldGhvZCkgPT4ge1xuICAgICAgY29uc3QgYXV0aG9yaXphdGlvblNjb3BlcyA9IG9wdGlvbnMuYXV0aG9yaXphdGlvblNjb3BlcyA/PyB0aGlzLmRlZmF1bHRBdXRob3JpemF0aW9uU2NvcGVzO1xuXG4gICAgICByZXR1cm4gbmV3IEh0dHBSb3V0ZSh0aGlzLCBgJHttZXRob2R9JHtvcHRpb25zLnBhdGh9YCwge1xuICAgICAgICBodHRwQXBpOiB0aGlzLFxuICAgICAgICByb3V0ZUtleTogSHR0cFJvdXRlS2V5LndpdGgob3B0aW9ucy5wYXRoLCBtZXRob2QpLFxuICAgICAgICBpbnRlZ3JhdGlvbjogb3B0aW9ucy5pbnRlZ3JhdGlvbixcbiAgICAgICAgYXV0aG9yaXplcjogb3B0aW9ucy5hdXRob3JpemVyID8/IHRoaXMuZGVmYXVsdEF1dGhvcml6ZXIsXG4gICAgICAgIGF1dGhvcml6YXRpb25TY29wZXMsXG4gICAgICB9KTtcbiAgICB9KTtcbiAgfVxufVxuIl19