import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IIntegration } from '../common';
import { IHttpApi } from './api';
import { HttpMethod, IHttpRoute } from './route';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * (experimental) Represents an Integration for an HTTP API.
 *
 * @experimental
 */
export interface IHttpIntegration extends IIntegration {
    /**
     * (experimental) The HTTP API associated with this integration.
     *
     * @experimental
     */
    readonly httpApi: IHttpApi;
}
/**
 * (experimental) Supported integration types.
 *
 * @experimental
 */
export declare enum HttpIntegrationType {
    /**
     * (experimental) Integration type is a Lambda proxy.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     * @experimental
     */
    LAMBDA_PROXY = "AWS_PROXY",
    /**
     * (experimental) Integration type is an HTTP proxy.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     * @experimental
     */
    HTTP_PROXY = "HTTP_PROXY"
}
/**
 * (experimental) Supported connection types.
 *
 * @experimental
 */
export declare enum HttpConnectionType {
    /**
     * (experimental) For private connections between API Gateway and resources in a VPC.
     *
     * @experimental
     */
    VPC_LINK = "VPC_LINK",
    /**
     * (experimental) For connections through public routable internet.
     *
     * @experimental
     */
    INTERNET = "INTERNET"
}
/**
 * (experimental) Payload format version for lambda proxy integration.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
 * @experimental
 */
export declare class PayloadFormatVersion {
    /**
     * (experimental) Version 1.0.
     *
     * @experimental
     */
    static readonly VERSION_1_0: PayloadFormatVersion;
    /**
     * (experimental) Version 2.0.
     *
     * @experimental
     */
    static readonly VERSION_2_0: PayloadFormatVersion;
    /**
     * (experimental) A custom payload version.
     *
     * Typically used if there is a version number that the CDK doesn't support yet
     *
     * @experimental
     */
    static custom(version: string): PayloadFormatVersion;
    /**
     * (experimental) version as a string.
     *
     * @experimental
     */
    readonly version: string;
    private constructor();
}
/**
 * (experimental) The integration properties.
 *
 * @experimental
 */
export interface HttpIntegrationProps {
    /**
     * (experimental) The HTTP API to which this integration should be bound.
     *
     * @experimental
     */
    readonly httpApi: IHttpApi;
    /**
     * (experimental) Integration type.
     *
     * @experimental
     */
    readonly integrationType: HttpIntegrationType;
    /**
     * (experimental) Integration URI.
     *
     * This will be the function ARN in the case of `HttpIntegrationType.LAMBDA_PROXY`,
     * or HTTP URL in the case of `HttpIntegrationType.HTTP_PROXY`.
     *
     * @experimental
     */
    readonly integrationUri: string;
    /**
     * (experimental) The HTTP method to use when calling the underlying HTTP proxy.
     *
     * @default - none. required if the integration type is `HttpIntegrationType.HTTP_PROXY`.
     * @experimental
     */
    readonly method?: HttpMethod;
    /**
     * (experimental) The ID of the VPC link for a private integration.
     *
     * Supported only for HTTP APIs.
     *
     * @default - undefined
     * @experimental
     */
    readonly connectionId?: string;
    /**
     * (experimental) The type of the network connection to the integration endpoint.
     *
     * @default HttpConnectionType.INTERNET
     * @experimental
     */
    readonly connectionType?: HttpConnectionType;
    /**
     * (experimental) The version of the payload format.
     *
     * @default - defaults to latest in the case of HttpIntegrationType.LAMBDA_PROXY`, irrelevant otherwise.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     * @experimental
     */
    readonly payloadFormatVersion?: PayloadFormatVersion;
    /**
     * (experimental) Specifies the TLS configuration for a private integration.
     *
     * @default undefined private integration traffic will use HTTP protocol
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html
     * @experimental
     */
    readonly secureServerName?: string;
}
/**
 * (experimental) The integration for an API route.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Integration
 */
export declare class HttpIntegration extends Resource implements IHttpIntegration {
    /**
     * (experimental) Id of the integration.
     *
     * @experimental
     */
    readonly integrationId: string;
    /**
     * (experimental) The HTTP API associated with this integration.
     *
     * @experimental
     */
    readonly httpApi: IHttpApi;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: HttpIntegrationProps);
}
/**
 * (experimental) Options to the HttpRouteIntegration during its bind operation.
 *
 * @experimental
 */
export interface HttpRouteIntegrationBindOptions {
    /**
     * (experimental) The route to which this is being bound.
     *
     * @experimental
     */
    readonly route: IHttpRoute;
    /**
     * (experimental) The current scope in which the bind is occurring.
     *
     * If the `HttpRouteIntegration` being bound creates additional constructs,
     * this will be used as their parent scope.
     *
     * @experimental
     */
    readonly scope: CoreConstruct;
}
/**
 * (experimental) The interface that various route integration classes will inherit.
 *
 * @experimental
 */
export interface IHttpRouteIntegration {
    /**
     * (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options: HttpRouteIntegrationBindOptions): HttpRouteIntegrationConfig;
}
/**
 * (experimental) Config returned back as a result of the bind.
 *
 * @experimental
 */
export interface HttpRouteIntegrationConfig {
    /**
     * (experimental) Integration type.
     *
     * @experimental
     */
    readonly type: HttpIntegrationType;
    /**
     * (experimental) Integration URI.
     *
     * @experimental
     */
    readonly uri: string;
    /**
     * (experimental) The HTTP method that must be used to invoke the underlying proxy.
     *
     * Required for `HttpIntegrationType.HTTP_PROXY`
     *
     * @default - undefined
     * @experimental
     */
    readonly method?: HttpMethod;
    /**
     * (experimental) The ID of the VPC link for a private integration.
     *
     * Supported only for HTTP APIs.
     *
     * @default - undefined
     * @experimental
     */
    readonly connectionId?: string;
    /**
     * (experimental) The type of the network connection to the integration endpoint.
     *
     * @default HttpConnectionType.INTERNET
     * @experimental
     */
    readonly connectionType?: HttpConnectionType;
    /**
     * (experimental) Payload format version in the case of lambda proxy integration.
     *
     * @default - undefined
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     * @experimental
     */
    readonly payloadFormatVersion: PayloadFormatVersion;
    /**
     * (experimental) Specifies the server name to verified by HTTPS when calling the backend integration.
     *
     * @default undefined private integration traffic will use HTTP protocol
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html
     * @experimental
     */
    readonly secureServerName?: string;
}
