"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpRoute = exports.HttpRouteKey = exports.HttpMethod = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const constructs_1 = require("constructs");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * (experimental) Supported HTTP methods.
 *
 * @experimental
 */
var HttpMethod;
(function (HttpMethod) {
    HttpMethod["ANY"] = "ANY";
    HttpMethod["DELETE"] = "DELETE";
    HttpMethod["GET"] = "GET";
    HttpMethod["HEAD"] = "HEAD";
    HttpMethod["OPTIONS"] = "OPTIONS";
    HttpMethod["PATCH"] = "PATCH";
    HttpMethod["POST"] = "POST";
    HttpMethod["PUT"] = "PUT";
})(HttpMethod = exports.HttpMethod || (exports.HttpMethod = {}));
/**
 * (experimental) HTTP route in APIGateway is a combination of the HTTP method and the path component.
 *
 * This class models that combination.
 *
 * @experimental
 */
class HttpRouteKey {
    constructor(key, path) {
        this.key = key;
        this.path = path;
    }
    /**
     * (experimental) Create a route key with the combination of the path and the method.
     *
     * @param method default is 'ANY'.
     * @experimental
     */
    static with(path, method) {
        if (path !== '/' && (!path.startsWith('/') || path.endsWith('/'))) {
            throw new Error('A route path must always start with a "/" and not end with a "/"');
        }
        return new HttpRouteKey(`${method !== null && method !== void 0 ? method : HttpMethod.ANY} ${path}`, path);
    }
}
exports.HttpRouteKey = HttpRouteKey;
_a = JSII_RTTI_SYMBOL_1;
HttpRouteKey[_a] = { fqn: "@aws-cdk/aws-apigatewayv2.HttpRouteKey", version: "1.117.0" };
/**
 * (experimental) The catch-all route of the API, i.e., when no other routes match.
 *
 * @experimental
 */
HttpRouteKey.DEFAULT = new HttpRouteKey('$default');
/**
 * Supported Route Authorizer types
 */
var HttpRouteAuthorizationType;
(function (HttpRouteAuthorizationType) {
    /** JSON Web Tokens */
    HttpRouteAuthorizationType["JWT"] = "JWT";
    /** Lambda Authorizer */
    HttpRouteAuthorizationType["CUSTOM"] = "CUSTOM";
    /** No authorizer */
    HttpRouteAuthorizationType["NONE"] = "NONE";
})(HttpRouteAuthorizationType || (HttpRouteAuthorizationType = {}));
/**
 * (experimental) Route class that creates the Route for API Gateway HTTP API.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Route
 */
class HttpRoute extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c;
        super(scope, id);
        this.httpApi = props.httpApi;
        this.path = props.routeKey.path;
        const config = props.integration.bind({
            route: this,
            scope: this,
        });
        const integration = props.httpApi._addIntegration(this, config);
        const authBindResult = props.authorizer ? props.authorizer.bind({
            route: this,
            scope: this.httpApi instanceof constructs_1.Construct ? this.httpApi : this,
        }) : undefined;
        if (authBindResult && !(authBindResult.authorizationType in HttpRouteAuthorizationType)) {
            throw new Error('authorizationType should either be JWT, CUSTOM, or NONE');
        }
        let authorizationScopes = authBindResult === null || authBindResult === void 0 ? void 0 : authBindResult.authorizationScopes;
        if (authBindResult && props.authorizationScopes) {
            authorizationScopes = Array.from(new Set([
                ...authorizationScopes !== null && authorizationScopes !== void 0 ? authorizationScopes : [],
                ...props.authorizationScopes,
            ]));
        }
        if ((authorizationScopes === null || authorizationScopes === void 0 ? void 0 : authorizationScopes.length) === 0) {
            authorizationScopes = undefined;
        }
        const routeProps = {
            apiId: props.httpApi.apiId,
            routeKey: props.routeKey.key,
            target: `integrations/${integration.integrationId}`,
            authorizerId: authBindResult === null || authBindResult === void 0 ? void 0 : authBindResult.authorizerId,
            authorizationType: (_c = authBindResult === null || authBindResult === void 0 ? void 0 : authBindResult.authorizationType) !== null && _c !== void 0 ? _c : 'NONE',
            authorizationScopes,
        };
        const route = new apigatewayv2_generated_1.CfnRoute(this, 'Resource', routeProps);
        this.routeId = route.ref;
    }
}
exports.HttpRoute = HttpRoute;
_b = JSII_RTTI_SYMBOL_1;
HttpRoute[_b] = { fqn: "@aws-cdk/aws-apigatewayv2.HttpRoute", version: "1.117.0" };
//# sourceMappingURL=data:application/json;base64,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