# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['space_objects', 'space_objects.base', 'space_objects.matplotlib']

package_data = \
{'': ['*']}

install_requires = \
['skyfield>=1.45,<2.0', 'tabulate>=0.9.0,<0.10.0']

setup_kwargs = {
    'name': 'space-objects',
    'version': '1.1.0',
    'description': 'wrapper lib around the skyfield package',
    'long_description': '# space_objects\n\n- ![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)\n\n\n- ![coverage](coverage-badge.svg)\n\n\n## Presentation\n\nVery simple objects which provides methods to get position and observation for space objects like the ISS station.\n\n- Allow to get position, observation and orbit data for actives and weather satellites.\n- Allow to get position, observation data for planets.\n\nThis project use the great [skyfield package](https://github.com/skyfielders/python-skyfield),  thanks to it\'s maintainers.\n\n## Motivation\n\nI was working on a project of an ISS tracker build on a rasperry pi and servo motors.\n\nI needed the ISS observation angles degrees for a given position, the position of the ISS in real time, this ISS orbit and a list of the forecast possible observations from my position.\n\nI needed to be web service agnostic and to be autonomous for the needed data.\n\nNow than this project is ready i decided to clean my researches and algos in appropriates repositories in the hope there will be usefull.\n\n## Environment Variable\n\nThis library support one environment variable, this variable is not mandatory.\n\nThe skyfield library will load some files, like TLE files and de421.bsp, by default space_objects create a directory `tle_files` in your script path and files will be download in this directory.\n\nYou can easily overide this behaviour with an environment variable: `TLE_FILES_DIRECTORY=< you custom path >`\n\n### Get the ISS position\n\n```python\nfrom space_objects.models import SatelliteActive\n\nmy_position = {\n    "observation_position_longitude": 1.433333,\n    "observation_position_latitude": 43.6,\n}\n\niss_object = SatelliteActive(satellite_name="ISS (ZARYA)", **my_position)\nposition = iss_object.get_position()\n```\n```python\nprint(position)\nPositionObject(\n  longitude=95.42870673510215,\n  latitude=-45.701086600061714,\n  altitude_kms=433.23953982510665,\n  timeposition_utc=\'2022-10-31T12:48:35Z\'\n)\n\n```\n### Get the ISS observation\n\n```python\nfrom space_objects.models import SatelliteActive\n\nmy_position = {\n    "observation_position_longitude": 1.433333,\n    "observation_position_latitude": 43.6,\n}\n\niss_object = SatelliteActive(satellite_name="ISS (ZARYA)", **my_position)\nobservation = iss_object.get_observation()\n```\n```python\nprint(observation)\nObservationObject(\n  degrees_vertical=-59.92007436232538,\n  degrees_horizontal=124.47513589616938,\n  distance_kms=11504.317997710621,\n  timeposition_utc=\'2022-10-31T12:48:35Z\'\n)\n```\n\n![vertical_orientation](assets/images/vertical_orientation.png)\n![horyzontal_orientation](assets/images/horyzontal_orientation.png)\n\n### Get the 24 hours forecast positions and observations for the ISS\n\n```python\nforecast_observations = iss_object.get_observations_forecast_24H()\nforecast_observations.tprint()\n```\n```text\ntimeposition_utc        degrees_vertical  is_sunlit\n--------------------  ------------------  -----------\n2022-11-01T01:41:39Z                  15  False\n2022-11-01T01:44:19Z                  85  False\n2022-11-01T01:47:00Z                  15  False\n2022-11-01T03:19:29Z                  15  False\n2022-11-01T03:21:27Z                  24  False\n2022-11-01T03:23:25Z                  15  False\n2022-11-01T04:57:16Z                  15  False\n2022-11-01T04:59:00Z                  21  True\n2022-11-01T05:00:43Z                  15  True\n2022-11-01T06:33:41Z                  15  True\n2022-11-01T06:36:18Z                  52  True\n2022-11-01T06:38:54Z                  15  True\n2022-11-01T08:11:01Z                  15  True\n2022-11-01T08:12:53Z                  23  True\n2022-11-01T08:14:45Z                  15  True\n```\n\n```python\nforecast_observation = forecast_observations[10].observation\nforecast_position = forecast_observations[10].position\nprint(forecast_position)\nprint(forecast_observation)\n```\n```text\nPositionObject(\n  longitude=3.2171481263959283,\n  latitude=46.0182975420938,\n  altitude_kms=422.3427194167064,\n  timeposition_utc=\'2022-11-01T06:36:18Z\'\n)\nObservationObject(\n  degrees_vertical=52.03750100701985,\n  degrees_horizontal=27.071376289371536,\n  distance_kms=525.8886708185943,\n  timeposition_utc=\'2022-11-01T06:36:18Z\'\n)\n```\n\n![forecast_vertical_orientation](assets/images/forecast_vertical_orientation.png)\n![forecast_horyzontal_orientation](assets/images/forecast_horyzontal_orientation.png)\n\n\n### Get the Sun position and observation\n\n```python\nfrom space_objects.models import PlanetObserver\n\nmy_position = {\n    "observation_position_longitude": 1.433333,\n    "observation_position_latitude": 43.6,\n}\n\nplanet_observer = PlanetObserver(**my_position)\nsun_observation = planet_observer.get_observation("SUN")\nsun_position = planet_observer.get_position("SUN")\n\nprint(sun_observation)\nprint(sun_position)\n```\n```text\nObservationObject(\n  degrees_vertical=27.123628441099548,\n  degrees_horizontal=209.69557585058428,\n  distance_kms=148520276.74009204,\n  timeposition_utc=\'2022-10-31T13:26:06Z\'\n)\nPositionObject(\n  longitude=-25.61420206366428,\n  latitude=-14.209948450817524,\n  altitude_kms=148516819.7673485,\n  timeposition_utc=\'2022-10-31T13:26:06Z\'\n)\n```\n\n![vertical_orientation_sun](assets/images/vertical_orientation_sun.png)\n![horyzontal_orientation_sun](assets/images/horyzontal_orientation_sun.png)\n\n## Notebooks\n\n- we maintain some Jupyter notebooks for concretes samples and demonstrations.\n\n## Development\n\n- this project use `poetry`\n- the code quality tools used are:\n  - `black`\n  - `isort`\n  - `flake8`\n  - `coverage`\n  - `pytest`\n  - `genbadge`\n\n- a precommit hook may be installed with the `pre-commit` python package\n- the pre commit hook will play:\n  - `black`\n  - `isort`\n  - `flake8`\n  - `coverage run -m pytest -W ignore`\n  - `coverage xml`\n  - `genbadge coverage -i coverage.xml`\n\n\n### install the development environment:\n\n```bash\npoetry install\npre-commit install\n```\n\n### Getting Started\n\n```bash\npoetry shell\nexport PYTHONPATH=.\n```\n\n\n## Authors\n\n  - **Olivier Larrieu** - [larrieu-olivier](https://github.com/larrieu-olivier)\n\n',
    'author': 'larrieu',
    'author_email': 'larrieuolivierad@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
