from setuptools import setup

name = "types-pytest-lazy-fixture"
description = "Typing stubs for pytest-lazy-fixture"
long_description = '''
## Typing stubs for pytest-lazy-fixture

This is a PEP 561 type stub package for the `pytest-lazy-fixture` package.
It can be used by type-checking tools like mypy, PyCharm, pytype etc. to check code
that uses `pytest-lazy-fixture`. The source for this package can be found at
https://github.com/python/typeshed/tree/main/stubs/pytest-lazy-fixture. All fixes for
types and metadata should be contributed there.

See https://github.com/python/typeshed/blob/main/README.md for more details.
This package was generated from typeshed commit `b58d0df34959f7448224a39d107d27c13e0b84d9`.
'''.lstrip()

setup(name=name,
      version="0.6.3.2",
      description=description,
      long_description=long_description,
      long_description_content_type="text/markdown",
      url="https://github.com/python/typeshed",
      project_urls={
          "GitHub": "https://github.com/python/typeshed",
          "Changes": "https://github.com/typeshed-internal/stub_uploader/blob/main/data/changelogs/pytest-lazy-fixture.md",
          "Issue tracker": "https://github.com/python/typeshed/issues",
          "Chat": "https://gitter.im/python/typing",
      },
      install_requires=[],
      packages=['pytest_lazyfixture-stubs'],
      package_data={'pytest_lazyfixture-stubs': ['__init__.pyi', 'METADATA.toml']},
      license="Apache-2.0 license",
      classifiers=[
          "License :: OSI Approved :: Apache Software License",
          "Programming Language :: Python :: 3",
          "Typing :: Stubs Only",
      ]
)
