import { Metric, MetricOptions } from '@aws-cdk/aws-cloudwatch';
import { IBucket } from '@aws-cdk/aws-s3';
import { Construct, Duration } from '@aws-cdk/core';
import type { IPackageSource, PackageSourceBindOptions, PackageSourceBindResult } from '../package-source';
export interface NpmJsProps {
    /**
     * The bucket to use for staging npm packages.
     *
     * @default - a new bucket will be created.
     */
    readonly stagingBucket?: IBucket;
    /**
     * Registers a package canary, which will track availability of a canary
     * package in ConstructHub, and emit dedicated metrics.
     *
     * @default true
     */
    readonly enableCanary?: boolean;
    /**
     * The package that is monitored by the package canary, if enabled by
     * `enableCanary`.
     *
     * @default 'construct-hub-probe'
     */
    readonly canaryPackage?: string;
    /**
     * The maximum amount of time it is supposed to take for packages to become
     * visible in this ConstructHub instance. If `enableCanary` is enabled, an
     * alarm will trigger if this SLA is breached by the `canaryPackage`.
     *
     * @default Duration.minutes(5)
     */
    readonly canarySla?: Duration;
}
/**
 * A package source that gets package data from the npmjs.com package registry.
 */
export declare class NpmJs implements IPackageSource {
    private readonly props;
    constructor(props?: NpmJsProps);
    bind(scope: Construct, { baseUrl, denyList, ingestion, licenseList, monitoring, queue, repository }: PackageSourceBindOptions): PackageSourceBindResult;
    /**
     * The average time it took to process a changes batch.
     */
    metricBatchProcessingTime(opts?: MetricOptions): Metric;
    /**
     * The total count of changes that were processed.
     */
    metricChangeCount(opts?: MetricOptions): Metric;
    /**
     * The last sequence number that was processed. This metric can be used to
     * discover when a sequence reset has happened in the CouchDB instance.
     */
    metricLastSeq(opts?: MetricOptions): Metric;
    metricNpmJsChangeAge(opts?: MetricOptions): Metric;
    /**
     * The age of the oldest package version that was processed.
     */
    metricPackageVersionAge(opts?: MetricOptions): Metric;
    /**
     * The total count of package versions that were inspected.
     */
    metricPackageVersionCount(opts?: MetricOptions): Metric;
    /**
     * The total count of package versions that were deemed relevant.
     */
    metricRelevantPackageVersions(opts?: MetricOptions): Metric;
    /**
     * The amount of time that was remaining when the lambda returned in order to
     * avoid hitting a timeout.
     */
    metricRemainingTime(opts?: MetricOptions): Metric;
    /**
     * The amount of changes that were not processed due to having an invalid
     * format.
     */
    metricUnprocessableEntity(opts?: MetricOptions): Metric;
    private registerAlarms;
    private registerCanary;
}
