"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagConditionReadme = exports.TagConditionField = exports.TagConditionLogicType = exports.TagCondition = exports.TagConditionSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
var TagConditionSource;
(function (TagConditionSource) {
    TagConditionSource["PACKAGE_JSON"] = "PACKAGE_JSON";
    TagConditionSource["README"] = "README";
})(TagConditionSource = exports.TagConditionSource || (exports.TagConditionSource = {}));
/**
 * Condition for applying a custom tag to a package.
 */
class TagCondition {
    /**
     * Create an && condition which applies only when all condition arguments are
     * true.
     */
    static and(...conds) {
        return new TagConditionLogic(TagConditionLogicType.AND, conds);
    }
    /**
     * Create an || condition which applies if any of the condition arguments are
     * true.
     */
    static or(...conds) {
        return new TagConditionLogic(TagConditionLogicType.OR, conds);
    }
    /**
     * Create a ! condition which applies if the condition argument is false
     */
    static not(...conds) {
        return new TagConditionLogic(TagConditionLogicType.NOT, conds);
    }
    /**
     * Target a field within the `package.json` to assert against. Nested fields
     * can be accessed by passing multiple keys.
     * `TagCondition.field('key1', 'key2')` will access
     * `packageJson?.key1?.key2`.
     */
    static field(...keys) {
        return new TagConditionField(keys);
    }
    /**
     * Create a condition with logic targeting the README of the package.
     */
    static readme() {
        return new TagConditionReadme();
    }
}
exports.TagCondition = TagCondition;
_a = JSII_RTTI_SYMBOL_1;
TagCondition[_a] = { fqn: "construct-hub.TagCondition", version: "0.3.248" };
/**
 * Logic operators for performing specific conditional logic.
 */
var TagConditionLogicType;
(function (TagConditionLogicType) {
    TagConditionLogicType["AND"] = "AND";
    TagConditionLogicType["OR"] = "OR";
    TagConditionLogicType["NOT"] = "NOT";
    TagConditionLogicType["EQUALS"] = "EQUALS";
    TagConditionLogicType["INCLUDES"] = "INCLUDES";
    TagConditionLogicType["STARTS_WITH"] = "STARTS_WITH";
})(TagConditionLogicType = exports.TagConditionLogicType || (exports.TagConditionLogicType = {}));
class TagConditionLogic extends TagCondition {
    constructor(type, children) {
        super();
        this.type = type;
        this.children = children;
        this.isLogic = true;
    }
    bind() {
        return {
            type: this.type,
            children: this.children.map((cond) => cond.bind()),
        };
    }
}
class TagConditionPredicate extends TagCondition {
    constructor(type, source, key, value, options) {
        super();
        this.type = type;
        this.source = source;
        this.key = key;
        this.value = value;
        this.options = options;
        this.isPredicate = true;
    }
    bind() {
        return {
            type: this.type,
            source: this.source,
            key: this.key,
            value: this.value,
            options: this.options,
        };
    }
}
/**
 * Target a field to use in logic to dictate whether a tag is relevant.
 */
class TagConditionField {
    constructor(field) {
        this.field = field;
    }
    /**
     * Create a === condition which applies if the specified field within the
     * package's package.json is equal to the passed value.
     */
    eq(value) {
        return new TagConditionPredicate(TagConditionLogicType.EQUALS, TagConditionSource.PACKAGE_JSON, this.field, value);
    }
    /**
     * Create a `field.includes(value)` condition which applies if the specified
     * field within the package's package.json includes the value. This works for
     * arrays or strings.
     */
    includes(value, options = {}) {
        return new TagConditionPredicate(TagConditionLogicType.INCLUDES, TagConditionSource.PACKAGE_JSON, this.field, value, options);
    }
    /**
     * Create a `field.startsWith(value)` condition which applies if the specified
     * field within the package's package.json begins with the value. This works
     * only for string values.
     */
    startsWith(value) {
        return new TagConditionPredicate(TagConditionLogicType.STARTS_WITH, TagConditionSource.PACKAGE_JSON, this.field, value);
    }
}
exports.TagConditionField = TagConditionField;
_b = JSII_RTTI_SYMBOL_1;
TagConditionField[_b] = { fqn: "construct-hub.TagConditionField", version: "0.3.248" };
/**
 * Target the README of the package to dictate whether a tag is relevant.
 */
class TagConditionReadme {
    constructor() { }
    /**
     * Create a `readme.includes(value)` condition which applies if the README
     * includes the specified string.
     */
    includes(value, options = {}) {
        return new TagConditionPredicate(TagConditionLogicType.INCLUDES, TagConditionSource.README, undefined, // no key
        value, options);
    }
}
exports.TagConditionReadme = TagConditionReadme;
_c = JSII_RTTI_SYMBOL_1;
TagConditionReadme[_c] = { fqn: "construct-hub.TagConditionReadme", version: "0.3.248" };
//# sourceMappingURL=data:application/json;base64,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