"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreloadFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
/**
 * Represents a javascript file to load before the webapp.
 * This can allow operators to add their own client monitors or analytics if they wish
 */
class PreloadFile {
    constructor(data) {
        this.data = data;
    }
    /**
     * Creates a PreloadFile instance from a filepath to load
     */
    static fromFile(path) {
        const data = fs_1.readFileSync(path, { encoding: 'utf-8' });
        return new PreloadFile(data);
    }
    /**
     * Creates a PreloadFile instance directly from source code
     */
    static fromCode(code) {
        return new PreloadFile(code);
    }
    bind() {
        return this.data;
    }
}
exports.PreloadFile = PreloadFile;
_a = JSII_RTTI_SYMBOL_1;
PreloadFile[_a] = { fqn: "construct-hub.PreloadFile", version: "0.3.248" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvcHJlbG9hZC1maWxlL2luZGV4LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsMkJBQWtDO0FBRWxDOzs7R0FHRztBQUNILE1BQWEsV0FBVztJQWdCdEIsWUFBNkIsSUFBWTtRQUFaLFNBQUksR0FBSixJQUFJLENBQVE7SUFBRyxDQUFDO0lBZjdDOztPQUVHO0lBQ0gsTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFZO1FBQzFCLE1BQU0sSUFBSSxHQUFHLGlCQUFZLENBQUMsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLE9BQU8sRUFBRSxDQUFDLENBQUM7UUFDdkQsT0FBTyxJQUFJLFdBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUMvQixDQUFDO0lBRUQ7O09BRUc7SUFDSCxNQUFNLENBQUMsUUFBUSxDQUFDLElBQVk7UUFDMUIsT0FBTyxJQUFJLFdBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUMvQixDQUFDO0lBSU0sSUFBSTtRQUNULE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQztJQUNuQixDQUFDOztBQXBCSCxrQ0FxQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyByZWFkRmlsZVN5bmMgfSBmcm9tICdmcyc7XG5cbi8qKlxuICogUmVwcmVzZW50cyBhIGphdmFzY3JpcHQgZmlsZSB0byBsb2FkIGJlZm9yZSB0aGUgd2ViYXBwLlxuICogVGhpcyBjYW4gYWxsb3cgb3BlcmF0b3JzIHRvIGFkZCB0aGVpciBvd24gY2xpZW50IG1vbml0b3JzIG9yIGFuYWx5dGljcyBpZiB0aGV5IHdpc2hcbiAqL1xuZXhwb3J0IGNsYXNzIFByZWxvYWRGaWxlIHtcbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBQcmVsb2FkRmlsZSBpbnN0YW5jZSBmcm9tIGEgZmlsZXBhdGggdG8gbG9hZFxuICAgKi9cbiAgc3RhdGljIGZyb21GaWxlKHBhdGg6IHN0cmluZyk6IFByZWxvYWRGaWxlIHtcbiAgICBjb25zdCBkYXRhID0gcmVhZEZpbGVTeW5jKHBhdGgsIHsgZW5jb2Rpbmc6ICd1dGYtOCcgfSk7XG4gICAgcmV0dXJuIG5ldyBQcmVsb2FkRmlsZShkYXRhKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGVzIGEgUHJlbG9hZEZpbGUgaW5zdGFuY2UgZGlyZWN0bHkgZnJvbSBzb3VyY2UgY29kZVxuICAgKi9cbiAgc3RhdGljIGZyb21Db2RlKGNvZGU6IHN0cmluZyk6IFByZWxvYWRGaWxlIHtcbiAgICByZXR1cm4gbmV3IFByZWxvYWRGaWxlKGNvZGUpO1xuICB9XG5cbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBkYXRhOiBzdHJpbmcpIHt9XG5cbiAgcHVibGljIGJpbmQoKTogc3RyaW5nIHtcbiAgICByZXR1cm4gdGhpcy5kYXRhO1xuICB9XG59Il19