"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3StorageFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const s3 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
/**
 * Create s3 storage resources.
 */
class S3StorageFactory extends core_1.Construct {
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id);
        this.failoverActive = (_b = props.failover) !== null && _b !== void 0 ? _b : false;
    }
    /**
     * Retrieve or create the storage factory for the current scope.
     *
     * This is stack singleton.
     */
    static getOrCreate(scope, props = {}) {
        const stack = core_1.Stack.of(scope);
        const factory = stack.node.tryFindChild(S3StorageFactory.UID);
        if (!factory) {
            return new S3StorageFactory(stack, S3StorageFactory.UID, props);
        }
        return stack.node.findChild(S3StorageFactory.UID);
    }
    ;
    /**
     * Create a new bucket in a storage config aware manner.
     *
     * @returns s3.Bucket
     */
    newBucket(scope, id, props) {
        function failoverFor(bucket) {
            const _failover = new s3.Bucket(scope, `Failover${id}`, props);
            core_1.Tags.of(_failover).add('failover', 'true');
            new core_1.CfnOutput(scope, 'SnapshotCommand', {
                description: `Snapshot ${bucket.node.path}`,
                value: `aws s3 sync s3://${bucket.bucketName} s3://${_failover.bucketName}`,
            });
            return _failover;
        }
        const primary = new s3.Bucket(scope, id, props);
        // note that we create the failover bucket even if we don't currently use it.
        // this is because conditioning bucket creation will eventually fail since buckets
        // are normally retained.
        const failover = failoverFor(primary);
        return this.failoverActive ? failover : primary;
    }
}
exports.S3StorageFactory = S3StorageFactory;
_a = JSII_RTTI_SYMBOL_1;
S3StorageFactory[_a] = { fqn: "construct-hub.S3StorageFactory", version: "0.3.248" };
S3StorageFactory.UID = 'S3StorageFactory';
//# sourceMappingURL=data:application/json;base64,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