import { GatewayVpcEndpoint } from '@aws-cdk/aws-ec2';
import { IBucket } from '@aws-cdk/aws-s3';
/**
 * Decorates an S3 Bucket so that grants are made including a VPC endpoint
 * policy.
 *
 * This currently only supports the `grantRead`, `grantWrite`, and `grantDelete`
 * APIs.
 *
 * @param bucket      the bucket to be wrapped.
 * @param vpcEndpoint the VPC Endpoint for S3 to be used.
 *
 * @returns a decorated S3 Bucket.
 */
export declare function throughVpcEndpoint(bucket: IBucket, vpcEndpoint: GatewayVpcEndpoint): IBucket;
