# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest

class DescribeMonitorGroupsRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'Cms', '2019-01-01', 'DescribeMonitorGroups','cms')
		self.set_method('POST')

	def get_SelectContactGroups(self):
		return self.get_query_params().get('SelectContactGroups')

	def set_SelectContactGroups(self,SelectContactGroups):
		self.add_query_param('SelectContactGroups',SelectContactGroups)

	def get_IncludeTemplateHistory(self):
		return self.get_query_params().get('IncludeTemplateHistory')

	def set_IncludeTemplateHistory(self,IncludeTemplateHistory):
		self.add_query_param('IncludeTemplateHistory',IncludeTemplateHistory)

	def get_DynamicTagRuleId(self):
		return self.get_query_params().get('DynamicTagRuleId')

	def set_DynamicTagRuleId(self,DynamicTagRuleId):
		self.add_query_param('DynamicTagRuleId',DynamicTagRuleId)

	def get_Type(self):
		return self.get_query_params().get('Type')

	def set_Type(self,Type):
		self.add_query_param('Type',Type)

	def get_PageNumber(self):
		return self.get_query_params().get('PageNumber')

	def set_PageNumber(self,PageNumber):
		self.add_query_param('PageNumber',PageNumber)

	def get_GroupFounderTagKey(self):
		return self.get_query_params().get('GroupFounderTagKey')

	def set_GroupFounderTagKey(self,GroupFounderTagKey):
		self.add_query_param('GroupFounderTagKey',GroupFounderTagKey)

	def get_PageSize(self):
		return self.get_query_params().get('PageSize')

	def set_PageSize(self,PageSize):
		self.add_query_param('PageSize',PageSize)

	def get_Tags(self):
		return self.get_query_params().get('Tag')

	def set_Tags(self, Tags):
		for depth1 in range(len(Tags)):
			if Tags[depth1].get('Value') is not None:
				self.add_query_param('Tag.' + str(depth1 + 1) + '.Value', Tags[depth1].get('Value'))
			if Tags[depth1].get('Key') is not None:
				self.add_query_param('Tag.' + str(depth1 + 1) + '.Key', Tags[depth1].get('Key'))

	def get_GroupFounderTagValue(self):
		return self.get_query_params().get('GroupFounderTagValue')

	def set_GroupFounderTagValue(self,GroupFounderTagValue):
		self.add_query_param('GroupFounderTagValue',GroupFounderTagValue)

	def get_Keyword(self):
		return self.get_query_params().get('Keyword')

	def set_Keyword(self,Keyword):
		self.add_query_param('Keyword',Keyword)

	def get_GroupId(self):
		return self.get_query_params().get('GroupId')

	def set_GroupId(self,GroupId):
		self.add_query_param('GroupId',GroupId)

	def get_GroupName(self):
		return self.get_query_params().get('GroupName')

	def set_GroupName(self,GroupName):
		self.add_query_param('GroupName',GroupName)

	def get_InstanceId(self):
		return self.get_query_params().get('InstanceId')

	def set_InstanceId(self,InstanceId):
		self.add_query_param('InstanceId',InstanceId)