"""Booster cycle data."""

import numpy as _np
from ..pwrsupply.csdev import \
    DEF_WFMSIZE_FBP as _DEF_WFMSIZE_FBP, \
    DEF_WFMSIZE_OTHERS as _DEF_WFMSIZE_OTHERS
from siriuspy.search import PSSearch as _PSSearch

# Constants

DEFAULT_RAMP_DURATION = 490000  # [us]

DEFAULT_RAMP_NRCYCLES = 16

DEFAULT_RAMP_TOTDURATION = DEFAULT_RAMP_DURATION * \
    DEFAULT_RAMP_NRCYCLES/1000000  # [s]

DEFAULT_RAMP_AMPLITUDE = {  # A
    'BO-Fam:PS-B-1': 1072,
    'BO-Fam:PS-B-2': 1072,
    'BO-Fam:PS-QD': 30,
    'BO-Fam:PS-QF': 120,
    'BO-Fam:PS-SD': 149,
    'BO-Fam:PS-SF': 149}

# Time x Current, units: [ms] x [A]
BASE_RAMP_CURVE_ORIG = \
    _np.array(
        [[0.00000000000000,   0.000000000000000000],
         [0.239374694663160,  3.65385069867429e-07],
         [0.478749389326320,  1.61382508427320e-06],
         [0.718124083989479,  3.97292032631705e-06],
         [0.957498778652639,  7.67062492569270e-06],
         [1.19687347331580,   1.29348314735558e-05],
         [1.43624816797896,   1.99933940994756e-05],
         [1.67562286264212,   2.90742053946078e-05],
         [1.91499755730528,   4.04051194885217e-05],
         [2.15437225196844,   5.42140289723730e-05],
         [2.39374694663160,   7.07287956680482e-05],
         [2.63312164129476,   9.01772890897511e-05],
         [2.87249633595792,   0.000112787394136320],
         [3.11187103062108,   0.000138786988014277],
         [3.35124572528424,   0.000168403924853190],
         [3.59062041994740,   0.000201866097244215],
         [3.82999511461056,   0.000239401374701556],
         [4.06936980927372,   0.000281237619047100],
         [4.30874450393688,   0.000327602715179685],
         [4.54811919860004,   0.000378724540305832],
         [4.78749389326320,   0.000434830956247428],
         [5.02686858792635,   0.000496149847903311],
         [5.26624328258952,   0.000562909077095368],
         [5.50561797725267,   0.000635336528722436],
         [5.74499267191583,   0.000713660072298721],
         [5.98436736657899,   0.000798107577338425],
         [6.22374206124215,   0.000888906928740388],
         [6.46311675590531,   0.000986285988326495],
         [6.70249145056847,   0.00109047263330327],
         [6.94186614523163,   0.00120169473318491],
         [7.18124083989479,   0.00132018017287026],
         [7.42061553455795,   0.00144615682187352],
         [7.65999022922111,   0.00157985254970890],
         [7.89936492388427,   0.00172149523358292],
         [8.13873961854743,   0.00187131274300977],
         [8.37811431321059,   0.00202953295519599],
         [8.61748900787375,   0.00219638374734809],
         [8.85686370253691,   0.00237209298128796],
         [9.09623839720007,   0.00255688854191444],
         [9.33561309186323,   0.00275099829874173],
         [9.57498778652639,   0.00295465012897635],
         [9.81436248609195,   0.00316807190213251],
         [10.0537371758527,   0.00339149149541673],
         [10.2931118754183,   0.00362513677065089],
         [10.5324865651790,   0.00386923562042615],
         [10.7718612647446,   0.00412401590656440],
         [11.0112359545053,   0.00438970550627216],
         [11.2506106540709,   0.00466653228906362],
         [11.4899853438317,   0.00495472413214533],
         [11.7293600433972,   0.00525450891272378],
         [11.9687347331580,   0.00556611450031319],
         [12.2081094327235,   0.00588976876442776],
         [12.4474841224843,   0.00622569958227402],
         [12.6868588220499,   0.00657413483875080],
         [12.9262335118106,   0.00693530238798766],
         [13.1656082113762,   0.00730943011488346],
         [13.4049829011369,   0.00769674588895239],
         [13.6443576007025,   0.00809747758740097],
         [13.8837322904633,   0.00851185308743573],
         [14.1231069900288,   0.00894010025087854],
         [14.3624816797896,   0.00938244696262826],
         [14.6018563793551,   0.00983912109219908],
         [14.8412310691159,   0.0103103505167975],
         [15.0806057686815,   0.0107963630982455],
         [15.3199804584422,   0.0112973867214418],
         [15.5593551580078,   0.0118136492635930],
         [15.7987298477685,   0.0123453785865209],
         [16.0381045473341,   0.0128928025674321],
         [16.2774792370949,   0.0134561490835331],
         [16.5168539366604,   0.0140356460043381],
         [16.7562286264212,   0.0146315212070537],
         [16.9956033259867,   0.0152440025688863],
         [17.2349780157475,   0.0158733179593501],
         [17.4743527153131,   0.0165196952479594],
         [17.7137274050738,   0.0171833623119207],
         [17.9531021046394,   0.0178645470284404],
         [18.1924767944001,   0.0185634772593406],
         [18.4318514939657,   0.0192803808972122],
         [18.6712261837265,   0.0200154858038773],
         [18.9106008832920,   0.0207690198488501],
         [19.1499755730528,   0.0215412109170293],
         [19.3893502726183,   0.0223322868702368],
         [19.6287249623791,   0.0231424137471408],
         [19.8680996619447,   0.0239606882880254],
         [20.1074743517054,   0.0247789628289099],
         [20.3468490512710,   0.0255972373697945],
         [20.5862237410317,   0.0264155119106790],
         [20.8255984405973,   0.0272337864515636],
         [21.0649731303581,   0.0280520609924482],
         [21.3043478299236,   0.0288703355333327],
         [21.5437225196844,   0.0296886100742173],
         [21.7830972192499,   0.0305068846151019],
         [22.0224719090107,   0.0313251591559864],
         [22.2618466085763,   0.0321434336968710],
         [22.5012212983370,   0.0329617082377556],
         [22.7405959979026,   0.0337799827786401],
         [22.9799706876633,   0.0345982573195247],
         [23.2193453872289,   0.0354165318604093],
         [23.4587200769897,   0.0362348064012938],
         [23.6980947765552,   0.0370530809421784],
         [23.9374694663160,   0.0378713554830629],
         [24.1768441658815,   0.0386896300239475],
         [24.4162188556423,   0.0395079045648321],
         [24.6555935552079,   0.0403261791057166],
         [24.8949682449686,   0.0411444536466012],
         [25.1343429445342,   0.0419627281874858],
         [25.3737176342949,   0.0427810027360626],
         [25.6130923338605,   0.0435992772769472],
         [25.8524670236213,   0.0444175518178318],
         [26.0918417231868,   0.0452358263587163],
         [26.3312164129476,   0.0460541008996009],
         [26.5705911125131,   0.0468723754404855],
         [26.8099658022739,   0.0476906499813700],
         [27.0493405018394,   0.0485089245222546],
         [27.2887151916002,   0.0493271990631391],
         [27.5280898911658,   0.0501454736040237],
         [27.7674645809265,   0.0509637481449083],
         [28.0068392804921,   0.0517820226857928],
         [28.2462139702529,   0.0526002972266774],
         [28.4855886698184,   0.0534185717675620],
         [28.7249633595792,   0.0542368463084465],
         [28.9643380591447,   0.0550551208493311],
         [29.2037127489055,   0.0558733953902157],
         [29.4430874484710,   0.0566916699311002],
         [29.6824621382318,   0.0575099444719848],
         [29.9218368377974,   0.0583282190128693],
         [30.1612115275581,   0.0591464935537539],
         [30.4005862271237,   0.0599647680946385],
         [30.6399609168844,   0.0607830426355230],
         [30.8793356164500,   0.0616013171764076],
         [31.1187103062108,   0.0624195917172922],
         [31.3580850057763,   0.0632378662581767],
         [31.5974596955371,   0.0640561407990613],
         [31.8368343951026,   0.0648744153399459],
         [32.0762090848634,   0.0656926898885227],
         [32.3155837844290,   0.0665109644294073],
         [32.5549584741897,   0.0673292389702919],
         [32.7943331737553,   0.0681475135111764],
         [33.0337078635161,   0.0689657880520610],
         [33.2730825630816,   0.0697840625929456],
         [33.5124572528424,   0.0706023371338301],
         [33.7518319524079,   0.0714206116747147],
         [33.9912066421687,   0.0722388862155993],
         [34.2305813417342,   0.0730571607564838],
         [34.4699560314950,   0.0738754352973684],
         [34.7093307310606,   0.0746937098382529],
         [34.9487054208213,   0.0755119843791375],
         [35.1880801203869,   0.0763302589200221],
         [35.4274548101476,   0.0771485334993682],
         [35.6668295097132,   0.0779668079787142],
         [35.9062041994740,   0.0787850825349834],
         [36.1455788990395,   0.0796033570912526],
         [36.3849535888003,   0.0804216316475218],
         [36.6243282883658,   0.0812399062037910],
         [36.8637029781266,   0.0820581806831371],
         [37.1030776776922,   0.0828764552394063],
         [37.3424523674529,   0.0836947297956755],
         [37.5818270670185,   0.0845130043519447],
         [37.8212017567792,   0.0853312789082138],
         [38.0605764563448,   0.0861495533875599],
         [38.2999511461056,   0.0869678279438291],
         [38.5393258456711,   0.0877861025000983],
         [38.7787005354319,   0.0886043770563675],
         [39.0180752349974,   0.0894226516126367],
         [39.2574499247582,   0.0902409260919827],
         [39.4968246243238,   0.0910592006482519],
         [39.7361993140845,   0.0918774752045211],
         [39.9755740136501,   0.0926957497607903],
         [40.2149487034108,   0.0935140243170595],
         [40.4543234029764,   0.0943322987964055],
         [40.6936980927372,   0.0951505733526747],
         [40.9330727923027,   0.0959688479089439],
         [41.1724474820635,   0.0967871224652131],
         [41.4118221816290,   0.0976053970214823],
         [41.6511968713898,   0.0984236715008283],
         [41.8905715709553,   0.0992419460570975],
         [42.1299462607161,   0.100060220613367],
         [42.3693209602817,   0.100878495169636],
         [42.6086956500424,   0.101696769725905],
         [42.8480703496080,   0.102515044205251],
         [43.0874450393688,   0.103333318761520],
         [43.3268197389343,   0.104151593317790],
         [43.5661944286951,   0.104969867874059],
         [43.8055691282606,   0.105788142430328],
         [44.0449438180214,   0.106606416909674],
         [44.2843185175870,   0.107424691465943],
         [44.5236932073477,   0.108242966022212],
         [44.7630679069133,   0.109061240578482],
         [45.0024425966740,   0.109879515134751],
         [45.2418172962396,   0.110697789614097],
         [45.4811919860004,   0.111516064170366],
         [45.7205666855659,   0.112334338726635],
         [45.9599413753267,   0.113152613282904],
         [46.1993160748922,   0.113970887839174],
         [46.4386907646530,   0.114789162318520],
         [46.6780654642186,   0.115607436874789],
         [46.9174401539793,   0.116425711431058],
         [47.1568148535449,   0.117243985987327],
         [47.3961895433056,   0.118062260543596],
         [47.6355642428712,   0.118880535022942],
         [47.8749389326320,   0.119698809579212],
         [48.1143136321975,   0.120517084135481],
         [48.3536883219583,   0.121335358691750],
         [48.5930630215238,   0.122153633248019],
         [48.8324377112846,   0.122971907804288],
         [49.0718124108501,   0.123790182283634],
         [49.3111871006109,   0.124608456839904],
         [49.5505618001765,   0.125426731396173],
         [49.7899364899372,   0.126245005952442],
         [50.0293111895028,   0.127063280508711],
         [50.2686858792636,   0.127881554988057],
         [50.5080605788291,   0.128699829544326],
         [50.7474352685899,   0.129518104100596],
         [50.9868099681554,   0.130336378656865],
         [51.2261846579162,   0.131154653213134],
         [51.4655593574817,   0.131972927692480],
         [51.7049340472425,   0.132791202248749],
         [51.9443087468081,   0.133609476805018],
         [52.1836834365688,   0.134427751361288],
         [52.4230581361344,   0.135246025917557],
         [52.6624328258951,   0.136064300396903],
         [52.9018075254607,   0.136882574953172],
         [53.1411822152215,   0.137700849509441],
         [53.3805569147870,   0.138519124065710],
         [53.6199316045478,   0.139337398621980],
         [53.8593063041133,   0.140155673101326],
         [54.0986809938741,   0.140973947657595],
         [54.3380556934397,   0.141792222213864],
         [54.5774303832004,   0.142610496770133],
         [54.8168050827660,   0.143428771326403],
         [55.0561797725267,   0.144247045805749],
         [55.2955544720923,   0.145065320362018],
         [55.5349291618531,   0.145883594918287],
         [55.7743038614186,   0.146701869474556],
         [56.0136785511794,   0.147520144030825],
         [56.2530532507449,   0.148338418510171],
         [56.4924279405057,   0.149156693066441],
         [56.7318026400713,   0.149974967622710],
         [56.9711773298320,   0.150793242178979],
         [57.2105520293976,   0.151611516735248],
         [57.4499267191583,   0.152429791214594],
         [57.6893014187239,   0.153248065770863],
         [57.9286761084847,   0.154066340327133],
         [58.1680508080502,   0.154884614883402],
         [58.4074254978110,   0.155702889439671],
         [58.6468001973765,   0.156521163919017],
         [58.8861748871373,   0.157339438475286],
         [59.1255495867029,   0.158157713031555],
         [59.3649242764636,   0.158975987587825],
         [59.6042989760292,   0.159794262144094],
         [59.8436736657899,   0.160612536623440],
         [60.0830483653555,   0.161430811179709],
         [60.3224230551163,   0.162249085735978],
         [60.5617977546818,   0.163067360292247],
         [60.8011724444426,   0.163885634848517],
         [61.0405471440081,   0.164703909327863],
         [61.2799218337689,   0.165522183884132],
         [61.5192965333345,   0.166340458440401],
         [61.7586712230952,   0.167158732996670],
         [61.9980459226608,   0.167977007552939],
         [62.2374206124215,   0.168795282109209],
         [62.4767953119871,   0.169613556588555],
         [62.7161700017479,   0.170431831144824],
         [62.9555447013134,   0.171250105701093],
         [63.1949193910742,   0.172068380257362],
         [63.4342940906397,   0.172886654813631],
         [63.6736687804005,   0.173704929292977],
         [63.9130434799661,   0.174523203849247],
         [64.1524181697268,   0.175341478405516],
         [64.3917928692924,   0.176159752961785],
         [64.6311675590531,   0.176978027518054],
         [64.8705422586187,   0.177796301997400],
         [65.1099169483795,   0.178614576553669],
         [65.3492916479450,   0.179432851109939],
         [65.5886663377058,   0.180251125666208],
         [65.8280410372713,   0.181069400222477],
         [66.0674157270321,   0.181887674701823],
         [66.3067904265976,   0.182705949258092],
         [66.5461651163584,   0.183524223814361],
         [66.7855398159240,   0.184342498370631],
         [67.0249145056847,   0.185160772926900],
         [67.2642892052503,   0.185979047406246],
         [67.5036638950111,   0.186797321962515],
         [67.7430385945766,   0.187615596518784],
         [67.9824132843374,   0.188433871075054],
         [68.2217879839029,   0.189252145631323],
         [68.4611626736637,   0.190070420110669],
         [68.7005373732293,   0.190888694666938],
         [68.9399120629900,   0.191706969223207],
         [69.1792867625556,   0.192525243779476],
         [69.4186614523163,   0.193343518335746],
         [69.6580361518819,   0.194161792815092],
         [69.8974108416427,   0.194980067371361],
         [70.1367855412082,   0.195798341927630],
         [70.3761602309690,   0.196616616483899],
         [70.6155349305345,   0.197434891040168],
         [70.8549096202953,   0.198253165519514],
         [71.0942843198609,   0.199071440075784],
         [71.3336590096216,   0.199889714632053],
         [71.5730337091872,   0.200707989188322],
         [71.8124083989479,   0.201526263744591],
         [72.0517830985135,   0.202344538223937],
         [72.2911577882742,   0.203162812780206],
         [72.5305324878398,   0.203981087336476],
         [72.7699071776006,   0.204799361892745],
         [73.0092818771661,   0.205617636449014],
         [73.2486565669269,   0.206435910928360],
         [73.4880312664924,   0.207254185484629],
         [73.7274059562532,   0.208072460040898],
         [73.9667806558188,   0.208890734597168],
         [74.2061553455795,   0.209709009153437],
         [74.4455300451451,   0.210527283632783],
         [74.6849047349058,   0.211345558189052],
         [74.9242794344714,   0.212163832745321],
         [75.1636541242322,   0.212982107301590],
         [75.4030288237977,   0.213800381857860],
         [75.6424035135585,   0.214618656414129],
         [75.8817782131241,   0.215436930893475],
         [76.1211529028848,   0.216255205449744],
         [76.3605276024504,   0.217073480006013],
         [76.5999022922111,   0.217891754562282],
         [76.8392769917767,   0.218710029118552],
         [77.0786516815374,   0.219528303597898],
         [77.3180263811030,   0.220346578154167],
         [77.5574010708638,   0.221164852710436],
         [77.7967757704293,   0.221983127266705],
         [78.0361504601901,   0.222801401822974],
         [78.2755251597557,   0.223619676302320],
         [78.5148998495164,   0.224437950858590],
         [78.7542745490820,   0.225256225414859],
         [78.9936492388427,   0.226074499971128],
         [79.2330239384083,   0.226892774527397],
         [79.4723986281690,   0.227711049006743],
         [79.7117733277346,   0.228529323563012],
         [79.9511480174954,   0.229347598119282],
         [80.1905227170609,   0.230165872675551],
         [80.4298974068217,   0.230984147231820],
         [80.6692721063872,   0.231802421711166],
         [80.9086467961480,   0.232620696267435],
         [81.1480214957136,   0.233438970823705],
         [81.3873961854743,   0.234257245379974],
         [81.6267708850399,   0.235075519936243],
         [81.8661455748006,   0.235893794415589],
         [82.1055202743662,   0.236712068971858],
         [82.3448949641270,   0.237530343528127],
         [82.5842696636925,   0.238348618084397],
         [82.8236443534533,   0.239166892640666],
         [83.0630190530188,   0.239985167120012],
         [83.3023937427796,   0.240803441676281],
         [83.5417684423452,   0.241621716232550],
         [83.7811431321059,   0.242439990788819],
         [84.0205178316715,   0.243258265345089],
         [84.2598925214322,   0.244076539824435],
         [84.4992672209978,   0.244894814380704],
         [84.7386419107586,   0.245713088936973],
         [84.9780166103241,   0.246531363493242],
         [85.2173913000849,   0.247349638049511],
         [85.4567659996504,   0.248167912528857],
         [85.6961406894112,   0.248986187085127],
         [85.9355153889768,   0.249804461641396],
         [86.1748900787375,   0.250622736197665],
         [86.4142647783031,   0.251441010753934],
         [86.6536394680638,   0.252259285233280],
         [86.8930141676294,   0.253077559789549],
         [87.1323888573901,   0.253895834345819],
         [87.3717635569557,   0.254714108902088],
         [87.6111382467165,   0.255532383458357],
         [87.8505129462820,   0.256350657937703],
         [88.0898876360428,   0.257168932493972],
         [88.3292623356084,   0.257987207050241],
         [88.5686370253691,   0.258805481606511],
         [88.8080117249347,   0.259623756162780],
         [89.0473864146954,   0.260442030719049],
         [89.2867611142610,   0.261260305198395],
         [89.5261358040218,   0.262078579754664],
         [89.7655105035873,   0.262896854310933],
         [90.0048851933481,   0.263715128867203],
         [90.2442598929136,   0.264533403423472],
         [90.4836345826744,   0.265351677902818],
         [90.7230092822399,   0.266169952459087],
         [90.9623839720007,   0.266988227015356],
         [91.2017586715663,   0.267806501571625],
         [91.4411333613270,   0.268624776127895],
         [91.6805080608926,   0.269443050607241],
         [91.9198827506533,   0.270261325163510],
         [92.1592574502189,   0.271079599719779],
         [92.3986321399797,   0.271897874276048],
         [92.6380068395452,   0.272716148832317],
         [92.8773815293060,   0.273534423311664],
         [93.1167562288715,   0.274352697867933],
         [93.3561309186323,   0.275170972424202],
         [93.5955056181979,   0.275989246980471],
         [93.8348803079586,   0.276807521536740],
         [94.0742550075242,   0.277625796016086],
         [94.3136296972849,   0.278444070572356],
         [94.5530043968505,   0.279262345128625],
         [94.7923790866113,   0.280080619684894],
         [95.0317537861768,   0.280898894241163],
         [95.2711284759376,   0.281717168720509],
         [95.5105031755031,   0.282535443276778],
         [95.7498778652639,   0.283353717833048],
         [95.9892525648295,   0.284171992389317],
         [96.2286272545902,   0.284990266945586],
         [96.4680019541558,   0.285808541424932],
         [96.7073766439165,   0.286626815981201],
         [96.9467513434821,   0.287445090537470],
         [97.1861260332429,   0.288263365093740],
         [97.4255007328084,   0.289081639650009],
         [97.6648754225692,   0.289899914129355],
         [97.9042501221347,   0.290718188685624],
         [98.1436248609194,   0.291536463241893],
         [98.3829995310706,   0.292354737798162],
         [98.6223742012218,   0.293173012354432],
         [98.8617488713730,   0.293991286833778],
         [99.1011236395721,   0.294809561390047],
         [99.3404983097233,   0.295627835946316],
         [99.5798729798745,   0.296446110502585],
         [99.8192476500256,   0.297264385058854],
         [100.058622418225,   0.298082659538200],
         [100.297997088376,   0.298900934094470],
         [100.537371758527,   0.299719208650739],
         [100.776746428678,   0.300537483207008],
         [101.016121196877,   0.301355757763277],
         [101.255495867029,   0.302174032242623],
         [101.494870537180,   0.302992306798892],
         [101.734245207331,   0.303810581355162],
         [101.973619975530,   0.304628855911431],
         [102.212994645681,   0.305447130467700],
         [102.452369315832,   0.306265405023969],
         [102.691743985984,   0.307083679503315],
         [102.931118754183,   0.307901954059584],
         [103.170493424334,   0.308720228615854],
         [103.409868094485,   0.309538503172123],
         [103.649242764636,   0.310356777728392],
         [103.888617532835,   0.311175052207738],
         [104.127992202986,   0.311993326764007],
         [104.367366873138,   0.312811601320276],
         [104.606741543289,   0.313629875876546],
         [104.846116311488,   0.314448150432815],
         [105.085490981639,   0.315266424912161],
         [105.324865651790,   0.316084699468430],
         [105.564240321941,   0.316902974024699],
         [105.803615090141,   0.317721248580968],
         [106.042989760292,   0.318539523137238],
         [106.282364430443,   0.319357797616584],
         [106.521739100594,   0.320176072172853],
         [106.761113868793,   0.320994346729122],
         [107.000488538944,   0.321812621285391],
         [107.239863209096,   0.322630895841661],
         [107.479237879247,   0.323449170321006],
         [107.718612647446,   0.324267444877276],
         [107.957987317597,   0.325085719433545],
         [108.197361987748,   0.325903993989814],
         [108.436736657899,   0.326722268546083],
         [108.676111426098,   0.327540543025429],
         [108.915486096250,   0.328358817581699],
         [109.154860766401,   0.329177092137968],
         [109.394235436552,   0.329995366694237],
         [109.633610204751,   0.330813641250506],
         [109.872984874902,   0.331631915729852],
         [110.112359545053,   0.332450190286121],
         [110.351734215205,   0.333268464842391],
         [110.591108983404,   0.334086739398660],
         [110.830483653555,   0.334905013954929],
         [111.069858323706,   0.335723288434275],
         [111.309232993857,   0.336541562990544],
         [111.548607762056,   0.337359837546813],
         [111.787982432208,   0.338178112103083],
         [112.027357102359,   0.338996386659352],
         [112.266731772510,   0.339814661138698],
         [112.506106540709,   0.340632935694967],
         [112.745481210860,   0.341451210251236],
         [112.984855881011,   0.342269484807505],
         [113.224230551163,   0.343087759363775],
         [113.463605319362,   0.343906033843121],
         [113.702979989513,   0.344724308399390],
         [113.942354659664,   0.345542582955659],
         [114.181729329815,   0.346360857511928],
         [114.421104098014,   0.347179132068197],
         [114.660478768166,   0.347997406547543],
         [114.899853438317,   0.348815681103813],
         [115.139228108468,   0.349633955660082],
         [115.378602876667,   0.350452230216351],
         [115.617977546818,   0.351270504772620],
         [115.857352216969,   0.352088779328889],
         [116.096726887121,   0.352907053808235],
         [116.336101655320,   0.353725328364505],
         [116.575476325471,   0.354543602920774],
         [116.814850995622,   0.355361877477043],
         [117.054225665773,   0.356180152033312],
         [117.293600433972,   0.356998426512658],
         [117.532975104123,   0.357816701068927],
         [117.772349774275,   0.358634975625197],
         [118.011724444426,   0.359453250181466],
         [118.251099212625,   0.360271524737735],
         [118.490473882776,   0.361089799217081],
         [118.729848552927,   0.361908073773350],
         [118.969223223078,   0.362726348329619],
         [119.208597991277,   0.363544622885889],
         [119.447972661429,   0.364362897442158],
         [119.687347331580,   0.365181171921504],
         [119.926722001731,   0.365999446477773],
         [120.166096769930,   0.366817721034042],
         [120.405471440081,   0.367635995590311],
         [120.644846110233,   0.368454270146581],
         [120.884220780384,   0.369272544625927],
         [121.123595548583,   0.370090819182196],
         [121.362970218734,   0.370909093738465],
         [121.602344888885,   0.371727368294734],
         [121.841719559036,   0.372545642851003],
         [122.081094327235,   0.373363917330350],
         [122.320468997387,   0.374182191886619],
         [122.559843667538,   0.375000466442888],
         [122.799218337689,   0.375818740999157],
         [123.038593105888,   0.376637015555426],
         [123.277967776039,   0.377455290034772],
         [123.517342446190,   0.378273564591042],
         [123.756717116342,   0.379091839147311],
         [123.996091884541,   0.379910113703580],
         [124.235466554692,   0.380728388259849],
         [124.474841224843,   0.381546662739195],
         [124.714215894994,   0.382364937295464],
         [124.953590663193,   0.383183211851734],
         [125.192965333345,   0.384001486408003],
         [125.432340003496,   0.384819760964272],
         [125.671714673647,   0.385638035443618],
         [125.911089441846,   0.386456309999887],
         [126.150464111997,   0.387274584556156],
         [126.389838782148,   0.388092859112426],
         [126.629213452300,   0.388911133668695],
         [126.868588220499,   0.389729408148041],
         [127.107962890650,   0.390547682704310],
         [127.347337560801,   0.391365957260579],
         [127.586712230952,   0.392184231816848],
         [127.826086999151,   0.393002506373118],
         [128.065461669302,   0.393820780852464],
         [128.304836339454,   0.394639055408733],
         [128.544211009605,   0.395457329965002],
         [128.783585777804,   0.396275604521271],
         [129.022960447955,   0.397093879077540],
         [129.262335118106,   0.397912153633810],
         [129.501709788257,   0.398730428113156],
         [129.741084556457,   0.399548702669425],
         [129.980459226608,   0.400366977225694],
         [130.219833896759,   0.401185251781963],
         [130.459208566910,   0.402003526338232],
         [130.698583335109,   0.402821800817578],
         [130.937958005260,   0.403640075373848],
         [131.177332675412,   0.404458349930117],
         [131.416707345563,   0.405276624486386],
         [131.656082113762,   0.406094899042655],
         [131.895456783913,   0.406913173522001],
         [132.134831454064,   0.407731448078270],
         [132.374206124215,   0.408549722634540],
         [132.613580892414,   0.409367997190809],
         [132.852955562566,   0.410186271747078],
         [133.092330232717,   0.411004546226424],
         [133.331704902868,   0.411822820782693],
         [133.571079671067,   0.412641095338963],
         [133.810454341218,   0.413459369895232],
         [134.049829011369,   0.414277644451501],
         [134.289203681521,   0.415095918930847],
         [134.528578449720,   0.415914193487116],
         [134.767953119871,   0.416732468043385],
         [135.007327790022,   0.417550742599654],
         [135.246702460173,   0.418369017155924],
         [135.486077228372,   0.419187291635270],
         [135.725451898524,   0.420005566191539],
         [135.964826568675,   0.420823840747808],
         [136.204201238826,   0.421642115304077],
         [136.443576007025,   0.422460389860347],
         [136.682950677176,   0.423278664339693],
         [136.922325347327,   0.424096938895962],
         [137.161700017479,   0.424915213452231],
         [137.401074785678,   0.425733488008500],
         [137.640449455829,   0.426551762564769],
         [137.879824125980,   0.427370037044115],
         [138.119198796131,   0.428188311600385],
         [138.358573564330,   0.429006586156654],
         [138.597948234481,   0.429824860712923],
         [138.837322904633,   0.430643135269192],
         [139.076697574784,   0.431461409748538],
         [139.316072342983,   0.432279684304807],
         [139.555447013134,   0.433097958861077],
         [139.794821683285,   0.433916233417346],
         [140.034196353437,   0.434734507973615],
         [140.273571121636,   0.435552782452961],
         [140.512945791787,   0.436371057009230],
         [140.752320461938,   0.437189331565499],
         [140.991695132089,   0.438007606121769],
         [141.231069900288,   0.438825880678038],
         [141.470444570439,   0.439644155157384],
         [141.709819240591,   0.440462429713653],
         [141.949193910742,   0.441280704269922],
         [142.188568678941,   0.442098978826191],
         [142.427943349092,   0.442917253382461],
         [142.667318019243,   0.443735527938730],
         [142.906692689394,   0.444553802418076],
         [143.146067457594,   0.445372076974345],
         [143.385442127745,   0.446190351530614],
         [143.624816797896,   0.447008626086883],
         [143.864191468047,   0.447826900643153],
         [144.103566236246,   0.448645175122499],
         [144.342940906397,   0.449463449678768],
         [144.582315576548,   0.450281724235037],
         [144.821690246700,   0.451099998791306],
         [145.061065014899,   0.451918273347575],
         [145.300439685050,   0.452736547826921],
         [145.539814355201,   0.453554822383191],
         [145.779189025352,   0.454373096939460],
         [146.018563793551,   0.455191371495729],
         [146.257938463703,   0.456009646051998],
         [146.497313133854,   0.456827920531344],
         [146.736687804005,   0.457646195087613],
         [146.976062572204,   0.458464469643883],
         [147.215437242355,   0.459282744200152],
         [147.454811912506,   0.460101018756421],
         [147.694186582658,   0.460919293235767],
         [147.933561350857,   0.461737567792036],
         [148.172936021008,   0.462555842348305],
         [148.412310691159,   0.463374116904575],
         [148.651685361310,   0.464192391460844],
         [148.891060129509,   0.465010665940190],
         [149.130434799661,   0.465828940496459],
         [149.369809469812,   0.466647215052728],
         [149.609184139963,   0.467465489608998],
         [149.848558908162,   0.468283764165267],
         [150.087933578313,   0.469102038644613],
         [150.327308248464,   0.469920313200882],
         [150.566682918616,   0.470738587757151],
         [150.806057686815,   0.471556862313420],
         [151.045432356966,   0.472375136869690],
         [151.284807027117,   0.473193411349036],
         [151.524181697268,   0.474011685905305],
         [151.763556465467,   0.474829960461574],
         [152.002931135618,   0.475648235017843],
         [152.242305805770,   0.476466509574112],
         [152.481680475921,   0.477284784053458],
         [152.721055244120,   0.478103058609728],
         [152.960429914271,   0.478921333165997],
         [153.199804584422,   0.479739607722266],
         [153.439179254573,   0.480557882278535],
         [153.678554022773,   0.481376156757881],
         [153.917928692924,   0.482194431314150],
         [154.157303363075,   0.483012705870420],
         [154.396678033226,   0.483830980426689],
         [154.636052801425,   0.484649254982958],
         [154.875427471576,   0.485467529462304],
         [155.114802141728,   0.486285804018573],
         [155.354176811879,   0.487104078574842],
         [155.593551580078,   0.487922353131112],
         [155.832926250229,   0.488740627687381],
         [156.072300920380,   0.489558902243650],
         [156.311675590531,   0.490377176722996],
         [156.551050358730,   0.491195451279265],
         [156.790425028882,   0.492013725835534],
         [157.029799699033,   0.492832000391804],
         [157.269174369184,   0.493650274948073],
         [157.508549137383,   0.494468549427419],
         [157.747923807534,   0.495286823983688],
         [157.987298477685,   0.496105098539957],
         [158.226673147837,   0.496923373096227],
         [158.466047916036,   0.497741647652496],
         [158.705422586187,   0.498559922131842],
         [158.944797256338,   0.499378196688111],
         [159.184171926489,   0.500196471244380],
         [159.423546694688,   0.501014745800649],
         [159.662921364840,   0.501833020356919],
         [159.902296034991,   0.502651294836265],
         [160.141670705142,   0.503469569392534],
         [160.381045473341,   0.504287843948803],
         [160.620420143492,   0.505106118505072],
         [160.859794813643,   0.505924393061341],
         [161.099169483795,   0.506742667540687],
         [161.338544251994,   0.507560942096957],
         [161.577918922145,   0.508379216653226],
         [161.817293592296,   0.509197491209495],
         [162.056668262447,   0.510015765765764],
         [162.296043030646,   0.510834040245110],
         [162.535417700797,   0.511652314801379],
         [162.774792370949,   0.512470589357648],
         [163.014167041100,   0.513288863913918],
         [163.253541809299,   0.514107138470187],
         [163.492916479450,   0.514925412949533],
         [163.732291149601,   0.515743687505802],
         [163.971665819752,   0.516561962062071],
         [164.211040587952,   0.517380236618341],
         [164.450415258103,   0.518198511174610],
         [164.689789928254,   0.519016785653956],
         [164.929164598405,   0.519835060210225],
         [165.168539366604,   0.520653334766494],
         [165.407914036755,   0.521471609322763],
         [165.647288706907,   0.522289883879033],
         [165.886663377058,   0.523108158358379],
         [166.126038145257,   0.523926432914648],
         [166.365412815408,   0.524744707470917],
         [166.604787485559,   0.525562982027186],
         [166.844162155710,   0.526381256583455],
         [167.083536923909,   0.527199531062801],
         [167.322911594061,   0.528017805619071],
         [167.562286264212,   0.528836080175340],
         [167.801660934363,   0.529654354731609],
         [168.041035702562,   0.530472629287878],
         [168.280410372713,   0.531290903767224],
         [168.519785042864,   0.532109178323493],
         [168.759159713016,   0.532927452879763],
         [168.998534481215,   0.533745727436032],
         [169.237909151366,   0.534564001992301],
         [169.477283821517,   0.535382276548570],
         [169.716658491668,   0.536200551027916],
         [169.956033259867,   0.537018825584186],
         [170.195407930019,   0.537837100140455],
         [170.434782600170,   0.538655374696724],
         [170.674157270321,   0.539473649252993],
         [170.913532038520,   0.540291923732339],
         [171.152906708671,   0.541110198288608],
         [171.392281378822,   0.541928472844877],
         [171.631656048974,   0.542746747401147],
         [171.871030817173,   0.543565021957416],
         [172.110405487324,   0.544383296436762],
         [172.349780157475,   0.545201570993031],
         [172.589154827626,   0.546019845549300],
         [172.828529595825,   0.546838120105569],
         [173.067904265976,   0.547656394661839],
         [173.307278936128,   0.548474669141185],
         [173.546653606279,   0.549292943697454],
         [173.786028374478,   0.550111218253723],
         [174.025403044629,   0.550929492809992],
         [174.264777714780,   0.551747767366261],
         [174.504152384932,   0.552566041845607],
         [174.743527153131,   0.553384316401877],
         [174.982901823282,   0.554202590958146],
         [175.222276493433,   0.555020865514415],
         [175.461651163584,   0.555839140070684],
         [175.701025931783,   0.556657414550030],
         [175.940400601934,   0.557475689106299],
         [176.179775272086,   0.558293963662569],
         [176.419149942237,   0.559112238218838],
         [176.658524710436,   0.559930512775107],
         [176.897899380587,   0.560748787254453],
         [177.137274050738,   0.561567061810722],
         [177.376648720889,   0.562385336366992],
         [177.616023489089,   0.563203610923261],
         [177.855398159240,   0.564021885479530],
         [178.094772829391,   0.564840159958876],
         [178.334147499542,   0.565658434515145],
         [178.573522267741,   0.566476709071414],
         [178.812896937892,   0.567294983627684],
         [179.052271608044,   0.568113258183953],
         [179.291646278195,   0.568931532663299],
         [179.531021046394,   0.569749807219568],
         [179.770395716545,   0.570568081775837],
         [180.009770386696,   0.571386356332106],
         [180.249145056847,   0.572204630888376],
         [180.488519825046,   0.573022905367722],
         [180.727894495198,   0.573841179923991],
         [180.967269165349,   0.574659454480260],
         [181.206643835500,   0.575477729036529],
         [181.446018603699,   0.576296003592798],
         [181.685393273850,   0.577114278072144],
         [181.924767944001,   0.577932552628414],
         [182.164142614153,   0.578750827184683],
         [182.403517382352,   0.579569101740952],
         [182.642892052503,   0.580387376297221],
         [182.882266722654,   0.581205650853490],
         [183.121641392805,   0.582023925332836],
         [183.361016161004,   0.582842199889106],
         [183.600390831156,   0.583660474445375],
         [183.839765501307,   0.584478749001644],
         [184.079140171458,   0.585297023557913],
         [184.318514939657,   0.586115298037259],
         [184.557889609808,   0.586933572593528],
         [184.797264279959,   0.587751847149798],
         [185.036638950111,   0.588570121706067],
         [185.276013718310,   0.589388396262336],
         [185.515388388461,   0.590206670741682],
         [185.754763058612,   0.591024945297951],
         [185.994137728763,   0.591843219854220],
         [186.233512496962,   0.592661494410490],
         [186.472887167113,   0.593479768966759],
         [186.712261837265,   0.594298043446105],
         [186.951636507416,   0.595116318002374],
         [187.191011275615,   0.595934592558643],
         [187.430385945766,   0.596752867114912],
         [187.669760615917,   0.597571141671182],
         [187.909135286068,   0.598389416150528],
         [188.148510054268,   0.599207690706797],
         [188.387884724419,   0.600025965263066],
         [188.627259394570,   0.600844239819335],
         [188.866634064721,   0.601662514375605],
         [189.106008832920,   0.602480788854951],
         [189.345383503071,   0.603299063411220],
         [189.584758173223,   0.604117337967489],
         [189.824132843374,   0.604935612523758],
         [190.063507611573,   0.605753887080027],
         [190.302882281724,   0.606572161559373],
         [190.542256951875,   0.607390436115643],
         [190.781631622026,   0.608208710671912],
         [191.021006390225,   0.609026985228181],
         [191.260381060377,   0.609845259784450],
         [191.499755730528,   0.610663534263796],
         [191.739130400679,   0.611481808820065],
         [191.978505168878,   0.612300083376335],
         [192.217879839029,   0.613118357932604],
         [192.457254509180,   0.613936632488873],
         [192.696629179332,   0.614754906968219],
         [192.936003947531,   0.615573181524488],
         [193.175378617682,   0.616391456080757],
         [193.414753287833,   0.617209730637027],
         [193.654127957984,   0.618028005193296],
         [193.893502726183,   0.618846279672642],
         [194.132877396335,   0.619664554228911],
         [194.372252066486,   0.620482828785180],
         [194.611626736637,   0.621301103341449],
         [194.851001504836,   0.622119377897719],
         [195.090376174987,   0.622937652377065],
         [195.329750845138,   0.623755926933334],
         [195.569125515290,   0.624574201489603],
         [195.808500283489,   0.625392476045872],
         [196.047874953640,   0.626210750602141],
         [196.287249623791,   0.627029025158411],
         [196.526624293942,   0.627847299637757],
         [196.765999062141,   0.628665574194026],
         [197.005373732292,   0.629483848750295],
         [197.244748402444,   0.630302123306564],
         [197.484123072595,   0.631120397862833],
         [197.723497840794,   0.631938672342179],
         [197.962872510945,   0.632756946898449],
         [198.202247181096,   0.633575221454718],
         [198.441621851247,   0.634393496010987],
         [198.680996619447,   0.635211770567256],
         [198.920371289598,   0.636030045046602],
         [199.159745959749,   0.636848319602871],
         [199.399120629900,   0.637666594159141],
         [199.638495398099,   0.638484868715410],
         [199.877870068250,   0.639303143271679],
         [200.117244738402,   0.640121417751025],
         [200.356619408553,   0.640939692307294],
         [200.595994176752,   0.641757966863563],
         [200.835368846903,   0.642576241419833],
         [201.074743517054,   0.643394515976102],
         [201.314118187205,   0.644212790455448],
         [201.553492955404,   0.645031065011717],
         [201.792867625556,   0.645849339567986],
         [202.032242295707,   0.646667614124255],
         [202.271616965858,   0.647485888680525],
         [202.510991734057,   0.648304163159871],
         [202.750366404208,   0.649122437716140],
         [202.989741074359,   0.649940712272409],
         [203.229115744511,   0.650758986828678],
         [203.468490512710,   0.651577261384947],
         [203.707865182861,   0.652395535864294],
         [203.947239853012,   0.653213810420563],
         [204.186614523163,   0.654032084976832],
         [204.425989291362,   0.654850359533101],
         [204.665363961514,   0.655668634089370],
         [204.904738631665,   0.656486908568716],
         [205.144113301816,   0.657305183124986],
         [205.383488070015,   0.658123457681255],
         [205.622862740166,   0.658941732237524],
         [205.862237410317,   0.659760006793793],
         [206.101612080469,   0.660578281273139],
         [206.340986848668,   0.661396555829408],
         [206.580361518819,   0.662214830385678],
         [206.819736188970,   0.663033104941947],
         [207.059110859121,   0.663851379498216],
         [207.298485627320,   0.664669653977562],
         [207.537860297471,   0.665487928533831],
         [207.777234967623,   0.666306203090100],
         [208.016609637774,   0.667124477646370],
         [208.255984405973,   0.667942752202639],
         [208.495359076124,   0.668761026681985],
         [208.734733746275,   0.669579301238254],
         [208.974108416427,   0.670397575794523],
         [209.213483184626,   0.671215850350792],
         [209.452857854777,   0.672034124907062],
         [209.692232524928,   0.672852399463331],
         [209.931607195079,   0.673670673942677],
         [210.170981963278,   0.674488948498946],
         [210.410356633429,   0.675307223055215],
         [210.649731303581,   0.676125497611484],
         [210.889105973732,   0.676943772167754],
         [211.128480741931,   0.677762046647100],
         [211.367855412082,   0.678580321203369],
         [211.607230082233,   0.679398595759638],
         [211.846604752384,   0.680216870315907],
         [212.085979520583,   0.681035144872176],
         [212.325354190735,   0.681853419351522],
         [212.564728860886,   0.682671693907792],
         [212.804103531037,   0.683489968464061],
         [213.043478299236,   0.684308243020330],
         [213.282852969387,   0.685126517576599],
         [213.522227639539,   0.685944792055945],
         [213.761602309690,   0.686763066612214],
         [214.000977077889,   0.687581341168484],
         [214.240351748040,   0.688399615724753],
         [214.479726418191,   0.689217890281022],
         [214.719101088342,   0.690036164760368],
         [214.958475856541,   0.690854439316637],
         [215.197850526693,   0.691672713872907],
         [215.437225196844,   0.692490988429176],
         [215.676599866995,   0.693309262985445],
         [215.915974635194,   0.694127537464791],
         [216.155349305345,   0.694945812021060],
         [216.394723975496,   0.695764086577329],
         [216.634098645648,   0.696582361133599],
         [216.873473413847,   0.697400635689868],
         [217.112848083998,   0.698218910169214],
         [217.352222754149,   0.699037184725483],
         [217.591597424300,   0.699855459281752],
         [217.830972192499,   0.700673733838021],
         [218.070346862651,   0.701492008394291],
         [218.309721532802,   0.702310282873637],
         [218.549096202953,   0.703128557429906],
         [218.788470971152,   0.703946831986175],
         [219.027845641303,   0.704765106542444],
         [219.267220311454,   0.705583381098713],
         [219.506594981606,   0.706401655578059],
         [219.745969749805,   0.707219930134329],
         [219.985344419956,   0.708038204690598],
         [220.224719090107,   0.708856479246867],
         [220.464093760258,   0.709674753803136],
         [220.703468528457,   0.710493028282482],
         [220.942843198608,   0.711311302838751],
         [221.182217868760,   0.712129577395021],
         [221.421592538911,   0.712947851951290],
         [221.660967307110,   0.713766126507559],
         [221.900341977261,   0.714584400986905],
         [222.139716647412,   0.715402675543174],
         [222.379091317563,   0.716220950099443],
         [222.618466085763,   0.717039224655713],
         [222.857840755914,   0.717857499211982],
         [223.097215426065,   0.718675773768251],
         [223.336590096216,   0.719494048247597],
         [223.575964864415,   0.720312322803866],
         [223.815339534566,   0.721130597360135],
         [224.054714204718,   0.721948871916405],
         [224.294088874869,   0.722767146472674],
         [224.533463643068,   0.723585420952020],
         [224.772838313219,   0.724403695508289],
         [225.012212983370,   0.725221970064558],
         [225.251587653521,   0.726040244620827],
         [225.490962421720,   0.726858519177097],
         [225.730337091872,   0.727676793656443],
         [225.969711762023,   0.728495068212712],
         [226.209086432174,   0.729313342768981],
         [226.448461200373,   0.730131617325250],
         [226.687835870524,   0.730949891881520],
         [226.927210540675,   0.731768166360865],
         [227.166585210827,   0.732586440917135],
         [227.405959979026,   0.733404715473404],
         [227.645334649177,   0.734222990029673],
         [227.884709319328,   0.735041264585942],
         [228.124083989479,   0.735859539065288],
         [228.363458757678,   0.736677813621558],
         [228.602833427830,   0.737496088177827],
         [228.842208097981,   0.738314362734096],
         [229.081582768132,   0.739132637290365],
         [229.320957536331,   0.739950911769711],
         [229.560332206482,   0.740769186325980],
         [229.799706876633,   0.741587460882250],
         [230.039081546785,   0.742405735438519],
         [230.278456314984,   0.743224009994788],
         [230.517830985135,   0.744042284474134],
         [230.757205655286,   0.744860559030403],
         [230.996580325437,   0.745678833586672],
         [231.235955093636,   0.746497108142942],
         [231.475329763787,   0.747315382699211],
         [231.714704433939,   0.748133657178557],
         [231.954079104090,   0.748951931734826],
         [232.193453872289,   0.749770206291095],
         [232.432828542440,   0.750588480847364],
         [232.672203212591,   0.751406755403633],
         [232.911577882742,   0.752225029882980],
         [233.150952650942,   0.753043304439249],
         [233.390327321093,   0.753861578995518],
         [233.629701991244,   0.754679853551787],
         [233.869076661395,   0.755498128108056],
         [234.108451429594,   0.756316402587402],
         [234.347826099745,   0.757134677143671],
         [234.587200769897,   0.757952951699941],
         [234.826575440048,   0.758771226256210],
         [235.065950208247,   0.759589500812479],
         [235.305324878398,   0.760407775291825],
         [235.544699548549,   0.761226049848094],
         [235.784074218700,   0.762044324404364],
         [236.023448986899,   0.762862598960633],
         [236.262823657051,   0.763680873516902],
         [236.502198327202,   0.764499148073171],
         [236.741572997353,   0.765317422552517],
         [236.980947765552,   0.766135697108786],
         [237.220322435703,   0.766953971665056],
         [237.459697105854,   0.767772246221325],
         [237.699071776006,   0.768590520777594],
         [237.938446544205,   0.769408795487710],
         [238.177821214356,   0.770227069582440],
         [238.417195884507,   0.771045344446402],
         [238.656570554658,   0.771863618541132],
         [238.895945322857,   0.772681893405094],
         [239.135319993009,   0.773500168269055],
         [239.374694663160,   0.774318442363786],
         [239.614069333311,   0.775136717227748],
         [239.853444101510,   0.775954991322478],
         [240.092818771661,   0.776773266186440],
         [240.332193441812,   0.777591541050402],
         [240.571568111964,   0.778409815145132],
         [240.810942880163,   0.779228090009094],
         [241.050317550314,   0.780046364103824],
         [241.289692220465,   0.780864638967786],
         [241.529066890616,   0.781682913062516],
         [241.768441658815,   0.782501187926478],
         [242.007816328966,   0.783319462790440],
         [242.247190999118,   0.784137736885170],
         [242.486565669269,   0.784956011749132],
         [242.725940437468,   0.785774285843862],
         [242.965315107619,   0.786592560707824],
         [243.204689777770,   0.787410835571786],
         [243.444064447922,   0.788229109666516],
         [243.683439216121,   0.789047384530478],
         [243.922813886272,   0.789865658625208],
         [244.162188556423,   0.790683933489170],
         [244.401563226574,   0.791502207583900],
         [244.640937994773,   0.792320482447862],
         [244.880312664924,   0.793138757311824],
         [245.119687335076,   0.793957031406554],
         [245.359062005227,   0.794775306270516],
         [245.598436773426,   0.795593580365246],
         [245.837811443577,   0.796411855229208],
         [246.077186113728,   0.797230129323938],
         [246.316560783879,   0.798048404187900],
         [246.555935552079,   0.798866679051862],
         [246.795310222230,   0.799684953146592],
         [247.034684892381,   0.800503228010554],
         [247.274059562532,   0.801321502105284],
         [247.513434330731,   0.802139776969246],
         [247.752809000882,   0.802958051833208],
         [247.992183671033,   0.803776325927938],
         [248.231558341185,   0.804594600791900],
         [248.470933109384,   0.805412874886630],
         [248.710307779535,   0.806231149750592],
         [248.949682449686,   0.807049423845322],
         [249.189057119837,   0.807867698709284],
         [249.428431888036,   0.808685973573246],
         [249.667806558188,   0.809504247667976],
         [249.907181228339,   0.810322522531938],
         [250.146555898490,   0.811140796626668],
         [250.385930666689,   0.811959071490630],
         [250.625305336840,   0.812777345585360],
         [250.864680006991,   0.813595620449322],
         [251.104054677143,   0.814413895313284],
         [251.343429445342,   0.815232169408014],
         [251.582804115493,   0.816050444271976],
         [251.822178785644,   0.816868718366706],
         [252.061553455795,   0.817686993230668],
         [252.300928223994,   0.818505268094630],
         [252.540302894146,   0.819323542189360],
         [252.779677564297,   0.820141817053322],
         [253.019052234448,   0.820960091148052],
         [253.258427002647,   0.821778366012014],
         [253.497801672798,   0.822596640106744],
         [253.737176342949,   0.823414914970706],
         [253.976551013100,   0.824233189834668],
         [254.215925781300,   0.825051463929398],
         [254.455300451451,   0.825869738793360],
         [254.694675121602,   0.826688012888090],
         [254.934049791753,   0.827506287752052],
         [255.173424559952,   0.828324562616014],
         [255.412799230103,   0.829142836710744],
         [255.652173900255,   0.829961111574706],
         [255.891548570406,   0.830779385669436],
         [256.130923338605,   0.831597660533398],
         [256.370298008756,   0.832415934628128],
         [256.609672678907,   0.833234209492090],
         [256.849047349058,   0.834052484356052],
         [257.088422117258,   0.834870758450782],
         [257.327796787409,   0.835689033314744],
         [257.567171457560,   0.836507307409474],
         [257.806546127711,   0.837325582273436],
         [258.045920895910,   0.838143856368166],
         [258.285295566061,   0.838962131232128],
         [258.524670236213,   0.839780406096090],
         [258.764044906364,   0.840598680190820],
         [259.003419674563,   0.841416955054782],
         [259.242794344714,   0.842235229149512],
         [259.482169014865,   0.843053504013474],
         [259.721543685016,   0.843871778877436],
         [259.960918453215,   0.844690052972166],
         [260.200293123367,   0.845508327836128],
         [260.439667793518,   0.846326601930858],
         [260.679042463669,   0.847144876794820],
         [260.918417231868,   0.847963150889550],
         [261.157791902019,   0.848781425753512],
         [261.397166572171,   0.849599700617474],
         [261.636541242322,   0.850417974712204],
         [261.875916010521,   0.851236249576166],
         [262.115290680672,   0.852054523670896],
         [262.354665350823,   0.852872798534858],
         [262.594040020974,   0.853691073398820],
         [262.833414789173,   0.854509347493550],
         [263.072789459325,   0.855327622357512],
         [263.312164129476,   0.856145896452242],
         [263.551538799627,   0.856964171316204],
         [263.790913567826,   0.857782445410934],
         [264.030288237977,   0.858600720274896],
         [264.269662908128,   0.859418995138858],
         [264.509037578280,   0.860237269233588],
         [264.748412346479,   0.861055544097550],
         [264.987787016630,   0.861873818192280],
         [265.227161686781,   0.862692093056242],
         [265.466536356932,   0.863510367150972],
         [265.705911125131,   0.864328642014934],
         [265.945285795283,   0.865146916878896],
         [266.184660465434,   0.865965190973626],
         [266.424035135585,   0.866783465837588],
         [266.663409903784,   0.867601739932318],
         [266.902784573935,   0.868420014796280],
         [267.142159244086,   0.869238289660242],
         [267.381533914238,   0.870056563754972],
         [267.620908682437,   0.870874838618934],
         [267.860283352588,   0.871693112713664],
         [268.099658022739,   0.872511387577626],
         [268.339032692890,   0.873329661672356],
         [268.578407461089,   0.874147936536318],
         [268.817782131240,   0.874966211400280],
         [269.057156801392,   0.875784485495010],
         [269.296531471543,   0.876602760358972],
         [269.535906239742,   0.877421034453702],
         [269.775280909893,   0.878239309317664],
         [270.014655580044,   0.879057584181626],
         [270.254030250195,   0.879875858276356],
         [270.493405018394,   0.880694133140318],
         [270.732779688546,   0.881512407235048],
         [270.972154358697,   0.882330682099010],
         [271.211529028848,   0.883148956193740],
         [271.450903797047,   0.883967231057702],
         [271.690278467198,   0.884785505921664],
         [271.929653137350,   0.885603780016394],
         [272.169027807501,   0.886422054880356],
         [272.408402575700,   0.887240328975086],
         [272.647777245851,   0.888058603839048],
         [272.887151916002,   0.888876877933778],
         [273.126526586153,   0.889695152797740],
         [273.365901354352,   0.890513427661702],
         [273.605276024504,   0.891331701756432],
         [273.844650694655,   0.892149976620394],
         [274.084025364806,   0.892968250715124],
         [274.323400133005,   0.893786525579086],
         [274.562774803156,   0.894604800443048],
         [274.802149473307,   0.895423074537778],
         [275.041524143459,   0.896241349401740],
         [275.280898911658,   0.897059623496470],
         [275.520273581809,   0.897877898360432],
         [275.759648251960,   0.898696172455162],
         [275.999022922111,   0.899514447319124],
         [276.238397690310,   0.900332722183086],
         [276.477772360462,   0.901150996277816],
         [276.717147030613,   0.901969271141778],
         [276.956521700764,   0.902787545236508],
         [277.195896468963,   0.903605820100470],
         [277.435271139114,   0.904424094195200],
         [277.674645809265,   0.905242369059162],
         [277.914020479417,   0.906060643923124],
         [278.153395247616,   0.906878918017854],
         [278.392769917767,   0.907697192881816],
         [278.632144587918,   0.908515466976546],
         [278.871519258069,   0.909333741840508],
         [279.110894026268,   0.910152016704470],
         [279.350268696419,   0.910970290799200],
         [279.589643366571,   0.911788565663162],
         [279.829018036722,   0.912606839757892],
         [280.068392804921,   0.913425114621854],
         [280.307767475072,   0.914243388716584],
         [280.547142145223,   0.915061663580546],
         [280.786516815374,   0.915879938444508],
         [281.025891583573,   0.916698212539238],
         [281.265266253725,   0.917516487403200],
         [281.504640923876,   0.918334761497930],
         [281.744015594027,   0.919153036361892],
         [281.983390362226,   0.919971311225854],
         [282.222765032377,   0.920789585320584],
         [282.462139702529,   0.921607860184546],
         [282.701514372680,   0.922426134279276],
         [282.940889140879,   0.923244409143238],
         [283.180263811030,   0.924062683237968],
         [283.419638481181,   0.924880958101930],
         [283.659013151332,   0.925699232965892],
         [283.898387919531,   0.926517507060622],
         [284.137762589683,   0.927335781924584],
         [284.377137259834,   0.928154056019314],
         [284.616511929985,   0.928972330883276],
         [284.855886698184,   0.929790604978006],
         [285.095261368335,   0.930608879841968],
         [285.334636038486,   0.931427154705930],
         [285.574010708638,   0.932245428800660],
         [285.813385476837,   0.933063703664622],
         [286.052760146988,   0.933881977759352],
         [286.292134817139,   0.934700252623314],
         [286.531509487290,   0.935518527487276],
         [286.770884255489,   0.936336801582006],
         [287.010258925641,   0.937155076445968],
         [287.249633595792,   0.937973350540698],
         [287.489008265943,   0.938791625404660],
         [287.728383034142,   0.939609899499390],
         [287.967757704293,   0.940428174363352],
         [288.207132374444,   0.941246449227314],
         [288.446507044596,   0.942064723322044],
         [288.685881812795,   0.942882998186006],
         [288.925256482946,   0.943701272280736],
         [289.164631153097,   0.944519547144698],
         [289.404005823248,   0.945337822008660],
         [289.643380591447,   0.946156096103390],
         [289.882755261598,   0.946974370967352],
         [290.122129931750,   0.947792645062082],
         [290.361504601901,   0.948610919926044],
         [290.600879370100,   0.949429194020774],
         [290.840254040251,   0.950247468884736],
         [291.079628710402,   0.951065743748698],
         [291.319003380553,   0.951884017843428],
         [291.558378148752,   0.952702292707390],
         [291.797752818904,   0.953520566802121],
         [292.037127489055,   0.954338841666082],
         [292.276502159206,   0.955157115760812],
         [292.515876927405,   0.955975390624774],
         [292.755251597556,   0.956793665488736],
         [292.994626267708,   0.957611939583466],
         [293.234000937859,   0.958430214447428],
         [293.473375706058,   0.959248488542159],
         [293.712750376209,   0.960066763406120],
         [293.952125046360,   0.960885038270082],
         [294.191499716511,   0.961703200826212],
         [294.430874484710,   0.962517547223749],
         [294.670249154862,   0.963326196691123],
         [294.909623825013,   0.964129040766661],
         [295.148998495164,   0.964925972527152],
         [295.388373263363,   0.965716883510924],
         [295.627747933514,   0.966501665256302],
         [295.867122603665,   0.967280210840078],
         [296.106497273817,   0.968052411031345],
         [296.345872042016,   0.968818158906895],
         [296.585246712167,   0.969577346774284],
         [296.824621382318,   0.970329865402610],
         [297.063996052469,   0.971075608637892],
         [297.303370820668,   0.971814466479994],
         [297.542745490820,   0.972546332774939],
         [297.782120160971,   0.973271098291820],
         [298.021494831122,   0.973988656107429],
         [298.260869599321,   0.974698897760091],
         [298.500244269472,   0.975401714788133],
         [298.739618939623,   0.976097000268346],
         [298.978993609775,   0.976784646508287],
         [299.218368377974,   0.977464543507821],
         [299.457743048125,   0.978136585882200],
         [299.697117718276,   0.978800663631287],
         [299.936492388427,   0.979456670601105],
         [300.175867156626,   0.980104496791517],
         [300.415241826778,   0.980744036817775],
         [300.654616496929,   0.981375179910512],
         [300.893991167080,   0.981997820684982],
         [301.133365935279,   0.982611849141046],
         [301.372740605430,   0.983217159124728],
         [301.612115275581,   0.983813641405122],
         [301.851489945732,   0.984401188289786],
         [302.090864713932,   0.984979692855511],
         [302.330239384083,   0.985549045102159],
         [302.569614054234,   0.986109139644984],
         [302.808988724385,   0.986659866483849],
         [303.048363492584,   0.987201117926314],
         [303.287738162735,   0.987732787049167],
         [303.527112832887,   0.988254765390735],
         [303.766487503038,   0.988766945258577],
         [304.005862271237,   0.989269218191020],
         [304.245236941388,   0.989761476495621],
         [304.484611611539,   0.990243612479940],
         [304.723986281690,   0.990715517682302],
         [304.963361049889,   0.991177084410266],
         [305.202735720041,   0.991628204971391],
         [305.442110390192,   0.992068771673234],
         [305.681485060343,   0.992498675284891],
         [305.920859828542,   0.992917808883152],
         [306.160234498693,   0.993326064775575],
         [306.399609168845,   0.993723334500486],
         [306.638983838996,   0.994109509596213],
         [306.878358607195,   0.994484483139546],
         [307.117733277346,   0.994848147438042],
         [307.357107947497,   0.995200393260797],
         [307.596482617648,   0.995541112915369],
         [307.835857385847,   0.995870199478548],
         [308.075232055999,   0.996187544488661],
         [308.314606726150,   0.996493039484035],
         [308.553981396301,   0.996786576772227],
         [308.793356164500,   0.997068049430028],
         [309.032730834651,   0.997337348226532],
         [309.272105504802,   0.997594365469299],
         [309.511480174954,   0.997838993465887],
         [309.750854943153,   0.998071124523853],
         [309.990229613304,   0.998290650181524],
         [310.229604283455,   0.998497462746460],
         [310.468978953606,   0.998691454526217],
         [310.708353721805,   0.998872517059123],
         [310.947728391957,   0.999040542652737],
         [311.187103062108,   0.999195422845384],
         [311.426477732259,   0.999337050713855],
         [311.665852500458,   0.999465317796476],
         [311.905227170609,   0.999580116400807],
         [312.144601840760,   0.999681338065172],
         [312.383976510912,   0.999768875866363],
         [312.623351279111,   0.999842620573475],
         [312.862725949262,   0.999902464494066],
         [313.102100619413,   0.999948300704925],
         [313.341475289564,   0.999980019975148],
         [313.580850057763,   0.999997515381525],
         [313.820224727914,   1],
         [314.059599398066,   0.999975333046241],
         [314.298974068217,   0.999919313745793],
         [314.538348836416,   0.999832265175979],
         [314.777723506567,   0.999714511952589],
         [315.017098176718,   0.999566376383716],
         [315.256472846869,   0.999388183854380],
         [315.495847615069,   0.999180257441905],
         [315.735222285220,   0.998942920992849],
         [315.974596955371,   0.998676499122999],
         [316.213971625522,   0.998381314140450],
         [316.453346393721,   0.998057690660989],
         [316.692721063872,   0.997705953300405],
         [316.932095734024,   0.997326424366791],
         [317.171470404175,   0.996919428475935],
         [317.410845172374,   0.996485289474395],
         [317.650219842525,   0.996024331208726],
         [317.889594512676,   0.995536877525485],
         [318.128969182827,   0.995023252271230],
         [318.368343951026,   0.994483778523285],
         [318.607718621178,   0.993918780897438],
         [318.847093291329,   0.993328583240246],
         [319.086467961480,   0.992713508629033],
         [319.325842729679,   0.992073881679590],
         [319.565217399830,   0.991410026238471],
         [319.804592069981,   0.990722265383003],
         [320.043966740133,   0.990010923728972],
         [320.283341508332,   0.989276324353705],
         [320.522716178483,   0.988518791872990],
         [320.762090848634,   0.987738649364151],
         [321.001465518785,   0.986936220673745],
         [321.240840286984,   0.986111830417562],
         [321.480214957136,   0.985265801672924],
         [321.719589627287,   0.984398459055622],
         [321.958964297438,   0.983510124873748],
         [322.198339065637,   0.982601124512322],
         [322.437713735788,   0.981671781048669],
         [322.677088405939,   0.980722418329347],
         [322.916463076091,   0.979753360200910],
         [323.155837844290,   0.978764931279149],
         [323.395212514441,   0.977757453872156],
         [323.634587184592,   0.976731253364951],
         [323.873961854743,   0.975686652065628],
         [324.113336622942,   0.974623974589975],
         [324.352711293093,   0.973543545553779],
         [324.592085963245,   0.972445687265136],
         [324.831460633396,   0.971330724339832],
         [325.070835401595,   0.970198980624424],
         [325.310210071746,   0.969050779196238],
         [325.549584741897,   0.967886444671062],
         [325.788959412048,   0.966706300895453],
         [326.028334180248,   0.965510671715966],
         [326.267708850399,   0.964299880209928],
         [326.507083520550,   0.963074250993126],
         [326.746458190701,   0.961834107912117],
         [326.985832958900,   0.960579774044227],
         [327.225207629051,   0.959311573236011],
         [327.464582299203,   0.958029830103258],
         [327.703956969354,   0.956734868492525],
         [327.943331737553,   0.955427011481137],
         [328.182706407704,   0.954106582915650],
         [328.422081077855,   0.952773906642621],
         [328.661455748006,   0.951429307277839],
         [328.900830516205,   0.950073107898627],
         [329.140205186357,   0.948705633120776],
         [329.379579856508,   0.947327205252378],
         [329.618954526659,   0.945938149678452],
         [329.858329294858,   0.944538789476325],
         [330.097703965009,   0.943129448492553],
         [330.337078635160,   0.941710450573691],
         [330.576453305312,   0.940282119566298],
         [330.815828073511,   0.938844779316929],
         [331.055202743662,   0.937398753672142],
         [331.294577413813,   0.935944366478493],
         [331.533952083964,   0.934481940813307],
         [331.773326852163,   0.933011802061603],
         [332.012701522315,   0.931534273300708],
         [332.252076192466,   0.930049677607945],
         [332.491450862617,   0.928558339599104],
         [332.730825630816,   0.927060583120741],
         [332.970200300967,   0.925556731250180],
         [333.209574971118,   0.924047108603211],
         [333.448949641270,   0.922532375949886],
         [333.688324409469,   0.921016555602900],
         [333.927699079620,   0.919500736025146],
         [334.167073749771,   0.917984915678161],
         [334.406448419922,   0.916469096100407],
         [334.645823188121,   0.914953275753421],
         [334.885197858273,   0.913437455406435],
         [335.124572528424,   0.911921635828681],
         [335.363947198575,   0.910405815481695],
         [335.603321966774,   0.908889995903941],
         [335.842696636925,   0.907374175556955],
         [336.082071307076,   0.905858355209970],
         [336.321445977228,   0.904342535632215],
         [336.560820745427,   0.902826715285230],
         [336.800195415578,   0.901310894938244],
         [337.039570085729,   0.899795075360490],
         [337.278944755880,   0.898279255013504],
         [337.518319524079,   0.896763435435750],
         [337.757694194230,   0.895247615088764],
         [337.997068864382,   0.893731794741779],
         [338.236443534533,   0.892215975164025],
         [338.475818302732,   0.890700154817039],
         [338.715192972883,   0.889184335239285],
         [338.954567643034,   0.887668514892299],
         [339.193942313185,   0.886152694545313],
         [339.433317081385,   0.884636874967559],
         [339.672691751536,   0.883121054620573],
         [339.912066421687,   0.881605234273588],
         [340.151441091838,   0.880089414695834],
         [340.390815860037,   0.878573594348848],
         [340.630190530188,   0.877057774771094],
         [340.869565200340,   0.875541954424108],
         [341.108939870491,   0.874026134077122],
         [341.348314638690,   0.872510314499368],
         [341.587689308841,   0.870994494152382],
         [341.827063978992,   0.869478674574628],
         [342.066438649143,   0.867962854227643],
         [342.305813417342,   0.866447033880657],
         [342.545188087494,   0.864931214302903],
         [342.784562757645,   0.863415393955917],
         [343.023937427796,   0.861899573608931],
         [343.263312195995,   0.860383754031177],
         [343.502686866146,   0.858867933684192],
         [343.742061536297,   0.857352114106437],
         [343.981436206449,   0.855836293759452],
         [344.220810974648,   0.854320473412466],
         [344.460185644799,   0.852804653834712],
         [344.699560314950,   0.851288833487726],
         [344.938934985101,   0.849773013909972],
         [345.178309753300,   0.848257193562986],
         [345.417684423452,   0.846741373216000],
         [345.657059093603,   0.845225553638246],
         [345.896433763754,   0.843709733291261],
         [346.135808531953,   0.842193912944275],
         [346.375183202104,   0.840678093366521],
         [346.614557872255,   0.839162273019535],
         [346.853932542407,   0.837646453441781],
         [347.093307310606,   0.836130633094795],
         [347.332681980757,   0.834614812747810],
         [347.572056650908,   0.833098993170055],
         [347.811431321059,   0.831583172823070],
         [348.050806089258,   0.830067353245316],
         [348.290180759409,   0.828551532898330],
         [348.529555429561,   0.827035712551344],
         [348.768930099712,   0.825519892973590],
         [349.008304867911,   0.824004072626604],
         [349.247679538062,   0.822488252279618],
         [349.487054208213,   0.820972432701864],
         [349.726428878364,   0.819456612354879],
         [349.965803646564,   0.817940792777125],
         [350.205178316715,   0.816424972430139],
         [350.444552986866,   0.814909152083153],
         [350.683927657017,   0.813393332505399],
         [350.923302425216,   0.811877512158413],
         [351.162677095367,   0.810361692580659],
         [351.402051765519,   0.808845872233673],
         [351.641426435670,   0.807330051886688],
         [351.880801203869,   0.805814232308934],
         [352.120175874020,   0.804298411961948],
         [352.359550544171,   0.802782591614962],
         [352.598925214322,   0.801266772037208],
         [352.838299982521,   0.799750951690222],
         [353.077674652673,   0.798235132112468],
         [353.317049322824,   0.796719311765482],
         [353.556423992975,   0.795203491418497],
         [353.795798761174,   0.793687671840743],
         [354.035173431325,   0.792171851493757],
         [354.274548101476,   0.790656031916003],
         [354.513922771628,   0.789140211569017],
         [354.753297539827,   0.787624391222031],
         [354.992672209978,   0.786108571644277],
         [355.232046880129,   0.784592751297291],
         [355.471421550280,   0.783076930950306],
         [355.710796318479,   0.781561111372552],
         [355.950170988631,   0.780045291025566],
         [356.189545658782,   0.778529471447812],
         [356.428920328933,   0.777013651100826],
         [356.668295097132,   0.775497830753840],
         [356.907669767283,   0.773982011176086],
         [357.147044437434,   0.772466190829101],
         [357.386419107586,   0.770950370482115],
         [357.625793875785,   0.769434550904361],
         [357.865168545936,   0.767918730788144],
         [358.104543216087,   0.766402910671928],
         [358.343917886238,   0.764887090632635],
         [358.583292654437,   0.763371270593342],
         [358.822667324588,   0.761855450554049],
         [359.062041994740,   0.760339630514756],
         [359.301416664891,   0.758823810475463],
         [359.540791433090,   0.757307990359247],
         [359.780166103241,   0.755792170319953],
         [360.019540773392,   0.754276350280660],
         [360.258915443543,   0.752760530241367],
         [360.498290211743,   0.751244710202074],
         [360.737664881894,   0.749728890162781],
         [360.977039552045,   0.748213070123488],
         [361.216414222196,   0.746697250007272],
         [361.455788990395,   0.745181429967979],
         [361.695163660546,   0.743665609928686],
         [361.934538330698,   0.742149789889393],
         [362.173913000849,   0.740633969850099],
         [362.413287769048,   0.739118149810806],
         [362.652662439199,   0.737602329694590],
         [362.892037109350,   0.736086509655297],
         [363.131411779501,   0.734570689616004],
         [363.370786547700,   0.733054869576711],
         [363.610161217852,   0.731539049537418],
         [363.849535888003,   0.730023229498125],
         [364.088910558154,   0.728507409381909],
         [364.328285326353,   0.726991589342615],
         [364.567659996504,   0.725475769303322],
         [364.807034666655,   0.723959949264029],
         [365.046409336807,   0.722444129224736],
         [365.285784105006,   0.720928309185443],
         [365.525158775157,   0.719412489069227],
         [365.764533445308,   0.717896669029934],
         [366.003908115459,   0.716380848990641],
         [366.243282883658,   0.714865028951348],
         [366.482657553810,   0.713349208912055],
         [366.722032223961,   0.711833388872761],
         [366.961406894112,   0.710317568756545],
         [367.200781662311,   0.708801748717252],
         [367.440156332462,   0.707285928677959],
         [367.679531002613,   0.705770108638666],
         [367.918905672765,   0.704254288599373],
         [368.158280440964,   0.702738468560080],
         [368.397655111115,   0.701222648520787],
         [368.637029781266,   0.699706828404570],
         [368.876404451417,   0.698191008365277],
         [369.115779219616,   0.696675188325984],
         [369.355153889768,   0.695159368286691],
         [369.594528559919,   0.693643548247398],
         [369.833903230070,   0.692127728208105],
         [370.073277998269,   0.690611908091889],
         [370.312652668420,   0.689096088052596],
         [370.552027338571,   0.687580268013303],
         [370.791402008722,   0.686064447974010],
         [371.030776776922,   0.684548627934717],
         [371.270151447073,   0.683032807895423],
         [371.509526117224,   0.681516987779207],
         [371.748900787375,   0.680001167739914],
         [371.988275555574,   0.678485347700621],
         [372.227650225725,   0.676969527661328],
         [372.467024895877,   0.675453707622035],
         [372.706399566028,   0.673937887582742],
         [372.945774334227,   0.672422067466526],
         [373.185149004378,   0.670906247427232],
         [373.424523674529,   0.669390427387939],
         [373.663898344680,   0.667874607348646],
         [373.903273112879,   0.666358787309353],
         [374.142647783031,   0.664842967270060],
         [374.382022453182,   0.663327147230767],
         [374.621397123333,   0.661811327114551],
         [374.860771891532,   0.660295507075258],
         [375.100146561683,   0.658779687035965],
         [375.339521231835,   0.657263866996672],
         [375.578895901986,   0.655748046957378],
         [375.818270670185,   0.654232226918085],
         [376.057645340336,   0.652716406801869],
         [376.297020010487,   0.651200586762576],
         [376.536394680638,   0.649684766723283],
         [376.775769448837,   0.648168946683990],
         [377.015144118989,   0.646653126644697],
         [377.254518789140,   0.645137306605404],
         [377.493893459291,   0.643621486489188],
         [377.733268227490,   0.642105666449894],
         [377.972642897641,   0.640589846410601],
         [378.212017567792,   0.639074026371308],
         [378.451392237944,   0.637558206332015],
         [378.690767006143,   0.636042386292722],
         [378.930141676294,   0.634526566176506],
         [379.169516346445,   0.633010746137213],
         [379.408891016596,   0.631494926097920],
         [379.648265784795,   0.629979106058627],
         [379.887640454947,   0.628463286019334],
         [380.127015125098,   0.626947465980040],
         [380.366389795249,   0.625431645863824],
         [380.605764563448,   0.623915825824531],
         [380.845139233599,   0.622400005785238],
         [381.084513903750,   0.620884185745945],
         [381.323888573902,   0.619368365706652],
         [381.563263342101,   0.617852545667359],
         [381.802638012252,   0.616336725628066],
         [382.042012682403,   0.614820905511849],
         [382.281387352554,   0.613305085472556],
         [382.520762120753,   0.611789265433263],
         [382.760136790905,   0.610273445393970],
         [382.999511461056,   0.608757625354677],
         [383.238886131207,   0.607241805315384],
         [383.478260899406,   0.605725985199168],
         [383.717635569557,   0.604210165159875],
         [383.957010239708,   0.602694345120582],
         [384.196384909859,   0.601178525081289],
         [384.435759678059,   0.599662705041996],
         [384.675134348210,   0.598146885002702],
         [384.914509018361,   0.596631064886486],
         [385.153883688512,   0.595115244847193],
         [385.393258456711,   0.593599424807900],
         [385.632633126862,   0.592083604768607],
         [385.872007797014,   0.590567784729314],
         [386.111382467165,   0.589051964690021],
         [386.350757235364,   0.587536144573805],
         [386.590131905515,   0.586020324534511],
         [386.829506575666,   0.584504504495218],
         [387.068881245817,   0.582988684455925],
         [387.308256014016,   0.581472864416632],
         [387.547630684168,   0.579957044377339],
         [387.787005354319,   0.578441224338046],
         [388.026380024470,   0.576925404221830],
         [388.265754792669,   0.575409584182537],
         [388.505129462820,   0.573893764143244],
         [388.744504132972,   0.572377944103951],
         [388.983878803123,   0.570862124064657],
         [389.223253571322,   0.569346304025364],
         [389.462628241473,   0.567830483909148],
         [389.702002911624,   0.566314663869855],
         [389.941377581775,   0.564798843830562],
         [390.180752349974,   0.563283023791269],
         [390.420127020126,   0.561767203751976],
         [390.659501690277,   0.560251383712683],
         [390.898876360428,   0.558735563596467],
         [391.138251128627,   0.557219743557173],
         [391.377625798778,   0.555703923517880],
         [391.617000468929,   0.554188103478587],
         [391.856375139081,   0.552672283439294],
         [392.095749907280,   0.551156463400001],
         [392.335124577431,   0.549640643283785],
         [392.574499247582,   0.548124823244492],
         [392.813873917733,   0.546609003205199],
         [393.053248685932,   0.545093183165906],
         [393.292623356083,   0.543577363126613],
         [393.531998026235,   0.542061543087319],
         [393.771372696386,   0.540545722971103],
         [394.010747464585,   0.539029902931810],
         [394.250122134736,   0.537514082892517],
         [394.489496804887,   0.535998262853224],
         [394.728871475039,   0.534482442813931],
         [394.968246243238,   0.532966622774638],
         [395.207620913389,   0.531450802735345],
         [395.446995583540,   0.529934982619128],
         [395.686370253691,   0.528419162579835],
         [395.925745021890,   0.526903342540542],
         [396.165119692041,   0.525387522501249],
         [396.404494362193,   0.523871702461956],
         [396.643869032344,   0.522355882422663],
         [396.883243800543,   0.520840062306447],
         [397.122618470694,   0.519324242267154],
         [397.361993140845,   0.517808422227861],
         [397.601367810996,   0.516292602188568],
         [397.840742579195,   0.514776782149275],
         [398.080117249347,   0.513260962109981],
         [398.319491919498,   0.511745141993765],
         [398.558866589649,   0.510229321954472],
         [398.798241357848,   0.508713501915179],
         [399.037616027999,   0.507197681875886],
         [399.276990698150,   0.505681861836593],
         [399.516365368302,   0.504166041797300],
         [399.755740136501,   0.502650221681084],
         [399.995114806652,   0.501134401641790],
         [400.234489476803,   0.499618581602497],
         [400.473864146954,   0.498102761563204],
         [400.713238915153,   0.496586941523911],
         [400.952613585305,   0.495071121484618],
         [401.191988255456,   0.493555301445325],
         [401.431362925607,   0.492039481329109],
         [401.670737693806,   0.490523661289816],
         [401.910112363957,   0.489007841250523],
         [402.149487034108,   0.487492021211230],
         [402.388861704260,   0.485976201171936],
         [402.628236472459,   0.484460381132643],
         [402.867611142610,   0.482944561016427],
         [403.106985812761,   0.481428740977134],
         [403.346360482912,   0.479912920937841],
         [403.585735251111,   0.478397100898548],
         [403.825109921263,   0.476881280859255],
         [404.064484591414,   0.475365460819962],
         [404.303859261565,   0.473849640703745],
         [404.543234029764,   0.472333820664452],
         [404.782608699915,   0.470818000625159],
         [405.021983370066,   0.469302180585866],
         [405.261358040217,   0.467786360546573],
         [405.500732808417,   0.466270540507280],
         [405.740107478568,   0.464754720391064],
         [405.979482148719,   0.463238900351771],
         [406.218856818870,   0.461723080312478],
         [406.458231587069,   0.460207260273185],
         [406.697606257220,   0.458691440233891],
         [406.936980927372,   0.457175620194598],
         [407.176355597523,   0.455659800078382],
         [407.415730365722,   0.454143980039089],
         [407.655105035873,   0.452628159999796],
         [407.894479706024,   0.451112339960503],
         [408.133854376175,   0.449596519921210],
         [408.373229144375,   0.448080699881917],
         [408.612603814526,   0.446564879842624],
         [408.851978484677,   0.445049059726407],
         [409.091353154828,   0.443533239687114],
         [409.330727923027,   0.442017419647821],
         [409.570102593178,   0.440501599608528],
         [409.809477263330,   0.438985779569235],
         [410.048851933481,   0.437469959529942],
         [410.288226701680,   0.435954139413726],
         [410.527601371831,   0.434438319374433],
         [410.766976041982,   0.432922499335140],
         [411.006350712133,   0.431406679295847],
         [411.245725480332,   0.429890859256553],
         [411.485100150484,   0.428375039217260],
         [411.724474820635,   0.426859219101044],
         [411.963849490786,   0.425343399061751],
         [412.203224258985,   0.423827579022458],
         [412.442598929136,   0.422311758983165],
         [412.681973599287,   0.420795938943872],
         [412.921348269439,   0.419280118904579],
         [413.160723037638,   0.417764298788362],
         [413.400097707789,   0.416248478749069],
         [413.639472377940,   0.414732658709776],
         [413.878847048091,   0.413216838670483],
         [414.118221816290,   0.411701018631190],
         [414.357596486442,   0.410185198591897],
         [414.596971156593,   0.408669378552604],
         [414.836345826744,   0.407153558436388],
         [415.075720594943,   0.405637738397095],
         [415.315095265094,   0.404121918357802],
         [415.554469935245,   0.402606098318508],
         [415.793844605397,   0.401090278279215],
         [416.033219373596,   0.399574458239922],
         [416.272594043747,   0.398058638123706],
         [416.511968713898,   0.396542818084413],
         [416.751343384049,   0.395026998045120],
         [416.990718152248,   0.393511178005827],
         [417.230092822399,   0.391995357966534],
         [417.469467492551,   0.390479537927241],
         [417.708842162702,   0.388963717811024],
         [417.948216930901,   0.387447897771731],
         [418.187591601052,   0.385932077732438],
         [418.426966271203,   0.384416257693145],
         [418.666340941354,   0.382900437653852],
         [418.905715709554,   0.381384617614559],
         [419.145090379705,   0.379868797498343],
         [419.384465049856,   0.378352977459050],
         [419.623839720007,   0.376837157419757],
         [419.863214488206,   0.375321337380464],
         [420.102589158357,   0.373805517341170],
         [420.341963828509,   0.372289697301877],
         [420.581338498660,   0.370773877185661],
         [420.820713266859,   0.369258057146368],
         [421.060087937010,   0.367742237107075],
         [421.299462607161,   0.366226417067782],
         [421.538837277312,   0.364710597028489],
         [421.778212045511,   0.363194776989196],
         [422.017586715663,   0.361678956949903],
         [422.256961385814,   0.360163136833686],
         [422.496336055965,   0.358647316794393],
         [422.735710824164,   0.357131496755100],
         [422.975085494315,   0.355615676715807],
         [423.214460164466,   0.354099856676514],
         [423.453834834618,   0.352584036637221],
         [423.693209602817,   0.351068216521005],
         [423.932584272968,   0.349552396481712],
         [424.171958943119,   0.348036576442419],
         [424.411333613270,   0.346520756403125],
         [424.650708381469,   0.345004936363832],
         [424.890083051621,   0.343489116324539],
         [425.129457721772,   0.341973296208323],
         [425.368832391923,   0.340457476169030],
         [425.608207160122,   0.338941656129737],
         [425.847581830273,   0.337425836090444],
         [426.086956500424,   0.335910016051151],
         [426.326331170576,   0.334394196011858],
         [426.565705938775,   0.332878375895641],
         [426.805080608926,   0.331362555856348],
         [427.044455279077,   0.329846735817055],
         [427.283829949228,   0.328330915777762],
         [427.523204717427,   0.326815095738469],
         [427.762579387578,   0.325299275699176],
         [428.001954057730,   0.323783455659883],
         [428.241328727881,   0.322267635543667],
         [428.480703496080,   0.320751815504374],
         [428.720078166231,   0.319235995465081],
         [428.959452836382,   0.317720175425787],
         [429.198827506533,   0.316204355386494],
         [429.438202274733,   0.314688535347201],
         [429.677576944884,   0.313172715230985],
         [429.916951615035,   0.311656895191692],
         [430.156326285186,   0.310141075152399],
         [430.395701053385,   0.308625255113106],
         [430.635075723536,   0.307109435073813],
         [430.874450393688,   0.305593615034520],
         [431.113825063839,   0.304077794918303],
         [431.353199832038,   0.302561974879010],
         [431.592574502189,   0.301046154839717],
         [431.831949172340,   0.299530334800424],
         [432.071323842491,   0.298014514761131],
         [432.310698610690,   0.296498694721838],
         [432.550073280842,   0.294982874605622],
         [432.789447950993,   0.293467054566329],
         [433.028822621144,   0.291951234527036],
         [433.268197389343,   0.290435414487743],
         [433.507572059494,   0.288919594448449],
         [433.746946729645,   0.287403774409156],
         [433.986321399797,   0.285887954292940],
         [434.225696167996,   0.284372134253647],
         [434.465070838147,   0.282856314214354],
         [434.704445508298,   0.281340494175061],
         [434.943820178449,   0.279824674135768],
         [435.183194946648,   0.278308854096475],
         [435.422569616800,   0.276793034057182],
         [435.661944286951,   0.275277213940965],
         [435.901318957102,   0.273761393901672],
         [436.140693725301,   0.272245573862379],
         [436.380068395452,   0.270729753823086],
         [436.619443065603,   0.269213933783793],
         [436.858817735755,   0.267698113744500],
         [437.098192503954,   0.266182293628284],
         [437.337567174105,   0.264666473588991],
         [437.576941844256,   0.263150653549698],
         [437.816316514407,   0.261634833510404],
         [438.055691282606,   0.260119013471111],
         [438.295065952757,   0.258603193431818],
         [438.534440622909,   0.257087373315602],
         [438.773815293060,   0.255571553276309],
         [439.013190061259,   0.254055733237016],
         [439.252564731410,   0.252539913197723],
         [439.491939401561,   0.251024093158430],
         [439.731314071712,   0.249508273119137],
         [439.970688839912,   0.247992453002920],
         [440.210063510063,   0.246476632963627],
         [440.449438180214,   0.244960812924334],
         [440.688812850365,   0.243444992885041],
         [440.928187618564,   0.241929172845748],
         [441.167562288715,   0.240413352806455],
         [441.406936958867,   0.238897532767162],
         [441.646311629018,   0.237381712650946],
         [441.885686397217,   0.235865892611653],
         [442.125061067368,   0.234350072572360],
         [442.364435737519,   0.232834252533066],
         [442.603810407670,   0.231318432493773],
         [442.843185175869,   0.229802612454480],
         [443.082559846021,   0.228286792338264],
         [443.321934516172,   0.226770972298971],
         [443.561309186323,   0.225255152259678],
         [443.800683954522,   0.223739332220385],
         [444.040058624673,   0.222223512181092],
         [444.279433294824,   0.220707692141799],
         [444.518807964976,   0.219191872025582],
         [444.758182733175,   0.217676051986289],
         [444.997557403326,   0.216160231946996],
         [445.236932073477,   0.214644411907703],
         [445.476306743628,   0.213128591868410],
         [445.715681511827,   0.211612771829117],
         [445.955056181979,   0.210096951712901],
         [446.194430852130,   0.208581131673608],
         [446.433805522281,   0.207065311634315],
         [446.673180290480,   0.205549491595021],
         [446.912554960631,   0.204033671555728],
         [447.151929630782,   0.202517851516435],
         [447.391304300934,   0.201002031400219],
         [447.630679069133,   0.199486211360926],
         [447.870053739284,   0.197970391321633],
         [448.109428409435,   0.196454571282340],
         [448.348803079586,   0.194938751243047],
         [448.588177847785,   0.193422931203754],
         [448.827552517937,   0.191907111164461],
         [449.066927188088,   0.190391291048244],
         [449.306301858239,   0.188875471008951],
         [449.545676626438,   0.187359650969658],
         [449.785051296589,   0.185843830930365],
         [450.024425966740,   0.184328010891072],
         [450.263800636891,   0.182812190851779],
         [450.503175405091,   0.181296370735563],
         [450.742550075242,   0.179780550696270],
         [450.981924745393,   0.178264730656977],
         [451.221299415544,   0.176748910617683],
         [451.460674183743,   0.175233090578390],
         [451.700048853894,   0.173717270539097],
         [451.939423524046,   0.172201450422881],
         [452.178798194197,   0.170685630383588],
         [452.418172962396,   0.169169810344295],
         [452.657547632547,   0.167653990305002],
         [452.896922302698,   0.166138170265709],
         [453.136296972849,   0.164622350226416],
         [453.375671741049,   0.163106530110199],
         [453.615046411200,   0.161590710070906],
         [453.854421081351,   0.160074890031613],
         [454.093795751502,   0.158559069992320],
         [454.333170519701,   0.157043249953027],
         [454.572545189852,   0.155527429913734],
         [454.811919860004,   0.154011609874441],
         [455.051294530155,   0.152495789758225],
         [455.290669298354,   0.150979969718932],
         [455.530043968505,   0.149464149679638],
         [455.769418638656,   0.147948329640345],
         [456.008793308807,   0.146432509601052],
         [456.248168077006,   0.144916689561759],
         [456.487542747158,   0.143400869445543],
         [456.726917417309,   0.141885049406250],
         [456.966292087460,   0.140369229366957],
         [457.205666855659,   0.138853409327664],
         [457.445041525810,   0.137337589288371],
         [457.684416195961,   0.135821769249078],
         [457.923790866113,   0.134305949132861],
         [458.163165634312,   0.132790129093568],
         [458.402540304463,   0.131274309054275],
         [458.641914974614,   0.129758489014982],
         [458.881289644765,   0.128242668975689],
         [459.120664412964,   0.126726848936396],
         [459.360039083116,   0.125211028820180],
         [459.599413753267,   0.123695208780887],
         [459.838788423418,   0.122179388741594],
         [460.078163191617,   0.120663568702300],
         [460.317537861768,   0.119147748663007],
         [460.556912531919,   0.117631928623714],
         [460.796287202071,   0.116116108507498],
         [461.035661970270,   0.114600288468205],
         [461.275036640421,   0.113084468428912],
         [461.514411310572,   0.111568648389619],
         [461.753785980723,   0.110052828350326],
         [461.993160748922,   0.108537008311033],
         [462.232535419074,   0.107021188271740],
         [462.471910089225,   0.105505368155523],
         [462.711284759376,   0.103989548116230],
         [462.950659527575,   0.102473728076937],
         [463.190034197726,   0.100957908037644],
         [463.429408867877,   0.0994420879983510],
         [463.668783538029,   0.0979262679590579],
         [463.908158306228,   0.0964104478428417],
         [464.147532976379,   0.0948946278035486],
         [464.386907646530,   0.0933788077642555],
         [464.626282316681,   0.0918629877249624],
         [464.865657084880,   0.0903471676856694],
         [465.105031755031,   0.0888313476463763],
         [465.344406425183,   0.0873155275301600],
         [465.583781095334,   0.0857997074908669],
         [465.823155863533,   0.0842838874515739],
         [466.062530533684,   0.0827680674122808],
         [466.301905203835,   0.0812522473729877],
         [466.541279873986,   0.0797364273336946],
         [466.780654642185,   0.0782206072174784],
         [467.020029312337,   0.0767047872012622],
         [467.259403982488,   0.0751889671465845],
         [467.498778652639,   0.0736731470995991],
         [467.738153420838,   0.0721573270449214],
         [467.977528090989,   0.0706415069979360],
         [468.216902761141,   0.0691256869432583],
         [468.456277431292,   0.0676098668885806],
         [468.695652199491,   0.0660940468415952],
         [468.935026869642,   0.0645782267869175],
         [469.174401539793,   0.0630624067399321],
         [469.413776209944,   0.0615465866852544],
         [469.653150978143,   0.0600307666305766],
         [469.892525648295,   0.0585149465835913],
         [470.131900318446,   0.0569991265289135],
         [470.371274988597,   0.0554833064819281],
         [470.610649756796,   0.0539674864272504],
         [470.850024426947,   0.0524625922169320],
         [471.089399097098,   0.0509833220692552],
         [471.328773767250,   0.0495295788917916],
         [471.568148535449,   0.0481011827843174],
         [471.807523205600,   0.0466979538466088],
         [472.046897875751,   0.0453197121784420],
         [472.286272545902,   0.0439662778795933],
         [472.525647314101,   0.0426374710421467],
         [472.765021984253,   0.0413331117812629],
         [473.004396654404,   0.0400530201813336],
         [473.243771324555,   0.0387970163498273],
         [473.483146092754,   0.0375649203865202],
         [473.722520762905,   0.0363565523834963],
         [473.961895433056,   0.0351717324559165],
         [474.201270103208,   0.0340102806881722],
         [474.440644871407,   0.0328720171954245],
         [474.680019541558,   0.0317567620620648],
         [474.919394211709,   0.0306643353955618],
         [475.158768881860,   0.0295945572879993],
         [475.398143650059,   0.0285472478545383],
         [475.637518320210,   0.0275222271795703],
         [475.876892990362,   0.0265193153705638],
         [476.116267660513,   0.0255383325272952],
         [476.355642428712,   0.0245790987418482],
         [476.595017098863,   0.0236414341216915],
         [476.834391769014,   0.0227251587666013],
         [477.073766439165,   0.0218300927763539],
         [477.313141207364,   0.0209560562507254],
         [477.552515877516,   0.0201028692817997],
         [477.791890547667,   0.0192703519770455],
         [478.031265217818,   0.0184583244362389],
         [478.270639986017,   0.0176666067514639],
         [478.510014656168,   0.0168950190301891],
         [478.749389326320,   0.0161433813721905],
         [478.988763996471,   0.0154115138695523],
         [479.228138764670,   0.0146992366297428],
         [479.467513434821,   0.0140063697525384],
         [479.706888104972,   0.0133327333377152],
         [479.946262775123,   0.0126781474773573],
         [480.185637543322,   0.0120424322789331],
         [480.425012213474,   0.0114254078345265],
         [480.664386883625,   0.0108268942516062],
         [480.903761553776,   0.0102467116299482],
         [481.143136321975,   0.00968468006932898],
         [481.382510992126,   0.00914061966183230],
         [481.621885662277,   0.00861435050723444],
         [481.861260332429,   0.00810569271300394],
         [482.100635100628,   0.00761446637891703],
         [482.340009770779,   0.00714049160474994],
         [482.579384440930,   0.00668358848258660],
         [482.818759111081,   0.00624357711220322],
         [483.058133879280,   0.00582027760876069],
         [483.297508549432,   0.00541351004895827],
         [483.536883219583,   0.00502309455564915],
         [483.776257889734,   0.00464885121322493],
         [484.015632657933,   0.00429060012146184],
         [484.255007328084,   0.00394816138782844],
         [484.494381998235,   0.00362135511210094],
         [484.733756668387,   0.00331000138636326],
         [484.973131436586,   0.00301392031039165],
         [485.212506106737,   0.00273293199165464],
         [485.451880776888,   0.00246685652992847],
         [485.691255447039,   0.00221551401729705],
         [485.930630215238,   0.00197872456122894],
         [486.170004885389,   0.00175630825380804],
         [486.409379555541,   0.00154808520250290],
         [486.648754225692,   0.00135387549939745],
         [486.888128993891,   0.00117349924426791],
         [487.127503664042,   0.00100677654458283],
         [487.366878334193,   0.000853527500118437],
         [487.606253004344,   0.000713572202958656],
         [487.845627772544,   0.000586730752879714],
         [488.085002442695,   0.000472823257350159],
         [488.324377112846,   0.000371669808453908],
         [488.563751782997,   0.000283090513659508],
         [488.803126551196,   0.000206905465050875],
         [489.042501221347,   0.000142934762404239],
         [489.281875891499,   9.09985131881506e-05],
         [489.521250561650,   5.09168171788411e-05],
         [489.760625329849,   2.25097587679076e-05],
         [490,                5.59746080853394e-06]])


def bo_generate_base_waveform(nrpoints, duration):
    """Return base waveform of required number of points and duration."""
    if nrpoints is None:
        raise Exception('Missing number of points to generate waveform!')
    if duration is None:
        duration = DEFAULT_RAMP_DURATION/1000

    time0 = BASE_RAMP_CURVE_ORIG[:, 0]
    wfm0 = BASE_RAMP_CURVE_ORIG[:, 1]
    time = _np.linspace(0.0, duration, nrpoints)
    wfm = _np.interp(time, time0, wfm0)
    return wfm


def bo_get_default_waveform(psname, nrpoints=None, duration=None,
                            ramp_config=None):
    """."""
    if ramp_config is None:
        # Uses a template wfmdata scaled to maximum ps current
        if nrpoints is None:
            if 'CH' in psname or 'CV' in psname or 'QS' in psname:
                nrpoints = _DEF_WFMSIZE_FBP
            else:
                nrpoints = _DEF_WFMSIZE_OTHERS
        wfm = bo_generate_base_waveform(nrpoints, duration)
        if psname in DEFAULT_RAMP_AMPLITUDE:
            # bypass upper_limit if psname in dictionary
            amp = DEFAULT_RAMP_AMPLITUDE[psname]
        else:
            pstype = _PSSearch.conv_psname_2_pstype(psname)
            splims = _PSSearch.conv_pstype_2_splims(pstype)
            amp = splims['HIHI']
        wfmdata = amp * wfm
    else:
        # load waveform from config database
        errmsg = ('Creation of waveform from ramp config '
                  'not yet implemented')
        raise NotImplementedError(errmsg)
    return wfmdata
