# django-simpletask2-server

The server program used with django-simpletask2. After startup, it can automatically process the asynchronous processing tasks generated by django-simpletask2.

## Install

```
pip install django-simpletask2-server
```

## Usage

```
C:\test\django-simpletask2>django-simpletask2-server --help
Usage: django-simpletask2-server [OPTIONS] COMMAND [ARGS]...

Options:
  --logfmt TEXT
  --logfile TEXT
  --loglevel TEXT
  --pidfile TEXT                  pidfile file path.
  --workspace TEXT                Set running folder
  --daemon / --no-daemon          Run application in background or in
                                  foreground.

  -c, --config TEXT               Config file path. Application will search
                                  config file if this option is missing. Use
                                  sub-command show-config-fileapaths to get
                                  the searching tactics.

  --error-sleep INTEGER
  --idle-sleep INTEGER
  -t, --threads INTEGER
  --auto-reset-task-interval INTEGER
  --do-auto-reset-task / --no-do-auto-reset-task
  --task-pull-timeout INTEGER
  --task-pull-engine TEXT
  --channel-flags-template TEXT
  --channel-name-strip-regex TEXT
  --channel-name-template TEXT
  -c, --channels TEXT
  -r, --redis TEXT
  -a, --aclkey TEXT
  -s, --server TEXT
  --help                          Show this message and exit.

Commands:
  restart                Restart Daemon application.
  show-config-filepaths  Print out the config searching paths.
  start                  Start daemon application.
  stop                   Stop daemon application.

```

## Config items

- server: Required. Default to: http://127.0.0.1:8000/django-simpletask2/。
- aclkey: Required. No default value.
- channels: Required. Default to "default".
- threads: Required. Default to 1.
- task-pull-engine Required. Default to "redis". Other options are: api.
- idle_sleep: Default to 5 seconds.
- error_sleep: Default to 5 seconds.

## Releases

### v0.0.6 2021/09/24

- First release.
