# mypy-boto3-cloudfront

[![PyPI - mypy-boto3-cloudfront](https://img.shields.io/pypi/v/mypy-boto3-cloudfront.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudfront)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-cloudfront.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudfront)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CloudFront 1.16.14](https://boto3.amazonaws.com/v1/documentation/api/1.16.14/reference/services/cloudfront.html#CloudFront) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-cloudfront](#mypy-boto3-cloudfront)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `CloudFront` service.

```bash
python -m pip install boto3-stubs[cloudfront]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[cloudfront]` in your environment: `python -m pip install 'boto3-stubs[cloudfront]'`

Both type checking and auto-complete should work for `CloudFront` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[cloudfront]` in your environment: `python -m pip install 'boto3-stubs[cloudfront]'`

Both type checking and auto-complete should work for `CloudFront` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[cloudfront]` in your environment: `python -m pip install 'boto3-stubs[cloudfront]'`
- Run `mypy` as usual

Type checking should work for `CloudFront` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[cloudfront]` in your environment: `python -m pip install 'boto3-stubs[cloudfront]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CloudFront` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`CloudFrontClient` provides annotations for `boto3.client("cloudfront")`.

```python
import boto3

from mypy_boto3_cloudfront import CloudFrontClient

client: CloudFrontClient = boto3.client("cloudfront")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CloudFrontClient = session.client("cloudfront")
```

### Paginators annotations

`mypy_boto3_cloudfront.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_cloudfront import CloudFrontClient
from mypy_boto3_cloudfront.paginator import (
    ListCloudFrontOriginAccessIdentitiesPaginator,
    ListDistributionsPaginator,
    ListInvalidationsPaginator,
    ListStreamingDistributionsPaginator,
)

client: CloudFrontClient = boto3.client("cloudfront")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_cloud_front_origin_access_identities_paginator: ListCloudFrontOriginAccessIdentitiesPaginator = client.get_paginator("list_cloud_front_origin_access_identities")
list_distributions_paginator: ListDistributionsPaginator = client.get_paginator("list_distributions")
list_invalidations_paginator: ListInvalidationsPaginator = client.get_paginator("list_invalidations")
list_streaming_distributions_paginator: ListStreamingDistributionsPaginator = client.get_paginator("list_streaming_distributions")
```


### Waiters annotations

`mypy_boto3_cloudfront.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_cloudfront import CloudFrontClient
from mypy_boto3_cloudfront.waiter import (
    DistributionDeployedWaiter,
    InvalidationCompletedWaiter,
    StreamingDistributionDeployedWaiter,
)

client: CloudFrontClient = boto3.client("cloudfront")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
distribution_deployed_waiter: DistributionDeployedWaiter = client.get_waiter("distribution_deployed")
invalidation_completed_waiter: InvalidationCompletedWaiter = client.get_waiter("invalidation_completed")
streaming_distribution_deployed_waiter: StreamingDistributionDeployedWaiter = client.get_waiter("streaming_distribution_deployed")
```





### Typed dictionations

`mypy_boto3_cloudfront.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_cloudfront.type_defs import (
    ActiveTrustedKeyGroupsTypeDef,
    ActiveTrustedSignersTypeDef,
    AliasesTypeDef,
    AliasICPRecordalTypeDef,
    AllowedMethodsTypeDef,
    CacheBehaviorsTypeDef,
    CacheBehaviorTypeDef,
    CachedMethodsTypeDef,
    CachePolicyConfigTypeDef,
    CachePolicyCookiesConfigTypeDef,
    CachePolicyHeadersConfigTypeDef,
    CachePolicyListTypeDef,
    CachePolicyQueryStringsConfigTypeDef,
    CachePolicySummaryTypeDef,
    CachePolicyTypeDef,
    CloudFrontOriginAccessIdentityConfigTypeDef,
    CloudFrontOriginAccessIdentityListTypeDef,
    CloudFrontOriginAccessIdentitySummaryTypeDef,
    CloudFrontOriginAccessIdentityTypeDef,
    ContentTypeProfileConfigTypeDef,
    ContentTypeProfilesTypeDef,
    ContentTypeProfileTypeDef,
    CookieNamesTypeDef,
    CookiePreferenceTypeDef,
    CreateCachePolicyResultTypeDef,
    CreateCloudFrontOriginAccessIdentityResultTypeDef,
    CreateDistributionResultTypeDef,
    CreateDistributionWithTagsResultTypeDef,
    CreateFieldLevelEncryptionConfigResultTypeDef,
    CreateFieldLevelEncryptionProfileResultTypeDef,
    CreateInvalidationResultTypeDef,
    CreateKeyGroupResultTypeDef,
    CreateMonitoringSubscriptionResultTypeDef,
    CreateOriginRequestPolicyResultTypeDef,
    CreatePublicKeyResultTypeDef,
    CreateRealtimeLogConfigResultTypeDef,
    CreateStreamingDistributionResultTypeDef,
    CreateStreamingDistributionWithTagsResultTypeDef,
    CustomErrorResponsesTypeDef,
    CustomErrorResponseTypeDef,
    CustomHeadersTypeDef,
    CustomOriginConfigTypeDef,
    DefaultCacheBehaviorTypeDef,
    DistributionConfigTypeDef,
    DistributionConfigWithTagsTypeDef,
    DistributionIdListTypeDef,
    DistributionListTypeDef,
    DistributionSummaryTypeDef,
    DistributionTypeDef,
    EncryptionEntitiesTypeDef,
    EncryptionEntityTypeDef,
    EndPointTypeDef,
    FieldLevelEncryptionConfigTypeDef,
    FieldLevelEncryptionListTypeDef,
    FieldLevelEncryptionProfileConfigTypeDef,
    FieldLevelEncryptionProfileListTypeDef,
    FieldLevelEncryptionProfileSummaryTypeDef,
    FieldLevelEncryptionProfileTypeDef,
    FieldLevelEncryptionSummaryTypeDef,
    FieldLevelEncryptionTypeDef,
    FieldPatternsTypeDef,
    ForwardedValuesTypeDef,
    GeoRestrictionTypeDef,
    GetCachePolicyConfigResultTypeDef,
    GetCachePolicyResultTypeDef,
    GetCloudFrontOriginAccessIdentityConfigResultTypeDef,
    GetCloudFrontOriginAccessIdentityResultTypeDef,
    GetDistributionConfigResultTypeDef,
    GetDistributionResultTypeDef,
    GetFieldLevelEncryptionConfigResultTypeDef,
    GetFieldLevelEncryptionProfileConfigResultTypeDef,
    GetFieldLevelEncryptionProfileResultTypeDef,
    GetFieldLevelEncryptionResultTypeDef,
    GetInvalidationResultTypeDef,
    GetKeyGroupConfigResultTypeDef,
    GetKeyGroupResultTypeDef,
    GetMonitoringSubscriptionResultTypeDef,
    GetOriginRequestPolicyConfigResultTypeDef,
    GetOriginRequestPolicyResultTypeDef,
    GetPublicKeyConfigResultTypeDef,
    GetPublicKeyResultTypeDef,
    GetRealtimeLogConfigResultTypeDef,
    GetStreamingDistributionConfigResultTypeDef,
    GetStreamingDistributionResultTypeDef,
    HeadersTypeDef,
    InvalidationBatchTypeDef,
    InvalidationListTypeDef,
    InvalidationSummaryTypeDef,
    InvalidationTypeDef,
    KeyGroupConfigTypeDef,
    KeyGroupListTypeDef,
    KeyGroupSummaryTypeDef,
    KeyGroupTypeDef,
    KeyPairIdsTypeDef,
    KGKeyPairIdsTypeDef,
    KinesisStreamConfigTypeDef,
    LambdaFunctionAssociationsTypeDef,
    LambdaFunctionAssociationTypeDef,
    ListCachePoliciesResultTypeDef,
    ListCloudFrontOriginAccessIdentitiesResultTypeDef,
    ListDistributionsByCachePolicyIdResultTypeDef,
    ListDistributionsByKeyGroupResultTypeDef,
    ListDistributionsByOriginRequestPolicyIdResultTypeDef,
    ListDistributionsByRealtimeLogConfigResultTypeDef,
    ListDistributionsByWebACLIdResultTypeDef,
    ListDistributionsResultTypeDef,
    ListFieldLevelEncryptionConfigsResultTypeDef,
    ListFieldLevelEncryptionProfilesResultTypeDef,
    ListInvalidationsResultTypeDef,
    ListKeyGroupsResultTypeDef,
    ListOriginRequestPoliciesResultTypeDef,
    ListPublicKeysResultTypeDef,
    ListRealtimeLogConfigsResultTypeDef,
    ListStreamingDistributionsResultTypeDef,
    ListTagsForResourceResultTypeDef,
    LoggingConfigTypeDef,
    MonitoringSubscriptionTypeDef,
    OriginCustomHeaderTypeDef,
    OriginGroupFailoverCriteriaTypeDef,
    OriginGroupMembersTypeDef,
    OriginGroupMemberTypeDef,
    OriginGroupsTypeDef,
    OriginGroupTypeDef,
    OriginRequestPolicyConfigTypeDef,
    OriginRequestPolicyCookiesConfigTypeDef,
    OriginRequestPolicyHeadersConfigTypeDef,
    OriginRequestPolicyListTypeDef,
    OriginRequestPolicyQueryStringsConfigTypeDef,
    OriginRequestPolicySummaryTypeDef,
    OriginRequestPolicyTypeDef,
    OriginShieldTypeDef,
    OriginSslProtocolsTypeDef,
    OriginsTypeDef,
    OriginTypeDef,
    PaginatorConfigTypeDef,
    ParametersInCacheKeyAndForwardedToOriginTypeDef,
    PathsTypeDef,
    PublicKeyConfigTypeDef,
    PublicKeyListTypeDef,
    PublicKeySummaryTypeDef,
    PublicKeyTypeDef,
    QueryArgProfileConfigTypeDef,
    QueryArgProfilesTypeDef,
    QueryArgProfileTypeDef,
    QueryStringCacheKeysTypeDef,
    QueryStringNamesTypeDef,
    RealtimeLogConfigsTypeDef,
    RealtimeLogConfigTypeDef,
    RealtimeMetricsSubscriptionConfigTypeDef,
    RestrictionsTypeDef,
    S3OriginConfigTypeDef,
    S3OriginTypeDef,
    SignerTypeDef,
    StatusCodesTypeDef,
    StreamingDistributionConfigTypeDef,
    StreamingDistributionConfigWithTagsTypeDef,
    StreamingDistributionListTypeDef,
    StreamingDistributionSummaryTypeDef,
    StreamingDistributionTypeDef,
    StreamingLoggingConfigTypeDef,
    TagKeysTypeDef,
    TagsTypeDef,
    TagTypeDef,
    TrustedKeyGroupsTypeDef,
    TrustedSignersTypeDef,
    UpdateCachePolicyResultTypeDef,
    UpdateCloudFrontOriginAccessIdentityResultTypeDef,
    UpdateDistributionResultTypeDef,
    UpdateFieldLevelEncryptionConfigResultTypeDef,
    UpdateFieldLevelEncryptionProfileResultTypeDef,
    UpdateKeyGroupResultTypeDef,
    UpdateOriginRequestPolicyResultTypeDef,
    UpdatePublicKeyResultTypeDef,
    UpdateRealtimeLogConfigResultTypeDef,
    UpdateStreamingDistributionResultTypeDef,
    ViewerCertificateTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> ActiveTrustedKeyGroupsTypeDef:
    return {
      ...
    }
```
