"use strict";
/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultCloudFrontWebDistributionForS3Props = exports.DefaultCloudFrontWebDistributionForApiGatewayProps = void 0;
const cloudfront = require("@aws-cdk/aws-cloudfront");
const cdk = require("@aws-cdk/core");
function DefaultCloudFrontWebDistributionForApiGatewayProps(apiEndPoint, loggingBucket, setHttpSecurityHeaders, edgeLambda) {
    const apiEndPointUrlWithoutProtocol = cdk.Fn.select(1, cdk.Fn.split("://", apiEndPoint.url));
    const apiEndPointDomainName = cdk.Fn.select(0, cdk.Fn.split("/", apiEndPointUrlWithoutProtocol));
    if (setHttpSecurityHeaders) {
        return {
            originConfigs: [{
                    customOriginSource: {
                        domainName: apiEndPointDomainName
                    },
                    behaviors: [{
                            isDefaultBehavior: true,
                            lambdaFunctionAssociations: [
                                {
                                    eventType: cloudfront.LambdaEdgeEventType.ORIGIN_RESPONSE,
                                    lambdaFunction: edgeLambda
                                }
                            ],
                        }],
                    originPath: `/${apiEndPoint.deploymentStage.stageName}`
                }],
            loggingConfig: {
                bucket: loggingBucket
            }
        };
    }
    else {
        return {
            originConfigs: [{
                    customOriginSource: {
                        domainName: apiEndPointDomainName
                    },
                    behaviors: [{
                            isDefaultBehavior: true
                        }],
                    originPath: `/${apiEndPoint.deploymentStage.stageName}`
                }],
            loggingConfig: {
                bucket: loggingBucket
            }
        };
    }
}
exports.DefaultCloudFrontWebDistributionForApiGatewayProps = DefaultCloudFrontWebDistributionForApiGatewayProps;
function DefaultCloudFrontWebDistributionForS3Props(sourceBucket, loggingBucket, _originAccessIdentity, setHttpSecurityHeaders, edgeLambda) {
    if (setHttpSecurityHeaders) {
        return {
            originConfigs: [{
                    s3OriginSource: {
                        s3BucketSource: sourceBucket,
                        originAccessIdentity: _originAccessIdentity
                    },
                    behaviors: [{
                            isDefaultBehavior: true,
                            lambdaFunctionAssociations: [
                                {
                                    eventType: cloudfront.LambdaEdgeEventType.ORIGIN_RESPONSE,
                                    lambdaFunction: edgeLambda
                                }
                            ]
                        }]
                }],
            loggingConfig: {
                bucket: loggingBucket
            }
        };
    }
    else {
        return {
            originConfigs: [{
                    s3OriginSource: {
                        s3BucketSource: sourceBucket,
                        originAccessIdentity: _originAccessIdentity
                    },
                    behaviors: [{
                            isDefaultBehavior: true,
                        }]
                }],
            loggingConfig: {
                bucket: loggingBucket
            }
        };
    }
}
exports.DefaultCloudFrontWebDistributionForS3Props = DefaultCloudFrontWebDistributionForS3Props;
//# sourceMappingURL=data:application/json;base64,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