"use strict";
/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildKinesisAnalyticsApp = void 0;
// Imports
const kinesisAnalytics = require("@aws-cdk/aws-kinesisanalytics");
const iam = require("@aws-cdk/aws-iam");
const defaults = require("./kinesis-analytics-defaults");
const utils_1 = require("./utils");
function buildKinesisAnalyticsApp(scope, props) {
    // Setup the IAM role for Kinesis Analytics
    const analyticsRole = new iam.Role(scope, 'KinesisAnalyticsRole', {
        assumedBy: new iam.ServicePrincipal('kinesisanalytics.amazonaws.com'),
    });
    // Setup the IAM policy for Kinesis Analytics
    const analyticsPolicy = new iam.Policy(scope, 'KinesisAnalyticsPolicy', {
        statements: [
            new iam.PolicyStatement({
                actions: [
                    'firehose:DescribeDeliveryStream',
                    'firehose:Get*'
                ],
                resources: [props.kinesisFirehose.attrArn]
            })
        ]
    });
    // Attach policy to role
    analyticsPolicy.attachToRole(analyticsRole);
    // Setup the Kinesis application properties
    const kinesisAnalyticsProps = utils_1.overrideProps(defaults.DefaultCfnApplicationProps, props.kinesisAnalyticsProps);
    kinesisAnalyticsProps.inputs[0].kinesisFirehoseInput = {
        resourceArn: props.kinesisFirehose.attrArn,
        roleArn: analyticsRole.roleArn
    };
    // Setup the Kinesis application and add dependencies
    const kinesisAnalyticsApp = new kinesisAnalytics.CfnApplication(scope, 'KinesisAnalytics', kinesisAnalyticsProps);
    kinesisAnalyticsApp.addDependsOn(analyticsPolicy.node.findChild('Resource'));
    // Create the application and return
    return kinesisAnalyticsApp;
}
exports.buildKinesisAnalyticsApp = buildKinesisAnalyticsApp;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia2luZXNpcy1hbmFseXRpY3MtaGVscGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsia2luZXNpcy1hbmFseXRpY3MtaGVscGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7Ozs7Ozs7Ozs7R0FXRzs7O0FBRUYsVUFBVTtBQUNWLGtFQUFrRTtBQUVsRSx3Q0FBd0M7QUFDeEMseURBQXlEO0FBRXpELG1DQUF3QztBQWlCeEMsU0FBZ0Isd0JBQXdCLENBQUMsS0FBb0IsRUFBRSxLQUFvQztJQUVoRywyQ0FBMkM7SUFDM0MsTUFBTSxhQUFhLEdBQUcsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxzQkFBc0IsRUFBRTtRQUM5RCxTQUFTLEVBQUUsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsZ0NBQWdDLENBQUM7S0FDeEUsQ0FBQyxDQUFDO0lBRUgsNkNBQTZDO0lBQzdDLE1BQU0sZUFBZSxHQUFHLElBQUksR0FBRyxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsd0JBQXdCLEVBQUU7UUFDcEUsVUFBVSxFQUFFO1lBQ1osSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO2dCQUNwQixPQUFPLEVBQUU7b0JBQ0wsaUNBQWlDO29CQUNqQyxlQUFlO2lCQUNsQjtnQkFDRCxTQUFTLEVBQUUsQ0FBQyxLQUFLLENBQUMsZUFBZSxDQUFDLE9BQU8sQ0FBQzthQUM3QyxDQUFDO1NBQ0w7S0FBQyxDQUFDLENBQUM7SUFFSix3QkFBd0I7SUFDeEIsZUFBZSxDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUU1QywyQ0FBMkM7SUFDM0MsTUFBTSxxQkFBcUIsR0FBRyxxQkFBYSxDQUFDLFFBQVEsQ0FBQywwQkFBMEIsRUFBRSxLQUFLLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUM5RyxxQkFBcUIsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsb0JBQW9CLEdBQUc7UUFDbkQsV0FBVyxFQUFFLEtBQUssQ0FBQyxlQUFlLENBQUMsT0FBTztRQUMxQyxPQUFPLEVBQUUsYUFBYSxDQUFDLE9BQU87S0FDakMsQ0FBQztJQUVGLHFEQUFxRDtJQUNyRCxNQUFNLG1CQUFtQixHQUFHLElBQUksZ0JBQWdCLENBQUMsY0FBYyxDQUFDLEtBQUssRUFBRSxrQkFBa0IsRUFBRSxxQkFBcUIsQ0FBQyxDQUFDO0lBQ2xILG1CQUFtQixDQUFDLFlBQVksQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQWtCLENBQUMsQ0FBQztJQUU5RixvQ0FBb0M7SUFDcEMsT0FBTyxtQkFBbUIsQ0FBQztBQUMvQixDQUFDO0FBbkNBLDREQW1DQSIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCAyMDIwIEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuIC8vIEltcG9ydHNcbiBpbXBvcnQgKiBhcyBraW5lc2lzQW5hbHl0aWNzIGZyb20gJ0Bhd3MtY2RrL2F3cy1raW5lc2lzYW5hbHl0aWNzJztcbiBpbXBvcnQgKiBhcyBraW5lc2lzRmlyZWhvc2UgZnJvbSAnQGF3cy1jZGsvYXdzLWtpbmVzaXNmaXJlaG9zZSc7XG4gaW1wb3J0ICogYXMgaWFtIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuIGltcG9ydCAqIGFzIGRlZmF1bHRzIGZyb20gJy4va2luZXNpcy1hbmFseXRpY3MtZGVmYXVsdHMnO1xuIGltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbiBpbXBvcnQgeyBvdmVycmlkZVByb3BzIH0gZnJvbSAnLi91dGlscyc7XG5cbiBleHBvcnQgaW50ZXJmYWNlIEJ1aWxkS2luZXNpc0FuYWx5dGljc0FwcFByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBraW5lc2lzRmlyZWhvc2U6IGtpbmVzaXNGaXJlaG9zZS5DZm5EZWxpdmVyeVN0cmVhbVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgIHJlYWRvbmx5IGtpbmVzaXNBbmFseXRpY3NQcm9wcz86IGtpbmVzaXNBbmFseXRpY3MuQ2ZuQXBwbGljYXRpb25Qcm9wcyB8IGFueVxuIH1cblxuIGV4cG9ydCBmdW5jdGlvbiBidWlsZEtpbmVzaXNBbmFseXRpY3NBcHAoc2NvcGU6IGNkay5Db25zdHJ1Y3QsIHByb3BzOiBCdWlsZEtpbmVzaXNBbmFseXRpY3NBcHBQcm9wcyk6IGtpbmVzaXNBbmFseXRpY3MuQ2ZuQXBwbGljYXRpb24ge1xuXG4gICAgLy8gU2V0dXAgdGhlIElBTSByb2xlIGZvciBLaW5lc2lzIEFuYWx5dGljc1xuICAgIGNvbnN0IGFuYWx5dGljc1JvbGUgPSBuZXcgaWFtLlJvbGUoc2NvcGUsICdLaW5lc2lzQW5hbHl0aWNzUm9sZScsIHtcbiAgICAgICAgYXNzdW1lZEJ5OiBuZXcgaWFtLlNlcnZpY2VQcmluY2lwYWwoJ2tpbmVzaXNhbmFseXRpY3MuYW1hem9uYXdzLmNvbScpLFxuICAgIH0pO1xuXG4gICAgLy8gU2V0dXAgdGhlIElBTSBwb2xpY3kgZm9yIEtpbmVzaXMgQW5hbHl0aWNzXG4gICAgY29uc3QgYW5hbHl0aWNzUG9saWN5ID0gbmV3IGlhbS5Qb2xpY3koc2NvcGUsICdLaW5lc2lzQW5hbHl0aWNzUG9saWN5Jywge1xuICAgICAgICBzdGF0ZW1lbnRzOiBbXG4gICAgICAgIG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICAgIGFjdGlvbnM6IFtcbiAgICAgICAgICAgICAgICAnZmlyZWhvc2U6RGVzY3JpYmVEZWxpdmVyeVN0cmVhbScsXG4gICAgICAgICAgICAgICAgJ2ZpcmVob3NlOkdldConXG4gICAgICAgICAgICBdLFxuICAgICAgICAgICAgcmVzb3VyY2VzOiBbcHJvcHMua2luZXNpc0ZpcmVob3NlLmF0dHJBcm5dXG4gICAgICAgIH0pXG4gICAgXX0pO1xuXG4gICAgLy8gQXR0YWNoIHBvbGljeSB0byByb2xlXG4gICAgYW5hbHl0aWNzUG9saWN5LmF0dGFjaFRvUm9sZShhbmFseXRpY3NSb2xlKTtcblxuICAgIC8vIFNldHVwIHRoZSBLaW5lc2lzIGFwcGxpY2F0aW9uIHByb3BlcnRpZXNcbiAgICBjb25zdCBraW5lc2lzQW5hbHl0aWNzUHJvcHMgPSBvdmVycmlkZVByb3BzKGRlZmF1bHRzLkRlZmF1bHRDZm5BcHBsaWNhdGlvblByb3BzLCBwcm9wcy5raW5lc2lzQW5hbHl0aWNzUHJvcHMpO1xuICAgIGtpbmVzaXNBbmFseXRpY3NQcm9wcy5pbnB1dHNbMF0ua2luZXNpc0ZpcmVob3NlSW5wdXQgPSB7XG4gICAgICAgIHJlc291cmNlQXJuOiBwcm9wcy5raW5lc2lzRmlyZWhvc2UuYXR0ckFybixcbiAgICAgICAgcm9sZUFybjogYW5hbHl0aWNzUm9sZS5yb2xlQXJuXG4gICAgfTtcblxuICAgIC8vIFNldHVwIHRoZSBLaW5lc2lzIGFwcGxpY2F0aW9uIGFuZCBhZGQgZGVwZW5kZW5jaWVzXG4gICAgY29uc3Qga2luZXNpc0FuYWx5dGljc0FwcCA9IG5ldyBraW5lc2lzQW5hbHl0aWNzLkNmbkFwcGxpY2F0aW9uKHNjb3BlLCAnS2luZXNpc0FuYWx5dGljcycsIGtpbmVzaXNBbmFseXRpY3NQcm9wcyk7XG4gICAga2luZXNpc0FuYWx5dGljc0FwcC5hZGREZXBlbmRzT24oYW5hbHl0aWNzUG9saWN5Lm5vZGUuZmluZENoaWxkKCdSZXNvdXJjZScpIGFzIGlhbS5DZm5Qb2xpY3kpO1xuXG4gICAgLy8gQ3JlYXRlIHRoZSBhcHBsaWNhdGlvbiBhbmQgcmV0dXJuXG4gICAgcmV0dXJuIGtpbmVzaXNBbmFseXRpY3NBcHA7XG59Il19