"use strict";
/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisEventSourceProps = exports.S3EventSourceProps = exports.DynamoEventSourceProps = void 0;
const lambda = require("@aws-cdk/aws-lambda");
const utils_1 = require("./utils");
const aws_lambda_event_sources_1 = require("@aws-cdk/aws-lambda-event-sources");
const s3 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const sqs_helper_1 = require("./sqs-helper");
function DynamoEventSourceProps(scope, _dynamoEventSourceProps) {
    const baseProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON,
        bisectBatchOnError: true,
        maxRecordAge: core_1.Duration.hours(24),
        retryAttempts: 500
    };
    let extraProps = {};
    if (_dynamoEventSourceProps === undefined || (_dynamoEventSourceProps === null || _dynamoEventSourceProps === void 0 ? void 0 : _dynamoEventSourceProps.deploySqsDlqQueue) === undefined
        || _dynamoEventSourceProps.deploySqsDlqQueue) {
        const [sqsQueue] = sqs_helper_1.buildQueue(scope, 'SqsDlqQueue', {
            queueProps: _dynamoEventSourceProps === null || _dynamoEventSourceProps === void 0 ? void 0 : _dynamoEventSourceProps.sqsDlqQueueProps
        });
        extraProps = {
            onFailure: new aws_lambda_event_sources_1.SqsDlq(sqsQueue),
        };
    }
    const defaultDynamoEventSourceProps = Object.assign(baseProps, extraProps);
    if (_dynamoEventSourceProps === null || _dynamoEventSourceProps === void 0 ? void 0 : _dynamoEventSourceProps.eventSourceProps) {
        return utils_1.overrideProps(defaultDynamoEventSourceProps, _dynamoEventSourceProps.eventSourceProps);
    }
    else {
        return defaultDynamoEventSourceProps;
    }
}
exports.DynamoEventSourceProps = DynamoEventSourceProps;
function S3EventSourceProps(_s3EventSourceProps) {
    const defaultS3EventSourceProps = {
        events: [s3.EventType.OBJECT_CREATED]
    };
    if (_s3EventSourceProps) {
        return utils_1.overrideProps(defaultS3EventSourceProps, _s3EventSourceProps, false);
    }
    else {
        return defaultS3EventSourceProps;
    }
}
exports.S3EventSourceProps = S3EventSourceProps;
function KinesisEventSourceProps(scope, _kinesisEventSourceProps) {
    const baseProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON,
        bisectBatchOnError: true,
        maxRecordAge: core_1.Duration.hours(24),
        retryAttempts: 500
    };
    let extraProps = {};
    if (_kinesisEventSourceProps === undefined || (_kinesisEventSourceProps === null || _kinesisEventSourceProps === void 0 ? void 0 : _kinesisEventSourceProps.deploySqsDlqQueue) === undefined
        || _kinesisEventSourceProps.deploySqsDlqQueue) {
        const [sqsQueue] = sqs_helper_1.buildQueue(scope, 'SqsDlqQueue', {
            queueProps: _kinesisEventSourceProps === null || _kinesisEventSourceProps === void 0 ? void 0 : _kinesisEventSourceProps.sqsDlqQueueProps
        });
        extraProps = {
            onFailure: new aws_lambda_event_sources_1.SqsDlq(sqsQueue),
        };
    }
    const defaultKinesisEventSourceProps = Object.assign(baseProps, extraProps);
    if (_kinesisEventSourceProps === null || _kinesisEventSourceProps === void 0 ? void 0 : _kinesisEventSourceProps.eventSourceProps) {
        return utils_1.overrideProps(defaultKinesisEventSourceProps, _kinesisEventSourceProps.eventSourceProps);
    }
    else {
        return defaultKinesisEventSourceProps;
    }
}
exports.KinesisEventSourceProps = KinesisEventSourceProps;
//# sourceMappingURL=data:application/json;base64,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