"use strict";
/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const iot = require("@aws-cdk/aws-iot");
const lambda = require("@aws-cdk/aws-lambda");
const defaults = require("../index");
const utils_1 = require("../lib/utils");
require("@aws-cdk/assert/jest");
test('snapshot test TopicRuleProps default params', () => {
    const stack = new core_1.Stack();
    const lambdaFunctionProps = {
        runtime: lambda.Runtime.NODEJS_12_X,
        handler: 'index.handler',
        code: lambda.Code.fromAsset(`${__dirname}/lambda`)
    };
    const fn = new lambda.Function(stack, 'LambdaFunction', lambdaFunctionProps);
    const defaultIotTopicProps = defaults.DefaultCfnTopicRuleProps([{
            lambda: {
                functionArn: fn.functionArn
            }
        }], "SELECT * FROM 'topic/#'");
    new iot.CfnTopicRule(stack, 'IotTopic', defaultIotTopicProps);
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
test('test TopicRuleProps override sql and description', () => {
    const stack = new core_1.Stack();
    const action1 = {
        lambda: {
            functionArn: 'xyz'
        }
    };
    const defaultProps = defaults.DefaultCfnTopicRuleProps([action1]);
    const inProps = {
        topicRulePayload: {
            ruleDisabled: true,
            description: "Processing of vehicle messages",
            sql: "SELECT * FROM 'connectedcar/#'",
            actions: []
        }
    };
    const outProps = utils_1.overrideProps(defaultProps, inProps, true);
    new iot.CfnTopicRule(stack, 'IotTopic', outProps);
    expect(stack).toHaveResource('AWS::IoT::TopicRule', {
        TopicRulePayload: {
            Actions: [
                {
                    Lambda: {
                        FunctionArn: "xyz"
                    }
                }
            ],
            Description: "Processing of vehicle messages",
            RuleDisabled: true,
            Sql: "SELECT * FROM 'connectedcar/#'"
        }
    });
});
test('test TopicRuleProps override actions', () => {
    const stack = new core_1.Stack();
    const defaultProps = defaults.DefaultCfnTopicRuleProps([], '');
    const action = {
        lambda: {
            functionArn: 'abc'
        }
    };
    const inProps = {
        topicRulePayload: {
            ruleDisabled: true,
            sql: '',
            actions: [action]
        }
    };
    const outProps = utils_1.overrideProps(defaultProps, inProps);
    new iot.CfnTopicRule(stack, 'IotTopic', outProps);
    expect(stack).toHaveResource('AWS::IoT::TopicRule', {
        TopicRulePayload: {
            Actions: [
                {
                    Lambda: {
                        FunctionArn: "abc"
                    }
                }
            ],
            RuleDisabled: true,
            Sql: ""
        }
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW90LXJ1bGUudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImlvdC1ydWxlLnRlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7Ozs7OztHQVdHOztBQUVILDRDQUE2QztBQUM3Qyx3Q0FBc0M7QUFDdEMsd0NBQXdDO0FBQ3hDLDhDQUE4QztBQUM5QyxxQ0FBcUM7QUFDckMsd0NBQTZDO0FBQzdDLGdDQUE4QjtBQUU5QixJQUFJLENBQUMsNkNBQTZDLEVBQUUsR0FBRyxFQUFFO0lBQ3JELE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxFQUFFLENBQUM7SUFFMUIsTUFBTSxtQkFBbUIsR0FBeUI7UUFDaEQsT0FBTyxFQUFFLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVztRQUNuQyxPQUFPLEVBQUUsZUFBZTtRQUN4QixJQUFJLEVBQUUsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsR0FBRyxTQUFTLFNBQVMsQ0FBQztLQUNuRCxDQUFDO0lBRUYsTUFBTSxFQUFFLEdBQUcsSUFBSSxNQUFNLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBRSxnQkFBZ0IsRUFBRSxtQkFBbUIsQ0FBQyxDQUFDO0lBRTdFLE1BQU0sb0JBQW9CLEdBQUcsUUFBUSxDQUFDLHdCQUF3QixDQUFDLENBQUM7WUFDNUQsTUFBTSxFQUFFO2dCQUNOLFdBQVcsRUFBRSxFQUFFLENBQUMsV0FBVzthQUM1QjtTQUNGLENBQUMsRUFBRSx5QkFBeUIsQ0FBQyxDQUFDO0lBQ2pDLElBQUksR0FBRyxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUUsVUFBVSxFQUFFLG9CQUFvQixDQUFDLENBQUM7SUFDOUQsTUFBTSxDQUFDLG1CQUFVLENBQUMsZ0JBQWdCLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxlQUFlLEVBQUUsQ0FBQztBQUNqRSxDQUFDLENBQUMsQ0FBQztBQUVILElBQUksQ0FBQyxrREFBa0QsRUFBRSxHQUFHLEVBQUU7SUFDMUQsTUFBTSxLQUFLLEdBQUcsSUFBSSxZQUFLLEVBQUUsQ0FBQztJQUUxQixNQUFNLE9BQU8sR0FBb0M7UUFDN0MsTUFBTSxFQUFFO1lBQ04sV0FBVyxFQUFFLEtBQUs7U0FDbkI7S0FDSixDQUFDO0lBRUYsTUFBTSxZQUFZLEdBQTBCLFFBQVEsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFFekYsTUFBTSxPQUFPLEdBQTBCO1FBQ25DLGdCQUFnQixFQUFFO1lBQ2QsWUFBWSxFQUFFLElBQUk7WUFDbEIsV0FBVyxFQUFFLGdDQUFnQztZQUM3QyxHQUFHLEVBQUUsZ0NBQWdDO1lBQ3JDLE9BQU8sRUFBRSxFQUFFO1NBQ2Q7S0FDSixDQUFDO0lBRUYsTUFBTSxRQUFRLEdBQUcscUJBQWEsQ0FBQyxZQUFZLEVBQUUsT0FBTyxFQUFFLElBQUksQ0FBQyxDQUFDO0lBRTVELElBQUksR0FBRyxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUUsVUFBVSxFQUFFLFFBQVEsQ0FBQyxDQUFDO0lBRWxELE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxjQUFjLENBQUMscUJBQXFCLEVBQUU7UUFDaEQsZ0JBQWdCLEVBQUU7WUFDaEIsT0FBTyxFQUFFO2dCQUNQO29CQUNJLE1BQU0sRUFBRTt3QkFDTixXQUFXLEVBQUUsS0FBSztxQkFDbkI7aUJBQ0o7YUFDRjtZQUNELFdBQVcsRUFBRSxnQ0FBZ0M7WUFDN0MsWUFBWSxFQUFFLElBQUk7WUFDbEIsR0FBRyxFQUFFLGdDQUFnQztTQUN0QztLQUNKLENBQUMsQ0FBQztBQUNQLENBQUMsQ0FBQyxDQUFDO0FBRUgsSUFBSSxDQUFDLHNDQUFzQyxFQUFFLEdBQUcsRUFBRTtJQUM5QyxNQUFNLEtBQUssR0FBRyxJQUFJLFlBQUssRUFBRSxDQUFDO0lBRTFCLE1BQU0sWUFBWSxHQUEwQixRQUFRLENBQUMsd0JBQXdCLENBQUMsRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBRXRGLE1BQU0sTUFBTSxHQUFvQztRQUM1QyxNQUFNLEVBQUU7WUFDTixXQUFXLEVBQUUsS0FBSztTQUNuQjtLQUNKLENBQUM7SUFFRixNQUFNLE9BQU8sR0FBMEI7UUFDbkMsZ0JBQWdCLEVBQUU7WUFDZCxZQUFZLEVBQUUsSUFBSTtZQUNsQixHQUFHLEVBQUUsRUFBRTtZQUNQLE9BQU8sRUFBRSxDQUFDLE1BQU0sQ0FBQztTQUNwQjtLQUNKLENBQUM7SUFFRixNQUFNLFFBQVEsR0FBRyxxQkFBYSxDQUFDLFlBQVksRUFBRSxPQUFPLENBQUMsQ0FBQztJQUV0RCxJQUFJLEdBQUcsQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLFVBQVUsRUFBRSxRQUFRLENBQUMsQ0FBQztJQUVsRCxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsY0FBYyxDQUFDLHFCQUFxQixFQUFFO1FBQ2hELGdCQUFnQixFQUFFO1lBQ2hCLE9BQU8sRUFBRTtnQkFDUDtvQkFDSSxNQUFNLEVBQUU7d0JBQ04sV0FBVyxFQUFFLEtBQUs7cUJBQ25CO2lCQUNKO2FBQ0Y7WUFDRCxZQUFZLEVBQUUsSUFBSTtZQUNsQixHQUFHLEVBQUUsRUFBRTtTQUNSO0tBQ0osQ0FBQyxDQUFDO0FBQ1AsQ0FBQyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqICBDb3B5cmlnaHQgMjAyMCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbmltcG9ydCB7IFN5bnRoVXRpbHMgfSBmcm9tICdAYXdzLWNkay9hc3NlcnQnO1xuaW1wb3J0IHsgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIGlvdCBmcm9tICdAYXdzLWNkay9hd3MtaW90JztcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIGRlZmF1bHRzIGZyb20gJy4uL2luZGV4JztcbmltcG9ydCB7IG92ZXJyaWRlUHJvcHMgfSBmcm9tICcuLi9saWIvdXRpbHMnO1xuaW1wb3J0ICdAYXdzLWNkay9hc3NlcnQvamVzdCc7XG5cbnRlc3QoJ3NuYXBzaG90IHRlc3QgVG9waWNSdWxlUHJvcHMgZGVmYXVsdCBwYXJhbXMnLCAoKSA9PiB7XG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soKTtcblxuICAgIGNvbnN0IGxhbWJkYUZ1bmN0aW9uUHJvcHM6IGxhbWJkYS5GdW5jdGlvblByb3BzID0ge1xuICAgICAgcnVudGltZTogbGFtYmRhLlJ1bnRpbWUuTk9ERUpTXzEyX1gsXG4gICAgICBoYW5kbGVyOiAnaW5kZXguaGFuZGxlcicsXG4gICAgICBjb2RlOiBsYW1iZGEuQ29kZS5mcm9tQXNzZXQoYCR7X19kaXJuYW1lfS9sYW1iZGFgKVxuICAgIH07XG5cbiAgICBjb25zdCBmbiA9IG5ldyBsYW1iZGEuRnVuY3Rpb24oc3RhY2ssICdMYW1iZGFGdW5jdGlvbicsIGxhbWJkYUZ1bmN0aW9uUHJvcHMpO1xuXG4gICAgY29uc3QgZGVmYXVsdElvdFRvcGljUHJvcHMgPSBkZWZhdWx0cy5EZWZhdWx0Q2ZuVG9waWNSdWxlUHJvcHMoW3tcbiAgICAgICAgbGFtYmRhOiB7XG4gICAgICAgICAgZnVuY3Rpb25Bcm46IGZuLmZ1bmN0aW9uQXJuXG4gICAgICAgIH1cbiAgICAgIH1dLCBcIlNFTEVDVCAqIEZST00gJ3RvcGljLyMnXCIpO1xuICAgIG5ldyBpb3QuQ2ZuVG9waWNSdWxlKHN0YWNrLCAnSW90VG9waWMnLCBkZWZhdWx0SW90VG9waWNQcm9wcyk7XG4gICAgZXhwZWN0KFN5bnRoVXRpbHMudG9DbG91ZEZvcm1hdGlvbihzdGFjaykpLnRvTWF0Y2hTbmFwc2hvdCgpO1xufSk7XG5cbnRlc3QoJ3Rlc3QgVG9waWNSdWxlUHJvcHMgb3ZlcnJpZGUgc3FsIGFuZCBkZXNjcmlwdGlvbicsICgpID0+IHtcbiAgICBjb25zdCBzdGFjayA9IG5ldyBTdGFjaygpO1xuXG4gICAgY29uc3QgYWN0aW9uMTogaW90LkNmblRvcGljUnVsZS5BY3Rpb25Qcm9wZXJ0eSA9IHtcbiAgICAgICAgbGFtYmRhOiB7XG4gICAgICAgICAgZnVuY3Rpb25Bcm46ICd4eXonXG4gICAgICAgIH1cbiAgICB9O1xuXG4gICAgY29uc3QgZGVmYXVsdFByb3BzOiBpb3QuQ2ZuVG9waWNSdWxlUHJvcHMgPSBkZWZhdWx0cy5EZWZhdWx0Q2ZuVG9waWNSdWxlUHJvcHMoW2FjdGlvbjFdKTtcblxuICAgIGNvbnN0IGluUHJvcHM6IGlvdC5DZm5Ub3BpY1J1bGVQcm9wcyA9IHtcbiAgICAgICAgdG9waWNSdWxlUGF5bG9hZDoge1xuICAgICAgICAgICAgcnVsZURpc2FibGVkOiB0cnVlLFxuICAgICAgICAgICAgZGVzY3JpcHRpb246IFwiUHJvY2Vzc2luZyBvZiB2ZWhpY2xlIG1lc3NhZ2VzXCIsXG4gICAgICAgICAgICBzcWw6IFwiU0VMRUNUICogRlJPTSAnY29ubmVjdGVkY2FyLyMnXCIsXG4gICAgICAgICAgICBhY3Rpb25zOiBbXVxuICAgICAgICB9XG4gICAgfTtcblxuICAgIGNvbnN0IG91dFByb3BzID0gb3ZlcnJpZGVQcm9wcyhkZWZhdWx0UHJvcHMsIGluUHJvcHMsIHRydWUpO1xuXG4gICAgbmV3IGlvdC5DZm5Ub3BpY1J1bGUoc3RhY2ssICdJb3RUb3BpYycsIG91dFByb3BzKTtcblxuICAgIGV4cGVjdChzdGFjaykudG9IYXZlUmVzb3VyY2UoJ0FXUzo6SW9UOjpUb3BpY1J1bGUnLCB7XG4gICAgICAgIFRvcGljUnVsZVBheWxvYWQ6IHtcbiAgICAgICAgICBBY3Rpb25zOiBbXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgTGFtYmRhOiB7XG4gICAgICAgICAgICAgICAgICBGdW5jdGlvbkFybjogXCJ4eXpcIlxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICBdLFxuICAgICAgICAgIERlc2NyaXB0aW9uOiBcIlByb2Nlc3Npbmcgb2YgdmVoaWNsZSBtZXNzYWdlc1wiLFxuICAgICAgICAgIFJ1bGVEaXNhYmxlZDogdHJ1ZSxcbiAgICAgICAgICBTcWw6IFwiU0VMRUNUICogRlJPTSAnY29ubmVjdGVkY2FyLyMnXCJcbiAgICAgICAgfVxuICAgIH0pO1xufSk7XG5cbnRlc3QoJ3Rlc3QgVG9waWNSdWxlUHJvcHMgb3ZlcnJpZGUgYWN0aW9ucycsICgpID0+IHtcbiAgICBjb25zdCBzdGFjayA9IG5ldyBTdGFjaygpO1xuXG4gICAgY29uc3QgZGVmYXVsdFByb3BzOiBpb3QuQ2ZuVG9waWNSdWxlUHJvcHMgPSBkZWZhdWx0cy5EZWZhdWx0Q2ZuVG9waWNSdWxlUHJvcHMoW10sICcnKTtcblxuICAgIGNvbnN0IGFjdGlvbjogaW90LkNmblRvcGljUnVsZS5BY3Rpb25Qcm9wZXJ0eSA9IHtcbiAgICAgICAgbGFtYmRhOiB7XG4gICAgICAgICAgZnVuY3Rpb25Bcm46ICdhYmMnXG4gICAgICAgIH1cbiAgICB9O1xuXG4gICAgY29uc3QgaW5Qcm9wczogaW90LkNmblRvcGljUnVsZVByb3BzID0ge1xuICAgICAgICB0b3BpY1J1bGVQYXlsb2FkOiB7XG4gICAgICAgICAgICBydWxlRGlzYWJsZWQ6IHRydWUsXG4gICAgICAgICAgICBzcWw6ICcnLFxuICAgICAgICAgICAgYWN0aW9uczogW2FjdGlvbl1cbiAgICAgICAgfVxuICAgIH07XG5cbiAgICBjb25zdCBvdXRQcm9wcyA9IG92ZXJyaWRlUHJvcHMoZGVmYXVsdFByb3BzLCBpblByb3BzKTtcblxuICAgIG5ldyBpb3QuQ2ZuVG9waWNSdWxlKHN0YWNrLCAnSW90VG9waWMnLCBvdXRQcm9wcyk7XG5cbiAgICBleHBlY3Qoc3RhY2spLnRvSGF2ZVJlc291cmNlKCdBV1M6OklvVDo6VG9waWNSdWxlJywge1xuICAgICAgICBUb3BpY1J1bGVQYXlsb2FkOiB7XG4gICAgICAgICAgQWN0aW9uczogW1xuICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgIExhbWJkYToge1xuICAgICAgICAgICAgICAgICAgRnVuY3Rpb25Bcm46IFwiYWJjXCJcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgXSxcbiAgICAgICAgICBSdWxlRGlzYWJsZWQ6IHRydWUsXG4gICAgICAgICAgU3FsOiBcIlwiXG4gICAgICAgIH1cbiAgICB9KTtcbn0pO1xuIl19