"use strict";
/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const kinesisFirehose = require("@aws-cdk/aws-kinesisfirehose");
const defaults = require("../");
const assert_1 = require("@aws-cdk/assert");
require("@aws-cdk/assert/jest");
// --------------------------------------------------------------
// Test default functionality
// --------------------------------------------------------------
test('Test default functionality', () => {
    // Setup the stack
    const stack = new core_1.Stack();
    const firehose = new kinesisFirehose.CfnDeliveryStream(stack, 'KinesisFirehose');
    // Setup the Kinesis Analytics application
    defaults.buildKinesisAnalyticsApp(stack, {
        kinesisFirehose: firehose,
        kinesisAnalyticsProps: {
            inputs: [{
                    inputSchema: {
                        recordColumns: [{
                                name: 'ticker_symbol',
                                sqlType: 'VARCHAR(4)',
                                mapping: '$.ticker_symbol'
                            }, {
                                name: 'sector',
                                sqlType: 'VARCHAR(16)',
                                mapping: '$.sector'
                            }, {
                                name: 'change',
                                sqlType: 'REAL',
                                mapping: '$.change'
                            }, {
                                name: 'price',
                                sqlType: 'REAL',
                                mapping: '$.price'
                            }],
                        recordFormat: {
                            recordFormatType: 'JSON'
                        },
                        recordEncoding: 'UTF-8'
                    },
                    namePrefix: 'SOURCE_SQL_STREAM'
                }]
        }
    });
    // Assertions
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
//# sourceMappingURL=data:application/json;base64,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