"use strict";
/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const kinesisfirehose = require("@aws-cdk/aws-kinesisfirehose");
const defaults = require("../index");
const utils_1 = require("../lib/utils");
require("@aws-cdk/assert/jest");
test('snapshot test kinesisfirehose default params', () => {
    const stack = new core_1.Stack();
    new kinesisfirehose.CfnDeliveryStream(stack, 'KinesisFirehose', defaults.DefaultCfnDeliveryStreamProps('bucket_arn', 'role_arn', 'log_group', 'log_stream'));
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
test('test kinesisanalytics override buffer conditions', () => {
    const stack = new core_1.Stack();
    const inProps = {
        extendedS3DestinationConfiguration: {
            bufferingHints: {
                intervalInSeconds: 600,
                sizeInMBs: 10
            },
        }
    };
    const defaultProps = defaults.DefaultCfnDeliveryStreamProps('bucket_arn', 'role_arn', 'log_group', 'log_stream');
    const outProps = utils_1.overrideProps(defaultProps, inProps);
    new kinesisfirehose.CfnDeliveryStream(stack, 'KinesisFirehose', outProps);
    expect(stack).toHaveResource("AWS::KinesisFirehose::DeliveryStream", {
        ExtendedS3DestinationConfiguration: {
            BucketARN: "bucket_arn",
            BufferingHints: {
                IntervalInSeconds: 600,
                SizeInMBs: 10
            },
            CloudWatchLoggingOptions: {
                Enabled: true,
                LogGroupName: "log_group",
                LogStreamName: "log_stream"
            },
            CompressionFormat: "GZIP",
            RoleARN: "role_arn"
        }
    });
});
//# sourceMappingURL=data:application/json;base64,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