import { DocumentationLanguage } from './language';
/**
 * Key prefix for the package data storage.
 */
export declare const STORAGE_KEY_PREFIX = "data/";
/**
 * Key suffix for storing npm package bundles.
 */
export declare const PACKAGE_KEY_SUFFIX = "/package.tgz";
/**
 * Key suffix for storing npm package metadata.
 */
export declare const METADATA_KEY_SUFFIX = "/metadata.json";
/**
 * The key suffix for (TypeScript) assembly files
 */
export declare const ASSEMBLY_KEY_SUFFIX = "/assembly.json";
/**
 * The key suffix for a TypeScript doc artifact (root module).
 */
export declare const DOCS_KEY_SUFFIX_TYPESCRIPT: string;
/**
 * The key suffix for a Python doc artifact (root module).
 */
export declare const DOCS_KEY_SUFFIX_PYTHON: string;
/**
 * The key suffix matching any documentation artifact.
 */
export declare const DOCS_KEY_SUFFIX_ANY: string;
/**
 * The key suffix for documentation artifacts by language and submodule.
 */
export declare function docsKeySuffix(lang?: DocumentationLanguage | '*', submodule?: string): string;
/**
 * The key for the catalog document.
 */
export declare const CATALOG_KEY = "catalog.json";
/**
 * A regular expression that can be used to parse out a storage key.
 */
export declare const STORAGE_KEY_FORMAT_REGEX: RegExp;
/**
 * A list of case-normalized (upper) SPDX license identifiers that are deemed
 * eligible for listing on the Construct Hub.
 *
 * @see https://github.com/cdklabs/construct-hub/issues/145
 */
export declare const ELIGIBLE_LICENSES: ReadonlySet<string>;
