"use strict";
/*
 * IMPORTANT: This file is used both by bundled lambda functions and by
 * constructs. This means it should not directly or transitively import anything
 * not part of the package's `dependencies`, such as the `aws-sdk`.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ELIGIBLE_LICENSES = exports.STORAGE_KEY_FORMAT_REGEX = exports.CATALOG_KEY = exports.docsKeySuffix = exports.DOCS_KEY_SUFFIX_ANY = exports.DOCS_KEY_SUFFIX_PYTHON = exports.DOCS_KEY_SUFFIX_TYPESCRIPT = exports.ASSEMBLY_KEY_SUFFIX = exports.METADATA_KEY_SUFFIX = exports.PACKAGE_KEY_SUFFIX = exports.STORAGE_KEY_PREFIX = void 0;
const language_1 = require("./language");
/**
 * Key prefix for the package data storage.
 */
exports.STORAGE_KEY_PREFIX = 'data/';
/**
 * Key suffix for storing npm package bundles.
 */
exports.PACKAGE_KEY_SUFFIX = '/package.tgz';
/**
 * Key suffix for storing npm package metadata.
 */
exports.METADATA_KEY_SUFFIX = '/metadata.json';
/**
 * The key suffix for (TypeScript) assembly files
 */
exports.ASSEMBLY_KEY_SUFFIX = '/assembly.json';
/**
 * The key suffix for a TypeScript doc artifact (root module).
 */
exports.DOCS_KEY_SUFFIX_TYPESCRIPT = docsKeySuffix(language_1.DocumentationLanguage.TYPESCRIPT);
/**
 * The key suffix for a Python doc artifact (root module).
 */
exports.DOCS_KEY_SUFFIX_PYTHON = docsKeySuffix(language_1.DocumentationLanguage.PYTHON);
/**
 * The key suffix matching any documentation artifact.
 */
exports.DOCS_KEY_SUFFIX_ANY = docsKeySuffix('*');
/**
 * The key suffix for documentation artifacts by language and submodule.
 */
function docsKeySuffix(lang, submodule) {
    return `/docs-${submodule ? `${submodule}-` : ''}${lang}.md`;
}
exports.docsKeySuffix = docsKeySuffix;
/**
 * The key for the catalog document.
 */
exports.CATALOG_KEY = 'catalog.json';
/**
 * A regular expression that can be used to parse out a storage key.
 */
exports.STORAGE_KEY_FORMAT_REGEX = new RegExp(`^${exports.STORAGE_KEY_PREFIX}((?:@[^/]+/)?[^/]+)/v([^/]+)/.*$`);
// Capture groups:                                                        ┗━━━━━━━━1━━━━━━━━┛  ┗━━2━━┛
/**
 * A list of case-normalized (upper) SPDX license identifiers that are deemed
 * eligible for listing on the Construct Hub.
 *
 * @see https://github.com/cdklabs/construct-hub/issues/145
 */
exports.ELIGIBLE_LICENSES = new Set([
    // Apache Licenses
    'Apache-1.0',
    'Apache-1.1',
    'Apache-2.0',
    // BSD Licenses
    '0BSD',
    'BSD-1-Clause',
    'BSD-2-Clause',
    'BSD-2-Clause-Patent',
    'BSD-2-Clause-Views',
    'BSD-3-Clause',
    'BSD-3-Clause-Attribution',
    'BSD-3-Clause-Clear',
    'BSD-3-Clause-LBNL',
    'BSD-3-Clause-Modification',
    'BSD-3-Clause-No-Military-License',
    'BSD-3-Clause-No-Nuclear-License',
    'BSD-3-Clause-No-Nuclear-License-2014',
    'BSD-3-Clause-No-Nuclear-Warranty',
    'BSD-3-Clause-Open-MPI',
    'BSD-4-Clause',
    'BSD-4-Clause-Shortened',
    'BSD-4-Clause-UC',
    'BSD-Protection',
    'BSD-Source-Code',
    // MIT Licenses
    'MIT',
    'MIT-0',
    'MIT-advertising',
    'MIT-CMU',
    'MIT-enna',
    'MIT-feh',
    'MIT-Modern-Variant',
    'MIT-open-group',
    'MITNFA',
].map((s) => s.toUpperCase()));
//# sourceMappingURL=data:application/json;base64,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