import { IAlarm } from '@aws-cdk/aws-cloudwatch';
import { GatewayVpcEndpoint, InterfaceVpcEndpoint, IVpc, SubnetSelection } from '@aws-cdk/aws-ec2';
import { RetentionDays } from '@aws-cdk/aws-logs';
import { Bucket } from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import { Repository } from '../../codeartifact/repository';
import { Monitoring } from '../../monitoring';
export interface TransliteratorProps {
    /**
     * The bucket in which to source assemblies to transliterate.
     */
    readonly bucket: Bucket;
    /**
     * The CodeArtifact registry to use for regular operations.
     */
    readonly codeArtifact?: Repository;
    /**
     * The monitoring handler to register alarms with.
     */
    readonly monitoring: Monitoring;
    /**
     * The VPC in which isolated lambda functions will reside.
     */
    readonly vpc?: IVpc;
    /**
     * VPC endpoints to use for interacting with CodeArtifact and S3.
     */
    readonly vpcEndpoints?: TransliteratorVpcEndpoints;
    /**
     * The subnet selection to use for placement of the Lambda function.
     *
     * @default { subnetType: SubnetType.ISOLATED }
     */
    readonly vpcSubnets?: SubnetSelection;
    /**
     * How long should execution logs be retained?
     *
     * @default RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
}
export interface TransliteratorVpcEndpoints {
    /**
     * The VPC endpoint for the CodeArtifact API (service: 'codeartifact.api')
     */
    readonly codeArtifactApi: InterfaceVpcEndpoint;
    /**
     * The VPC endpoint for the CodeArtifact repositories (service: 'codeartifact.repositories')
     */
    readonly codeArtifact: InterfaceVpcEndpoint;
    /**
     * The VPC endpoint for the S3
     */
    readonly s3: GatewayVpcEndpoint;
}
/**
 * Transliterates jsii assemblies to various other languages.
 */
export declare class Transliterator extends Construct {
    /**
     * Alarms if the dead-letter-queue associated with the transliteration process
     * is not empty, meaning some packages failed transliteration and require
     * operator attention.
     */
    readonly alarmDeadLetterQueueNotEmpty: IAlarm;
    constructor(scope: Construct, id: string, props: TransliteratorProps);
}
