"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipeline = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const pdk_nag_1 = require("../../pdk-nag");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_codecommit_1 = require("aws-cdk-lib/aws-codecommit");
const aws_codepipeline_1 = require("aws-cdk-lib/aws-codepipeline");
const aws_kms_1 = require("aws-cdk-lib/aws-kms");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const pipelines_1 = require("aws-cdk-lib/pipelines");
const cdk_nag_1 = require("cdk-nag");
const sonar_code_scanner_1 = require("./code_scanner/sonar-code-scanner");
__exportStar(require("./code_scanner/sonar-code-scanner"), exports);
const DEFAULT_BRANCH_NAME = "mainline";
/**
 * An extension to CodePipeline which configures sane defaults for a NX Monorepo
 * codebase. In addition to this, it also creates a CodeCommit repository with
 * automated PR builds and approvals.
 */
class PDKPipeline extends pipelines_1.CodePipeline {
    constructor(scope, id, props) {
        const codeRepository = new aws_codecommit_1.Repository(scope, "CodeRepository", {
            repositoryName: props.repositoryName,
        });
        codeRepository.applyRemovalPolicy(props.codeCommitRemovalPolicy ?? aws_cdk_lib_1.RemovalPolicy.RETAIN);
        const artifactBucket = new aws_s3_1.Bucket(scope, "ArtifactsBucket", {
            enforceSSL: true,
            autoDeleteObjects: true,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
            encryption: props.crossAccountKeys
                ? aws_s3_1.BucketEncryption.KMS
                : aws_s3_1.BucketEncryption.S3_MANAGED,
            encryptionKey: props.crossAccountKeys
                ? new aws_kms_1.Key(scope, "ArtifactKey", {
                    enableKeyRotation: true,
                    removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
                })
                : undefined,
            publicReadAccess: false,
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            serverAccessLogsPrefix: "access-logs",
        });
        const codePipeline = new aws_codepipeline_1.Pipeline(scope, "CodePipeline", {
            enableKeyRotation: props.crossAccountKeys,
            restartExecutionOnUpdate: true,
            crossAccountKeys: props.crossAccountKeys,
            artifactBucket,
        });
        // ignore input and primaryOutputDirectory
        const { input, primaryOutputDirectory, commands, ...synthShellStepPartialProps } = props.synthShellStepPartialProps || {};
        const synthShellStep = new pipelines_1.ShellStep("Synth", {
            input: pipelines_1.CodePipelineSource.codeCommit(codeRepository, props.defaultBranchName || DEFAULT_BRANCH_NAME),
            installCommands: [
                "npm install -g aws-cdk",
                "yarn install --frozen-lockfile || npx projen && yarn install --frozen-lockfile",
            ],
            commands: commands && commands.length > 0
                ? commands
                : ["npx nx run-many --target=build --all"],
            primaryOutputDirectory: props.primarySynthDirectory,
            ...(synthShellStepPartialProps || {}),
        });
        synthShellStep.addOutputDirectory(".");
        const codePipelineProps = {
            codePipeline,
            ...props,
            crossAccountKeys: undefined,
            synth: synthShellStep,
        };
        super(scope, id, codePipelineProps);
        this.id = id;
        this.codeRepository = codeRepository;
        this.sonarCodeScannerConfig = props.sonarCodeScannerConfig
            ? {
                cdkOutDir: props.primarySynthDirectory,
                ...props.sonarCodeScannerConfig,
            }
            : undefined;
        new aws_cdk_lib_1.CfnOutput(scope, "CodeRepositoryGRCUrl", {
            exportName: "CodeRepositoryGRCUrl",
            value: this.codeRepository.repositoryCloneUrlGrc,
        });
    }
    /**
     * @inheritDoc
     */
    addStage(stage, options) {
        // Add any root Aspects to the stage level as currently this doesn't happen automatically
        aws_cdk_lib_1.Aspects.of(stage.node.root).all.forEach((aspect) => aws_cdk_lib_1.Aspects.of(stage).add(aspect));
        return super.addStage(stage, options);
    }
    buildPipeline() {
        super.buildPipeline();
        this.sonarCodeScannerConfig &&
            new sonar_code_scanner_1.SonarCodeScanner(this, "SonarCodeScanner", {
                artifactBucketArn: this.pipeline.artifactBucket.bucketArn,
                artifactBucketKeyArn: this.pipeline.artifactBucket.encryptionKey?.keyArn,
                synthBuildArn: this.synthProject.projectArn,
                ...this.sonarCodeScannerConfig,
            });
        this.suppressCDKViolations();
    }
    suppressCDKViolations() {
        const stack = aws_cdk_lib_1.Stack.of(this);
        ["AwsSolutions-IAM5", "AwsPrototyping-IAMNoWildcardPermissions"].forEach((RuleId) => {
            pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}CodePipeline/Role/DefaultPolicy/Resource`, [
                {
                    id: RuleId,
                    reason: "Actions contain wildcards which are valid for CodePipeline as all of these operations are required.",
                    appliesTo: [
                        {
                            regex: "/^Action::s3:.*$/g",
                        },
                    ],
                },
                {
                    id: RuleId,
                    reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                    appliesTo: [
                        {
                            regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                        },
                        {
                            regex: "/^Action::kms:ReEncrypt\\*$/g",
                        },
                        {
                            regex: "/^Action::kms:GenerateDataKey\\*$/g",
                        },
                    ],
                },
            ]);
            pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}CodePipeline/Role/DefaultPolicy/Resource`, [
                {
                    id: RuleId,
                    reason: "Actions contain wildcards which are valid for CodePipeline as all of these operations are required.",
                    appliesTo: [
                        {
                            regex: "/^Action::s3:.*$/g",
                        },
                    ],
                },
                {
                    id: RuleId,
                    reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                    appliesTo: [
                        {
                            regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                        },
                    ],
                },
            ]);
            pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}CodePipeline/Source/CodeCommit/CodePipelineActionRole/DefaultPolicy/Resource`, [
                {
                    id: RuleId,
                    reason: "Actions contain wildcards which are valid for CodePipeline as all of these operations are required.",
                    appliesTo: [
                        {
                            regex: "/^Action::s3:.*$/g",
                        },
                    ],
                },
                {
                    id: RuleId,
                    reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                    appliesTo: [
                        {
                            regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                        },
                        {
                            regex: "/^Action::kms:ReEncrypt\\*$/g",
                        },
                        {
                            regex: "/^Action::kms:GenerateDataKey\\*$/g",
                        },
                    ],
                },
            ]);
            pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}CodePipeline/Build/Synth/CdkBuildProject/Role/DefaultPolicy/Resource`, [
                {
                    id: RuleId,
                    reason: "Actions contain wildcards which are valid for CodePipeline as all of these operations are required.",
                    appliesTo: [
                        {
                            regex: "/^Action::s3:.*$/g",
                        },
                    ],
                },
                {
                    id: RuleId,
                    reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                    appliesTo: [
                        {
                            regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                        },
                        {
                            regex: "/^Action::kms:ReEncrypt\\*$/g",
                        },
                        {
                            regex: "/^Action::kms:GenerateDataKey\\*$/g",
                        },
                    ],
                },
                {
                    id: RuleId,
                    reason: "CodePipeline requires access to manage logs and streams whose names are dynamically determined.",
                    appliesTo: [
                        {
                            regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:logs:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:log-group:/aws/codebuild/<CodePipelineBuildSynthCdkBuildProject.*>:\\*$/g`,
                        },
                    ],
                },
                {
                    id: RuleId,
                    reason: "CodePipeline requires access to create report groups that are dynamically determined.",
                    appliesTo: [
                        {
                            regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:codebuild:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:report-group/<CodePipelineBuildSynthCdkBuildProject.*>-\\*$/g`,
                        },
                    ],
                },
            ]);
            pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}${this.id}/UpdatePipeline/SelfMutation/Role/DefaultPolicy/Resource`, [
                {
                    id: RuleId,
                    reason: "CodePipeline requires access to manage logs and streams whose names are dynamically determined.",
                    appliesTo: [
                        {
                            regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:logs:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:log-group:/aws/codebuild/<${this.id}UpdatePipelineSelfMutation.*>:\\*$/g`,
                        },
                    ],
                },
                {
                    id: RuleId,
                    reason: "CodePipeline requires access to create report groups that are dynamically determined.",
                    appliesTo: [
                        {
                            regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:codebuild:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:report-group/<${this.id}UpdatePipelineSelfMutation.*>-\\*$/g`,
                        },
                    ],
                },
                {
                    id: RuleId,
                    reason: "CodePipeline requires access to assume a role from within the current account in order to deploy.",
                    appliesTo: [
                        {
                            regex: `/^Resource::arn:\\*:iam::${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:role/\\*$/g`,
                        },
                    ],
                },
                {
                    id: RuleId,
                    reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                    appliesTo: [
                        {
                            regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                        },
                    ],
                },
                {
                    id: RuleId,
                    reason: "CodePipeline requires access to list all buckets and stacks.",
                    appliesTo: [
                        {
                            regex: "/^Resource::\\*$/g",
                        },
                    ],
                },
            ]);
            pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}${this.id}/UpdatePipeline/SelfMutation/Role/DefaultPolicy/Resource`, [
                {
                    id: RuleId,
                    reason: "Actions contain wildcards which are valid for CodePipeline as all of these operations are required.",
                    appliesTo: [
                        {
                            regex: "/^Action::s3:.*$/g",
                        },
                    ],
                },
                {
                    id: RuleId,
                    reason: "CodePipeline requires access to manage logs and streams whose names are dynamically determined.",
                    appliesTo: [
                        {
                            regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:logs:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:(<AWS::AccountId>|${stack.account}):log-group:/aws/codebuild/<${this.id}UpdatePipelineSelfMutation.*>:\\*$/g`,
                        },
                    ],
                },
                {
                    id: RuleId,
                    reason: "CodePipeline requires access to create report groups that are dynamically determined.",
                    appliesTo: [
                        {
                            regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:codebuild:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:report-group/<${this.id}UpdatePipelineSelfMutation.*>-\\*$/g`,
                        },
                    ],
                },
                {
                    id: RuleId,
                    reason: "CodePipeline requires access to assume a role from within the current account in order to deploy.",
                    appliesTo: [
                        {
                            regex: `/^Resource::arn:\\*:iam::${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:role/\\*$/g`,
                        },
                    ],
                },
                {
                    id: RuleId,
                    reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                    appliesTo: [
                        {
                            regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                        },
                        {
                            regex: "/^Action::kms:ReEncrypt\\*$/g",
                        },
                        {
                            regex: "/^Action::kms:GenerateDataKey\\*$/g",
                        },
                    ],
                },
                {
                    id: RuleId,
                    reason: "CodePipeline requires access to list all buckets and stacks.",
                    appliesTo: [
                        {
                            regex: "/^Resource::\\*$/g",
                        },
                    ],
                },
            ]);
            pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}${this.id}/Assets/FileRole/DefaultPolicy/Resource`, [
                {
                    id: RuleId,
                    reason: "Asset role requires access to the Artifacts Bucket",
                },
            ]);
        });
        [
            "AwsSolutions-CB4",
            "AwsPrototyping-CodeBuildProjectKMSEncryptedArtifacts",
        ].forEach((RuleId) => {
            cdk_nag_1.NagSuppressions.addStackSuppressions(stack, [
                {
                    id: RuleId,
                    reason: "Encryption of Codebuild is not required.",
                },
            ]);
        });
    }
}
exports.PDKPipeline = PDKPipeline;
_a = JSII_RTTI_SYMBOL_1;
PDKPipeline[_a] = { fqn: "aws-prototyping-sdk.pipeline.PDKPipeline", version: "0.12.30" };
//# sourceMappingURL=data:application/json;base64,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