# sharepoint-rest-api
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import sharepoint_rest_api 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import sharepoint_rest_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import sharepoint_rest_api
from sharepoint_rest_api.rest import ApiException
from pprint import pprint

# Configure API key authorization: bearerAuth
configuration = sharepoint_rest_api.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = sharepoint_rest_api.ListsApi(sharepoint_rest_api.ApiClient(configuration))
accept = 'application/json;odata=verbose' # str |  (optional) (default to application/json;odata=verbose)
select = 'select_example' # str | Select items by property values (optional)
expand = 'expand_example' # str | Expand related entities (optional)
skiptoken = 'skiptoken_example' # str | Skips the first n results. (optional)
skip = 56 # int | Skip the first n items (optional)
top = 56 # int | Show only the first n items (optional)
filter = 'filter_example' # str | Filter items by property values (optional)
search = 'search_example' # str | Search items by search phrases (optional)
orderby = 'orderby_example' # str | Order items by property values (optional)
count = true # bool | Include count of items (optional)

try:
    # Get all list a specific site
    api_response = api_instance.get_list(accept=accept, select=select, expand=expand, skiptoken=skiptoken, skip=skip, top=top, filter=filter, search=search, orderby=orderby, count=count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ListsApi->get_list: %s\n" % e)

# Configure API key authorization: bearerAuth
configuration = sharepoint_rest_api.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = sharepoint_rest_api.ListsApi(sharepoint_rest_api.ApiClient(configuration))
list_id = 'list_id_example' # str | Id of a specific list
accept = 'application/json;odata=verbose' # str |  (optional) (default to application/json;odata=verbose)
select = 'select_example' # str | Select items by property values (optional)
expand = 'expand_example' # str | Expand related entities (optional)

try:
    # Get a specific List of site by Id
    api_response = api_instance.get_list_by_id(list_id, accept=accept, select=select, expand=expand)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ListsApi->get_list_by_id: %s\n" % e)

# Configure API key authorization: bearerAuth
configuration = sharepoint_rest_api.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = sharepoint_rest_api.ListsApi(sharepoint_rest_api.ApiClient(configuration))
list_id = 'list_id_example' # str | Id of a specific list
accept = 'application/json;odata=verbose' # str |  (optional) (default to application/json;odata=verbose)
select = 'select_example' # str | Select items by property values (optional)
expand = 'expand_example' # str | Expand related entities (optional)

try:
    # Get all Fields of a specific list of site by Id
    api_response = api_instance.get_list_by_id_fields(list_id, accept=accept, select=select, expand=expand)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ListsApi->get_list_by_id_fields: %s\n" % e)

# Configure API key authorization: bearerAuth
configuration = sharepoint_rest_api.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = sharepoint_rest_api.ListsApi(sharepoint_rest_api.ApiClient(configuration))
list_id = 'list_id_example' # str | Id of a specific list
list_item_id = 'list_item_id_example' # str | Item's Id of a specific list
accept = 'application/json;odata=verbose' # str |  (optional) (default to application/json;odata=verbose)
select = 'select_example' # str | Select items by property values (optional)
expand = 'expand_example' # str | Expand related entities (optional)

try:
    # Get a specific Item by Id of a specific list of site by Id
    api_response = api_instance.get_list_by_id_item_by_id(list_id, list_item_id, accept=accept, select=select, expand=expand)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ListsApi->get_list_by_id_item_by_id: %s\n" % e)

# Configure API key authorization: bearerAuth
configuration = sharepoint_rest_api.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = sharepoint_rest_api.ListsApi(sharepoint_rest_api.ApiClient(configuration))
list_id = 'list_id_example' # str | Id of a specific list
list_item_id = 'list_item_id_example' # str | Item's Id of a specific list
accept = 'application/json;odata=verbose' # str |  (optional) (default to application/json;odata=verbose)
select = 'select_example' # str | Select items by property values (optional)
expand = 'expand_example' # str | Expand related entities (optional)
skiptoken = 'skiptoken_example' # str | Skips the first n results. (optional)
skip = 56 # int | Skip the first n items (optional)
top = 56 # int | Show only the first n items (optional)
filter = 'filter_example' # str | Filter items by property values (optional)
search = 'search_example' # str | Search items by search phrases (optional)
orderby = 'orderby_example' # str | Order items by property values (optional)
count = true # bool | Include count of items (optional)

try:
    # Get AttachmentFiles of a specific Item by Id of a specific list of site by Id
    api_response = api_instance.get_list_by_id_item_by_id_attachment_files(list_id, list_item_id, accept=accept, select=select, expand=expand, skiptoken=skiptoken, skip=skip, top=top, filter=filter, search=search, orderby=orderby, count=count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ListsApi->get_list_by_id_item_by_id_attachment_files: %s\n" % e)

# Configure API key authorization: bearerAuth
configuration = sharepoint_rest_api.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = sharepoint_rest_api.ListsApi(sharepoint_rest_api.ApiClient(configuration))
list_id = 'list_id_example' # str | Id of a specific list
list_item_id = 'list_item_id_example' # str | Item's Id of a specific list
accept = 'application/json;odata=verbose' # str |  (optional) (default to application/json;odata=verbose)
select = 'select_example' # str | Select items by property values (optional)
expand = 'expand_example' # str | Expand related entities (optional)
skiptoken = 'skiptoken_example' # str | Skips the first n results. (optional)
skip = 56 # int | Skip the first n items (optional)
top = 56 # int | Show only the first n items (optional)
filter = 'filter_example' # str | Filter items by property values (optional)
search = 'search_example' # str | Search items by search phrases (optional)
orderby = 'orderby_example' # str | Order items by property values (optional)
count = true # bool | Include count of items (optional)

try:
    # Get File of a specific Item by Id of a specific list of site by Id
    api_response = api_instance.get_list_by_id_item_by_id_file(list_id, list_item_id, accept=accept, select=select, expand=expand, skiptoken=skiptoken, skip=skip, top=top, filter=filter, search=search, orderby=orderby, count=count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ListsApi->get_list_by_id_item_by_id_file: %s\n" % e)

# Configure API key authorization: bearerAuth
configuration = sharepoint_rest_api.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = sharepoint_rest_api.ListsApi(sharepoint_rest_api.ApiClient(configuration))
list_id = 'list_id_example' # str | Id of a specific list
list_item_id = 'list_item_id_example' # str | Item's Id of a specific list
accept = 'application/json;odata=verbose' # str |  (optional) (default to application/json;odata=verbose)
select = 'select_example' # str | Select items by property values (optional)
expand = 'expand_example' # str | Expand related entities (optional)
skiptoken = 'skiptoken_example' # str | Skips the first n results. (optional)
skip = 56 # int | Skip the first n items (optional)
top = 56 # int | Show only the first n items (optional)
filter = 'filter_example' # str | Filter items by property values (optional)
search = 'search_example' # str | Search items by search phrases (optional)
orderby = 'orderby_example' # str | Order items by property values (optional)
count = true # bool | Include count of items (optional)

try:
    # Get Folder of a specific Item by Id of a specific list of site by Id
    api_response = api_instance.get_list_by_id_item_by_id_folder(list_id, list_item_id, accept=accept, select=select, expand=expand, skiptoken=skiptoken, skip=skip, top=top, filter=filter, search=search, orderby=orderby, count=count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ListsApi->get_list_by_id_item_by_id_folder: %s\n" % e)

# Configure API key authorization: bearerAuth
configuration = sharepoint_rest_api.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = sharepoint_rest_api.ListsApi(sharepoint_rest_api.ApiClient(configuration))
list_id = 'list_id_example' # str | Id of a specific list
accept = 'application/json;odata=verbose' # str |  (optional) (default to application/json;odata=verbose)
select = 'select_example' # str | Select items by property values (optional)
expand = 'expand_example' # str | Expand related entities (optional)
skiptoken = 'skiptoken_example' # str | Skips the first n results. (optional)
skip = 56 # int | Skip the first n items (optional)
top = 56 # int | Show only the first n items (optional)
filter = 'filter_example' # str | Filter items by property values (optional)
search = 'search_example' # str | Search items by search phrases (optional)
orderby = 'orderby_example' # str | Order items by property values (optional)
count = true # bool | Include count of items (optional)

try:
    # Get all Items of a specific list of site by Id
    api_response = api_instance.get_list_by_id_items(list_id, accept=accept, select=select, expand=expand, skiptoken=skiptoken, skip=skip, top=top, filter=filter, search=search, orderby=orderby, count=count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ListsApi->get_list_by_id_items: %s\n" % e)

# Configure API key authorization: bearerAuth
configuration = sharepoint_rest_api.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = sharepoint_rest_api.ListsApi(sharepoint_rest_api.ApiClient(configuration))
list_title = 'list_title_example' # str | Title of a specific list
accept = 'application/json;odata=verbose' # str |  (optional) (default to application/json;odata=verbose)
select = 'select_example' # str | Select items by property values (optional)
expand = 'expand_example' # str | Expand related entities (optional)

try:
    # Get a specific List of site by title
    api_response = api_instance.get_list_by_title(list_title, accept=accept, select=select, expand=expand)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ListsApi->get_list_by_title: %s\n" % e)

# Configure API key authorization: bearerAuth
configuration = sharepoint_rest_api.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = sharepoint_rest_api.ListsApi(sharepoint_rest_api.ApiClient(configuration))
list_title = 'list_title_example' # str | Title of a specific list
accept = 'application/json;odata=verbose' # str |  (optional) (default to application/json;odata=verbose)
select = 'select_example' # str | Select items by property values (optional)
expand = 'expand_example' # str | Expand related entities (optional)

try:
    # Get all Fields of a specific list of site by title
    api_response = api_instance.get_list_by_title_fields(list_title, accept=accept, select=select, expand=expand)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ListsApi->get_list_by_title_fields: %s\n" % e)

# Configure API key authorization: bearerAuth
configuration = sharepoint_rest_api.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = sharepoint_rest_api.ListsApi(sharepoint_rest_api.ApiClient(configuration))
list_title = 'list_title_example' # str | Title of a specific list
accept = 'application/json;odata=verbose' # str |  (optional) (default to application/json;odata=verbose)
select = 'select_example' # str | Select items by property values (optional)
expand = 'expand_example' # str | Expand related entities (optional)
skiptoken = 'skiptoken_example' # str | Skips the first n results. (optional)
skip = 56 # int | Skip the first n items (optional)
top = 56 # int | Show only the first n items (optional)
filter = 'filter_example' # str | Filter items by property values (optional)
search = 'search_example' # str | Search items by search phrases (optional)
orderby = 'orderby_example' # str | Order items by property values (optional)
count = true # bool | Include count of items (optional)

try:
    # Get all Items of a specific list of site by title
    api_response = api_instance.get_list_by_title_items(list_title, accept=accept, select=select, expand=expand, skiptoken=skiptoken, skip=skip, top=top, filter=filter, search=search, orderby=orderby, count=count)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ListsApi->get_list_by_title_items: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sites/Fusion/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ListsApi* | [**get_list**](docs/ListsApi.md#get_list) | **GET** /_api/Lists | Get all list a specific site
*ListsApi* | [**get_list_by_id**](docs/ListsApi.md#get_list_by_id) | **GET** /_api/Lists(guid&#x27;{listId}&#x27;) | Get a specific List of site by Id
*ListsApi* | [**get_list_by_id_fields**](docs/ListsApi.md#get_list_by_id_fields) | **GET** /_api/Lists(guid&#x27;{listId}&#x27;)/Fields | Get all Fields of a specific list of site by Id
*ListsApi* | [**get_list_by_id_item_by_id**](docs/ListsApi.md#get_list_by_id_item_by_id) | **GET** /_api/Lists(guid&#x27;{listId}&#x27;)/Items({listItemId}) | Get a specific Item by Id of a specific list of site by Id
*ListsApi* | [**get_list_by_id_item_by_id_attachment_files**](docs/ListsApi.md#get_list_by_id_item_by_id_attachment_files) | **GET** /_api/Lists(guid&#x27;{listId}&#x27;)/Items({listItemId})/AttachmentFiles | Get AttachmentFiles of a specific Item by Id of a specific list of site by Id
*ListsApi* | [**get_list_by_id_item_by_id_file**](docs/ListsApi.md#get_list_by_id_item_by_id_file) | **GET** /_api/Lists(guid&#x27;{listId}&#x27;)/Items({listItemId})/File | Get File of a specific Item by Id of a specific list of site by Id
*ListsApi* | [**get_list_by_id_item_by_id_folder**](docs/ListsApi.md#get_list_by_id_item_by_id_folder) | **GET** /_api/Lists(guid&#x27;{listId}&#x27;)/Items({listItemId})/Folder | Get Folder of a specific Item by Id of a specific list of site by Id
*ListsApi* | [**get_list_by_id_items**](docs/ListsApi.md#get_list_by_id_items) | **GET** /_api/Lists(guid&#x27;{listId}&#x27;)/Items | Get all Items of a specific list of site by Id
*ListsApi* | [**get_list_by_title**](docs/ListsApi.md#get_list_by_title) | **GET** /_api/Lists/GetByTitle(&#x27;{listTitle}&#x27;) | Get a specific List of site by title
*ListsApi* | [**get_list_by_title_fields**](docs/ListsApi.md#get_list_by_title_fields) | **GET** /_api/Lists/GetByTitle(&#x27;{listTitle}&#x27;)/Fields | Get all Fields of a specific list of site by title
*ListsApi* | [**get_list_by_title_items**](docs/ListsApi.md#get_list_by_title_items) | **GET** /_api/Lists/GetByTitle(&#x27;{listTitle}&#x27;)/Items | Get all Items of a specific list of site by title
*SitesApi* | [**get_site**](docs/SitesApi.md#get_site) | **GET** /_api/Site | Get a specific site collection
*WebsApi* | [**get_folder_by_server_relative_url**](docs/WebsApi.md#get_folder_by_server_relative_url) | **GET** /_api/Web/GetFolderByServerRelativeUrl(&#x27;{serverRelativeUrl}&#x27;) | Get Folders information of a ServerRelativeUrl e.g. /sites/Fusion/Data%20Science
*WebsApi* | [**get_folder_by_server_relative_url_files**](docs/WebsApi.md#get_folder_by_server_relative_url_files) | **GET** /_api/Web/GetFolderByServerRelativeUrl(&#x27;{serverRelativeUrl}&#x27;)/Files | Get all files of a ServerRelativeUrl (e.g. /sites/Fusion/Data%20Science)
*WebsApi* | [**get_folder_by_server_relative_url_folders**](docs/WebsApi.md#get_folder_by_server_relative_url_folders) | **GET** /_api/Web/GetFolderByServerRelativeUrl(&#x27;{serverRelativeUrl}&#x27;)/Folders | Get all Sub-Folders of a ServerRelativeUrl (e.g. /sites/Fusion/Data%20Science)
*WebsApi* | [**get_get_file_by_server_relative_url**](docs/WebsApi.md#get_get_file_by_server_relative_url) | **GET** /_api/Web/GetFileByServerRelativeUrl(&#x27;{serverRelativeUrl}&#x27;) | Get all files of a ServerRelativeUrl (e.g. /sites/Fusion/Data%20Science/Test.pdf)
*WebsApi* | [**get_get_file_by_server_relative_url_content**](docs/WebsApi.md#get_get_file_by_server_relative_url_content) | **GET** /_api/Web/GetFileByServerRelativeUrl(&#x27;{serverRelativeUrl}&#x27;)$value | Get file content of a ServerRelativeUrl (e.g. /sites/Fusion/Data%20Science/Test.pdf)/$value
*WebsApi* | [**get_web**](docs/WebsApi.md#get_web) | **GET** /_api/Web | Get a specific site
*WebsApi* | [**get_web_folders**](docs/WebsApi.md#get_web_folders) | **GET** /_api/Web/Folders | Get Folders of a specific site
*WebsApi* | [**get_web_lists**](docs/WebsApi.md#get_web_lists) | **GET** /_api/Web/Lists | Get Lists of a specific site
*WebsApi* | [**get_web_root_folder**](docs/WebsApi.md#get_web_root_folder) | **GET** /_api/Web/RootFolder | Get RootFolder of a specific site

## Documentation For Models

 - [SPOdataResult](docs/SPOdataResult.md)

## Documentation For Authorization


## bearerAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author


