# async-doh

[![PyPI](https://img.shields.io/pypi/v/async-doh.svg)]()

DNS over HTTPS based on aiohttp and [async_dns](https://github.com/gera2ld/async_dns).

## Installation

```sh
$ pip install async-doh
```

## Usage

### Client

```py
import asyncio
from async_doh.client import query

async def main():
    result = await query('https://1.1.1.1/dns-query', 'www.google.com', 'A')
    print('query:', result)
    result = await query_json('https://1.1.1.1/dns-query', 'www.google.com', 'A')
    print('query_json:', result)

asyncio.run(main())
```

### Server

```py
from aiohttp import web
from async_doh.server import application

web.run(application)
```

Now you have `http://localhost:8080/dns-query` as an endpoint.
