from pydantic import Field
from typing import Any, Union, List, Optional
from pydantic_schemaorg.Article import Article


class Report(Article):
    """A Report generated by governmental or non-governmental organization.

    See https://schema.org/Report.

    """

    reportNumber: Optional[Union[List[str], str]] = Field(
        None,
        description="The number or other unique designator assigned to a Report by the publishing organization.",
    )
    locals().update({"@type": Field("Report", const=True)})


Report.update_forward_refs()
