<p align="center">
  <img width="150" src="source_nbs/figures/logo.svg">
</p>
<h3 align="center">Generate, manage and analyze anomalous diffusion trajectories</h3>
<p align="center">
  <a href="https://doi.org/10.5281/zenodo.4775311"><img src="https://zenodo.org/badge/DOI/10.5281/zenodo.4775311.svg" alt="PyPI version"></a>
  <a href="https://badge.fury.io/py/andi-datasetsl"><img src="https://badge.fury.io/py/andi-datasets.svg" alt="PyPI version"></a>
  <a href="https://badge.fury.io/py/andi-datasets"><img src="https://img.shields.io/badge/python-3.10-red" alt="Python version"></a>
</p>
<p align="center">
  <a href="https://andichallenge.github.io/andi_datasets/">Get started</a> |
  <a href="https://andichallenge.github.io/andi_datasets/lib_nbs/index_docs.html">Documentation</a> |
  <a href="https://andichallenge.github.io/andi_datasets/tutorials/index_tutorials.html">Tutorials</a> |
  <a href="#cite-us">Cite us</a> |
  <a href="/LICENSE">License</a> 
</p>



This library has been created in the framework of the [**Anomalous Diffusion (AnDi) Challenge**](http://andi-challenge.org/)  and allows to create trajectories and datasets from various anomalous diffusion models. Learn all the details and discover the available tutorials in the [**library webpage**](https://andichallenge.github.io/andi_datasets/).

## Installation

You can install the package using:

``` python
pip install andi-datasets
```

You can then import the package in a Python3 environment using:

``` python
import andi_datasets
```



## Contributing

The AnDi challenge is a community effort, hence any contribution to this library is more than welcome. If you think we should include a new model to the library, you can contact us in this mail: andi.challenge@gmail.com. You can also perform pull-requests and open issues with any feedback or comments you may have.

## Requirements

`andi-datasets` runs in `python>=3.10`. All the requirements are declared in the file `setting.ini` and automatically included when installing the package. Further details can be found at the [PYPI package webpage](https://pypi.org/project/andi-datasets/).

## Cite us

If you found this package useful and used it in your projects, you can use the following to directly cite the package:

````
Muñoz-Gil, G., Requena B., Volpe G., Garcia-March M.A. and Manzo C.
AnDiChallenge/ANDI_datasets: Challenge 2020 release (v.1.0). Zenodo (2021). 
https://doi.org/10.5281/zenodo.4775311
````

Or you can cite the paper this package was developed for:

````
Muñoz-Gil, G., Volpe, G., Garcia-March, M.A. et al. 
Objective comparison of methods to decode anomalous diffusion. 
Nat Commun 12, 6253 (2021). 
https://doi.org/10.1038/s41467-021-26320-w
````



