"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const bundling_1 = require("./bundling");
const util_1 = require("./util");
/**
 * (experimental) A Golang Lambda function.
 *
 * @experimental
 */
class GoFunction extends lambda.Function {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        if (props.runtime && (props.runtime.family !== lambda.RuntimeFamily.GO && props.runtime.family != lambda.RuntimeFamily.OTHER)) {
            throw new Error('Only `go` and `provided` runtimes are supported.');
        }
        const entry = path.resolve(props.entry);
        // Find the project root
        let moduleDir;
        if (props.moduleDir) {
            const parsedModuleDir = path.parse(props.moduleDir);
            if (parsedModuleDir.base && parsedModuleDir.ext && parsedModuleDir.base === 'go.mod') {
                if (!fs.existsSync(props.moduleDir)) {
                    throw new Error(`go.mod file at ${props.moduleDir} doesn't exist`);
                }
            }
            else if (parsedModuleDir.base && parsedModuleDir.ext && parsedModuleDir.base != 'go.mod') {
                throw new Error('moduleDir is specifying a file that is not go.mod');
            }
            else if (!fs.existsSync(path.join(props.moduleDir, 'go.mod'))) {
                throw new Error(`go.mod file at ${props.moduleDir} doesn't exist`);
            }
            moduleDir = props.moduleDir;
        }
        else {
            const modFile = util_1.findUp('go.mod', entry);
            if (!modFile) {
                throw new Error('Cannot find go.mod. Please specify it with `moduleDir`.');
            }
            moduleDir = modFile;
        }
        const runtime = (_b = props.runtime) !== null && _b !== void 0 ? _b : lambda.Runtime.PROVIDED_AL2;
        super(scope, id, {
            ...props,
            runtime,
            code: bundling_1.Bundling.bundle({
                ...(_c = props.bundling) !== null && _c !== void 0 ? _c : {},
                entry,
                runtime,
                moduleDir,
            }),
            handler: 'bootstrap',
        });
    }
}
exports.GoFunction = GoFunction;
_a = JSII_RTTI_SYMBOL_1;
GoFunction[_a] = { fqn: "@aws-cdk/aws-lambda-go.GoFunction", version: "1.127.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZnVuY3Rpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJmdW5jdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHlCQUF5QjtBQUN6Qiw2QkFBNkI7QUFDN0IsOENBQThDO0FBQzlDLHlDQUFzQztBQUV0QyxpQ0FBZ0M7Ozs7OztBQXNCaEMsTUFBYSxVQUFXLFNBQVEsTUFBTSxDQUFDLFFBQVE7Ozs7SUFDN0MsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFzQjs7UUFDOUQsSUFBSSxLQUFLLENBQUMsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxNQUFNLEtBQUssTUFBTSxDQUFDLGFBQWEsQ0FBQyxFQUFFLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxNQUFNLElBQUksTUFBTSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsRUFBRTtZQUM3SCxNQUFNLElBQUksS0FBSyxDQUFDLGtEQUFrRCxDQUFDLENBQUM7U0FDckU7UUFFRCxNQUFNLEtBQUssR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUV4Qyx3QkFBd0I7UUFDeEIsSUFBSSxTQUFpQixDQUFDO1FBQ3RCLElBQUksS0FBSyxDQUFDLFNBQVMsRUFBRTtZQUNuQixNQUFNLGVBQWUsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUMsQ0FBQztZQUNwRCxJQUFJLGVBQWUsQ0FBQyxJQUFJLElBQUksZUFBZSxDQUFDLEdBQUcsSUFBSSxlQUFlLENBQUMsSUFBSSxLQUFLLFFBQVEsRUFBRTtnQkFDcEYsSUFBSSxDQUFDLEVBQUUsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxFQUFFO29CQUNuQyxNQUFNLElBQUksS0FBSyxDQUFDLGtCQUFrQixLQUFLLENBQUMsU0FBUyxnQkFBZ0IsQ0FBQyxDQUFDO2lCQUNwRTthQUNGO2lCQUFNLElBQUksZUFBZSxDQUFDLElBQUksSUFBSSxlQUFlLENBQUMsR0FBRyxJQUFJLGVBQWUsQ0FBQyxJQUFJLElBQUksUUFBUSxFQUFFO2dCQUMxRixNQUFNLElBQUksS0FBSyxDQUFDLG1EQUFtRCxDQUFDLENBQUM7YUFDdEU7aUJBQU0sSUFBSSxDQUFDLEVBQUUsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxFQUFFLFFBQVEsQ0FBQyxDQUFDLEVBQUU7Z0JBQy9ELE1BQU0sSUFBSSxLQUFLLENBQUMsa0JBQWtCLEtBQUssQ0FBQyxTQUFTLGdCQUFnQixDQUFDLENBQUM7YUFDcEU7WUFDRCxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztTQUM3QjthQUFNO1lBQ0wsTUFBTSxPQUFPLEdBQUcsYUFBTSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztZQUN4QyxJQUFJLENBQUMsT0FBTyxFQUFFO2dCQUNaLE1BQU0sSUFBSSxLQUFLLENBQUUseURBQXlELENBQUMsQ0FBQzthQUM3RTtZQUNELFNBQVMsR0FBRyxPQUFPLENBQUM7U0FDckI7UUFFRCxNQUFNLE9BQU8sU0FBRyxLQUFLLENBQUMsT0FBTyxtQ0FBSSxNQUFNLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQztRQUU3RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLEdBQUcsS0FBSztZQUNSLE9BQU87WUFDUCxJQUFJLEVBQUUsbUJBQVEsQ0FBQyxNQUFNLENBQUM7Z0JBQ3BCLFNBQUcsS0FBSyxDQUFDLFFBQVEsbUNBQUksRUFBRTtnQkFDdkIsS0FBSztnQkFDTCxPQUFPO2dCQUNQLFNBQVM7YUFDVixDQUFDO1lBQ0YsT0FBTyxFQUFFLFdBQVc7U0FDckIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUEzQ0gsZ0NBNENDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZnMgZnJvbSAnZnMnO1xuaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCB7IEJ1bmRsaW5nIH0gZnJvbSAnLi9idW5kbGluZyc7XG5pbXBvcnQgeyBCdW5kbGluZ09wdGlvbnMgfSBmcm9tICcuL3R5cGVzJztcbmltcG9ydCB7IGZpbmRVcCB9IGZyb20gJy4vdXRpbCc7XG5cbi8vIGtlZXAgdGhpcyBpbXBvcnQgc2VwYXJhdGUgZnJvbSBvdGhlciBpbXBvcnRzIHRvIHJlZHVjZSBjaGFuY2UgZm9yIG1lcmdlIGNvbmZsaWN0cyB3aXRoIHYyLW1haW5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1kdXBsaWNhdGUtaW1wb3J0cywgaW1wb3J0L29yZGVyXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEdvRnVuY3Rpb25Qcm9wcyBleHRlbmRzIGxhbWJkYS5GdW5jdGlvbk9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBlbnRyeTogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBydW50aW1lPzogbGFtYmRhLlJ1bnRpbWU7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtb2R1bGVEaXI/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGJ1bmRsaW5nPzogQnVuZGxpbmdPcHRpb25zO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEdvRnVuY3Rpb24gZXh0ZW5kcyBsYW1iZGEuRnVuY3Rpb24ge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogR29GdW5jdGlvblByb3BzKSB7XG4gICAgaWYgKHByb3BzLnJ1bnRpbWUgJiYgKHByb3BzLnJ1bnRpbWUuZmFtaWx5ICE9PSBsYW1iZGEuUnVudGltZUZhbWlseS5HTyAmJiBwcm9wcy5ydW50aW1lLmZhbWlseSAhPSBsYW1iZGEuUnVudGltZUZhbWlseS5PVEhFUikpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignT25seSBgZ29gIGFuZCBgcHJvdmlkZWRgIHJ1bnRpbWVzIGFyZSBzdXBwb3J0ZWQuJyk7XG4gICAgfVxuXG4gICAgY29uc3QgZW50cnkgPSBwYXRoLnJlc29sdmUocHJvcHMuZW50cnkpO1xuXG4gICAgLy8gRmluZCB0aGUgcHJvamVjdCByb290XG4gICAgbGV0IG1vZHVsZURpcjogc3RyaW5nO1xuICAgIGlmIChwcm9wcy5tb2R1bGVEaXIpIHtcbiAgICAgIGNvbnN0IHBhcnNlZE1vZHVsZURpciA9IHBhdGgucGFyc2UocHJvcHMubW9kdWxlRGlyKTtcbiAgICAgIGlmIChwYXJzZWRNb2R1bGVEaXIuYmFzZSAmJiBwYXJzZWRNb2R1bGVEaXIuZXh0ICYmIHBhcnNlZE1vZHVsZURpci5iYXNlID09PSAnZ28ubW9kJykge1xuICAgICAgICBpZiAoIWZzLmV4aXN0c1N5bmMocHJvcHMubW9kdWxlRGlyKSkge1xuICAgICAgICAgIHRocm93IG5ldyBFcnJvcihgZ28ubW9kIGZpbGUgYXQgJHtwcm9wcy5tb2R1bGVEaXJ9IGRvZXNuJ3QgZXhpc3RgKTtcbiAgICAgICAgfVxuICAgICAgfSBlbHNlIGlmIChwYXJzZWRNb2R1bGVEaXIuYmFzZSAmJiBwYXJzZWRNb2R1bGVEaXIuZXh0ICYmIHBhcnNlZE1vZHVsZURpci5iYXNlICE9ICdnby5tb2QnKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcignbW9kdWxlRGlyIGlzIHNwZWNpZnlpbmcgYSBmaWxlIHRoYXQgaXMgbm90IGdvLm1vZCcpO1xuICAgICAgfSBlbHNlIGlmICghZnMuZXhpc3RzU3luYyhwYXRoLmpvaW4ocHJvcHMubW9kdWxlRGlyLCAnZ28ubW9kJykpKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcihgZ28ubW9kIGZpbGUgYXQgJHtwcm9wcy5tb2R1bGVEaXJ9IGRvZXNuJ3QgZXhpc3RgKTtcbiAgICAgIH1cbiAgICAgIG1vZHVsZURpciA9IHByb3BzLm1vZHVsZURpcjtcbiAgICB9IGVsc2Uge1xuICAgICAgY29uc3QgbW9kRmlsZSA9IGZpbmRVcCgnZ28ubW9kJywgZW50cnkpO1xuICAgICAgaWYgKCFtb2RGaWxlKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvciAoJ0Nhbm5vdCBmaW5kIGdvLm1vZC4gUGxlYXNlIHNwZWNpZnkgaXQgd2l0aCBgbW9kdWxlRGlyYC4nKTtcbiAgICAgIH1cbiAgICAgIG1vZHVsZURpciA9IG1vZEZpbGU7XG4gICAgfVxuXG4gICAgY29uc3QgcnVudGltZSA9IHByb3BzLnJ1bnRpbWUgPz8gbGFtYmRhLlJ1bnRpbWUuUFJPVklERURfQUwyO1xuXG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICAuLi5wcm9wcyxcbiAgICAgIHJ1bnRpbWUsXG4gICAgICBjb2RlOiBCdW5kbGluZy5idW5kbGUoe1xuICAgICAgICAuLi5wcm9wcy5idW5kbGluZyA/PyB7fSxcbiAgICAgICAgZW50cnksXG4gICAgICAgIHJ1bnRpbWUsXG4gICAgICAgIG1vZHVsZURpcixcbiAgICAgIH0pLFxuICAgICAgaGFuZGxlcjogJ2Jvb3RzdHJhcCcsIC8vIHNldHRpbmcgbmFtZSB0byBib290c3RyYXAgc28gdGhhdCB0aGUgJ3Byb3ZpZGVkJyBydW50aW1lIGNhbiBhbHNvIGJlIHVzZWRcbiAgICB9KTtcbiAgfVxufVxuXG4iXX0=