from typing import TYPE_CHECKING, List, Optional

import pydantic

# This file is based on autogenerated code from: https://static.ionq.co/schemas/circuit-v0.json using
# https://pydantic-docs.helpmanual.io/datamodel_code_generator/
# Run: datamodel-codegen --url https://static.ionq.co/schemas/circuit-v0.json

if TYPE_CHECKING:
    pydanticGateName = str
else:
    pydanticGateName = pydantic.constr(
        regex=r"^\w+$",
        min_length=1,
    )


class Gate(pydantic.BaseModel):
    gate: pydanticGateName
    target: Optional[int] = None
    control: Optional[int] = None
    targets: Optional[List[int]] = None
    controls: Optional[List[int]] = None


class IonqQuantumCircuit(pydantic.BaseModel):
    qubits: int
    circuit: List[Gate]
