# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['patterns_components',
 'patterns_components.components',
 'patterns_components.components.utilities',
 'patterns_components.components.utilities.generate_date_table',
 'patterns_components.components.vendor',
 'patterns_components.components.vendor.slack',
 'patterns_components.components.vendor.slack.functions',
 'patterns_components.components.vendor.square',
 'patterns_components.components.vendor.square.replication',
 'patterns_components.components.vendor.stripe',
 'patterns_components.components.vendor.stripe.replication',
 'patterns_components.helpers',
 'patterns_components.tests',
 'patterns_components.tests.test_components',
 'patterns_components.tests.test_components.utilities',
 'patterns_components.tests.test_components.utilities.generate_mock_data',
 'patterns_components.tests.test_components.vendor',
 'patterns_components.tests.test_components.vendor.square',
 'patterns_components.tests.test_components.vendor.square.tests',
 'patterns_components.tests.test_components.vendor.stripe',
 'patterns_components.tests.test_components.vendor.stripe.tests',
 'patterns_components.tests.test_helpers']

package_data = \
{'': ['*'],
 'patterns_components.components.utilities.generate_date_table': ['schemas/*'],
 'patterns_components.components.vendor.slack': ['docs/*'],
 'patterns_components.components.vendor.square': ['schemas/SquareCatalogObject.yml',
                                                  'schemas/SquareCatalogObject.yml',
                                                  'schemas/SquareCatalogObject.yml',
                                                  'schemas/SquareCatalogObject.yml',
                                                  'schemas/SquareCatalogObject.yml',
                                                  'schemas/SquareCustomer.yml',
                                                  'schemas/SquareCustomer.yml',
                                                  'schemas/SquareCustomer.yml',
                                                  'schemas/SquareCustomer.yml',
                                                  'schemas/SquareCustomer.yml',
                                                  'schemas/SquareLoyaltyAccount.yml',
                                                  'schemas/SquareLoyaltyAccount.yml',
                                                  'schemas/SquareLoyaltyAccount.yml',
                                                  'schemas/SquareLoyaltyAccount.yml',
                                                  'schemas/SquareLoyaltyAccount.yml',
                                                  'schemas/SquareOrder.yml',
                                                  'schemas/SquareOrder.yml',
                                                  'schemas/SquareOrder.yml',
                                                  'schemas/SquareOrder.yml',
                                                  'schemas/SquareOrder.yml',
                                                  'schemas/SquarePayment.yml',
                                                  'schemas/SquarePayment.yml',
                                                  'schemas/SquarePayment.yml',
                                                  'schemas/SquarePayment.yml',
                                                  'schemas/SquarePayment.yml'],
 'patterns_components.components.vendor.stripe': ['schemas/StripeCharge.yml',
                                                  'schemas/StripeCharge.yml',
                                                  'schemas/StripeCharge.yml',
                                                  'schemas/StripeCharge.yml',
                                                  'schemas/StripeCharge.yml',
                                                  'schemas/StripeInvoice.yml',
                                                  'schemas/StripeInvoice.yml',
                                                  'schemas/StripeInvoice.yml',
                                                  'schemas/StripeInvoice.yml',
                                                  'schemas/StripeInvoice.yml',
                                                  'schemas/StripeRefund.yml',
                                                  'schemas/StripeRefund.yml',
                                                  'schemas/StripeRefund.yml',
                                                  'schemas/StripeRefund.yml',
                                                  'schemas/StripeRefund.yml',
                                                  'schemas/StripeSubscription.yml',
                                                  'schemas/StripeSubscription.yml',
                                                  'schemas/StripeSubscription.yml',
                                                  'schemas/StripeSubscription.yml',
                                                  'schemas/StripeSubscription.yml',
                                                  'schemas/StripeSubscriptionItem.yml',
                                                  'schemas/StripeSubscriptionItem.yml',
                                                  'schemas/StripeSubscriptionItem.yml',
                                                  'schemas/StripeSubscriptionItem.yml',
                                                  'schemas/StripeSubscriptionItem.yml']}

install_requires = \
['PyYAML>=6.0,<7.0',
 'datacopy>=0.2.1,<0.3.0',
 'patterns-devkit>=1.4.0,<2.0.0',
 'requests-mock>=1.9.3,<2.0.0',
 'semver>=2.13.0,<3.0.0']

setup_kwargs = {
    'name': 'patterns-components',
    'version': '0.1.0',
    'description': 'Patterns open-source components',
    'long_description': '# Patterns Components\n\nOpen-source Components for the [Patterns platform](https://www.patterns.app).\n\nFor more information on developing components see the [component development docs](https://www.patterns.app/docs/dev/building-components).\n\n## Publishing components\n\nComponents are published with the [Patterns Devkit](https://github.com/patterns-app/patterns-devkit).\n\n`patterns upload [path to component] --publish-component`\n\n',
    'author': 'None',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8.1,<3.11',
}


setup(**setup_kwargs)
