# Generated by Django 3.0.5 on 2020-04-27 20:12

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django_extensions.db.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='KubernetesContainer',
            fields=[
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='description')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='title', verbose_name='slug')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, help_text='UUID Auto field.', primary_key=True, serialize=False)),
                ('config', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Pass in extra parameters here.', null=True)),
                ('deployed', models.DateTimeField(blank=True, help_text='Time when object is applied to cluster.', null=True)),
                ('removed', models.DateTimeField(blank=True, help_text='Time when object is removed from cluster.', null=True)),
                ('image_name', models.CharField(db_index=True, default='debian', help_text='Properly qualified image name.', max_length=200)),
                ('image_tag', models.CharField(db_index=True, default='latest', help_text='Tag name for the image to be used for this job', max_length=100)),
                ('image_pull_policy', models.CharField(choices=[('Always', 'Always'), ('IfNotPresent', 'IfNotPresent'), ('Never', 'Never')], default='IfNotPresent', max_length=16)),
                ('command', models.TextField(blank=True, help_text='Command to run when start container', null=True)),
                ('args', models.TextField(blank=True, help_text='Comma separated args to run with command        when instantiating container.', null=True)),
                ('port', models.IntegerField(default=80, help_text='Port to expose.')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='KubernetesNamespace',
            fields=[
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='description')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='title', verbose_name='slug')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, help_text='UUID Auto field.', primary_key=True, serialize=False)),
                ('config', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Pass in extra parameters here.', null=True)),
                ('deployed', models.DateTimeField(blank=True, help_text='Time when object is applied to cluster.', null=True)),
                ('removed', models.DateTimeField(blank=True, help_text='Time when object is removed from cluster.', null=True)),
                ('labels', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Dictionary store equivalent to Labels in Kubernetes API')),
                ('annotations', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Dictionary store equivalent to Annotations in Kubernetes API', null=True)),
                ('api_version', models.CharField(default='v1', max_length=16)),
                ('kind', models.CharField(default='Namespace', max_length=16)),
                ('exists', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='TargetCluster',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='description')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='title', verbose_name='slug')),
                ('api_endpoint', models.URLField(help_text='Cluster Endpoint URL')),
                ('telemetry_endpoint', models.URLField(help_text='Telemetry Endpoint URL')),
                ('telemetry_source', models.CharField(choices=[('p', 'Prometheus')], default='p', max_length=5)),
                ('config', django.contrib.postgres.fields.jsonb.JSONField(help_text='Equivalent to .kube/config but all JSON', null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='KubernetesVolumeMount',
            fields=[
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='description')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='title', verbose_name='slug')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, help_text='UUID Auto field.', primary_key=True, serialize=False)),
                ('config', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Pass in extra parameters here.', null=True)),
                ('deployed', models.DateTimeField(blank=True, help_text='Time when object is applied to cluster.', null=True)),
                ('removed', models.DateTimeField(blank=True, help_text='Time when object is removed from cluster.', null=True)),
                ('mount_path', models.CharField(default='/media', max_length=255)),
                ('sub_path', models.CharField(blank=True, default=None, max_length=255, null=True)),
                ('cluster', models.ForeignKey(help_text='ForeignKey to TargetCluster object.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='kubernetes_manager.TargetCluster')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='KubernetesVolume',
            fields=[
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='description')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='title', verbose_name='slug')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, help_text='UUID Auto field.', primary_key=True, serialize=False)),
                ('config', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Pass in extra parameters here.', null=True)),
                ('deployed', models.DateTimeField(blank=True, help_text='Time when object is applied to cluster.', null=True)),
                ('removed', models.DateTimeField(blank=True, help_text='Time when object is removed from cluster.', null=True)),
                ('cluster', models.ForeignKey(help_text='ForeignKey to TargetCluster object.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='kubernetes_manager.TargetCluster')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='KubernetesService',
            fields=[
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='description')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='title', verbose_name='slug')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, help_text='UUID Auto field.', primary_key=True, serialize=False)),
                ('config', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Pass in extra parameters here.', null=True)),
                ('deployed', models.DateTimeField(blank=True, help_text='Time when object is applied to cluster.', null=True)),
                ('removed', models.DateTimeField(blank=True, help_text='Time when object is removed from cluster.', null=True)),
                ('labels', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Dictionary store equivalent to Labels in Kubernetes API')),
                ('annotations', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Dictionary store equivalent to Annotations in Kubernetes API', null=True)),
                ('api_version', models.CharField(default='v1', help_text='API version used to deploy child object.', max_length=16)),
                ('kind', models.CharField(help_text='String representation of Kubernetes object kind', max_length=16)),
                ('port', models.IntegerField(default=80, help_text='Port object will expose')),
                ('kuid', models.CharField(blank=True, help_text="Object's UID in the cluster", max_length=48, null=True)),
                ('selector', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
                ('target_port', models.IntegerField(default=80)),
                ('cluster', models.ForeignKey(help_text='ForeignKey to TargetCluster object.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='kubernetes_manager.TargetCluster')),
                ('namespace', models.ForeignKey(help_text='Live namespace the object is associated with.', on_delete=django.db.models.deletion.CASCADE, to='kubernetes_manager.KubernetesNamespace')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='KubernetesPodTemplate',
            fields=[
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='description')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='title', verbose_name='slug')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, help_text='UUID Auto field.', primary_key=True, serialize=False)),
                ('config', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Pass in extra parameters here.', null=True)),
                ('deployed', models.DateTimeField(blank=True, help_text='Time when object is applied to cluster.', null=True)),
                ('removed', models.DateTimeField(blank=True, help_text='Time when object is removed from cluster.', null=True)),
                ('labels', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Dictionary store equivalent to Labels in Kubernetes API')),
                ('annotations', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Dictionary store equivalent to Annotations in Kubernetes API', null=True)),
                ('restart_policy', models.CharField(choices=[('Always', 'Always'), ('OnFailure', 'OnFailure'), ('Never', 'Never')], default='Never', help_text='How the pod should handle restart om case of failures', max_length=16)),
                ('cluster', models.ForeignKey(help_text='ForeignKey to TargetCluster object.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='kubernetes_manager.TargetCluster')),
                ('containers', models.ManyToManyField(help_text='All containers to be included in a pod.', to='kubernetes_manager.KubernetesContainer')),
                ('volumes', models.ManyToManyField(blank=True, help_text='All volumes to be created for a pod.', to='kubernetes_manager.KubernetesVolume')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='kubernetesnamespace',
            name='cluster',
            field=models.ForeignKey(help_text='ForeignKey to TargetCluster object.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='kubernetes_manager.TargetCluster'),
        ),
        migrations.CreateModel(
            name='KubernetesJob',
            fields=[
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='description')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='title', verbose_name='slug')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, help_text='UUID Auto field.', primary_key=True, serialize=False)),
                ('config', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Pass in extra parameters here.', null=True)),
                ('deployed', models.DateTimeField(blank=True, help_text='Time when object is applied to cluster.', null=True)),
                ('removed', models.DateTimeField(blank=True, help_text='Time when object is removed from cluster.', null=True)),
                ('labels', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Dictionary store equivalent to Labels in Kubernetes API')),
                ('annotations', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Dictionary store equivalent to Annotations in Kubernetes API', null=True)),
                ('api_version', models.CharField(default='v1', help_text='API version used to deploy child object.', max_length=16)),
                ('kind', models.CharField(help_text='String representation of Kubernetes object kind', max_length=16)),
                ('port', models.IntegerField(default=80, help_text='Port object will expose')),
                ('kuid', models.CharField(blank=True, help_text="Object's UID in the cluster", max_length=48, null=True)),
                ('object_status', models.CharField(blank=True, help_text='status of the object in Kubernetes', max_length=128, null=True)),
                ('average_cpu_usage', models.DecimalField(blank=True, decimal_places=4, help_text='Average PIT CPU units consumed', max_digits=8, null=True)),
                ('average_mem_usage', models.IntegerField(blank=True, help_text='Average PIT bytes consumed', null=True)),
                ('cpu_usage_seconds', models.DecimalField(blank=True, decimal_places=4, help_text='Average cpu usage * seconds live', max_digits=8, null=True)),
                ('mem_usage_seconds', models.IntegerField(blank=True, help_text='Average mem usage * seconds live', null=True)),
                ('backoff_limit', models.IntegerField(default=3)),
                ('cluster', models.ForeignKey(help_text='ForeignKey to TargetCluster object.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='kubernetes_manager.TargetCluster')),
                ('namespace', models.ForeignKey(help_text='Live namespace the object is associated with.', on_delete=django.db.models.deletion.CASCADE, to='kubernetes_manager.KubernetesNamespace')),
                ('pod_template', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kubernetes_manager.KubernetesPodTemplate')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='KubernetesIngress',
            fields=[
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='description')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='title', verbose_name='slug')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, help_text='UUID Auto field.', primary_key=True, serialize=False)),
                ('config', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Pass in extra parameters here.', null=True)),
                ('deployed', models.DateTimeField(blank=True, help_text='Time when object is applied to cluster.', null=True)),
                ('removed', models.DateTimeField(blank=True, help_text='Time when object is removed from cluster.', null=True)),
                ('labels', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Dictionary store equivalent to Labels in Kubernetes API')),
                ('annotations', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Dictionary store equivalent to Annotations in Kubernetes API', null=True)),
                ('api_version', models.CharField(default='v1', help_text='API version used to deploy child object.', max_length=16)),
                ('kind', models.CharField(help_text='String representation of Kubernetes object kind', max_length=16)),
                ('port', models.IntegerField(default=80, help_text='Port object will expose')),
                ('kuid', models.CharField(blank=True, help_text="Object's UID in the cluster", max_length=48, null=True)),
                ('hostname', models.CharField(default='localhost', max_length=255)),
                ('path', models.CharField(default='/', max_length=255)),
                ('cluster', models.ForeignKey(help_text='ForeignKey to TargetCluster object.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='kubernetes_manager.TargetCluster')),
                ('namespace', models.ForeignKey(help_text='Live namespace the object is associated with.', on_delete=django.db.models.deletion.CASCADE, to='kubernetes_manager.KubernetesNamespace')),
                ('target_service', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kubernetes_manager.KubernetesService')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='KubernetesDeployment',
            fields=[
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='description')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='title', verbose_name='slug')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, help_text='UUID Auto field.', primary_key=True, serialize=False)),
                ('config', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Pass in extra parameters here.', null=True)),
                ('deployed', models.DateTimeField(blank=True, help_text='Time when object is applied to cluster.', null=True)),
                ('removed', models.DateTimeField(blank=True, help_text='Time when object is removed from cluster.', null=True)),
                ('labels', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Dictionary store equivalent to Labels in Kubernetes API')),
                ('annotations', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Dictionary store equivalent to Annotations in Kubernetes API', null=True)),
                ('api_version', models.CharField(default='v1', help_text='API version used to deploy child object.', max_length=16)),
                ('kind', models.CharField(help_text='String representation of Kubernetes object kind', max_length=16)),
                ('port', models.IntegerField(default=80, help_text='Port object will expose')),
                ('kuid', models.CharField(blank=True, help_text="Object's UID in the cluster", max_length=48, null=True)),
                ('object_status', models.CharField(blank=True, help_text='status of the object in Kubernetes', max_length=128, null=True)),
                ('average_cpu_usage', models.DecimalField(blank=True, decimal_places=4, help_text='Average PIT CPU units consumed', max_digits=8, null=True)),
                ('average_mem_usage', models.IntegerField(blank=True, help_text='Average PIT bytes consumed', null=True)),
                ('cpu_usage_seconds', models.DecimalField(blank=True, decimal_places=4, help_text='Average cpu usage * seconds live', max_digits=8, null=True)),
                ('mem_usage_seconds', models.IntegerField(blank=True, help_text='Average mem usage * seconds live', null=True)),
                ('selector', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
                ('replicas', models.IntegerField(default=1)),
                ('cluster', models.ForeignKey(help_text='ForeignKey to TargetCluster object.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='kubernetes_manager.TargetCluster')),
                ('namespace', models.ForeignKey(help_text='Live namespace the object is associated with.', on_delete=django.db.models.deletion.CASCADE, to='kubernetes_manager.KubernetesNamespace')),
                ('pod_template', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kubernetes_manager.KubernetesPodTemplate')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='kubernetescontainer',
            name='cluster',
            field=models.ForeignKey(help_text='ForeignKey to TargetCluster object.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='kubernetes_manager.TargetCluster'),
        ),
        migrations.AddField(
            model_name='kubernetescontainer',
            name='volume_mounts',
            field=models.ManyToManyField(blank=True, help_text='Mounts for any number of volumes', to='kubernetes_manager.KubernetesVolumeMount'),
        ),
        migrations.CreateModel(
            name='KubernetesConfigMap',
            fields=[
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='description')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='title', verbose_name='slug')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, help_text='UUID Auto field.', primary_key=True, serialize=False)),
                ('config', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Pass in extra parameters here.', null=True)),
                ('deployed', models.DateTimeField(blank=True, help_text='Time when object is applied to cluster.', null=True)),
                ('removed', models.DateTimeField(blank=True, help_text='Time when object is removed from cluster.', null=True)),
                ('labels', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Dictionary store equivalent to Labels in Kubernetes API')),
                ('annotations', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Dictionary store equivalent to Annotations in Kubernetes API', null=True)),
                ('kind', models.CharField(default='ConfigMap', max_length=16)),
                ('data', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, null=True)),
                ('binary', models.BinaryField(blank=True, null=True)),
                ('override_name', models.CharField(blank=True, default='ConfigMap', max_length=32, null=True)),
                ('cluster', models.ForeignKey(help_text='ForeignKey to TargetCluster object.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='kubernetes_manager.TargetCluster')),
                ('namespace', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kubernetes_manager.KubernetesNamespace')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
