# -*- coding: utf-8 -*-

"""
MIT License

Copyright (c) 2021 plun1331

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
"""


class GameInfo:
    r"""Contains information on some games and their IDs."""
    apinames = {
        'QUAKECRAFT': "Quake",
        'WALLS': 'Walls',
        'PAINTBALL': 'Paintball',
        'SURVIVAL_GAMES': 'Blitz Survival Games',
        'TNTGAMES': 'TNT Games',
        'VAMPIREZ': 'VampireZ',
        'WALLS3': 'Mega Walls',
        'ARCADE': 'Arcade',
        'ARENA': 'Arena',
        'UHC': 'UHC Champions',
        'MCGO': 'Cops and Crims',
        'BATTLEGROUND': 'Warlords',
        'SUPER_SMASH': 'Smash Heroes',
        'GINGERBREAD': 'Turbo Kart Racers',
        'HOUSING': 'Housing',
        'SKYWARS': 'Skywars',
        'TRUE_COMBAT': 'Crazy Walls',
        'SPEED_UHC': 'Speed UHC',
        'SKYCLASH': 'SkyClash',
        'LEGACY': 'Classic Games',
        'PROTOTYPE': 'Prototype',
        'BEDWARS': 'BedWars',
        'MURDER_MYSTERY': 'Murder Mystery',
        'BUILD_BATTLE': 'Build Battle',
        'DUELS': 'Duels',
        'SKYBLOCK': 'Skyblock',
        'PIT': 'The Pit'
    }

    databasenames = {
        'quake': 'Quake',
        'walls': 'Walls',
        'paintball': 'Paintball',
        'hungergames': 'Blitz Survival Games',
        'blitz': 'Blitz Survival Games',
        'tntgames': 'TNT Games',
        'vampirez': 'VampireZ',
        'walls3': 'Mega Walls',
        'arcade': 'Arcade',
        'arena': 'Arena',
        'uhc': 'UHC Champions',
        'mcgo': 'Cops and Crims',
        'copsandcrims': 'Cops and Crims',
        'battleground': 'Warlords',
        'warlords': 'Warlords',
        'supersmash': 'Smash Heroes',
        'gingerbread': 'Turbo Kart Racers',
        'housing': 'Housing',
        'skywars': 'SkyWars',
        'truecombat': 'Crazy Walls',
        'speeduhc': 'Speed UHC',
        'skyclash': 'SkyClash',
        'legacy': 'Classic Games',
        'prototype': 'Prototype',
        'bedwars': 'Bed Wars',
        'murdermystery': 'Murder Mystery',
        'buildbattle': 'Build Battle',
        'duels': 'Duels',
        'skyblock': 'SkyBlock',
        'pit': 'Pit'
    }

    ids = {
        'QUAKECRAFT': 2,
        'WALLS': 3,
        'PAINTBALL': 4,
        'SURVIVAL_GAMES': 5,
        'TNTGAMES': 6,
        'VAMPIREZ': 7,
        'WALLS3': 12,
        'ARCADE': 14,
        'ARENA': 17,
        'UHC': 20,
        'MCGO': 21,
        'BATTLEGROUND': 23,
        'SUPER_SMASH': 24,
        'GINGERBREAD': 25,
        'HOUSING': 26,
        'SKYWARS': 51,
        'TRUE_COMBAT': 52,
        'SPEED_UHC': 54,
        'SKYCLASH': 55,
        'LEGACY': 56,
        'PROTOTYPE': 57,
        'BEDWARS': 58,
        'MURDER_MYSTERY': 59,
        'BUILD_BATTLE': 60,
        'DUELS': 61,
        'SKYBLOCK': 63,
        'PIT': 64
    }
