# statements that used at the start of defenition or in statements without columns
defenition_statements = {
    "DROP": "DROP",
    "CREATE": "CREATE",
    "TABLE": "TABLE",
    "DATABASE": "DATABASE",
    "SCHEMA": "SCHEMA",
    "ALTER": "ALTER",
    "TYPE": "TYPE",
    "DOMAIN": "DOMAIN",
    "REPLACE": "REPLACE",
    "OR": "OR",
    "CLUSTERED": "CLUSTERED",
    "SEQUENCE": "SEQUENCE",
    "TABLESPACE": "TABLESPACE",
}
common_statements = {
    "INDEX": "INDEX",
    "REFERENCES": "REFERENCES",
    "KEY": "KEY",
    "ADD": "ADD",
    "AS": "AS",
    "LIKE": "LIKE",
    "CLONE": "CLONE",
    "DEFERRABLE": "DEFERRABLE",
    "INITIALLY": "INITIALLY",
    "IF": "IF",
    "NOT": "NOT",
    "EXISTS": "EXISTS",
    "ON": "ON",
    "FOR": "FOR",
    "ENCRYPT": "ENCRYPT",
    "SALT": "SALT",
    "NO": "NO",
    "USING": "USING",
}

columns_defenition = {
    "DELETE": "DELETE",
    "UPDATE": "UPDATE",
    "NULL": "NULL",
    "ARRAY": "ARRAY",
    ",": "COMMA",
    "DEFAULT": "DEFAULT",
    "COLLATE": "COLLATE",
    "ENFORCED": "ENFORCED",
    "ENCODE": "ENCODE",
    "GENERATED": "GENERATED",
    "COMMENT": "COMMENT",
}
first_liners = {
    "CONSTRAINT": "CONSTRAINT",
    "FOREIGN": "FOREIGN",
    "PRIMARY": "PRIMARY",
    "UNIQUE": "UNIQUE",
    "CHECK": "CHECK",
}

common_statements.update(first_liners)
defenition_statements.update(common_statements)
after_columns_tokens = {
    "PARTITIONED": "PARTITIONED",
    "PARTITION": "PARTITION",
    "BY": "BY",
    # hql
    "STORED": "STORED",
    "LOCATION": "LOCATION",
    "ROW": "ROW",
    "FORMAT": "FORMAT",
    "TERMINATED": "TERMINATED",
    "COLLECTION": "COLLECTION",
    "ITEMS": "ITEMS",
    "MAP": "MAP",
    "KEYS": "KEYS",
    "SERDE": "SERDE",
    "WITH": "WITH",
    "CLUSTER": "CLUSTER",
    "SERDEPROPERTIES": "SERDEPROPERTIES",
    "TBLPROPERTIES": "TBLPROPERTIES",
    # oracle
    "STORAGE": "STORAGE",
    "TABLESPACE": "TABLESPACE",
}
sequence_reserved = {
    "INCREMENT": "INCREMENT",
    "START": "START",
    "MINVALUE": "MINVALUE",
    "MAXVALUE": "MAXVALUE",
    "CACHE": "CACHE",
}


tokens = tuple(
    set(
        ["ID", "DOT", "STRING", "LP", "RP", "LT", "RT", "COMMAT", "NEWLINE"]
        + list(defenition_statements.values())
        + list(common_statements.values())
        + list(columns_defenition.values())
        + list(sequence_reserved.values())
        + list(after_columns_tokens.values())
    )
)

symbol_tokens = {
    ")": "RP",
    "(": "LP",
}

symbol_tokens_no_check = {"<": "LT", ">": "RT"}
