"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LazyNodejsFunctions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_lambda_nodejs_1 = require("aws-cdk-lib/aws-lambda-nodejs");
class LazyNodejsFunctions extends aws_lambda_nodejs_1.NodejsFunction {
    constructor(scope, id, props) {
        // Entry and defaults
        const errorAlarm = props.errorAlarm ?? true;
        super(scope, id, {
            ...props,
            tracing: props?.tracing ?? aws_lambda_1.Tracing.ACTIVE,
        });
        if (errorAlarm) {
            const errorMetric = this.metricErrors({
                period: aws_cdk_lib_1.Duration.minutes(1),
            });
            new aws_cloudwatch_1.Alarm(this, 'ErrorAlarm', {
                alarmName: this.functionName.concat('ErrorAlarm'),
                metric: errorMetric,
                threshold: 1,
                evaluationPeriods: 1,
                comparisonOperator: aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
            });
        }
    }
}
exports.LazyNodejsFunctions = LazyNodejsFunctions;
_a = JSII_RTTI_SYMBOL_1;
LazyNodejsFunctions[_a] = { fqn: "lazy-constructs.LazyNodejsFunctions", version: "0.0.8" };
//# sourceMappingURL=data:application/json;base64,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