"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DualNlbFargateService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
const route53 = require("@aws-cdk/aws-route53");
const targets = require("@aws-cdk/aws-route53-targets");
const cdk = require("@aws-cdk/core");
const main_1 = require("./main");
;
/**
 * @stability stable
 */
class DualNlbFargateService extends main_1.BaseFargateService {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id, props);
        if (this.hasExternalLoadBalancer) {
            this.externalNlb = new elbv2.NetworkLoadBalancer(this, 'ExternalNlb', {
                vpc: this.vpc,
                internetFacing: true,
            });
        }
        if (this.hasInternalLoadBalancer) {
            this.internalNlb = new elbv2.NetworkLoadBalancer(this, 'InternalNlb', {
                vpc: this.vpc,
                internetFacing: false,
            });
        }
        props.tasks.forEach((t, index) => {
            var _b, _c, _d, _e, _f, _g, _h;
            const defaultContainerName = (_b = t.task.defaultContainer) === null || _b === void 0 ? void 0 : _b.containerName;
            // default scaling policy
            const scaling = this.service[index].autoScaleTaskCount({ maxCapacity: (_d = (_c = t.scalingPolicy) === null || _c === void 0 ? void 0 : _c.maxCapacity) !== null && _d !== void 0 ? _d : 10 });
            scaling.scaleOnCpuUtilization('CpuScaling', {
                targetUtilizationPercent: (_f = (_e = t.scalingPolicy) === null || _e === void 0 ? void 0 : _e.targetCpuUtilization) !== null && _f !== void 0 ? _f : 50,
            });
            if (t.external) {
                const exttg = new elbv2.NetworkTargetGroup(this, `${defaultContainerName}ExtTG`, {
                    protocol: (_g = t.protocol) !== null && _g !== void 0 ? _g : elbv2.Protocol.TCP,
                    port: t.external.port,
                    vpc: this.vpc,
                    healthCheck: t.healthCheck,
                });
                // listener for the external Nlb
                new elbv2.NetworkListener(this, `ExtNlbListener${t.external.port}`, {
                    loadBalancer: this.externalNlb,
                    port: t.external.port,
                    protocol: t.external.certificate ? elbv2.Protocol.TLS : elbv2.Protocol.TCP,
                    certificates: t.external.certificate,
                    defaultTargetGroups: [exttg],
                });
                exttg.addTarget(this.service[index]);
            }
            if (t.internal) {
                const inttg = new elbv2.NetworkTargetGroup(this, `${defaultContainerName}IntTG`, {
                    protocol: (_h = t.protocol) !== null && _h !== void 0 ? _h : elbv2.Protocol.TCP,
                    port: t.internal.port,
                    vpc: this.vpc,
                    healthCheck: t.healthCheck,
                });
                // listener for the internal Nlb
                new elbv2.NetworkListener(this, `IntNlbListener${t.internal.port}`, {
                    loadBalancer: this.internalNlb,
                    port: t.internal.port,
                    protocol: t.internal.certificate ? elbv2.Protocol.TLS : elbv2.Protocol.TCP,
                    certificates: t.internal.certificate,
                    defaultTargetGroups: [inttg],
                });
                inttg.addTarget(this.service[index]);
            }
        });
        // Route53
        const externalNlbRecordName = (_c = (_b = props.route53Ops) === null || _b === void 0 ? void 0 : _b.externalElbRecordName) !== null && _c !== void 0 ? _c : 'external';
        const internalNlbRecordName = (_e = (_d = props.route53Ops) === null || _d === void 0 ? void 0 : _d.internalElbRecordName) !== null && _e !== void 0 ? _e : 'internal';
        if (this.enableLoadBalancerAlias) {
            const zone = new route53.PrivateHostedZone(this, 'HostedZone', {
                zoneName: this.zoneName,
                vpc: this.vpc,
            });
            if (this.hasInternalLoadBalancer) {
                new route53.ARecord(this, 'InternalNlbAlias', {
                    zone,
                    recordName: internalNlbRecordName,
                    target: route53.RecordTarget.fromAlias(new targets.LoadBalancerTarget(this.internalNlb)),
                });
            }
            if (this.hasExternalLoadBalancer) {
                new route53.ARecord(this, 'ExternalNlbAlias', {
                    zone,
                    recordName: externalNlbRecordName,
                    target: route53.RecordTarget.fromAlias(new targets.LoadBalancerTarget(this.externalNlb)),
                });
            }
            if (this.hasExternalLoadBalancer) {
                new cdk.CfnOutput(this, 'ExternalEndpoint', { value: `http://${this.externalNlb.loadBalancerDnsName}` });
                new cdk.CfnOutput(this, 'ExternalEndpointPrivate', { value: `http://${externalNlbRecordName}.${this.zoneName}` });
            }
            if (this.hasInternalLoadBalancer) {
                new cdk.CfnOutput(this, 'InternalEndpoint', { value: `http://${this.internalNlb.loadBalancerDnsName}` });
                new cdk.CfnOutput(this, 'InternalEndpointPrivate', { value: `http://${internalNlbRecordName}.${this.zoneName}` });
            }
        }
        else {
            if (this.hasExternalLoadBalancer) {
                new cdk.CfnOutput(this, 'ExternalEndpoint', { value: `http://${this.externalNlb.loadBalancerDnsName}` });
            }
            if (this.hasInternalLoadBalancer) {
                new cdk.CfnOutput(this, 'InternalEndpoint', { value: `http://${this.internalNlb.loadBalancerDnsName}` });
            }
        }
    }
}
exports.DualNlbFargateService = DualNlbFargateService;
_a = JSII_RTTI_SYMBOL_1;
DualNlbFargateService[_a] = { fqn: "cdk-fargate-patterns.DualNlbFargateService", version: "0.3.46" };
;
//# sourceMappingURL=data:application/json;base64,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