/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import java.util.Collections;
import proper.core.Assignable;
import proper.database.Column;
import proper.util.ProperVector;

public class Table
implements Comparable,
Assignable {
    protected String name;
    protected int size;
    protected boolean sortByName;

    public Table(String name) {
        this(name, 0);
    }

    public Table(String name, int size) {
        this.name = name;
        this.size = size;
        this.sortByName = true;
    }

    public String getName() {
        return this.name;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setSortByName(boolean sortByName) {
        this.sortByName = sortByName;
    }

    public boolean getSortByName() {
        return this.sortByName;
    }

    public int compareTo(Object o) {
        int result = 0;
        Table t = (Table)o;
        result = this.getSortByName() ? this.getName().toLowerCase().compareTo(t.getName().toLowerCase()) : (this.getSize() < t.getSize() ? -1 : (this.getSize() == t.getSize() ? 0 : 1));
        return result;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public String createForeignKeyStatement(Column localCol, Table foreignTable, Column foreignCol) {
        return Table.createForeignKeyStatement(this, localCol, foreignTable, foreignCol);
    }

    public static String createForeignKeyStatement(Table localTable, Column localCol, Table foreignTable, Column foreignCol) {
        return "ALTER TABLE " + localTable.getName() + " " + "ADD FOREIGN KEY (" + localCol.getName() + ") " + "REFERENCES " + foreignTable.getName() + " (" + foreignCol.getName() + ")" + ";";
    }

    @Override
    public void assign(Object o) {
        if (!(o instanceof Table)) {
            return;
        }
        Table t = (Table)o;
        this.name = t.getName();
        this.size = t.getSize();
        this.sortByName = t.getSortByName();
    }

    public String toString() {
        return this.getName();
    }

    public static void main(String[] args) {
        ProperVector list = new ProperVector();
        list.add(new Table("table1", 10));
        list.add(new Table("table3", 1));
        list.add(new Table("table0", 20));
        list.add(new Table("Table2", 13));
        System.out.println("\nUnsorted:");
        int i = 0;
        while (i < list.size()) {
            System.out.println(list.get(i) + " = " + ((Table)list.get(i)).getSize());
            ++i;
        }
        Collections.sort(list);
        System.out.println("\nSorted by name:");
        i = 0;
        while (i < list.size()) {
            System.out.println(list.get(i) + " = " + ((Table)list.get(i)).getSize());
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            ((Table)list.get(i)).setSortByName(false);
            ++i;
        }
        Collections.sort(list);
        System.out.println("\nSorted by size:");
        i = 0;
        while (i < list.size()) {
            System.out.println(list.get(i) + " = " + ((Table)list.get(i)).getSize());
            ++i;
        }
    }
}

