/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import proper.database.ColumnLister;
import proper.database.Connector;
import proper.database.Join;
import proper.gui.core.dialog.ProperDialog;
import proper.gui.core.frame.DummyFrame;
import proper.gui.core.frame.ProperFrame;
import proper.gui.core.panel.OkCancelPanel;
import proper.util.Set;

public class JoinBuilderDialog
extends ProperDialog {
    private Connector mConnector;
    private OkCancelPanel mPanelOkCancel;
    private String mLeftTable;
    private String mRightTable;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JButton jButtonDelete;
    private JPanel jPanel6;
    private JButton jButtonAdd;
    private JComboBox jComboBoxRightColumns;
    private JLabel jLabelColumnsWith;
    private JComboBox jComboBoxLeftColumns;
    private JLabel jLabelColumns;
    private JLabel jLabelRightTable;
    private JLabel jLabelLeftTable;
    private JPanel jPanel5;
    private JList jListJoins;
    private JScrollPane jScrollPaneJoins;
    private JLabel jLabelJoins;
    private JPanel jPanel4;
    private JPanel jPanel3;
    private JPanel jPanel1;

    public JoinBuilderDialog() {
        this(new DummyFrame(), "Join Builder");
    }

    public JoinBuilderDialog(ProperFrame parent) {
        this(parent, "Join Builder");
    }

    public JoinBuilderDialog(String title) {
        this(new DummyFrame(), title);
    }

    public JoinBuilderDialog(ProperFrame parent, String title) {
        super(parent, title);
        this.initialize();
        this.createDialog();
    }

    @Override
    protected void createDialog() {
        super.createDialog();
        this.getContentPane().setLayout(new BorderLayout());
        this.mPanelOkCancel = new OkCancelPanel(true);
        this.mPanelOkCancel.addActionListener(this);
        this.mPanelOkCancel.addKeyListener(this);
        JPanel panel = new JPanel(new FlowLayout(4));
        panel.add(this.mPanelOkCancel);
        this.getContentPane().add((Component)panel, "South");
        this.jPanel1 = new JPanel();
        BorderLayout jPanel1Layout = new BorderLayout();
        this.jPanel1.setLayout(jPanel1Layout);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.jPanel3 = new JPanel();
        this.jPanel1.add((Component)this.jPanel3, "Center");
        FlowLayout jPanel3Layout = new FlowLayout();
        jPanel3Layout.setAlignment(0);
        this.jPanel3.setLayout(jPanel3Layout);
        this.jLabelColumns = new JLabel();
        this.jPanel3.add(this.jLabelColumns);
        this.jLabelColumns.setText("Columns");
        this.jLabelColumns.setPreferredSize(new Dimension(60, 20));
        this.jLabelLeftTable = new JLabel();
        this.jPanel3.add(this.jLabelLeftTable);
        this.jLabelLeftTable.setText("left");
        this.jLabel1 = new JLabel();
        this.jPanel3.add(this.jLabel1);
        this.jLabel1.setText(".");
        this.jComboBoxLeftColumns = new JComboBox();
        this.jPanel3.add(this.jComboBoxLeftColumns);
        this.jLabelColumnsWith = new JLabel();
        this.jPanel3.add(this.jLabelColumnsWith);
        this.jLabelColumnsWith.setText("=");
        this.jLabelRightTable = new JLabel();
        this.jPanel3.add(this.jLabelRightTable);
        this.jLabelRightTable.setText("right");
        this.jLabel2 = new JLabel();
        this.jPanel3.add(this.jLabel2);
        this.jLabel2.setText(".");
        this.jComboBoxRightColumns = new JComboBox();
        this.jPanel3.add(this.jComboBoxRightColumns);
        this.jButtonAdd = new JButton();
        this.jPanel3.add(this.jButtonAdd);
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.setPreferredSize(new Dimension(80, 25));
        this.jButtonAdd.setMnemonic(65);
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JoinBuilderDialog.this.addJoin(JoinBuilderDialog.this.jComboBoxLeftColumns.getSelectedItem().toString(), JoinBuilderDialog.this.jComboBoxRightColumns.getSelectedItem().toString());
            }
        });
        this.jPanel4 = new JPanel();
        BorderLayout jPanel4Layout = new BorderLayout();
        this.jPanel4.setLayout(jPanel4Layout);
        this.getContentPane().add((Component)this.jPanel4, "Center");
        this.jListJoins = new JList(new DefaultListModel());
        this.jScrollPaneJoins = new JScrollPane(this.jListJoins);
        this.jPanel4.add((Component)this.jScrollPaneJoins, "Center");
        this.jPanel5 = new JPanel();
        this.jPanel4.add((Component)this.jPanel5, "West");
        this.jLabelJoins = new JLabel();
        this.jPanel5.add(this.jLabelJoins);
        this.jLabelJoins.setText("Joins");
        this.jLabelJoins.setPreferredSize(new Dimension(60, 20));
        this.jPanel6 = new JPanel();
        this.jPanel4.add((Component)this.jPanel6, "East");
        this.jButtonDelete = new JButton();
        this.jPanel6.add(this.jButtonDelete);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setPreferredSize(new Dimension(80, 25));
        this.jButtonDelete.setMnemonic(68);
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int[] indices = JoinBuilderDialog.this.jListJoins.getSelectedIndices();
                int i = indices.length - 1;
                while (i >= 0) {
                    ((DefaultListModel)JoinBuilderDialog.this.jListJoins.getModel()).removeElementAt(indices[i]);
                    --i;
                }
            }
        });
        this.getRootPane().setDefaultButton(this.mPanelOkCancel.buttonOK);
    }

    protected void addJoin(String leftCol, String rightCol) {
        String join = String.valueOf(this.getLeftTable()) + "." + leftCol + " = " + this.getRightTable() + "." + rightCol;
        ((DefaultListModel)this.jListJoins.getModel()).addElement(join);
    }

    public void setConnector(Connector conn) {
        this.mConnector = conn;
    }

    public Connector getConnector() {
        return this.mConnector;
    }

    public void setLeftTable(String table) {
        this.mLeftTable = table;
    }

    public String getLeftTable() {
        return this.mLeftTable;
    }

    public void setRightTable(String table) {
        this.mRightTable = table;
    }

    public String getRightTable() {
        return this.mRightTable;
    }

    public Join getJoin() {
        Join result = null;
        if (this.jListJoins.getModel().getSize() > 0) {
            String[] left = new String[this.jListJoins.getModel().getSize()];
            String[] right = new String[this.jListJoins.getModel().getSize()];
            int i = 0;
            while (i < left.length) {
                String join = this.jListJoins.getModel().getElementAt(i).toString();
                left[i] = join.substring(0, join.indexOf(" = ")).replaceAll(".*\\.", "").trim();
                right[i] = join.substring(join.indexOf(" = ") + 2).replaceAll(".*\\.", "").trim();
                ++i;
            }
            result = new Join(this.getRightTable(), right, this.getLeftTable(), left);
        }
        return result;
    }

    @Override
    public void show() {
        ColumnLister cols = new ColumnLister(this.getConnector());
        cols.setSort(true);
        this.jLabelLeftTable.setText(this.getLeftTable());
        cols.setTable(this.getLeftTable());
        this.jComboBoxLeftColumns.setModel(new DefaultComboBoxModel(cols.getList()));
        this.jLabelRightTable.setText(this.getRightTable());
        cols.setTable(this.getRightTable());
        this.jComboBoxRightColumns.setModel(new DefaultComboBoxModel(cols.getList()));
        this.jListJoins.removeAll();
        cols.setAddTable(false);
        cols.setTable(this.getLeftTable());
        Vector listLeft = cols.getList();
        cols.setTable(this.getRightTable());
        Vector listRight = cols.getList();
        Vector common = Set.intersect(listLeft, listRight);
        int i = 0;
        while (i < common.size()) {
            this.addJoin(common.get(i).toString(), common.get(i).toString());
            ++i;
        }
        this.pack();
        this.setCenteredLocation();
        super.show();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("ok")) {
            this.approved = true;
            this.close();
        } else if (action.equals("cancel")) {
            this.close();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            e.consume();
            this.close();
        }
    }
}

