/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import proper.gui.core.frame.ApplicationFrame;
import proper.gui.core.frame.DatabaseChildFrame;
import proper.gui.core.panel.RelationsPanel;

public class Relations
extends DatabaseChildFrame {
    private RelationsPanel panelRelations;
    private String maxDepth;

    public Relations(ApplicationFrame parent) {
        super(parent, "Relations");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.maxDepth = "1";
    }

    @Override
    protected void createFrame() {
        super.createFrame();
        this.setConfirmExit(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.panelRelations = new RelationsPanel(this, this.cl.getValue("driver"), this.cl.getValue("url"), this.cl.getValue("database"), this.cl.getValue("user"), this.cl.getValue("password"), this.cl.getValue("table"), "_*", this.maxDepth);
        this.getContentPane().add((Component)this.panelRelations, "Center");
    }

    @Override
    protected void setFrameTitle() {
        String title = "Relations";
        if (!this.panelRelations.getTitle().equals("")) {
            title = String.valueOf(title) + " - " + this.panelRelations.getTitle();
        }
        this.setTitle(title);
        super.setFrameTitle();
    }

    private void close() {
        this.windowClosing(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("exit")) {
            this.close();
        }
    }

    @Override
    public void printDescription() {
        System.out.println("Prints the relations between tables for a given database and central table.");
        System.out.println("These relations can be edited and used for the Propositionaliztion process");
        System.out.println("if the automatic discovery is not desired (e.g. to avoid exponential");
        System.out.println("explosion of data).");
        System.out.println();
    }

    @Override
    public void printUsage() {
        super.printUsage();
        System.out.println(" -table <name>");
        System.out.println("  the table to discover the relations for");
        System.out.println(" -exclude_tables <name[,name...]> (optional)");
        System.out.println("  tables you want to exclude from the discovering");
        System.out.println(" -max_depth <int> (optional)");
        System.out.println("  defines the maximal depth the search for relations does, -1 means unlimited");
        System.out.println("  default is: " + this.maxDepth);
    }

    public static void main(String[] args) throws Exception {
        Relations frame = new Relations(null);
        frame.run(args);
    }
}

