/*
 * Decompiled with CFR 0.152.
 */
package proper.io;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import proper.io.CommandLineParameter;
import proper.util.ProperVector;
import proper.util.Strings;
import proper.xml.Attribute;
import proper.xml.Element;
import proper.xml.Path;
import proper.xml.XMLAccessInterface;

public class CommandLine
implements XMLAccessInterface {
    private Hashtable parameters = new Hashtable();
    private Hashtable definitions = new Hashtable();
    private Hashtable undefined = new Hashtable();
    private Vector erroneous = new ProperVector();
    private Vector missing = new ProperVector();

    public CommandLine() {
    }

    public CommandLine(Vector args) {
        this(Strings.vectorToArray(args));
    }

    public CommandLine(String[] args) {
        this();
        this.setArguments(args);
    }

    public void clearParameterDefinitions() {
        this.definitions.clear();
    }

    public void addParameterDefinition(CommandLineParameter p) {
        this.definitions.put(p.getName(), p);
    }

    public Vector getParameterDefinitions() {
        ProperVector result = new ProperVector();
        Enumeration enm = this.definitions.elements();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        return result;
    }

    public void setArguments(String[] args) {
        this.parameters.clear();
        this.undefined.clear();
        this.erroneous.clear();
        this.missing.clear();
        this.parse(args);
    }

    private boolean isDefined(String argument) {
        return this.definitions.containsKey(argument);
    }

    private boolean isParameter(String argument) {
        return argument.startsWith("-") || argument.startsWith("--");
    }

    private String processArgument(String argument) {
        if (this.isParameter(argument)) {
            argument = argument.startsWith("--") ? argument.substring(2) : argument.substring(1);
        }
        return argument;
    }

    private void parse(String[] args) {
        CommandLineParameter param;
        if (args == null) {
            return;
        }
        Stack<String> params = new Stack<String>();
        int i = args.length - 1;
        while (i >= 0) {
            if (args[i] != null && args[i].trim().length() != 0) {
                params.push(args[i]);
            }
            --i;
        }
        while (params.size() > 0) {
            String argument = params.pop().toString();
            if (this.isParameter(argument)) {
                String value;
                if (this.isDefined(argument = this.processArgument(argument))) {
                    param = (CommandLineParameter)this.definitions.get(argument);
                    if (param.hasArgument()) {
                        value = params.size() > 0 && !this.isParameter(params.peek().toString()) ? params.pop().toString() : "";
                        this.parameters.put(argument, value);
                        if (!value.equals("")) continue;
                        if (param.isOptional()) {
                            this.parameters.remove(argument);
                        }
                        if (param.isOptional()) continue;
                        this.erroneous.add(argument);
                        continue;
                    }
                    this.parameters.put(argument, "");
                    continue;
                }
                this.undefined.put(argument, "");
                if (params.size() > 0) {
                    value = params.peek().toString();
                    if (!this.isParameter(value)) {
                        params.pop();
                        this.parameters.put(argument, value);
                        this.undefined.put(argument, value);
                        continue;
                    }
                    this.parameters.put(argument, "");
                    continue;
                }
                this.parameters.put(argument, "");
                continue;
            }
            this.erroneous.add(argument);
        }
        Enumeration enm = this.definitions.elements();
        while (enm.hasMoreElements()) {
            param = (CommandLineParameter)enm.nextElement();
            if (param.isOptional() || this.exists(param.getName())) continue;
            this.missing.add(param.getName());
        }
    }

    public boolean isComplete() {
        boolean result;
        boolean bl = result = this.erroneous.size() == 0;
        if (result) {
            Enumeration enm = this.definitions.elements();
            while (enm.hasMoreElements()) {
                CommandLineParameter param = (CommandLineParameter)enm.nextElement();
                if (param.isOptional() || this.exists(param.getName())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean exists(String parameter) {
        return this.parameters.containsKey(parameter);
    }

    public boolean hasValue(String parameter) {
        return !this.getValue(parameter).equals("");
    }

    public String getValue(String parameter) {
        if (!this.exists(parameter)) {
            return "";
        }
        return (String)this.parameters.get(parameter);
    }

    public String getValue(String parameter, String defaultValue) {
        if (!this.hasValue(parameter)) {
            return defaultValue;
        }
        return this.getValue(parameter);
    }

    public void setValue(String parameter, String value) {
        this.parameters.put(parameter, value);
    }

    private Vector getValues(Hashtable h, boolean keys) {
        ProperVector result = new ProperVector();
        Enumeration<Object> enm = keys ? h.keys() : h.elements();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        if (result.size() > 1) {
            Collections.sort(result);
        }
        return result;
    }

    public Vector getParameters() {
        return this.getValues(this.parameters, true);
    }

    public Vector getErroneous() {
        return this.erroneous;
    }

    public Vector getMissing() {
        return this.missing;
    }

    public Vector getUndefined() {
        return this.getValues(this.undefined, false);
    }

    public String toString() {
        String result = "";
        Vector par = this.getParameters();
        int i = 0;
        while (i < par.size()) {
            result = String.valueOf(result) + "-" + (String)par.get(i) + " " + this.getValue((String)par.get(i)) + "\n";
            ++i;
        }
        return result;
    }

    public Vector toVector() {
        ProperVector result = new ProperVector();
        Vector params = this.getParameters();
        int i = 0;
        while (i < params.size()) {
            String name = params.get(i).toString();
            result.add("-" + name);
            if (this.hasValue(name)) {
                result.add(this.getValue(name));
            }
            ++i;
        }
        return result;
    }

    public String[] toArray() {
        return Strings.vectorToArray(this.toVector());
    }

    @Override
    public Element toXML() {
        Element result = new Element(this.getClass().getName());
        Vector params = this.getParameters();
        int i = 0;
        while (i < params.size()) {
            String name = params.get(i).toString();
            Element node = new Element(result, "arg");
            node.addAttribute(new Attribute("value", "-" + name));
            if (this.hasValue(name)) {
                node = new Element(result, "arg");
                node.addAttribute(new Attribute("value", this.getValue(name)));
            }
            ++i;
        }
        return result;
    }

    @Override
    public void fromXML(Element node) {
        Path path = new Path();
        Vector nodes = path.get(node, "//arg");
        ProperVector args = new ProperVector();
        int i = 0;
        while (i < nodes.size()) {
            args.add(((Element)nodes.get(i)).getAttribute("value").getValue());
            ++i;
        }
        this.parse(Strings.vectorToArray(args));
    }

    public static void main(String[] args) {
        CommandLine cl = new CommandLine(args);
        System.out.println("Commandline-Parameters:");
        System.out.println(cl);
        System.out.println(cl.toXML());
        System.out.println(cl.toVector());
    }
}

