/*
 * Decompiled with CFR 0.152.
 */
package proper.relaggs;

import java.io.Serializable;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import proper.database.Connector;
import proper.database.ConnectorObject;
import proper.database.Join;
import proper.relaggs.RelaggsAttribute;
import proper.relaggs.RelaggsConfig;
import proper.relaggs.RelaggsDate;
import proper.relaggs.RelaggsTable;

public class RelaggsStructure
extends ConnectorObject {
    public static final String KEY_DATE_YMD = "YMD";
    public static final String KEY_DATE_YM = "YM";
    public static final String KEY_DATE_Y = "Y";
    public static final String KEY_INT_CNTALL = "CNT_ALL";
    public static final String KEY_INT_CNTVAL = "CNT_VAL";
    public static final String KEY_INT_SUM = "SUM";
    public static final String KEY_INT_AVG = "AVG";
    public static final String KEY_INT_MIN = "MIN";
    public static final String KEY_INT_MAX = "MAX";
    public static final String KEY_INT_STDDEV = "STDDEV";
    public static final String KEY_INT_Q1 = "QUART1";
    public static final String KEY_INT_Q3 = "QUART3";
    public static final String KEY_INT_MED = "MEDIAN";
    public static final String KEY_INT_RNG = "RANGE";
    public static final String KEY_INT_VALUES = "VALUES";
    private Hashtable attribute_values = new Hashtable();
    private Hashtable key_attributes = new Hashtable();
    private Hashtable key_values_distinct = new Hashtable();
    private Hashtable key_values_all = new Hashtable();
    private int records = 0;
    private HashSet columns = new HashSet();

    public RelaggsStructure(Connector conn) {
        super(conn);
    }

    public HashSet getColumns() {
        return this.columns;
    }

    public void addRecord() {
        ++this.records;
    }

    public void addAttribute(RelaggsAttribute attr) {
        switch (attr.getType()) {
            case 5: {
                Hashtable<String, Serializable> tmp_ht = new Hashtable<String, Serializable>();
                tmp_ht.put(KEY_DATE_YMD, new Vector());
                tmp_ht.put(KEY_DATE_YM, new Vector());
                tmp_ht.put(KEY_DATE_Y, new Vector());
                this.attribute_values.put(attr, tmp_ht);
                tmp_ht = new Hashtable();
                tmp_ht.put(KEY_DATE_YMD, new Integer(0));
                tmp_ht.put(KEY_DATE_YM, new Integer(0));
                tmp_ht.put(KEY_DATE_Y, new Integer(0));
                this.key_values_distinct.put(attr, tmp_ht);
                tmp_ht = new Hashtable();
                tmp_ht.put(KEY_DATE_YMD, new Integer(0));
                tmp_ht.put(KEY_DATE_YM, new Integer(0));
                tmp_ht.put(KEY_DATE_Y, new Integer(0));
                this.key_values_all.put(attr, tmp_ht);
                break;
            }
            case 1: 
            case 3: {
                Vector tmp_vector = new Vector();
                this.attribute_values.put(attr, tmp_vector);
                this.key_values_distinct.put(attr, new Integer(0));
                this.key_values_all.put(attr, new Integer(0));
            }
        }
    }

    public void addAttributeValue(RelaggsAttribute attr, int value, Object key) {
        Vector<Integer> attr_list;
        Hashtable ht_attr;
        Hashtable key_attr = (Hashtable)this.key_attributes.get(key);
        if (key_attr == null) {
            key_attr = new Hashtable();
            this.key_attributes.put(key, key_attr);
        }
        Integer tmp_number = (Integer)this.key_values_distinct.get(attr);
        Hashtable ht_int = (Hashtable)key_attr.get(attr);
        if (ht_int == null) {
            ht_int = new Hashtable();
            key_attr.put(attr, ht_int);
        }
        if ((ht_attr = (Hashtable)ht_int.get(attr)) == null) {
            ht_attr = new Hashtable();
            ht_int.put(attr, ht_attr);
        }
        if ((attr_list = (Vector<Integer>)ht_attr.get(KEY_INT_VALUES)) == null) {
            attr_list = new Vector<Integer>();
            ht_attr.put(KEY_INT_VALUES, attr_list);
        }
        if (!attr_list.contains(new Integer(value))) {
            this.key_values_distinct.put(attr, new Integer(tmp_number + 1));
        }
        attr_list.add(new Integer(value));
        tmp_number = (Integer)this.key_values_all.get(attr);
        this.key_values_all.put(attr, new Integer(tmp_number + 1));
        if (!((Vector)this.attribute_values.get(attr)).contains(new Integer(value))) {
            ((Vector)this.attribute_values.get(attr)).add(new Integer(value));
        }
    }

    public void addAttributeValue(RelaggsAttribute attr, Date value, Object key) {
        if (value != null) {
            Integer tmp_number;
            Hashtable ht_attr;
            Hashtable ht_chr;
            Hashtable key_attr;
            RelaggsDate rd_ymd = new RelaggsDate(value);
            RelaggsDate rd_ym = new RelaggsDate(value, 2);
            RelaggsDate rd_y = new RelaggsDate(value, 3);
            Hashtable dist_attr_values = (Hashtable)this.attribute_values.get(attr);
            if (!((Vector)dist_attr_values.get(KEY_DATE_YMD)).contains(rd_ymd)) {
                ((Vector)dist_attr_values.get(KEY_DATE_YMD)).add(rd_ymd);
            }
            if (!((Vector)dist_attr_values.get(KEY_DATE_YM)).contains(rd_ym)) {
                ((Vector)dist_attr_values.get(KEY_DATE_YM)).add(rd_ym);
            }
            if (!((Vector)dist_attr_values.get(KEY_DATE_Y)).contains(rd_y)) {
                ((Vector)dist_attr_values.get(KEY_DATE_Y)).add(rd_y);
            }
            if ((key_attr = (Hashtable)this.key_attributes.get(key)) == null) {
                key_attr = new Hashtable();
                this.key_attributes.put(key, key_attr);
            }
            if ((ht_chr = (Hashtable)key_attr.get(attr)) == null) {
                ht_chr = new Hashtable();
                key_attr.put(attr, ht_chr);
            }
            if ((ht_attr = (Hashtable)ht_chr.get(attr)) == null) {
                ht_attr = new Hashtable();
                ht_attr.put(KEY_DATE_YMD, new Hashtable());
                ht_attr.put(KEY_DATE_YM, new Hashtable());
                ht_attr.put(KEY_DATE_Y, new Hashtable());
                ht_chr.put(attr, ht_attr);
            }
            Hashtable dist_key_val = (Hashtable)this.key_values_distinct.get(attr);
            Hashtable all_key_val = (Hashtable)this.key_values_all.get(attr);
            Hashtable ht_tmp = (Hashtable)ht_attr.get(KEY_DATE_YMD);
            Integer val = (Integer)ht_tmp.get(rd_ymd.getHashKey());
            if (val == null) {
                tmp_number = (Integer)dist_key_val.get(KEY_DATE_YMD);
                dist_key_val.put(KEY_DATE_YMD, new Integer(tmp_number + 1));
                ht_tmp.put(rd_ymd.getHashKey(), new Integer(1));
            } else {
                ht_tmp.put(rd_ymd.getHashKey(), new Integer(val + 1));
            }
            tmp_number = (Integer)all_key_val.get(KEY_DATE_YMD);
            all_key_val.put(KEY_DATE_YMD, new Integer(tmp_number + 1));
            ht_tmp = (Hashtable)ht_attr.get(KEY_DATE_YM);
            val = (Integer)ht_tmp.get(rd_ym.getHashKey());
            if (val == null) {
                tmp_number = (Integer)dist_key_val.get(KEY_DATE_YM);
                dist_key_val.put(KEY_DATE_YM, new Integer(tmp_number + 1));
                ht_tmp.put(rd_ym.getHashKey(), new Integer(1));
            } else {
                ht_tmp.put(rd_ym.getHashKey(), new Integer(val + 1));
            }
            tmp_number = (Integer)all_key_val.get(KEY_DATE_YM);
            all_key_val.put(KEY_DATE_YM, new Integer(tmp_number + 1));
            ht_tmp = (Hashtable)ht_attr.get(KEY_DATE_Y);
            val = (Integer)ht_tmp.get(rd_y.getHashKey());
            if (val == null) {
                tmp_number = (Integer)dist_key_val.get(KEY_DATE_Y);
                dist_key_val.put(KEY_DATE_Y, new Integer(tmp_number + 1));
                ht_tmp.put(rd_y.getHashKey(), new Integer(1));
            } else {
                ht_tmp.put(rd_y.getHashKey(), new Integer(val + 1));
            }
            tmp_number = (Integer)all_key_val.get(KEY_DATE_Y);
            all_key_val.put(KEY_DATE_Y, new Integer(tmp_number + 1));
        }
    }

    public void addAttributeValueGroupBy(RelaggsAttribute attr, RelaggsAttribute gb_attr, Object gb_value, Date value, Object key) {
        if (value != null) {
            Integer val;
            Hashtable ht_tmp;
            Hashtable ht_attr;
            Hashtable ht_date;
            RelaggsDate rd_ymd = new RelaggsDate(value);
            RelaggsDate rd_ym = new RelaggsDate(value, 2);
            RelaggsDate rd_y = new RelaggsDate(value, 3);
            Hashtable key_attr = (Hashtable)this.key_attributes.get(key);
            if (key_attr == null) {
                key_attr = new Hashtable();
                this.key_attributes.put(key, key_attr);
            }
            if ((ht_date = (Hashtable)key_attr.get(attr)) == null) {
                ht_date = new Hashtable();
                key_attr.put(attr, ht_date);
            }
            if ((ht_attr = (Hashtable)ht_date.get(gb_attr)) == null) {
                ht_attr = new Hashtable();
                ht_date.put(gb_attr, ht_attr);
            }
            Object hash_value = null;
            switch (gb_attr.getType()) {
                case 1: 
                case 3: {
                    hash_value = gb_value;
                    break;
                }
                case 5: {
                    hash_value = ((RelaggsDate)gb_value).getHashKey();
                }
            }
            Hashtable ht_values = (Hashtable)ht_attr.get(hash_value);
            if (ht_values == null) {
                ht_values = new Hashtable();
                ht_values.put(KEY_DATE_YMD, new Hashtable());
                ht_values.put(KEY_DATE_YM, new Hashtable());
                ht_values.put(KEY_DATE_Y, new Hashtable());
                ht_attr.put(hash_value, ht_values);
            }
            if (this.isAggregationValid(attr, KEY_DATE_YMD)) {
                ht_tmp = (Hashtable)ht_values.get(KEY_DATE_YMD);
                val = (Integer)ht_tmp.get(rd_ymd.getHashKey());
                if (val == null) {
                    ht_tmp.put(rd_ymd.getHashKey(), new Integer(1));
                } else {
                    ht_tmp.put(rd_ymd.getHashKey(), new Integer(val + 1));
                }
            }
            if (this.isAggregationValid(attr, KEY_DATE_YM)) {
                ht_tmp = (Hashtable)ht_values.get(KEY_DATE_YM);
                val = (Integer)ht_tmp.get(rd_ym.getHashKey());
                if (val == null) {
                    ht_tmp.put(rd_ym.getHashKey(), new Integer(1));
                } else {
                    ht_tmp.put(rd_ym.getHashKey(), new Integer(val + 1));
                }
            }
            if (this.isAggregationValid(attr, KEY_DATE_Y)) {
                ht_tmp = (Hashtable)ht_values.get(KEY_DATE_Y);
                val = (Integer)ht_tmp.get(rd_y.getHashKey());
                if (val == null) {
                    ht_tmp.put(rd_y.getHashKey(), new Integer(1));
                } else {
                    ht_tmp.put(rd_y.getHashKey(), new Integer(val + 1));
                }
            }
        }
    }

    public void addAttributeValueGroupBy(RelaggsAttribute attr, RelaggsAttribute gb_attr, Object gb_value, Object value, String value_type, Object key) {
        Hashtable ht_attr;
        Hashtable ht_int;
        Hashtable key_attr = (Hashtable)this.key_attributes.get(key);
        if (key_attr == null) {
            key_attr = new Hashtable();
            this.key_attributes.put(key, key_attr);
        }
        if ((ht_int = (Hashtable)key_attr.get(attr)) == null) {
            ht_int = new Hashtable();
            key_attr.put(attr, ht_int);
        }
        if ((ht_attr = (Hashtable)ht_int.get(gb_attr)) == null) {
            ht_attr = new Hashtable();
            ht_int.put(gb_attr, ht_attr);
        }
        Object hash_value = null;
        switch (gb_attr.getType()) {
            case 1: 
            case 3: {
                hash_value = gb_value;
                break;
            }
            case 5: {
                hash_value = ((RelaggsDate)gb_value).getHashKey();
            }
        }
        Hashtable<String, Object> ht_values = (Hashtable<String, Object>)ht_attr.get(hash_value);
        if (ht_values == null) {
            ht_values = new Hashtable<String, Object>();
            ht_attr.put(hash_value, ht_values);
        }
        if (value_type.equals(KEY_INT_VALUES)) {
            Vector<Object> vec_int = (Vector<Object>)ht_values.get(KEY_INT_VALUES);
            if (vec_int == null) {
                vec_int = new Vector<Object>();
                ht_values.put(KEY_INT_VALUES, vec_int);
            }
            vec_int.add(value);
        } else {
            ht_values.put(value_type, value);
        }
    }

    public void addAttributeValue(RelaggsAttribute attr, String value, Object key) {
        if (value != null) {
            Integer tmp_number;
            Integer val;
            Hashtable<String, Integer> ht_attr;
            Hashtable ht_char;
            Hashtable key_attr = (Hashtable)this.key_attributes.get(key);
            if (key_attr == null) {
                key_attr = new Hashtable();
                this.key_attributes.put(key, key_attr);
            }
            if ((ht_char = (Hashtable)key_attr.get(attr)) == null) {
                ht_char = new Hashtable();
                key_attr.put(attr, ht_char);
            }
            if ((ht_attr = (Hashtable<String, Integer>)ht_char.get(attr)) == null) {
                ht_attr = new Hashtable<String, Integer>();
                ht_char.put(attr, ht_attr);
            }
            if ((val = (Integer)ht_attr.get(value)) == null) {
                tmp_number = (Integer)this.key_values_distinct.get(attr);
                this.key_values_distinct.put(attr, new Integer(tmp_number + 1));
                ht_attr.put(value, new Integer(1));
            } else {
                ht_attr.put(value, new Integer(val + 1));
            }
            tmp_number = (Integer)this.key_values_all.get(attr);
            this.key_values_all.put(attr, new Integer(tmp_number + 1));
            if (!((Vector)this.attribute_values.get(attr)).contains(value)) {
                ((Vector)this.attribute_values.get(attr)).add(value);
            }
        }
    }

    public void addAttributeValueGroupBy(RelaggsAttribute attr, RelaggsAttribute gb_attr, Object gb_value, String value, Object key) {
        if (value != null) {
            Integer val;
            Hashtable ht_attr;
            Hashtable ht_char;
            Hashtable key_attr = (Hashtable)this.key_attributes.get(key);
            if (key_attr == null) {
                key_attr = new Hashtable();
                this.key_attributes.put(key, key_attr);
            }
            if ((ht_char = (Hashtable)key_attr.get(attr)) == null) {
                ht_char = new Hashtable();
                key_attr.put(attr, ht_char);
            }
            if ((ht_attr = (Hashtable)ht_char.get(gb_attr)) == null) {
                ht_attr = new Hashtable();
                ht_char.put(gb_attr, ht_attr);
            }
            Object hash_value = null;
            switch (gb_attr.getType()) {
                case 1: 
                case 3: {
                    hash_value = gb_value;
                    break;
                }
                case 5: {
                    hash_value = ((RelaggsDate)gb_value).getHashKey();
                }
            }
            Hashtable<String, Integer> ht_values = (Hashtable<String, Integer>)ht_attr.get(hash_value);
            if (ht_values == null) {
                ht_values = new Hashtable<String, Integer>();
                ht_attr.put(hash_value, ht_values);
            }
            if ((val = (Integer)ht_values.get(value)) == null) {
                ht_values.put(value, new Integer(1));
            } else {
                ht_values.put(value, new Integer(val + 1));
            }
        }
    }

    public void processAttributes() {
        Enumeration enm = this.key_attributes.keys();
        while (enm.hasMoreElements()) {
            Object key = enm.nextElement();
            Hashtable key_attr = (Hashtable)this.key_attributes.get(key);
            Enumeration enum_attr = key_attr.keys();
            block17: while (enum_attr.hasMoreElements()) {
                RelaggsAttribute attr = (RelaggsAttribute)enum_attr.nextElement();
                switch (attr.getType()) {
                    case 1: {
                        Hashtable ht_int = (Hashtable)key_attr.get(attr);
                        Hashtable ht_attr = (Hashtable)ht_int.get(attr);
                        Vector vec_int = (Vector)ht_attr.get(KEY_INT_VALUES);
                        int vec_size = vec_int.size();
                        Collections.sort(vec_int);
                        int med = 0;
                        med = vec_size % 2 != 0 ? (Integer)vec_int.elementAt((vec_size + 1) / 2 - 1) : ((Integer)vec_int.elementAt(vec_size / 2 - 1) + (Integer)vec_int.elementAt(vec_size / 2)) / 2;
                        int quart1 = 0;
                        int quart3 = 0;
                        switch (vec_size % 4) {
                            case 0: {
                                quart1 = ((Integer)vec_int.elementAt(vec_size / 4 - 1) + (Integer)vec_int.elementAt(vec_size / 4)) / 2;
                                quart3 = ((Integer)vec_int.elementAt(3 * vec_size / 4 - 1) + (Integer)vec_int.elementAt(3 * vec_size / 4)) / 2;
                                break;
                            }
                            case 1: {
                                if (vec_size == 1) {
                                    quart1 = quart3 = ((Integer)vec_int.elementAt(0)).intValue();
                                    break;
                                }
                                quart1 = ((Integer)vec_int.elementAt((vec_size - 1) / 4 - 1) + (Integer)vec_int.elementAt((vec_size - 1) / 4)) / 2;
                                quart3 = ((Integer)vec_int.elementAt(3 * (vec_size - 1) / 4) + (Integer)vec_int.elementAt(3 * (vec_size - 1) / 4 + 1)) / 2;
                                break;
                            }
                            case 2: {
                                quart1 = (Integer)vec_int.elementAt((vec_size - 2) / 4);
                                quart3 = (Integer)vec_int.elementAt(3 * (vec_size - 2) / 4 + 1);
                                break;
                            }
                            case 3: {
                                quart1 = (Integer)vec_int.elementAt((vec_size + 1) / 4 - 1);
                                quart3 = (Integer)vec_int.elementAt(3 * (vec_size + 1) / 4 - 1);
                            }
                        }
                        ht_attr.put(KEY_INT_Q1, new Integer(quart1));
                        ht_attr.put(KEY_INT_MED, new Integer(med));
                        ht_attr.put(KEY_INT_Q3, new Integer(quart3));
                        ht_attr.put(KEY_INT_RNG, new Integer((Integer)vec_int.elementAt(vec_int.size() - 1) - (Integer)vec_int.elementAt(0)));
                        Enumeration enum_int = ht_int.keys();
                        while (enum_int.hasMoreElements()) {
                            RelaggsAttribute ref_attr = (RelaggsAttribute)enum_int.nextElement();
                            if (ref_attr.equals(attr)) continue;
                            ht_attr = (Hashtable)ht_int.get(ref_attr);
                            Enumeration enum_val = ht_attr.keys();
                            while (enum_val.hasMoreElements()) {
                                Object gb_val = enum_val.nextElement();
                                Hashtable ht_val = (Hashtable)ht_attr.get(gb_val);
                                vec_int = (Vector)ht_val.get(KEY_INT_VALUES);
                                vec_size = vec_int.size();
                                Collections.sort(vec_int);
                                med = 0;
                                med = vec_size % 2 != 0 ? (Integer)vec_int.elementAt((vec_size + 1) / 2 - 1) : ((Integer)vec_int.elementAt(vec_size / 2 - 1) + (Integer)vec_int.elementAt(vec_size / 2)) / 2;
                                quart1 = 0;
                                quart3 = 0;
                                switch (vec_size % 4) {
                                    case 0: {
                                        quart1 = ((Integer)vec_int.elementAt(vec_size / 4 - 1) + (Integer)vec_int.elementAt(vec_size / 4)) / 2;
                                        quart3 = ((Integer)vec_int.elementAt(3 * vec_size / 4 - 1) + (Integer)vec_int.elementAt(3 * vec_size / 4)) / 2;
                                        break;
                                    }
                                    case 1: {
                                        if (vec_size == 1) {
                                            quart1 = quart3 = ((Integer)vec_int.elementAt(0)).intValue();
                                            break;
                                        }
                                        quart1 = ((Integer)vec_int.elementAt((vec_size - 1) / 4 - 1) + (Integer)vec_int.elementAt((vec_size - 1) / 4)) / 2;
                                        quart3 = ((Integer)vec_int.elementAt(3 * (vec_size - 1) / 4) + (Integer)vec_int.elementAt(3 * (vec_size - 1) / 4 + 1)) / 2;
                                        break;
                                    }
                                    case 2: {
                                        quart1 = (Integer)vec_int.elementAt((vec_size - 2) / 4);
                                        quart3 = (Integer)vec_int.elementAt(3 * (vec_size - 2) / 4 + 1);
                                        break;
                                    }
                                    case 3: {
                                        quart1 = (Integer)vec_int.elementAt((vec_size + 1) / 4 - 1);
                                        quart3 = (Integer)vec_int.elementAt(3 * (vec_size + 1) / 4 - 1);
                                    }
                                }
                                ht_val.put(KEY_INT_Q1, new Integer(quart1));
                                ht_val.put(KEY_INT_MED, new Integer(med));
                                ht_val.put(KEY_INT_Q3, new Integer(quart3));
                                ht_val.put(KEY_INT_RNG, new Integer((Integer)vec_int.elementAt(vec_int.size() - 1) - (Integer)vec_int.elementAt(0)));
                            }
                        }
                        continue block17;
                    }
                    case 3: {
                        break;
                    }
                }
            }
        }
    }

    public void printReport() {
        Enumeration enm = this.attribute_values.keys();
        while (enm.hasMoreElements()) {
            RelaggsAttribute attr = (RelaggsAttribute)enm.nextElement();
            this.println("Attribute: '" + attr.getName() + "' [Type: " + attr.getTypeName() + "]");
            switch (attr.getType()) {
                case 1: {
                    this.println("  Number of distinct values: " + ((Vector)this.attribute_values.get(attr)).size());
                    break;
                }
                case 3: {
                    this.println("  Number of distinct values : " + ((Vector)this.attribute_values.get(attr)).size());
                    this.println("  Number of dist. key-values: " + (Integer)this.key_values_distinct.get(attr));
                    this.println("  Number of all key-values  : " + (Integer)this.key_values_all.get(attr));
                    this.println("  Avr. size per value-group : " + (Integer)this.key_values_all.get(attr) / (Integer)this.key_values_distinct.get(attr));
                    break;
                }
                case 5: {
                    Hashtable tmp_ht = (Hashtable)this.attribute_values.get(attr);
                    Hashtable dkv = (Hashtable)this.key_values_distinct.get(attr);
                    Hashtable akv = (Hashtable)this.key_values_all.get(attr);
                    this.println("  Number of distinct values YMD : " + ((Vector)tmp_ht.get(KEY_DATE_YMD)).size());
                    this.println("  Number of dist. key-values YMD: " + (Integer)dkv.get(KEY_DATE_YMD));
                    this.println("  Number of all key-values YMD  : " + (Integer)akv.get(KEY_DATE_YMD));
                    this.println("  Avr. size per value-group YMD : " + (Integer)akv.get(KEY_DATE_YMD) / (Integer)dkv.get(KEY_DATE_YMD));
                    this.println("  Number of distinct values YM  : " + ((Vector)tmp_ht.get(KEY_DATE_YM)).size());
                    this.println("  Number of dist. key-values YM : " + (Integer)dkv.get(KEY_DATE_YM));
                    this.println("  Number of all key-values YM   : " + (Integer)akv.get(KEY_DATE_YM));
                    this.println("  Avr. size per value-group YM  : " + (Integer)akv.get(KEY_DATE_YM) / (Integer)dkv.get(KEY_DATE_YM));
                    this.println("  Number of distinct values Y   : " + ((Vector)tmp_ht.get(KEY_DATE_Y)).size());
                    this.println("  Number of dist. key-values Y  : " + (Integer)dkv.get(KEY_DATE_Y));
                    this.println("  Number of all key-values Y    : " + (Integer)akv.get(KEY_DATE_Y));
                    this.println("  Avr. size per value-group Y   : " + (Integer)akv.get(KEY_DATE_Y) / (Integer)dkv.get(KEY_DATE_Y));
                    break;
                }
                default: {
                    this.println("  UNKNOWN TYPE [" + attr.getType() + "]");
                }
            }
        }
    }

    public Hashtable getGroupByAttributes() {
        Hashtable<RelaggsAttribute, Object> result = new Hashtable<RelaggsAttribute, Object>();
        Enumeration enum_attr = this.attribute_values.keys();
        block4: while (enum_attr.hasMoreElements()) {
            RelaggsAttribute attr = (RelaggsAttribute)enum_attr.nextElement();
            switch (attr.getType()) {
                case 1: 
                case 3: {
                    Vector vec_values = (Vector)this.attribute_values.get(attr);
                    if ((Integer)this.key_values_distinct.get(attr) == 0 || this.records == 0 || vec_values.size() > RelaggsConfig.max_groups || (Integer)this.key_values_all.get(attr) / (Integer)this.key_values_distinct.get(attr) < RelaggsConfig.min_avg_group_size || !((double)((Integer)this.key_values_all.get(attr) / this.records) >= RelaggsConfig.min_fill_percentage)) continue block4;
                    result.put(attr, attr);
                    break;
                }
                case 5: {
                    Hashtable attr_date = (Hashtable)this.attribute_values.get(attr);
                    Hashtable dkv = (Hashtable)this.key_values_distinct.get(attr);
                    Hashtable akv = (Hashtable)this.key_values_all.get(attr);
                    Vector<String> tmp_date = new Vector<String>();
                    if ((Integer)dkv.get(KEY_DATE_YMD) != 0 && this.records != 0 && ((Vector)attr_date.get(KEY_DATE_YMD)).size() <= RelaggsConfig.max_groups && (Integer)akv.get(KEY_DATE_YMD) / (Integer)dkv.get(KEY_DATE_YMD) >= RelaggsConfig.min_avg_group_size && (double)((Integer)akv.get(KEY_DATE_YMD) / this.records) >= RelaggsConfig.min_fill_percentage) {
                        tmp_date.add(KEY_DATE_YMD);
                    }
                    if ((Integer)dkv.get(KEY_DATE_YM) != 0 && this.records != 0 && ((Vector)attr_date.get(KEY_DATE_YM)).size() <= RelaggsConfig.max_groups && (Integer)akv.get(KEY_DATE_YM) / (Integer)dkv.get(KEY_DATE_YM) >= RelaggsConfig.min_avg_group_size && (double)((Integer)akv.get(KEY_DATE_YM) / this.records) >= RelaggsConfig.min_fill_percentage) {
                        tmp_date.add(KEY_DATE_YM);
                    }
                    if ((Integer)dkv.get(KEY_DATE_Y) != 0 && this.records != 0 && ((Vector)attr_date.get(KEY_DATE_Y)).size() <= RelaggsConfig.max_groups && (Integer)akv.get(KEY_DATE_Y) / (Integer)dkv.get(KEY_DATE_Y) >= RelaggsConfig.min_avg_group_size && (double)((Integer)akv.get(KEY_DATE_Y) / this.records) >= RelaggsConfig.min_fill_percentage) {
                        tmp_date.add(KEY_DATE_Y);
                    }
                    if (tmp_date.size() == 0) break;
                    result.put(attr, tmp_date);
                }
            }
        }
        return result;
    }

    private String getUniqueName(String name) {
        String result = name;
        int i = 0;
        while (this.columns.contains(result.toLowerCase())) {
            result = String.valueOf(name) + Integer.toString(++i);
        }
        this.columns.add(result.toLowerCase());
        return result;
    }

    private boolean canAddColumn(RelaggsTable table) {
        return this.canAddColumns(table, 1);
    }

    private boolean canAddColumns(RelaggsTable table, int count) {
        return true;
    }

    public String getAlterTableColumns(RelaggsTable source_table) {
        StringBuffer sql = new StringBuffer();
        Hashtable group_by_attributes = this.getGroupByAttributes();
        this.println("max. Column count : " + source_table.getMaxColumns() + "\n" + "curr. Column count: " + source_table.getColumnCount());
        Enumeration enum_attr = this.attribute_values.keys();
        int cnt = 0;
        block17: while (enum_attr.hasMoreElements()) {
            RelaggsAttribute attr = (RelaggsAttribute)enum_attr.nextElement();
            String attr_name = String.valueOf(source_table.getShortName()) + "_" + attr.getName();
            switch (attr.getType()) {
                case 1: {
                    Vector date_vec;
                    if (!this.canAddColumns(source_table, 4)) continue block17;
                    if (cnt != 0) {
                        sql.append(", ");
                    }
                    ++cnt;
                    sql.append(String.valueOf(this.getUniqueName(String.valueOf(attr_name) + "_QUART1")) + " " + attr.getTypeCreate() + ", " + this.getUniqueName(String.valueOf(attr_name) + "_MEDIAN") + " " + attr.getTypeCreate() + ", " + this.getUniqueName(String.valueOf(attr_name) + "_QUART3") + " " + attr.getTypeCreate() + ", " + this.getUniqueName(String.valueOf(attr_name) + "_RANGE") + " " + attr.getTypeCreate());
                    if (group_by_attributes.size() <= 0) break;
                    Enumeration enum_gb = group_by_attributes.keys();
                    block18: while (enum_gb.hasMoreElements()) {
                        RelaggsAttribute gb_attr = (RelaggsAttribute)enum_gb.nextElement();
                        if (attr.equals(gb_attr)) continue;
                        switch (gb_attr.getType()) {
                            case 1: 
                            case 3: {
                                Vector vec_values = (Vector)this.attribute_values.get(gb_attr);
                                for (Object obj_val : vec_values) {
                                    String gb_val = "";
                                    if (obj_val instanceof Integer) {
                                        gb_val = "" + (Integer)obj_val;
                                    } else if (obj_val instanceof String) {
                                        gb_val = (String)obj_val;
                                    }
                                    if (!this.canAddColumns(source_table, 10)) continue block18;
                                    sql.append(", " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + this.validColumnName(gb_val) + "_CNT_VAL") + " INT, " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + this.validColumnName(gb_val) + "_SUM") + " INT, " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + this.validColumnName(gb_val) + "_AVG") + " DOUBLE PRECISION, " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + this.validColumnName(gb_val) + "_MIN") + " " + attr.getTypeCreate() + ", " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + this.validColumnName(gb_val) + "_MAX") + " " + attr.getTypeCreate() + ", " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + this.validColumnName(gb_val) + "_STDDEV") + " DOUBLE PRECISION, " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + this.validColumnName(gb_val) + "_QUART1") + " " + attr.getTypeCreate() + ", " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + this.validColumnName(gb_val) + "_MEDIAN") + " " + attr.getTypeCreate() + ", " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + this.validColumnName(gb_val) + "_QUART3") + " " + attr.getTypeCreate() + ", " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + this.validColumnName(gb_val) + "_RANGE") + " " + attr.getTypeCreate());
                                }
                                continue block18;
                            }
                            case 5: {
                                date_vec = (Vector)group_by_attributes.get(gb_attr);
                                block20: for (String date_str : date_vec) {
                                    Hashtable ht_values = (Hashtable)this.attribute_values.get(gb_attr);
                                    Vector vec_date_values = (Vector)ht_values.get(date_str);
                                    for (RelaggsDate obj_val : vec_date_values) {
                                        if (!this.canAddColumns(source_table, 10)) continue block20;
                                        sql.append(", " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + obj_val.getColumnString() + "_CNT_VAL") + " INT, " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + obj_val.getColumnString() + "_SUM") + " INT, " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + obj_val.getColumnString() + "_AVG") + " DOUBLE PRECISION, " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + obj_val.getColumnString() + "_MIN") + " " + attr.getTypeCreate() + ", " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + obj_val.getColumnString() + "_MAX") + " " + attr.getTypeCreate() + ", " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + obj_val.getColumnString() + "_STDDEV") + " DOUBLE PRECISION, " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + obj_val.getColumnString() + "_QUART1") + " " + attr.getTypeCreate() + ", " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + obj_val.getColumnString() + "_MEDIAN") + " " + attr.getTypeCreate() + ", " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + obj_val.getColumnString() + "_QUART3") + " " + attr.getTypeCreate() + ", " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + obj_val.getColumnString() + "_RANGE") + " " + attr.getTypeCreate());
                                    }
                                }
                                continue block18;
                            }
                        }
                    }
                    continue block17;
                }
                case 3: {
                    Vector char_vec = (Vector)this.attribute_values.get(attr);
                    if (char_vec.size() > RelaggsConfig.max_aggr_values) break;
                    int i = 0;
                    while (i < char_vec.size()) {
                        if (!this.canAddColumn(source_table)) break;
                        if (i != 0) {
                            sql.append(", ");
                        } else if (cnt != 0) {
                            sql.append(", ");
                        }
                        ++cnt;
                        String str_val = (String)char_vec.elementAt(i);
                        sql.append(String.valueOf(this.getUniqueName(String.valueOf(attr_name) + "_" + this.validColumnName(str_val))) + " INT DEFAULT 0");
                        ++i;
                    }
                    if (group_by_attributes.size() <= 0) break;
                    Enumeration enum_gb = group_by_attributes.keys();
                    block23: while (enum_gb.hasMoreElements()) {
                        RelaggsAttribute gb_attr = (RelaggsAttribute)enum_gb.nextElement();
                        if (attr.equals(gb_attr)) continue;
                        switch (gb_attr.getType()) {
                            case 1: 
                            case 3: {
                                int i2 = 0;
                                while (i2 < char_vec.size()) {
                                    String str_val = (String)char_vec.elementAt(i2);
                                    Vector vec_values = (Vector)this.attribute_values.get(gb_attr);
                                    for (Object obj_val : vec_values) {
                                        String gb_val = "";
                                        if (obj_val instanceof Integer) {
                                            gb_val = "" + (Integer)obj_val;
                                        } else if (obj_val instanceof String) {
                                            gb_val = (String)obj_val;
                                        }
                                        if (!this.canAddColumn(source_table)) break;
                                        sql.append(", " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + this.validColumnName(gb_val) + "_" + this.validColumnName(str_val)) + " INT DEFAULT 0");
                                    }
                                    ++i2;
                                }
                                continue block23;
                            }
                            case 5: {
                                Vector date_vec = (Vector)group_by_attributes.get(gb_attr);
                                for (String date_str : date_vec) {
                                    int i3 = 0;
                                    while (i3 < char_vec.size()) {
                                        String str_val = (String)char_vec.elementAt(i3);
                                        Hashtable ht_values = (Hashtable)this.attribute_values.get(gb_attr);
                                        Vector vec_date_values = (Vector)ht_values.get(date_str);
                                        for (Object obj_val : vec_date_values) {
                                            if (!this.canAddColumn(source_table)) break;
                                            sql.append(", " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + ((RelaggsDate)obj_val).getColumnString() + "_" + this.validColumnName(str_val)) + " INT DEFAULT 0");
                                        }
                                        ++i3;
                                    }
                                }
                                continue block23;
                            }
                        }
                    }
                    continue block17;
                }
                case 5: {
                    Vector date_vec;
                    Hashtable ht_date = (Hashtable)this.attribute_values.get(attr);
                    Enumeration enum_date_keys = ht_date.keys();
                    while (enum_date_keys.hasMoreElements()) {
                        String date_key = (String)enum_date_keys.nextElement();
                        date_vec = (Vector)ht_date.get(date_key);
                        if (date_vec.size() > RelaggsConfig.max_aggr_values) continue;
                        int i = 0;
                        while (i < date_vec.size()) {
                            if (!this.canAddColumn(source_table)) break;
                            if (i != 0) {
                                sql.append(", ");
                            } else if (cnt != 0) {
                                sql.append(", ");
                            }
                            ++cnt;
                            RelaggsDate date_val = (RelaggsDate)date_vec.elementAt(i);
                            sql.append(String.valueOf(this.getUniqueName(String.valueOf(attr_name) + "_" + date_val.getColumnString())) + " INT DEFAULT 0");
                            ++i;
                        }
                        if (group_by_attributes.size() <= 0) continue;
                        Enumeration enum_gb = group_by_attributes.keys();
                        block31: while (enum_gb.hasMoreElements()) {
                            RelaggsAttribute gb_attr = (RelaggsAttribute)enum_gb.nextElement();
                            if (attr.equals(gb_attr)) continue;
                            switch (gb_attr.getType()) {
                                case 1: 
                                case 3: {
                                    int i4 = 0;
                                    while (i4 < date_vec.size()) {
                                        RelaggsDate date_val = (RelaggsDate)date_vec.elementAt(i4);
                                        Vector vec_values = (Vector)this.attribute_values.get(gb_attr);
                                        for (Object obj_val : vec_values) {
                                            String gb_val = "";
                                            if (obj_val instanceof Integer) {
                                                gb_val = "" + (Integer)obj_val;
                                            } else if (obj_val instanceof String) {
                                                gb_val = (String)obj_val;
                                            }
                                            if (!this.canAddColumn(source_table)) break;
                                            sql.append(", " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + this.validColumnName(gb_val) + "_" + date_val.getColumnString()) + " INT DEFAULT 0");
                                        }
                                        ++i4;
                                    }
                                    continue block31;
                                }
                                case 5: {
                                    Vector date_gb_vec = (Vector)group_by_attributes.get(gb_attr);
                                    for (String date_str : date_gb_vec) {
                                        int i5 = 0;
                                        while (i5 < date_vec.size()) {
                                            RelaggsDate date_val = (RelaggsDate)date_vec.elementAt(i5);
                                            Hashtable ht_values = (Hashtable)this.attribute_values.get(gb_attr);
                                            Vector vec_date_values = (Vector)ht_values.get(date_str);
                                            for (RelaggsDate obj_val : vec_date_values) {
                                                if (!this.canAddColumn(source_table)) break;
                                                sql.append(", " + this.getUniqueName(String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + obj_val.getColumnString() + "_" + date_val.getColumnString()) + " INT DEFAULT 0");
                                            }
                                            ++i5;
                                        }
                                    }
                                    continue block31;
                                }
                            }
                        }
                    }
                    continue block17;
                }
            }
        }
        return sql.toString();
    }

    private String validColumnName(String name) {
        String tmp = name;
        int i = 0;
        while (i < tmp.length()) {
            char c = tmp.charAt(i);
            if (!('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_')) {
                tmp = tmp.substring(0, i).concat("_").concat(tmp.substring(i + 1));
            }
            ++i;
        }
        return tmp;
    }

    public boolean isAggregationValid(RelaggsAttribute attr, String attr_param) {
        switch (attr.getType()) {
            case 1: {
                return true;
            }
            case 3: {
                Vector char_vec = (Vector)this.attribute_values.get(attr);
                return char_vec.size() <= RelaggsConfig.max_aggr_values;
            }
            case 5: {
                Hashtable ht_date = (Hashtable)this.attribute_values.get(attr);
                Vector date_vec = (Vector)ht_date.get(attr_param);
                return date_vec.size() <= RelaggsConfig.max_aggr_values;
            }
        }
        return false;
    }

    public boolean isAggregationValid(RelaggsAttribute attr) {
        switch (attr.getType()) {
            case 1: {
                return true;
            }
            case 3: {
                Vector char_vec = (Vector)this.attribute_values.get(attr);
                return char_vec.size() <= RelaggsConfig.max_aggr_values;
            }
            case 5: {
                Hashtable ht_date = (Hashtable)this.attribute_values.get(attr);
                Enumeration enum_date_keys = ht_date.keys();
                while (enum_date_keys.hasMoreElements()) {
                    String date_key = (String)enum_date_keys.nextElement();
                    Vector date_vec = (Vector)ht_date.get(date_key);
                    if (date_vec.size() > RelaggsConfig.max_aggr_values) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public Enumeration getKeyValues() {
        return this.key_attributes.keys();
    }

    public PreparedStatement getUpdateQuery(Object key, RelaggsTable source, RelaggsTable dest, Join join) throws SQLException {
        String sql = "";
        Vector params = new Vector();
        int cnt = 0;
        Hashtable ht_key = (Hashtable)this.key_attributes.get(key);
        if (ht_key != null) {
            Enumeration enum_attr = ht_key.keys();
            block20: while (enum_attr.hasMoreElements()) {
                RelaggsAttribute attr = (RelaggsAttribute)enum_attr.nextElement();
                String attr_name = String.valueOf(source.getShortName()) + "_" + attr.getName();
                if (!this.isAggregationValid(attr)) continue;
                switch (attr.getType()) {
                    case 1: {
                        String tmp;
                        RelaggsDate date_val;
                        String gb_str;
                        Object gb_value;
                        Enumeration gb_values;
                        Hashtable ht_gb_values;
                        Hashtable ht_values;
                        RelaggsAttribute gb_attr;
                        Hashtable ht_list = (Hashtable)ht_key.get(attr);
                        Enumeration enum_list = ht_list.keys();
                        while (enum_list.hasMoreElements()) {
                            gb_attr = (RelaggsAttribute)enum_list.nextElement();
                            if (gb_attr.equals(attr)) {
                                ht_values = (Hashtable)ht_list.get(attr);
                                if (cnt != 0) {
                                    sql = String.valueOf(sql) + ", ";
                                }
                                ++cnt;
                                sql = String.valueOf(sql) + attr_name + "_" + KEY_INT_Q1 + " = " + (Integer)ht_values.get(KEY_INT_Q1) + ", " + attr_name + "_" + KEY_INT_Q3 + " = " + (Integer)ht_values.get(KEY_INT_Q3) + ", " + attr_name + "_" + KEY_INT_MED + " = " + (Integer)ht_values.get(KEY_INT_MED) + ", " + attr_name + "_" + KEY_INT_RNG + " = " + (Integer)ht_values.get(KEY_INT_RNG);
                                continue;
                            }
                            ht_gb_values = (Hashtable)ht_list.get(gb_attr);
                            gb_values = ht_gb_values.keys();
                            while (gb_values.hasMoreElements()) {
                                gb_value = gb_values.nextElement();
                                Hashtable ht_values2 = (Hashtable)ht_gb_values.get(gb_value);
                                gb_str = "";
                                switch (gb_attr.getType()) {
                                    case 3: {
                                        gb_str = this.validColumnName((String)gb_value);
                                        break;
                                    }
                                    case 1: {
                                        gb_str = this.validColumnName("" + (Integer)gb_value);
                                        break;
                                    }
                                    case 5: {
                                        date_val = new RelaggsDate((String)gb_value);
                                        gb_str = date_val.getColumnString();
                                    }
                                }
                                tmp = String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + gb_str + "_";
                                if (cnt != 0) {
                                    sql = String.valueOf(sql) + ", ";
                                }
                                ++cnt;
                                sql = String.valueOf(sql) + tmp + KEY_INT_CNTVAL + " = " + (Integer)ht_values2.get(KEY_INT_CNTVAL) + ", " + tmp + KEY_INT_SUM + " = " + (Integer)ht_values2.get(KEY_INT_SUM) + ", " + tmp + KEY_INT_AVG + " = ?, " + tmp + KEY_INT_MIN + " = " + (Integer)ht_values2.get(KEY_INT_MIN) + ", " + tmp + KEY_INT_MAX + " = " + (Integer)ht_values2.get(KEY_INT_MAX) + ", " + tmp + KEY_INT_STDDEV + " = ?, " + tmp + KEY_INT_Q1 + " = " + (Integer)ht_values2.get(KEY_INT_Q1) + ", " + tmp + KEY_INT_Q3 + " = " + (Integer)ht_values2.get(KEY_INT_Q3) + ", " + tmp + KEY_INT_MED + " = " + (Integer)ht_values2.get(KEY_INT_MED) + ", " + tmp + KEY_INT_RNG + " = " + (Integer)ht_values2.get(KEY_INT_RNG);
                                params.add(ht_values2.get(KEY_INT_AVG));
                                params.add(ht_values2.get(KEY_INT_STDDEV));
                            }
                        }
                        continue block20;
                    }
                    case 3: {
                        Enumeration enum_values;
                        String tmp;
                        RelaggsDate date_val;
                        String gb_str;
                        Enumeration gb_values;
                        Hashtable ht_gb_values;
                        Hashtable ht_values;
                        RelaggsAttribute gb_attr;
                        Hashtable ht_list = (Hashtable)ht_key.get(attr);
                        Enumeration enum_list = ht_list.keys();
                        while (enum_list.hasMoreElements()) {
                            gb_attr = (RelaggsAttribute)enum_list.nextElement();
                            if (gb_attr.equals(attr)) {
                                ht_values = (Hashtable)ht_list.get(attr);
                                Enumeration enum_values2 = ht_values.keys();
                                int i = 0;
                                while (enum_values2.hasMoreElements()) {
                                    String str_val = (String)enum_values2.nextElement();
                                    if (i != 0) {
                                        sql = String.valueOf(sql) + ", ";
                                    } else if (cnt != 0) {
                                        sql = String.valueOf(sql) + ", ";
                                    }
                                    ++cnt;
                                    sql = String.valueOf(sql) + attr_name + "_" + this.validColumnName(str_val) + " = " + (Integer)ht_values.get(str_val);
                                    ++i;
                                }
                                continue;
                            }
                            ht_gb_values = (Hashtable)ht_list.get(gb_attr);
                            gb_values = ht_gb_values.keys();
                            while (gb_values.hasMoreElements()) {
                                Object gb_value = gb_values.nextElement();
                                Hashtable ht_values3 = (Hashtable)ht_gb_values.get(gb_value);
                                gb_str = "";
                                switch (gb_attr.getType()) {
                                    case 3: {
                                        gb_str = this.validColumnName((String)gb_value);
                                        break;
                                    }
                                    case 1: {
                                        gb_str = this.validColumnName("" + (Integer)gb_value);
                                        break;
                                    }
                                    case 5: {
                                        date_val = new RelaggsDate((String)gb_value);
                                        gb_str = date_val.getColumnString();
                                    }
                                }
                                tmp = String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + gb_str + "_";
                                int i = 0;
                                enum_values = ht_values3.keys();
                                while (enum_values.hasMoreElements()) {
                                    String str_val = (String)enum_values.nextElement();
                                    if (i != 0) {
                                        sql = String.valueOf(sql) + ", ";
                                    } else if (cnt != 0) {
                                        sql = String.valueOf(sql) + ", ";
                                    }
                                    ++cnt;
                                    sql = String.valueOf(sql) + tmp + this.validColumnName(str_val) + " = " + (Integer)ht_values3.get(str_val);
                                    ++i;
                                }
                            }
                        }
                        continue block20;
                    }
                    case 5: {
                        Enumeration enum_values;
                        String tmp;
                        RelaggsDate date_val;
                        String gb_str;
                        Object gb_value;
                        Enumeration gb_values;
                        Hashtable ht_gb_values;
                        RelaggsAttribute gb_attr;
                        Hashtable ht_list = (Hashtable)ht_key.get(attr);
                        Enumeration enum_list = ht_list.keys();
                        while (enum_list.hasMoreElements()) {
                            gb_attr = (RelaggsAttribute)enum_list.nextElement();
                            if (gb_attr.equals(attr)) {
                                String str_val;
                                Enumeration enum_values3;
                                Hashtable ht_values;
                                Hashtable ht_date = (Hashtable)ht_list.get(attr);
                                if (this.isAggregationValid(attr, KEY_DATE_YMD)) {
                                    ht_values = (Hashtable)ht_date.get(KEY_DATE_YMD);
                                    enum_values3 = ht_values.keys();
                                    int i = 0;
                                    if (cnt != 0) {
                                        ++i;
                                    }
                                    ++cnt;
                                    while (enum_values3.hasMoreElements()) {
                                        str_val = (String)enum_values3.nextElement();
                                        date_val = new RelaggsDate(str_val);
                                        if (i != 0) {
                                            sql = String.valueOf(sql) + ", ";
                                        }
                                        sql = String.valueOf(sql) + attr_name + "_" + date_val.getColumnString() + " = " + (Integer)ht_values.get(str_val);
                                        ++i;
                                    }
                                }
                                if (this.isAggregationValid(attr, KEY_DATE_YM)) {
                                    ht_values = (Hashtable)ht_date.get(KEY_DATE_YM);
                                    enum_values3 = ht_values.keys();
                                    int i = 0;
                                    if (cnt != 0) {
                                        ++i;
                                    }
                                    ++cnt;
                                    while (enum_values3.hasMoreElements()) {
                                        str_val = (String)enum_values3.nextElement();
                                        date_val = new RelaggsDate(str_val);
                                        if (i != 0) {
                                            sql = String.valueOf(sql) + ", ";
                                        }
                                        sql = String.valueOf(sql) + attr_name + "_" + date_val.getColumnString() + " = " + (Integer)ht_values.get(str_val);
                                        ++i;
                                    }
                                }
                                if (!this.isAggregationValid(attr, KEY_DATE_Y)) continue;
                                ht_values = (Hashtable)ht_date.get(KEY_DATE_Y);
                                enum_values3 = ht_values.keys();
                                int i = 0;
                                if (cnt != 0) {
                                    ++i;
                                }
                                ++cnt;
                                while (enum_values3.hasMoreElements()) {
                                    str_val = (String)enum_values3.nextElement();
                                    date_val = new RelaggsDate(str_val);
                                    if (i != 0) {
                                        sql = String.valueOf(sql) + ", ";
                                    }
                                    sql = String.valueOf(sql) + attr_name + "_" + date_val.getColumnString() + " = " + (Integer)ht_values.get(str_val);
                                    ++i;
                                }
                                continue;
                            }
                            ht_gb_values = (Hashtable)ht_list.get(gb_attr);
                            gb_values = ht_gb_values.keys();
                            while (gb_values.hasMoreElements()) {
                                RelaggsDate date_val2;
                                String str_val;
                                int i;
                                Hashtable ht_values;
                                gb_value = gb_values.nextElement();
                                Hashtable ht_date = (Hashtable)ht_gb_values.get(gb_value);
                                gb_str = "";
                                switch (gb_attr.getType()) {
                                    case 3: {
                                        gb_str = this.validColumnName((String)gb_value);
                                        break;
                                    }
                                    case 1: {
                                        gb_str = this.validColumnName("" + (Integer)gb_value);
                                        break;
                                    }
                                    case 5: {
                                        date_val = new RelaggsDate((String)gb_value);
                                        gb_str = date_val.getColumnString();
                                    }
                                }
                                tmp = String.valueOf(attr_name) + "_gb_" + gb_attr.getName() + "_" + gb_str + "_";
                                if (this.isAggregationValid(attr, KEY_DATE_YMD)) {
                                    ht_values = (Hashtable)ht_date.get(KEY_DATE_YMD);
                                    enum_values = ht_values.keys();
                                    i = 0;
                                    if (cnt != 0) {
                                        ++i;
                                    }
                                    ++cnt;
                                    while (enum_values.hasMoreElements()) {
                                        str_val = (String)enum_values.nextElement();
                                        date_val2 = new RelaggsDate(str_val);
                                        if (i != 0) {
                                            sql = String.valueOf(sql) + ", ";
                                        }
                                        sql = String.valueOf(sql) + tmp + date_val2.getColumnString() + " = " + (Integer)ht_values.get(str_val);
                                        ++i;
                                    }
                                }
                                if (this.isAggregationValid(attr, KEY_DATE_YM)) {
                                    ht_values = (Hashtable)ht_date.get(KEY_DATE_YM);
                                    enum_values = ht_values.keys();
                                    i = 0;
                                    if (cnt != 0) {
                                        ++i;
                                    }
                                    ++cnt;
                                    while (enum_values.hasMoreElements()) {
                                        str_val = (String)enum_values.nextElement();
                                        date_val2 = new RelaggsDate(str_val);
                                        if (i != 0) {
                                            sql = String.valueOf(sql) + ", ";
                                        }
                                        sql = String.valueOf(sql) + tmp + date_val2.getColumnString() + " = " + (Integer)ht_values.get(str_val);
                                        ++i;
                                    }
                                }
                                if (!this.isAggregationValid(attr, KEY_DATE_Y)) continue;
                                ht_values = (Hashtable)ht_date.get(KEY_DATE_Y);
                                enum_values = ht_values.keys();
                                i = 0;
                                if (cnt != 0) {
                                    ++i;
                                }
                                ++cnt;
                                while (enum_values.hasMoreElements()) {
                                    str_val = (String)enum_values.nextElement();
                                    date_val2 = new RelaggsDate(str_val);
                                    if (i != 0) {
                                        sql = String.valueOf(sql) + ", ";
                                    }
                                    sql = String.valueOf(sql) + tmp + date_val2.getColumnString() + " = " + (Integer)ht_values.get(str_val);
                                    ++i;
                                }
                            }
                        }
                        continue block20;
                    }
                }
            }
            String key_str = key.toString();
            if (key instanceof String || key instanceof Character) {
                key_str = "'" + key_str + "'";
            }
            if (sql.length() > 0) {
                sql = "UPDATE " + dest.getName() + " SET " + sql + " WHERE " + join.getLeftColumn() + " = " + key_str;
                PreparedStatement ps = this.getConnector().getConnection().prepareStatement(sql);
                if (params.size() > 0) {
                    int i = 0;
                    while (i < params.size()) {
                        ps.setDouble(i + 1, (Double)params.get(i));
                        ++i;
                    }
                }
                return ps;
            }
            return null;
        }
        return null;
    }
}

