/*
 * Decompiled with CFR 0.152.
 */
package model.inference;

import data.Type;
import data.catalog.Catalog;
import data.feature.SimpleFeature;
import data.instance.Instance;
import data.instance.Instances;
import data.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.TreeMap;
import model.ModelOptions;
import model.NodeSplit;
import model.criterion.cancel.CancelCriterion;
import model.inference.Inference;
import model.inference.SplitFinder;
import model.inference.hc.AggregateBase;
import model.inference.hc.GuidedHillClimbingRandom;
import util.GlobalRandom;

public class GuidedInference
extends Inference {
    Random rt = GlobalRandom.instance();
    private ArrayList<SimpleFeature> mfToUse;
    private ArrayList<AggregateBase> aggsToUse;

    public GuidedInference(ModelOptions opts, Random gr, ArrayList<SimpleFeature> sfToUse, ArrayList<AggregateBase> aggBaseToUse) {
        super(opts);
        this.rt = gr;
        this.mfToUse = new ArrayList<SimpleFeature>(sfToUse);
        this.aggsToUse = new ArrayList<AggregateBase>(aggBaseToUse);
    }

    @Override
    public NodeSplit infer(Instances insts, Catalog cat) {
        ArrayList<NodeSplit> bestNodeSplits = new ArrayList<NodeSplit>();
        ArrayList<Value> ids = new ArrayList<Value>(insts.size());
        for (Instance inst : insts) {
            ids.add(inst.getId());
        }
        GuidedHillClimbingRandom hc = new GuidedHillClimbingRandom(this.opts, this.rt, this.aggsToUse);
        NodeSplit ns = hc.run(insts, cat, this.cancels);
        if (ns != null) {
            bestNodeSplits.add(ns);
        }
        ArrayList<SimpleFeature> sfsCopy = new ArrayList<SimpleFeature>(this.mfToUse);
        if (this.opts.treesInForest > 1 && !this.mfToUse.isEmpty()) {
            int nf = (int)Math.floor(Math.sqrt(this.mfToUse.size()));
            Collections.shuffle(sfsCopy, this.rt);
            int i = this.mfToUse.size() - 1;
            while (i >= nf) {
                sfsCopy.remove(i);
                --i;
            }
        }
        for (SimpleFeature sf : sfsCopy) {
            Type typeOutput = sf.getTypeOut();
            if (typeOutput.getKind() == 0) {
                HashMap<Value, Instances> decomposition = new HashMap<Value, Instances>();
                for (Instance inst : insts) {
                    Value val = sf.result(inst.getId(), cat);
                    if (!decomposition.containsKey(val)) {
                        decomposition.put(val, new Instances());
                    }
                    decomposition.get(val).add(inst);
                }
                NodeSplit bs = null;
                if (this.opts.mode.equals("classification")) {
                    bs = SplitFinder.inferNominalSplitOnNominalTarget(sf, decomposition, new Instances(), this.opts.complexity);
                } else if (this.opts.mode.equals("regression")) {
                    bs = SplitFinder.inferNominalSplitOnNumericTarget(sf, decomposition, new Instances(), this.opts.complexity);
                }
                this.updateBestSplits(bs, bestNodeSplits);
                continue;
            }
            if (typeOutput.getKind() != 1) continue;
            TreeMap<Value, Instances> groups = new TreeMap<Value, Instances>();
            Instances noValue = new Instances();
            for (Instance inst : insts) {
                Value val = sf.result(inst.getId(), cat);
                if (val == null) {
                    noValue.add(inst);
                    continue;
                }
                if (!groups.containsKey(val)) {
                    groups.put(val, new Instances());
                }
                groups.get(val).add(inst);
            }
            NodeSplit bs = null;
            if (this.opts.mode.equals("classification")) {
                bs = SplitFinder.inferNumericSplitOnNominalTarget(sf, groups, new Instances(), this.opts.complexity);
            } else if (this.opts.mode.equals("regression")) {
                bs = SplitFinder.inferNumericSplitOnNumericTarget(sf, groups, new Instances(), this.opts.complexity);
            }
            this.updateBestSplits(bs, bestNodeSplits);
        }
        return this.chooseBestSplit(bestNodeSplits);
    }

    private boolean updateBestSplits(NodeSplit ns, ArrayList<NodeSplit> bestNodeSplits) {
        boolean res = false;
        if (ns != null) {
            boolean cancelNow = false;
            for (CancelCriterion cancel : this.cancels) {
                boolean bl = cancelNow = cancelNow || cancel.cancelCriterion(ns);
            }
            if (!cancelNow) {
                double score = ns.getScore();
                if (bestNodeSplits.isEmpty() && score > this.opts.m.getMin() || !bestNodeSplits.isEmpty() && score >= bestNodeSplits.get(0).getScore()) {
                    boolean toAdd = true;
                    if (bestNodeSplits.isEmpty() || !bestNodeSplits.isEmpty() && score > bestNodeSplits.get(0).getScore()) {
                        res = true;
                        bestNodeSplits.clear();
                    } else if (!bestNodeSplits.isEmpty()) {
                        for (NodeSplit cns : bestNodeSplits) {
                            if (!toAdd) break;
                            boolean bl = toAdd = !cns.getSplitCondition().equals(ns.getSplitCondition());
                        }
                    }
                    if (toAdd) {
                        bestNodeSplits.add(ns);
                    }
                }
            }
        }
        return res;
    }

    private NodeSplit chooseBestSplit(ArrayList<NodeSplit> bestNodeSplits) {
        ArrayList<NodeSplit> candidates = new ArrayList<NodeSplit>();
        double bestScore = this.opts.m.getMin();
        for (NodeSplit ns : bestNodeSplits) {
            if (!(ns.getScore() >= bestScore)) continue;
            if (ns.getScore() > bestScore) {
                bestScore = ns.getScore();
                candidates.clear();
            }
            candidates.add(ns);
        }
        ArrayList<NodeSplit> candidates2 = new ArrayList<NodeSplit>();
        double bestComplexity = Double.MAX_VALUE;
        for (NodeSplit ns : candidates) {
            double compl = ns.getSplitCondition().complexity();
            if (!(compl <= bestComplexity)) continue;
            if (compl < bestComplexity) {
                bestComplexity = compl;
                candidates2.clear();
            }
            candidates2.add(ns);
        }
        if (candidates2.isEmpty()) {
            return null;
        }
        return (NodeSplit)candidates2.get(this.rt.nextInt(candidates2.size()));
    }
}

