/*
 * Decompiled with CFR 0.152.
 */
package model.inference.hc;

import data.Type;
import data.aggregate.AggregateFunction;
import data.aggregate.Ratio;
import data.catalog.Catalog;
import data.feature.LinkFeature;
import data.feature.SimpleFeature;
import data.instance.Instance;
import data.instance.Instances;
import data.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import model.ModelOptions;
import model.NodeSplit;
import model.criterion.cancel.CancelCriterion;
import model.inference.hc.AggregateBase;
import model.inference.hc.HillClimbing;
import model.inference.hc.OneRandomRestartHillClimbing;
import util.Logging;

public class RandomRestartHillClimbing
extends HillClimbing {
    private ArrayList<AggregateBase> abs;
    private ArrayList<OneRandomRestartHillClimbing> hcs;
    private int numIterations = 0;
    private int reinitsWithoutImprovement;
    private double totalGain = 0.0;

    public RandomRestartHillClimbing(ModelOptions opt, Random gr) {
        super(opt, gr);
    }

    @Override
    public NodeSplit run(Instances insts, Catalog cat, ArrayList<CancelCriterion> cancels) {
        ArrayList<NodeSplit> bestSplits = new ArrayList<NodeSplit>();
        this.abs = new ArrayList();
        Type ti = cat.getClassFeature().getTypeIn();
        ArrayList<LinkFeature> lfs = cat.getLinkFeatures(ti);
        if (!lfs.isEmpty()) {
            LinkFeature lf = lfs.get(0);
            ArrayList<SimpleFeature> sfs = cat.getSimpleFeatures(lf.getTypeOut());
            for (AggregateFunction<?> af : this.opts.aggFunctions) {
                if (af.isNeedsFeature()) {
                    for (SimpleFeature sf : sfs) {
                        if (af.getKindIn() != sf.getTypeOut().getKind()) continue;
                        if (af.getName().equals("ratio")) {
                            for (Value val : sf.getTypeOut().getValues()) {
                                AggregateBase ab = new AggregateBase(new Ratio(sf, val), lf, sf);
                                this.abs.add(ab);
                            }
                            continue;
                        }
                        AggregateBase ab = new AggregateBase(af, lf, sf);
                        this.abs.add(ab);
                    }
                    continue;
                }
                AggregateBase ab = new AggregateBase(af, lf, null);
                this.abs.add(ab);
            }
            ArrayList<Value> ids = new ArrayList<Value>();
            for (Instance inst : insts) {
                ids.add(inst.getId());
            }
            if (this.opts.treesInForest > 1) {
                Collections.shuffle(this.abs, this.rt);
                int toKeep = (int)Math.floor(Math.sqrt(this.abs.size()));
                int n = this.abs.size();
                int i = n - 1;
                while (i >= toKeep) {
                    this.abs.remove(i);
                    --i;
                }
            }
            this.hcs = new ArrayList();
            for (AggregateBase ab : this.abs) {
                ArrayList<SimpleFeature> allFeatures = null;
                if (this.opts.treesInForest > 1) {
                    ArrayList<SimpleFeature> sfsCopy = new ArrayList<SimpleFeature>(sfs);
                    Collections.shuffle(sfsCopy, this.rt);
                    allFeatures = new ArrayList(sfsCopy.subList(0, (1 + sfsCopy.size()) / 2));
                } else {
                    allFeatures = new ArrayList<SimpleFeature>(sfs);
                }
                this.hcs.add(new OneRandomRestartHillClimbing(this.opts, this.rt, ab, allFeatures, insts, cat, cancels));
            }
            long numSec = 0L;
            for (Instance inst : insts) {
                numSec += (long)lf.getLinkedElements(inst.getId(), cat).size();
            }
            this.numIterations = (int)Math.round(Math.sqrt((double)this.hcs.size() * (double)numSec));
            int initHcs = this.hcs.size();
            for (OneRandomRestartHillClimbing hc : this.hcs) {
                this.totalGain += hc.weight();
            }
            int n = 0;
            while (n < this.numIterations && !this.hcs.isEmpty() && this.reinitsWithoutImprovement < 3 * initHcs) {
                long t1 = System.currentTimeMillis();
                double choice = this.rt.nextDouble() * this.totalGain;
                OneRandomRestartHillClimbing chosenBranch = null;
                double count = 0.0;
                for (OneRandomRestartHillClimbing hc : this.hcs) {
                    if (!((count += hc.weight()) >= choice)) continue;
                    chosenBranch = hc;
                    break;
                }
                this.totalGain -= chosenBranch.weight();
                boolean keepGoingBranch = chosenBranch.oneStep(insts, cat, cancels);
                this.totalGain += chosenBranch.weight();
                long t2 = System.currentTimeMillis();
                Logging.hc.info((Object)(String.valueOf(this.opts.name) + " - " + (n + 1) + "/" + this.numIterations + " ; Time " + (double)(t2 - t1) / 1000.0 + "s ; " + chosenBranch.getAggregateBase().toString()));
                if (!keepGoingBranch) {
                    Logging.hc.info((Object)(String.valueOf(this.opts.name) + " - HC finished."));
                    ++this.reinitsWithoutImprovement;
                    NodeSplit ns = this.chooseBestSplit(chosenBranch.getBestSplits());
                    boolean globImp = this.updateBestSplits(ns, bestSplits, true, cancels);
                    if (globImp) {
                        Logging.hc.info((Object)(String.valueOf(this.opts.name) + " - New best aggregate!\n" + ns.toString()));
                        this.reinitsWithoutImprovement = 0;
                    }
                    if (chosenBranch.getNumIterationsWithoutImp() > 2) {
                        Logging.hc.info((Object)(String.valueOf(this.opts.name) + " - Branch has not improved for some time. Deleted."));
                        this.totalGain -= chosenBranch.weight();
                        this.hcs.remove(chosenBranch);
                    } else {
                        Logging.hc.info((Object)(String.valueOf(this.opts.name) + " - Branch reinitialized."));
                        this.totalGain -= chosenBranch.weight();
                        chosenBranch.reInit(insts, cat, cancels);
                        this.totalGain += chosenBranch.weight();
                    }
                }
                ++n;
            }
            if (bestSplits.isEmpty()) {
                for (OneRandomRestartHillClimbing hc : this.hcs) {
                    this.updateBestSplits(this.chooseBestSplit(hc.getBestSplits()), bestSplits, true, cancels);
                }
            }
        }
        Logging.hc.info((Object)(String.valueOf(this.opts.name) + " - HC finished. Best split(s) :\n" + bestSplits.toString()));
        return this.chooseBestSplit(bestSplits);
    }
}

