#!/bin/bash

# traverses all README.DATA and stores the data in the README file in
# the 'datasets' directory (based on README.skel)
#
# $Revision: 1.2 $
# FracPete

# prints the usage for this script
function usage()
{
   echo
   echo "usage: ${0##*/} -i <datasets> -v [-h]"
   echo
   echo "traverses all README.DATA and stores the data in the README file in"
   echo "the 'datasets' directory (based on README.skel)"
   echo
   echo " -h this help"
   echo " -i <datasets>"
   echo "    the directory with the datasets"
   echo "    default: $INPUT"
   echo
}

# interprete parameters
ROOT=`expr "$0" : '\(.*\)/'`
OUTPUT=$ROOT/../tmp/datasets.txt
DATASETS=$ROOT/../datasets
README=$DATASETS/README
SKELETON=$README.skel
VERBOSE=no

while getopts ":hi:v" flag
do
   case $flag in
      i) INPUT=$OPTARG
         ;;
      h) usage
         exit 0
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# delete output file
echo "delete $OUTPUT..."
rm -f $OUTPUT

# traverse all README.DATA
echo "processing README.DATAs..."
for i in $DATASETS/*
do
   # no dir? -> continue
   if [ ! -d $i ]
   then
      continue
   fi

   # info
   DIR="${i##*/}"
   echo " - $DIR"
   
   FILE="$i/README.DATA"

   # the overall line count
   COUNT=`cat $FILE  | wc -l | sed s/" "*//g`
   # get the line-no of "data from:"
   LINE=`cat $FILE | grep -n "data from:" | cut -f1 -d":"`

   # print files
   echo "- $DIR" >> $OUTPUT
   tail -n $(($COUNT - $LINE + 1)) $FILE | sed s/\{r\}//g | grep -v "FracPete\|^$" | sed s/^/"  "/g >> $OUTPUT
   echo >> $OUTPUT
done

# create new README in datasets
echo "creating new README..."
LINE=`grep -n "#NOTES#" $SKELETON | cut -f1 -d":"`
LINES=`cat $SKELETON | wc -l | sed s/" "*//g`
head -n $(($LINE - 1)) $SKELETON > $README
cat $OUTPUT >> $README
tail -n $(($LINES - $LINE)) $SKELETON >> $README

