#!/bin/bash
#
# This shell script prepares the data, s.t. Proper can handle it better
#
# use -help to see options
#
# FracPete

# the usage of this script
function usage()
{
   echo
   echo "usage: ${0##*/} -i <input-dir> -o <output-dir> [-h]"
   echo 
   echo "combines the names file with the data file"
   echo
   echo " -h   this help"
   echo " -i   <input-dir>"
   echo "      the directory where the data is located"
   echo "      default: $SRC"
   echo " -o   <output-dir>"
   echo "      where to put the processed files"
   echo "      default: $DEST"
   echo
}

# cleans up temporary files
function clean_up()
{
   rm -f _*
}

# returns the header from the file TMPFILE in TMP
function get_header()
{
   TMP=`cat $TMPFILE | sed s/{\r}//g | grep -v "^$" | cut -f 1 -d ":" | sed s/$/,/`
   TMP=`echo $TMP | sed s/,$//g | sed s/" "*//g`
}


# variables
ROOT=`expr "$0" : '\(.*\)/'`
SRC="$ROOT/original"
DEST="$ROOT"

# interprete parameters
while getopts ":hi:o:" flag
do
   case $flag in
      i) SRC=$OPTARG
         ;;
      o) DEST=$OPTARG
         ;;
      h) usage
         exit 0
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# create ARFF files
$ROOT/JapaneseVowels.sh -n $SRC/JapaneseVowels.data.html -t $SRC/JapaneseVowels.task.html -d $SRC/ae.train -s $SRC/size_ae.train -o $DEST/JapaneseVowels_train.arff -r JapaneseVowels
$ROOT/JapaneseVowels.sh -n $SRC/JapaneseVowels.data.html -t $SRC/JapaneseVowels.task.html -d $SRC/ae.test -s $SRC/size_ae.test -o $DEST/JapaneseVowels_test.arff -r JapaneseVowels-test

# transform into CSV
$ROOT/transform_csv.sh -a $DEST/JapaneseVowels_train.arff -s $DEST/JapaneseVowels-speaker_train.csv -u $DEST/JapaneseVowels-utterance_train.csv
$ROOT/transform_csv.sh -a $DEST/JapaneseVowels_test.arff  -s $DEST/JapaneseVowels-speaker_test.csv  -u $DEST/JapaneseVowels-utterance_test.csv
