/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.Handler;
import com.javonet.sdk.core.JvmCommand;
import com.javonet.utils.HandlerUtlis;
import com.javonet.utils.exceptions.JavonetArgumentsMismatchException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class InvokeStaticMethodHandler
extends Handler {
    private final int requiredArgumentsCount = 2;

    public int getRequiredArgumentsCount() {
        return 2;
    }

    @Override
    public Object process(JvmCommand command) throws Exception {
        return this.invokeStaticMethod(command);
    }

    private Object invokeStaticMethod(JvmCommand command) throws Exception {
        if (command.getPayload().length < 2) {
            throw new JavonetArgumentsMismatchException(this.getClass().getName(), 2);
        }
        Class classToLoad = (Class)command.getPayload()[0];
        String methodToInvoke = command.getPayload()[1].toString();
        Object[] arguments = Arrays.stream(command.getPayload()).skip(2L).toArray();
        Class<?>[] argumentTypes = HandlerUtlis.getArgumentTypes(arguments);
        Method foundMethod = classToLoad.getMethod(methodToInvoke, argumentTypes);
        return foundMethod.invoke(null, arguments);
    }
}

