/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.internal;

import com.javonet.core.generator.IOptimizedTransmitter;
import com.javonet.core.generator.TransmitterOptimizer;
import com.javonet.core.handler.JvmHandler;
import com.javonet.core.interpreter.JvmInterpreter;
import com.javonet.sdk.core.JvmCommand;
import com.javonet.sdk.core.JvmCommandType;
import com.javonet.sdk.core.RuntimeLib;
import com.javonet.sdk.internal.AbstractInstanceContext;
import com.javonet.sdk.internal.AbstractInvocationContext;
import com.javonet.sdk.internal.AbstractStaticContext;
import com.javonet.sdk.internal.ConnectionType;
import com.javonet.utils.TcpConnectionData;
import com.javonet.utils.exceptions.ExceptionThrower;
import java.util.Optional;

public class InvocationContext
implements AbstractInvocationContext,
AbstractInstanceContext,
AbstractStaticContext {
    private final JvmInterpreter interpreter;
    private JvmHandler handler;
    private final RuntimeLib runtimeLib;
    private final ConnectionType connectionType;
    private JvmCommand currentCommand;
    private JvmCommand responseCommand;
    private boolean isExecuted;
    private Optional<TcpConnectionData> tcpAddress;
    private Object resultValue;

    public InvocationContext(RuntimeLib runtime, ConnectionType connectionType, Optional<TcpConnectionData> tcpAddress, JvmCommand command) {
        this.runtimeLib = runtime;
        this.connectionType = connectionType;
        this.tcpAddress = tcpAddress;
        this.currentCommand = command;
        this.responseCommand = null;
        this.isExecuted = false;
        this.interpreter = new JvmInterpreter();
    }

    public InvocationContext(RuntimeLib runtime, ConnectionType connectionType, Optional<TcpConnectionData> tcpAddress, JvmCommand command, boolean isExecuted) {
        this.runtimeLib = runtime;
        this.connectionType = connectionType;
        this.tcpAddress = tcpAddress;
        this.currentCommand = command;
        this.responseCommand = null;
        this.isExecuted = isExecuted;
        this.interpreter = new JvmInterpreter();
    }

    public InvocationContext execute(boolean toOptimize) {
        if (toOptimize) {
            Integer commandHashCode = this.currentCommand.hashCode();
            if (!IOptimizedTransmitter.optimizedClasses.containsKey(commandHashCode)) {
                TransmitterOptimizer.optimize(this.currentCommand, this.handler, this.interpreter, this.connectionType, this.tcpAddress);
            }
            this.resultValue = ((IOptimizedTransmitter)IOptimizedTransmitter.optimizedClasses.get(commandHashCode)).execute(this.currentCommand.getPayload());
            this.isExecuted = true;
            return this;
        }
        return this.execute();
    }

    @Override
    public InvocationContext execute() {
        if (RuntimeLib.Jvm == this.currentCommand.getTargetRuntime()) {
            this.handler = new JvmHandler();
            this.responseCommand = this.handler.handleCommand(this.currentCommand);
        } else {
            this.responseCommand = this.interpreter.execute(this.currentCommand, this.connectionType, this.tcpAddress);
        }
        if (this.responseCommand.getCommandType() == JvmCommandType.EXCEPTION) {
            ExceptionThrower.throwException(this.responseCommand);
        }
        if (this.responseCommand.getCommandType() == JvmCommandType.CREATE_INSTANCE) {
            this.currentCommand = this.responseCommand;
            this.isExecuted = true;
            return this;
        }
        return new InvocationContext(this.runtimeLib, this.connectionType, this.tcpAddress, this.responseCommand, true);
    }

    @Override
    public InvocationContext invokeStaticMethod(Object ... arguments) {
        JvmCommand localCommand = new JvmCommand(this.runtimeLib, JvmCommandType.INVOKE_STATIC_METHOD, arguments);
        return new InvocationContext(this.runtimeLib, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getInstanceField(Object ... arguments) {
        JvmCommand localCommand = new JvmCommand(this.runtimeLib, JvmCommandType.GET_INSTANCE_FIELD, arguments);
        return new InvocationContext(this.runtimeLib, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext invokeInstanceMethod(Object ... arguments) {
        JvmCommand localCommand = new JvmCommand(this.runtimeLib, JvmCommandType.INVOKE_INSTANCE_METHOD, arguments);
        return new InvocationContext(this.runtimeLib, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext createInstance(Object ... arguments) {
        JvmCommand localCommand = new JvmCommand(this.runtimeLib, JvmCommandType.CREATE_INSTANCE, arguments);
        return new InvocationContext(this.runtimeLib, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getStaticField(Object ... args) {
        JvmCommand localCommand = new JvmCommand(this.runtimeLib, JvmCommandType.GET_STATIC_FIELD, args);
        return new InvocationContext(this.runtimeLib, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext setStaticField(Object ... args) {
        JvmCommand localCommand = new JvmCommand(this.runtimeLib, JvmCommandType.SET_STATIC_FIELD, args);
        return new InvocationContext(this.runtimeLib, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    public Object getValue() {
        this.resultValue = this.currentCommand.getPayload()[0];
        return this.resultValue;
    }

    private JvmCommand buildCommand(JvmCommand cmd) {
        for (int i = 0; i < cmd.getPayload().length; ++i) {
            if (!(cmd.getPayload()[i] instanceof InvocationContext)) continue;
            cmd.setPayload(((InvocationContext)cmd.getPayload()[i]).currentCommand, i);
        }
        return this.currentCommand == null ? cmd : cmd.appendArgument(this.currentCommand);
    }

    public JvmCommand getCommand() {
        return this.currentCommand;
    }
}

